/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.dispatcher.resolver.impl;

import com.tplink.smb.omada.dispatcher.annotation.Api;
import com.tplink.smb.omada.dispatcher.annotation.PathVar;
import com.tplink.smb.omada.dispatcher.common.access.OperationResponse;
import com.tplink.smb.omada.dispatcher.common.util.StringUtils;
import com.tplink.smb.omada.dispatcher.resolver.ParameterResolveContext;
import com.tplink.smb.omada.dispatcher.resolver.ParameterResolver;
import com.tplink.smb.omada.dispatcher.resolver.ResolveResult;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.MethodParameter;
import org.springframework.http.RequestEntity;
import org.springframework.util.Assert;
import org.springframework.web.util.UriTemplate;

public class PathVariableResolver
implements ParameterResolver {
    public static final Logger log = LoggerFactory.getLogger(PathVariableResolver.class);

    @Override
    public boolean supported(MethodParameter parameter, ParameterResolveContext context) {
        return parameter.hasMethodAnnotation(Api.class) && parameter.hasParameterAnnotation(PathVar.class) && new UriTemplate(((Api)parameter.getMethodAnnotation(Api.class)).path()).matches(context.getRequestEntity().getUrl().getPath()) && (String.class.equals((Object)parameter.getNestedParameterType()) || Map.class.equals((Object)parameter.getNestedParameterType()));
    }

    @Override
    public ResolveResult resolveParameter(MethodParameter parameter, ParameterResolveContext context) {
        RequestEntity<String> request = context.getRequestEntity();
        String requestPath = request.getUrl().getPath();
        Api api = (Api)parameter.getMethodAnnotation(Api.class);
        Assert.notNull((Object)api, (String)"Failed to resolve path variable, Api annotation is missing on method.");
        String pathTemplate = api.path();
        return this.getPathVarResolveResult(parameter, requestPath, pathTemplate);
    }

    protected ResolveResult getPathVarResolveResult(MethodParameter parameter, String requestPath, String pathTemplate) {
        UriTemplate uriTemplate = new UriTemplate(pathTemplate);
        Map pathVariableMap = uriTemplate.match(requestPath);
        PathVar pathVariable = (PathVar)parameter.getParameterAnnotation(PathVar.class);
        Assert.notNull((Object)pathVariable, (String)"Failed to resolve path variable, PathVar annotation is missing on parameter.");
        String key = pathVariable.value();
        if (StringUtils.isNull((String)key)) {
            log.warn("Path variable name unknown {}", (Object)parameter);
            return ResolveResult.failedResult(null);
        }
        if (String.class.isAssignableFrom(parameter.getNestedParameterType())) {
            String value = (String)pathVariableMap.get(key);
            if (value != null) {
                return ResolveResult.successResult(value);
            }
            log.warn("Path variable [{}] resolved as null, path: {}.", (Object)key, (Object)requestPath);
            return ResolveResult.successResult(null);
        }
        if (Map.class.isAssignableFrom(parameter.getNestedParameterType())) {
            return ResolveResult.successResult(pathVariableMap);
        }
        log.warn("Parameter class {} not supported in PathVariableResolver, path: {}.", (Object)parameter.getNestedParameterType(), (Object)requestPath);
        return ResolveResult.failedResult(OperationResponse.PARAM_ERROR);
    }
}

