/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.dispatcher.resolver.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.primitives.Primitives;
import com.tplink.smb.omada.dispatcher.annotation.VO;
import com.tplink.smb.omada.dispatcher.common.access.OperationResponse;
import com.tplink.smb.omada.dispatcher.common.util.CollectionCommonUtils;
import com.tplink.smb.omada.dispatcher.resolver.ParameterResolveContext;
import com.tplink.smb.omada.dispatcher.resolver.ParameterResolver;
import com.tplink.smb.omada.dispatcher.resolver.ResolveResult;
import jakarta.validation.ConstraintViolation;
import jakarta.validation.Validator;
import java.io.IOException;
import java.net.URI;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.MethodParameter;
import org.springframework.http.RequestEntity;
import org.springframework.util.Assert;
import org.springframework.util.MultiValueMap;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;

public class Message2VOResolver
implements ParameterResolver {
    public static final Logger log = LoggerFactory.getLogger(Message2VOResolver.class);
    private static final Set<Class<?>> UNSUPPORTED_CLASSES = new HashSet();
    private Validator validator;
    private ObjectMapper objectMapper;

    public Message2VOResolver(Validator validator, ObjectMapper objectMapper) {
        this.validator = validator;
        this.objectMapper = objectMapper;
    }

    @Override
    public boolean supported(MethodParameter parameter, ParameterResolveContext context) {
        if (!parameter.hasParameterAnnotation(VO.class)) {
            return false;
        }
        if (parameter.getNestedParameterType().isPrimitive()) {
            return false;
        }
        return !this.getUnsupportedClasses().contains(parameter.getNestedParameterType());
    }

    @Override
    public ResolveResult resolveParameter(MethodParameter parameter, ParameterResolveContext context) {
        OperationResponse<?> response;
        Object result;
        RequestEntity<String> request = context.getRequestEntity();
        Class clazz = parameter.getNestedParameterType();
        VO voAnnotation = (VO)parameter.getParameterAnnotation(VO.class);
        Assert.notNull((Object)voAnnotation, (String)"VO annotation not present!");
        try {
            if (voAnnotation.src() == VO.Source.REQ_PARAM) {
                UriComponents uriComponents = UriComponentsBuilder.fromUri((URI)request.getUrl()).build();
                MultiValueMap queryParams = uriComponents.getQueryParams();
                Map queryParamMap = CollectionCommonUtils.convertRequestParamsToMap((Map)queryParams);
                result = this.objectMapper.convertValue((Object)queryParamMap, parameter.getNestedParameterType());
            } else {
                String json = (String)request.getBody();
                if (json == null) {
                    log.info("Request Body is null, should not use @VO, class: {}, parameter: {}, path: {}.", new Object[]{parameter.getDeclaringClass(), parameter, request.getUrl().getPath()});
                    return null;
                }
                result = this.objectMapper.readValue(json, clazz);
            }
        }
        catch (IOException | IllegalArgumentException e) {
            log.info("resolveParameter error: {}, path: {}.", new Object[]{request.getUrl().getPath(), e.getMessage(), e});
            return ResolveResult.failedResult(OperationResponse.PARAM_ERROR);
        }
        if (voAnnotation.validate() && !(response = this.validateEntry(request, result, voAnnotation.group())).success()) {
            return ResolveResult.failedResult(response);
        }
        return ResolveResult.successResult(result);
    }

    public OperationResponse<?> validateEntry(RequestEntity<String> request, Object entry, Class<?> ... groups) {
        if (this.validator == null || entry == null) {
            log.warn("Valid entity failed, validator is null or entry is null, path: {}.", (Object)request.getUrl().getPath());
            return OperationResponse.PARAM_ERROR;
        }
        Set validateRes = this.validator.validate(entry, (Class[])groups);
        if (validateRes != null && !validateRes.isEmpty()) {
            StringBuilder stringBuilder = new StringBuilder();
            for (ConstraintViolation constraintViolation : validateRes) {
                stringBuilder.append(constraintViolation.getMessage());
                stringBuilder.append('\n');
            }
            log.warn("Valid entity failed, path: {}.", (Object)request.getUrl().getPath());
            return new OperationResponse(OperationResponse.PARAM_ERROR.getErrorCode(), stringBuilder.toString());
        }
        return OperationResponse.SUCCESS;
    }

    private Set<Class<?>> getUnsupportedClasses() {
        return Collections.unmodifiableSet(UNSUPPORTED_CLASSES);
    }

    public void setValidator(Validator validator) {
        this.validator = validator;
    }

    public void setObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    static {
        UNSUPPORTED_CLASSES.addAll(Primitives.allPrimitiveTypes());
        UNSUPPORTED_CLASSES.addAll(Primitives.allWrapperTypes());
        UNSUPPORTED_CLASSES.add(String.class);
        UNSUPPORTED_CLASSES.add(Void.class);
    }
}

