/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.dispatcher.resolver.impl;

import com.google.common.collect.Sets;
import com.tplink.smb.omada.dispatcher.common.access.OperationResponse;
import com.tplink.smb.omada.dispatcher.common.response.ApiResponseWrapper;
import com.tplink.smb.omada.dispatcher.resolver.ParameterResolveContext;
import com.tplink.smb.omada.dispatcher.resolver.ParameterResolver;
import com.tplink.smb.omada.dispatcher.resolver.ResolveResult;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.MethodParameter;
import org.springframework.http.RequestEntity;

public class ContextParamResolver
implements ParameterResolver {
    public static final Logger log = LoggerFactory.getLogger(ContextParamResolver.class);
    private final Set<Class<?>> SUPPORTED_CLASSES = Sets.newHashSet((Object[])new Class[]{ParameterResolveContext.class, RequestEntity.class, ApiResponseWrapper.class, OutputStream.class});

    @Override
    public boolean supported(MethodParameter parameter, ParameterResolveContext context) {
        return this.SUPPORTED_CLASSES.contains(parameter.getNestedParameterType());
    }

    @Override
    public ResolveResult resolveParameter(MethodParameter parameter, ParameterResolveContext context) {
        if (ParameterResolveContext.class.equals((Object)parameter.getNestedParameterType())) {
            return ResolveResult.successResult(context);
        }
        if (RequestEntity.class.equals((Object)parameter.getNestedParameterType())) {
            return ResolveResult.successResult(context.getRequestEntity());
        }
        if (ApiResponseWrapper.class.equals((Object)parameter.getNestedParameterType())) {
            return ResolveResult.successResult(context.getResponse());
        }
        if (OutputStream.class.equals((Object)parameter.getNestedParameterType())) {
            try {
                return ResolveResult.successResult(context.getResponse().getOutputStream());
            }
            catch (IOException e) {
                RequestEntity<String> requestEntity = context.getRequestEntity();
                if (requestEntity != null) {
                    log.error("Resolve OutputStream failed, path: {}.", (Object)requestEntity.getUrl().getPath(), (Object)e);
                } else {
                    log.error("Resolve OutputStream failed.", (Throwable)e);
                }
                return ResolveResult.failedResult(new OperationResponse(OperationResponse.GENERAL_ERROR.getErrorCode(), "Get output stream failed."));
            }
        }
        log.error("Not supported to resolve {}, path: {}.", (Object)parameter.getNestedParameterType(), (Object)context.getRequestEntity().getUrl());
        return ResolveResult.failedResult(new OperationResponse(OperationResponse.GENERAL_ERROR.getErrorCode(), "Parameter resolve failed."));
    }
}

