/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.dispatcher.meter;

import com.tplink.smb.omada.dispatcher.common.access.OperationResponse;
import com.tplink.smb.omada.dispatcher.configuration.DispatcherProperties;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.MeterRegistry;
import jakarta.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;

public class DispatcherMeters {
    private MeterRegistry meterRegistry;
    private DispatcherProperties dispatcherProperties;
    private static final double ERR_CODE_STEP = 2000.0;

    private String SegmentErrCode(int errorCode) {
        if (this.dispatcherProperties.isSegmentErrCodeEnable()) {
            return String.valueOf((int)(Math.floor((double)errorCode / 2000.0) * 2000.0));
        }
        return "others";
    }

    public String valueOfErrCode(int errorCode) {
        if (errorCode == OperationResponse.GENERAL_ERROR.getErrorCode() || errorCode == OperationResponse.SUCCESS.getErrorCode() || this.dispatcherProperties.getErrCodeToMonitor().contains(errorCode)) {
            return String.valueOf(errorCode);
        }
        return this.SegmentErrCode(errorCode);
    }

    public void summaryRequestsSeconds(@Nonnull String httpMethod, @Nonnull String path, int errorCode, double timeSec, String importance, String timeCost) {
        String errorCodeStr = this.valueOfErrCode(errorCode);
        DistributionSummary.builder((String)"omada_rest_dispatcher_requests_seconds").tags(new String[]{"method", httpMethod, "path", path, "err_code", errorCodeStr, "importance", importance, "time_cost_level", timeCost}).publishPercentiles(new double[]{0.9, 0.99}).register(this.meterRegistry).record(timeSec);
    }

    @Autowired
    public void setMeterRegistry(MeterRegistry meterRegistry) {
        this.meterRegistry = meterRegistry;
    }

    @Autowired
    public void setDispatcherProperties(DispatcherProperties dispatcherProperties) {
        this.dispatcherProperties = dispatcherProperties;
    }
}

