/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.dispatcher.interceptor.impl;

import com.tplink.smb.omada.dispatcher.cache.MethodInfo;
import com.tplink.smb.omada.dispatcher.chain.ServiceHandlerChain;
import com.tplink.smb.omada.dispatcher.common.access.OperationResponse;
import com.tplink.smb.omada.dispatcher.common.response.ApiResponseWrapper;
import com.tplink.smb.omada.dispatcher.interceptor.impl.AbstractServerRequestInterceptor;
import com.tplink.smb.omada.dispatcher.resolver.ParameterResolveContext;
import com.tplink.smb.omada.dispatcher.resolver.ParameterResolver;
import com.tplink.smb.omada.dispatcher.resolver.ResolveResult;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.SpringProxy;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.MethodParameter;
import org.springframework.http.RequestEntity;
import org.springframework.util.CollectionUtils;
import org.springframework.web.multipart.MultipartFile;

public class ParameterResolverInterceptor
extends AbstractServerRequestInterceptor {
    private static final Logger log = LoggerFactory.getLogger(ParameterResolverInterceptor.class);
    private List<ParameterResolver> resolvers;

    @Autowired
    public ParameterResolverInterceptor(List<ParameterResolver> resolvers) {
        this.resolvers = resolvers;
    }

    @Override
    public OperationResponse<?> preHandle(RequestEntity<String> request, Map<String, MultipartFile> multipartFileMap, ApiResponseWrapper<?> response, MethodInfo method, ServiceHandlerChain chain) {
        try {
            Method abstractMethod = null;
            Class<?> serviceClass = method.getMethod().getDeclaringClass();
            if (method.getService() instanceof SpringProxy) {
                serviceClass = method.getService().getClass().getSuperclass();
            }
            if (!serviceClass.isInterface()) {
                Class<?>[] interfaces;
                for (Class<?> interfaceClazz : interfaces = serviceClass.getInterfaces()) {
                    abstractMethod = interfaceClazz.getMethod(method.getMethod().getName(), method.getMethod().getParameterTypes());
                }
                if (abstractMethod == null) {
                    log.error("Find abstract Method failed");
                    return OperationResponse.GENERAL_ERROR;
                }
            } else {
                abstractMethod = method.getMethod();
            }
            if (CollectionUtils.isEmpty(this.resolvers)) {
                return OperationResponse.success(this.getDefaults(abstractMethod));
            }
            ArrayList<Object> attrs = new ArrayList<Object>();
            ParameterResolveContext resolveContext = new ParameterResolveContext(request, multipartFileMap, response);
            for (int i = 0; i < abstractMethod.getParameterCount(); ++i) {
                MethodParameter parameter = new MethodParameter(abstractMethod, i);
                ResolveResult result = this.resolve(resolveContext, parameter);
                if (!result.success()) {
                    if (result.getResult() instanceof OperationResponse) {
                        return (OperationResponse)result.getResult();
                    }
                    return OperationResponse.PARAM_ERROR;
                }
                attrs.add(result.getResult());
            }
            chain.setParams(attrs);
            return OperationResponse.success(attrs);
        }
        catch (Exception e) {
            log.error("Fail to resolve the parameter of method {}", (Object)method.getMethod().getName(), (Object)e);
            return OperationResponse.GENERAL_ERROR;
        }
    }

    private ResolveResult resolve(ParameterResolveContext resolveContext, MethodParameter parameter) {
        block6: for (ParameterResolver resolver : this.resolvers) {
            if (!resolver.supported(parameter, resolveContext)) continue;
            try {
                ResolveResult result = resolver.resolveParameter(parameter, resolveContext);
                switch (result.getStatus()) {
                    case FAILED_STOP: 
                    case SUCCESS: {
                        return result;
                    }
                    case UNHANDLED_CONTINUE: {
                        continue block6;
                    }
                }
            }
            catch (Exception e) {
                log.warn("Resolve API parameter failed {}.", (Object)parameter, (Object)e);
            }
        }
        return ResolveResult.successResult(this.getDefault(parameter));
    }

    private List<Object> getDefaults(Method method) {
        ArrayList<Object> params = new ArrayList<Object>();
        for (int i = 0; i < method.getParameterCount(); ++i) {
            MethodParameter parameter = new MethodParameter(method, i);
            params.add(this.getDefault(parameter));
        }
        return params;
    }

    private Object getDefault(MethodParameter parameter) {
        if (!parameter.getNestedParameterType().isPrimitive()) {
            return null;
        }
        if (Byte.TYPE == parameter.getNestedParameterType()) {
            return (byte)0;
        }
        if (Short.TYPE == parameter.getNestedParameterType()) {
            return (short)0;
        }
        if (Integer.TYPE == parameter.getNestedParameterType()) {
            return 0;
        }
        if (Long.TYPE == parameter.getNestedParameterType()) {
            return 0L;
        }
        if (Boolean.TYPE == parameter.getNestedParameterType()) {
            return false;
        }
        if (Character.TYPE == parameter.getNestedParameterType()) {
            return 0;
        }
        if (Float.TYPE == parameter.getNestedParameterType()) {
            return Float.valueOf(0.0f);
        }
        if (Double.TYPE == parameter.getNestedParameterType()) {
            return 0.0;
        }
        return null;
    }

    public List<ParameterResolver> getResolvers() {
        return this.resolvers;
    }

    public void setResolvers(List<ParameterResolver> resolvers) {
        this.resolvers = resolvers;
    }
}

