/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.dispatcher.interceptor.impl;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.tplink.smb.omada.dispatcher.cache.ServiceMethodInfo;
import com.tplink.smb.omada.dispatcher.chain.HandlerChain;
import com.tplink.smb.omada.dispatcher.common.access.OperationResponse;
import com.tplink.smb.omada.dispatcher.common.response.ApiResponseWrapper;
import com.tplink.smb.omada.dispatcher.interceptor.impl.AbstractRequestInterceptor;
import com.tplink.smb.omada.dispatcher.meter.DispatcherMeters;
import java.time.Duration;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpMethod;
import org.springframework.http.RequestEntity;
import org.springframework.web.multipart.MultipartFile;

@Order(value=100)
public class MetersRequestInterceptor
extends AbstractRequestInterceptor {
    public static final double SECOND_TO_NANOS = TimeUnit.SECONDS.toNanos(1L);
    private final Cache<Long, Long> startNanoCache = CacheBuilder.newBuilder().expireAfterWrite(Duration.ofHours(1L)).initialCapacity(1000).maximumSize(20000L).build();
    private DispatcherMeters dispatcherMeters;

    @Override
    public OperationResponse<?> preHandle(RequestEntity<String> request, Map<String, MultipartFile> multipartFileMap, ApiResponseWrapper<?> response, ServiceMethodInfo method, HandlerChain chain) {
        long requestId = chain.getRequestId();
        this.startNanoCache.put((Object)requestId, (Object)System.nanoTime());
        return OperationResponse.SUCCESS;
    }

    @Override
    public void postHandle(RequestEntity<String> request, OperationResponse<?> result, ApiResponseWrapper<?> response, ServiceMethodInfo method, HandlerChain chain) {
        String httpMethod = Optional.ofNullable(request.getMethod()).map(HttpMethod::name).orElse("unknown");
        String serviceMethodPath = method.getPath();
        int errorCode = result.getErrorCode();
        String importance = method.getImportance();
        String timeCostLevel = method.getTimeCostLevel();
        Long start = (Long)this.startNanoCache.getIfPresent((Object)chain.getRequestId());
        if (start != null) {
            this.startNanoCache.invalidate((Object)chain.getRequestId());
            double delta = (double)(System.nanoTime() - start) / SECOND_TO_NANOS;
            this.dispatcherMeters.summaryRequestsSeconds(httpMethod, serviceMethodPath, errorCode, delta, importance, timeCostLevel);
        }
    }

    public void setDispatcherMeters(DispatcherMeters dispatcherMeters) {
        this.dispatcherMeters = dispatcherMeters;
    }
}

