/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.dispatcher.init;

import com.google.common.collect.Sets;
import com.tplink.smb.omada.dispatcher.annotation.Api;
import com.tplink.smb.omada.dispatcher.annotation.ApiService;
import com.tplink.smb.omada.dispatcher.annotation.AppApi;
import com.tplink.smb.omada.dispatcher.annotation.SupportStream;
import com.tplink.smb.omada.dispatcher.cache.ApiServiceCache;
import com.tplink.smb.omada.dispatcher.init.ApiServiceRegisterStrategy;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.context.ApplicationContext;
import org.springframework.core.annotation.AnnotationUtils;

public class ApiServiceRegister
implements ApiServiceRegisterStrategy {
    ApiServiceCache apiServiceCache;

    public void registerAll(Map<String, Object> beanMap) {
        Collection<Object> beans = beanMap.values();
        for (Object bean : beans) {
            this.resolveApiAndRegisterService(bean);
        }
        this.apiServiceCache.logAllApis();
    }

    @Override
    public void registerAll(ApplicationContext applicationContext) {
        this.registerAll(applicationContext.getBeansWithAnnotation(ApiService.class));
    }

    private <T> void resolveApiAndRegisterService(T service) {
        if (service == null) {
            return;
        }
        Class<?> clazz = service.getClass();
        for (Method method : clazz.getDeclaredMethods()) {
            AppApi appApiAnnotation;
            Api annotation = (Api)AnnotationUtils.findAnnotation((Method)method, Api.class);
            if (annotation != null) {
                SupportStream streamAnnotation = (SupportStream)AnnotationUtils.findAnnotation((Method)method, SupportStream.class);
                if (streamAnnotation != null && streamAnnotation.value()) {
                    this.apiServiceCache.register(annotation.path(), annotation.method(), method, service, Sets.newHashSet((Object[])annotation.requires()).stream().map(String::toString).collect(Collectors.toSet()), annotation.service(), annotation.capability(), Sets.newHashSet((Object[])annotation.encryptKeys()).stream().map(String::toString).collect(Collectors.toSet()));
                } else {
                    this.apiServiceCache.register(annotation.path(), annotation.method(), method, service, Sets.newHashSet((Object[])annotation.requires()).stream().map(String::toString).collect(Collectors.toSet()), annotation.service(), annotation.capability(), Sets.newHashSet((Object[])annotation.encryptKeys()).stream().map(String::toString).collect(Collectors.toSet()));
                }
            }
            if ((appApiAnnotation = (AppApi)AnnotationUtils.findAnnotation((Method)method, AppApi.class)) == null) continue;
            this.apiServiceCache.register(appApiAnnotation.path(), appApiAnnotation.method(), method, service, Sets.newHashSet((Object[])appApiAnnotation.requires()).stream().map(String::toString).collect(Collectors.toSet()), appApiAnnotation.service(), annotation.capability(), Sets.newHashSet((Object[])appApiAnnotation.encryptKeys()).stream().map(String::toString).collect(Collectors.toSet()));
        }
    }

    @Override
    public void reRegister() {
    }

    public void setApiServiceCache(ApiServiceCache apiServiceCache) {
        this.apiServiceCache = apiServiceCache;
    }

    public ApiServiceRegister(ApiServiceCache apiServiceCache) {
        this.apiServiceCache = apiServiceCache;
    }
}

