/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.dispatcher.handler.impl;

import com.google.common.collect.Lists;
import com.tplink.smb.omada.dispatcher.cache.MethodInfo;
import com.tplink.smb.omada.dispatcher.cache.ServiceMethodInfo;
import com.tplink.smb.omada.dispatcher.chain.HandlerChain;
import com.tplink.smb.omada.dispatcher.chain.ServiceHandlerChain;
import com.tplink.smb.omada.dispatcher.common.access.HttpResponse;
import com.tplink.smb.omada.dispatcher.common.access.OperationResponse;
import com.tplink.smb.omada.dispatcher.common.response.ApiResponseWrapper;
import com.tplink.smb.omada.dispatcher.handler.RequestHandler;
import com.tplink.smb.omada.dispatcher.interceptor.ServerRequestExceptionInterceptor;
import com.tplink.smb.omada.dispatcher.interceptor.ServerRequestInterceptor;
import io.reactivex.Single;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.RequestEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.web.multipart.MultipartFile;

@Component
public class ReflectionApiMethodHandler
implements RequestHandler {
    private static final Logger log = LoggerFactory.getLogger(ReflectionApiMethodHandler.class);
    private List<ServerRequestInterceptor> serverRequestInterceptors;
    private ServerRequestExceptionInterceptor serverRequestExceptionInterceptor;

    public HttpResponse<?> handle(RequestEntity<String> request, String sessionId, Map<String, MultipartFile> multipartFileMap, ApiResponseWrapper<?> response, ServiceMethodInfo method, HandlerChain chain) {
        try {
            OperationResponse result;
            MethodInfo methodInfo = new MethodInfo(method.getMethod(), method.getService(), method.getCapability());
            ServiceHandlerChain serviceHandlerChain = ServiceHandlerChain.builder().setResponseWrapper(chain.getResponseWrapper()).setServerRequestInterceptor(this.serverRequestInterceptors).setMethodInfo(methodInfo).setRequestEntity(request).setMultipartFileMap(multipartFileMap).setPathTemplate(method.getPath()).build();
            OperationResponse<?> operationResponse = this.preHandle(request, response, multipartFileMap, methodInfo, serviceHandlerChain);
            if (!operationResponse.success()) {
                result = operationResponse;
            } else if (methodInfo.getMethod().getParameterCount() != serviceHandlerChain.getParams().size()) {
                log.error("Invalid parameter count, need: [{}], provided: [{}].", (Object)methodInfo.getMethod().getParameterCount(), (Object)serviceHandlerChain.getParams().size());
                result = OperationResponse.PARAM_ERROR;
            } else {
                result = method.getMethod().invoke(method.getService(), serviceHandlerChain.getParams().toArray());
            }
            if (result == null) {
                log.error("Invoke API method {} failed, result is null.", (Object)method.getMethod().getName());
                return new HttpResponse(OperationResponse.GENERAL_ERROR);
            }
            if (Single.class.isAssignableFrom(result.getClass())) {
                return ReflectionApiMethodHandler.onResult(((Single)result).blockingGet());
            }
            if (result instanceof OperationResponse) {
                this.postHandle(request, response, result, methodInfo, serviceHandlerChain);
            }
            return ReflectionApiMethodHandler.onResult(result);
        }
        catch (Exception e) {
            log.error("Invoke API method {} failed.", (Object)method.getMethod().getName(), (Object)e);
            try {
                return new HttpResponse(this.serverRequestExceptionInterceptor.handleException(e));
            }
            catch (Exception e1) {
                return new HttpResponse(OperationResponse.GENERAL_ERROR);
            }
        }
    }

    static HttpResponse<?> onResult(Object result) {
        if (OperationResponse.class.isAssignableFrom(result.getClass())) {
            return new HttpResponse((OperationResponse)result);
        }
        if (HttpResponse.class.isAssignableFrom(result.getClass())) {
            return (HttpResponse)result;
        }
        log.warn("Unsupported dispatch method result type: {}", result.getClass());
        return new HttpResponse(OperationResponse.GENERAL_ERROR);
    }

    private OperationResponse<?> preHandle(RequestEntity<String> requestEntity, ApiResponseWrapper apiResponseWrapper, Map<String, MultipartFile> multipartFileMap, MethodInfo methodInfo, ServiceHandlerChain chain) {
        OperationResponse<?> response = OperationResponse.SUCCESS;
        ArrayList<ServerRequestInterceptor> succeededInterceptors = new ArrayList<ServerRequestInterceptor>();
        for (ServerRequestInterceptor preHandleInterceptor : this.serverRequestInterceptors) {
            response = preHandleInterceptor.preHandle(requestEntity, multipartFileMap, apiResponseWrapper, methodInfo, chain);
            succeededInterceptors.add(preHandleInterceptor);
            if (response.success()) continue;
            log.warn("PreHandle the request before invoke method failed, request <{}, {}>", (Object)requestEntity.getMethod(), (Object)requestEntity.getUrl());
            break;
        }
        chain.setSucceededInterceptors(succeededInterceptors);
        return response;
    }

    private OperationResponse<?> postHandle(RequestEntity<String> requestEntity, ApiResponseWrapper apiResponseWrapper, OperationResponse<?> response, MethodInfo methodInfo, ServiceHandlerChain chain) {
        List<ServerRequestInterceptor> succeededInterceptors = chain.getSucceededInterceptors();
        if (!CollectionUtils.isEmpty(this.serverRequestInterceptors)) {
            for (ServerRequestInterceptor interceptor : Lists.reverse(succeededInterceptors)) {
                interceptor.postHandle(requestEntity, response, apiResponseWrapper, methodInfo, chain);
            }
        }
        return response;
    }

    @Autowired
    public void setServerRequestInterceptors(List<ServerRequestInterceptor> serverRequestInterceptors) {
        this.serverRequestInterceptors = Collections.unmodifiableList(serverRequestInterceptors);
    }

    @Autowired
    public void setServerRequestExceptionInterceptor(ServerRequestExceptionInterceptor serverRequestExceptionInterceptor) {
        this.serverRequestExceptionInterceptor = serverRequestExceptionInterceptor;
    }
}

