/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.dispatcher.configuration;

import com.tplink.smb.omada.dispatcher.common.access.OperationResponse;
import java.util.Set;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(value="omada-dispatcher")
public class DispatcherProperties {
    private StreamProperties stream = new StreamProperties();
    private AsyncProperties async = new AsyncProperties();
    private RequestProperties request = new RequestProperties();
    private boolean segmentErrCodeEnable = true;
    private Set<Integer> errCodeToMonitor = Set.of(Integer.valueOf(OperationResponse.DB_OPT_FAILED.getErrorCode()), Integer.valueOf(OperationResponse.INTERNAL_SERVER_ERROR.getErrorCode()), Integer.valueOf(OperationResponse.PLATFORM_SERVER_ERROR.getErrorCode()), Integer.valueOf(OperationResponse.SERVICE_UNAVAILABLE.getErrorCode()), Integer.valueOf(OperationResponse.SYSTEM_BUSY.getErrorCode()));

    public StreamProperties getStream() {
        return this.stream;
    }

    public AsyncProperties getAsync() {
        return this.async;
    }

    public RequestProperties getRequest() {
        return this.request;
    }

    public boolean isSegmentErrCodeEnable() {
        return this.segmentErrCodeEnable;
    }

    public Set<Integer> getErrCodeToMonitor() {
        return this.errCodeToMonitor;
    }

    public void setStream(StreamProperties stream) {
        this.stream = stream;
    }

    public void setAsync(AsyncProperties async) {
        this.async = async;
    }

    public void setRequest(RequestProperties request) {
        this.request = request;
    }

    public void setSegmentErrCodeEnable(boolean segmentErrCodeEnable) {
        this.segmentErrCodeEnable = segmentErrCodeEnable;
    }

    public void setErrCodeToMonitor(Set<Integer> errCodeToMonitor) {
        this.errCodeToMonitor = errCodeToMonitor;
    }

    public static class StreamProperties {
        private boolean enable = false;

        public boolean isEnable() {
            return this.enable;
        }

        public void setEnable(boolean enable) {
            this.enable = enable;
        }
    }

    public static class AsyncProperties {
        private boolean enable = false;
        private AsyncExecutorProperties threadPool = new AsyncExecutorProperties();

        public boolean isEnable() {
            return this.enable;
        }

        public AsyncExecutorProperties getThreadPool() {
            return this.threadPool;
        }

        public void setEnable(boolean enable) {
            this.enable = enable;
        }

        public void setThreadPool(AsyncExecutorProperties threadPool) {
            this.threadPool = threadPool;
        }

        public static class AsyncExecutorProperties {
            private int coreSize = 5;
            private int maxSize = 100;
            private int aliveMillis = 100000;
            private int queueSize = 100000;

            public int getCoreSize() {
                return this.coreSize;
            }

            public int getMaxSize() {
                return this.maxSize;
            }

            public int getAliveMillis() {
                return this.aliveMillis;
            }

            public int getQueueSize() {
                return this.queueSize;
            }

            public void setCoreSize(int coreSize) {
                this.coreSize = coreSize;
            }

            public void setMaxSize(int maxSize) {
                this.maxSize = maxSize;
            }

            public void setAliveMillis(int aliveMillis) {
                this.aliveMillis = aliveMillis;
            }

            public void setQueueSize(int queueSize) {
                this.queueSize = queueSize;
            }
        }
    }

    public static class RequestProperties {
        private Integer timeOut = 21;

        public Integer getTimeOut() {
            return this.timeOut;
        }

        public void setTimeOut(Integer timeOut) {
            this.timeOut = timeOut;
        }
    }
}

