/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.dispatcher.configuration;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.tplink.smb.omada.dispatcher.RestDispatcher;
import com.tplink.smb.omada.dispatcher.cache.ApiServiceCache;
import com.tplink.smb.omada.dispatcher.cache.ApiServiceInMemoryCache;
import com.tplink.smb.omada.dispatcher.chain.HandlerChainManager;
import com.tplink.smb.omada.dispatcher.chain.strategy.HandlerChainBuildStrategy;
import com.tplink.smb.omada.dispatcher.cluster.NodeDispatcher;
import com.tplink.smb.omada.dispatcher.common.access.OperationResponse;
import com.tplink.smb.omada.dispatcher.configuration.DispatcherProperties;
import com.tplink.smb.omada.dispatcher.configuration.GrpcThreadPoolExecutorWrapper;
import com.tplink.smb.omada.dispatcher.configuration.ParameterResolverObjectMapperConfigurer;
import com.tplink.smb.omada.dispatcher.handler.RequestHandler;
import com.tplink.smb.omada.dispatcher.init.ApiServiceRegister;
import com.tplink.smb.omada.dispatcher.interceptor.RequestInterceptor;
import com.tplink.smb.omada.dispatcher.interceptor.ServerRequestExceptionInterceptor;
import com.tplink.smb.omada.dispatcher.interceptor.ServerRequestInterceptor;
import com.tplink.smb.omada.dispatcher.interceptor.impl.MetersRequestInterceptor;
import com.tplink.smb.omada.dispatcher.interceptor.impl.ParameterResolverInterceptor;
import com.tplink.smb.omada.dispatcher.interceptor.impl.XSSAttackInterceptor;
import com.tplink.smb.omada.dispatcher.meter.DispatcherMeters;
import com.tplink.smb.omada.dispatcher.resolver.ParameterResolver;
import com.tplink.smb.omada.dispatcher.resolver.impl.AppPathVariableResolver;
import com.tplink.smb.omada.dispatcher.resolver.impl.ContextParamResolver;
import com.tplink.smb.omada.dispatcher.resolver.impl.Message2VOResolver;
import com.tplink.smb.omada.dispatcher.resolver.impl.MultipartFileResolver;
import com.tplink.smb.omada.dispatcher.resolver.impl.PathVariableResolver;
import com.tplink.smb.omada.dispatcher.resolver.impl.RequestAttributeResolver;
import com.tplink.smb.omada.dispatcher.resolver.impl.RequestBodyResolver;
import com.tplink.smb.omada.dispatcher.resolver.impl.RequestParameterResolver;
import io.micrometer.core.instrument.MeterRegistry;
import jakarta.annotation.Resource;
import jakarta.validation.Validator;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.core.annotation.Order;

@AutoConfiguration
@EnableConfigurationProperties(value={DispatcherProperties.class})
public class DispatcherConfiguration {
    @Resource
    private DispatcherProperties dispatcherProperties;

    @Bean
    @ConditionalOnMissingBean
    public HandlerChainManager handlerChainManager(List<RequestInterceptor> requestInterceptors, List<RequestHandler> requestHandlers, List<HandlerChainBuildStrategy> handlerChainBuildStrategies) {
        HandlerChainManager handlerChainManager = new HandlerChainManager();
        handlerChainManager.setInterceptors(requestInterceptors);
        handlerChainManager.setRequestHandlers(requestHandlers);
        handlerChainManager.setBuildStrategies(handlerChainBuildStrategies);
        handlerChainManager.setDispatcherProperties(this.dispatcherProperties);
        return handlerChainManager;
    }

    @Bean(name={"grpcExecutors"})
    @ConditionalOnProperty(name={"omada-dispatcher.async.enable"}, havingValue="true")
    public ExecutorService grpcExecutors() {
        DispatcherProperties.AsyncProperties.AsyncExecutorProperties executorProperties = this.dispatcherProperties.getAsync().getThreadPool();
        return new GrpcThreadPoolExecutorWrapper(executorProperties.getCoreSize(), executorProperties.getMaxSize(), (long)executorProperties.getAliveMillis(), TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(executorProperties.getQueueSize()), new ThreadFactoryBuilder().setNameFormat("dispatcher-async-worker-%d").build());
    }

    @Bean
    public RestDispatcher restDispatcher(ApiServiceCache apiServiceCache, HandlerChainManager handlerChainManager, NodeDispatcher nodeDispatcher) {
        RestDispatcher restDispatcher = new RestDispatcher();
        restDispatcher.setApiServiceCache(apiServiceCache);
        restDispatcher.setHandlerChainManager(handlerChainManager);
        restDispatcher.setNodeDispatcher(nodeDispatcher);
        return restDispatcher;
    }

    @Bean
    @ConditionalOnMissingBean(name={"requestInterceptors"})
    public List<RequestInterceptor> requestInterceptors(XSSAttackInterceptor xssAttackInterceptor, MetersRequestInterceptor metersRequestInterceptor) {
        ArrayList<RequestInterceptor> interceptors = new ArrayList<RequestInterceptor>();
        interceptors.add(xssAttackInterceptor);
        interceptors.add(metersRequestInterceptor);
        return interceptors;
    }

    @Bean
    @ConditionalOnMissingBean
    public XSSAttackInterceptor xssAttackInterceptor() {
        return new XSSAttackInterceptor();
    }

    @Bean
    @ConditionalOnMissingBean
    public MetersRequestInterceptor prometheusRequestInterceptor(DispatcherMeters dispatcherMeters) {
        MetersRequestInterceptor metersRequestInterceptor = new MetersRequestInterceptor();
        metersRequestInterceptor.setDispatcherMeters(dispatcherMeters);
        return metersRequestInterceptor;
    }

    @Bean
    public ApiServiceInMemoryCache apiServiceInMemoryCache() {
        return new ApiServiceInMemoryCache();
    }

    @Bean
    @ConditionalOnMissingBean
    @Order(value=1)
    public ParameterResolverInterceptor parameterResolverInterceptor(List<ParameterResolver> parameterResolvers) {
        return new ParameterResolverInterceptor(parameterResolvers);
    }

    @Bean
    @ConditionalOnMissingBean
    public ParameterResolverObjectMapperConfigurer parameterResolverConfigurer() {
        return objectMapper -> {};
    }

    @Bean
    public ApiServiceRegister apiServiceRegister(ApiServiceCache apiServiceCache) {
        return new ApiServiceRegister(apiServiceCache);
    }

    @Bean(value={"parameterResolverObjectMapper"})
    @ConditionalOnMissingBean(name={"parameterResolverObjectMapper"})
    public ObjectMapper parameterResolverObjectMapper(@Autowired(required=false) ParameterResolverObjectMapperConfigurer configurer) {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.configure(JsonGenerator.Feature.IGNORE_UNKNOWN, false);
        objectMapper.configure(DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT, true);
        objectMapper.configure(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY, true);
        if (configurer != null) {
            configurer.configure(objectMapper);
        }
        return objectMapper;
    }

    @Bean(name={"message2VOResolver"})
    @ConditionalOnMissingBean(name={"message2VOResolver"})
    public Message2VOResolver message2VOResolver(Validator validator, @Qualifier(value="parameterResolverObjectMapper") ObjectMapper objectMapper) {
        return new Message2VOResolver(validator, objectMapper);
    }

    @Bean(name={"appPathVariableResolver"})
    @ConditionalOnMissingBean(name={"appPathVariableResolver"})
    public AppPathVariableResolver appPathVariableResolver() {
        return new AppPathVariableResolver();
    }

    @Bean(name={"contextParamResolver"})
    @ConditionalOnMissingBean(name={"contextParamResolver"})
    public ContextParamResolver contextParamResolver() {
        return new ContextParamResolver();
    }

    @Bean(name={"multipartFileResolver"})
    @ConditionalOnMissingBean(name={"multipartFileResolver"})
    public MultipartFileResolver multipartFileResolver() {
        return new MultipartFileResolver();
    }

    @Bean(name={"pathVariableResolver"})
    @ConditionalOnMissingBean(name={"pathVariableResolver"})
    public PathVariableResolver pathVariableResolver() {
        return new PathVariableResolver();
    }

    @Bean(name={"requestAttributeResolver"})
    @ConditionalOnMissingBean(name={"requestAttributeResolver"})
    public RequestAttributeResolver requestAttributeResolver(@Qualifier(value="parameterResolverObjectMapper") ObjectMapper objectMapper) {
        return new RequestAttributeResolver(objectMapper);
    }

    @Bean(name={"requestBodyResolver"})
    @ConditionalOnMissingBean(name={"requestBodyResolver"})
    public RequestBodyResolver requestBodyResolver(@Qualifier(value="parameterResolverObjectMapper") ObjectMapper objectMapper) {
        return new RequestBodyResolver(objectMapper);
    }

    @Bean(name={"requestParameterResolver"})
    @ConditionalOnMissingBean(name={"requestParameterResolver"})
    public RequestParameterResolver requestParameterResolver() {
        return new RequestParameterResolver();
    }

    @Bean
    public DispatcherMeters dispatcherMeters(MeterRegistry meterRegistry) {
        DispatcherMeters dispatcherMeters = new DispatcherMeters();
        dispatcherMeters.setMeterRegistry(meterRegistry);
        dispatcherMeters.setDispatcherProperties(this.dispatcherProperties);
        return dispatcherMeters;
    }

    @Bean
    @ConditionalOnMissingBean
    public ServerRequestExceptionInterceptor serverRequestExceptionInterceptor() {
        return new ServerRequestExceptionInterceptor(){

            @Override
            public OperationResponse<?> handleException(Exception e) throws Exception {
                throw e;
            }
        };
    }

    @ComponentScan(basePackageClasses={ServerRequestInterceptor.class})
    public static class ServerRequestInterceptorConfiguration {
    }

    @ComponentScan(basePackageClasses={ParameterResolver.class})
    public static class ParamResolverConfiguration {
    }

    @ComponentScan(basePackageClasses={HandlerChainBuildStrategy.class})
    public static class HandlerChainBuildStrategyConfiguration {
    }

    @ComponentScan(basePackageClasses={RequestHandler.class})
    public static class RequestHandlerConfiguration {
    }

    @ComponentScan(basePackageClasses={RequestInterceptor.class})
    public static class RequestInterceptorConfiguration {
    }

    public static final class BeanNames {
        public static final String OBJECT_MAPPER_BEAN_NAME = "parameterResolverObjectMapper";
        public static final String REQUEST_PARAMETER_RESOLVER = "requestParameterResolver";
        public static final String REQUEST_BODY_RESOLVER = "requestBodyResolver";
        public static final String REQUEST_ATTRIBUTE_RESOLVER = "requestAttributeResolver";
        public static final String PATH_VARIABLE_RESOLVER = "pathVariableResolver";
        public static final String MULTIPART_FILE_RESOLVER = "multipartFileResolver";
        public static final String CONTEXT_PARAM_RESOLVER = "contextParamResolver";
        public static final String APP_PATH_VARIABLE_RESOLVER = "appPathVariableResolver";
        public static final String MESSAGE_2_VO_RESOLVER = "message2VOResolver";
    }
}

