/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.dispatcher.chain;

import com.tplink.smb.omada.dispatcher.cache.MethodInfo;
import com.tplink.smb.omada.dispatcher.common.response.ApiResponseWrapper;
import com.tplink.smb.omada.dispatcher.interceptor.ServerRequestInterceptor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.RequestEntity;
import org.springframework.util.CollectionUtils;
import org.springframework.web.multipart.MultipartFile;

public class ServiceHandlerChain {
    private static final Logger log = LoggerFactory.getLogger(ServiceHandlerChain.class);
    private static final AtomicLong requestIdGenerator = new AtomicLong(0L);
    private final List<ServerRequestInterceptor> serverRequestInterceptor;
    private final MethodInfo methodInfo;
    private final RequestEntity<String> requestEntity;
    private final Map<String, MultipartFile> multipartFileMap;
    private final ApiResponseWrapper<?> responseWrapper;
    private final long requestId;
    private final String pathTemplate;
    private List<ServerRequestInterceptor> succeededInterceptors = new ArrayList<ServerRequestInterceptor>();
    private List<Object> params = new ArrayList<Object>();

    private ServiceHandlerChain(List<ServerRequestInterceptor> serverRequestInterceptor, MethodInfo methodInfo, RequestEntity<String> requestEntity, Map<String, MultipartFile> multipartFileMap, ApiResponseWrapper<?> responseWrapper, String pathTemplate) {
        this.methodInfo = methodInfo;
        this.serverRequestInterceptor = serverRequestInterceptor;
        this.requestEntity = requestEntity;
        this.multipartFileMap = multipartFileMap;
        this.responseWrapper = responseWrapper;
        this.pathTemplate = pathTemplate;
        this.requestId = requestIdGenerator.incrementAndGet();
    }

    public static ServiceHandlerChainBuilder builder() {
        return new ServiceHandlerChainBuilder();
    }

    public List<Object> getParams() {
        return Collections.unmodifiableList(this.params);
    }

    public List<ServerRequestInterceptor> getServerRequestInterceptor() {
        return this.serverRequestInterceptor;
    }

    public MethodInfo getMethodInfo() {
        return this.methodInfo;
    }

    public RequestEntity<String> getRequestEntity() {
        return this.requestEntity;
    }

    public Map<String, MultipartFile> getMultipartFileMap() {
        return this.multipartFileMap;
    }

    public ApiResponseWrapper<?> getResponseWrapper() {
        return this.responseWrapper;
    }

    public long getRequestId() {
        return this.requestId;
    }

    public String getPathTemplate() {
        return this.pathTemplate;
    }

    public List<ServerRequestInterceptor> getSucceededInterceptors() {
        return this.succeededInterceptors;
    }

    public void setSucceededInterceptors(List<ServerRequestInterceptor> succeededInterceptors) {
        this.succeededInterceptors = succeededInterceptors;
    }

    public void setParams(List<Object> params) {
        this.params = params;
    }

    public static class ServiceHandlerChainBuilder {
        private List<ServerRequestInterceptor> serverRequestInterceptors = Collections.emptyList();
        private MethodInfo methodInfo = null;
        private RequestEntity<String> requestEntity = null;
        private Map<String, MultipartFile> multipartFileMap = Collections.emptyMap();
        private ApiResponseWrapper<?> responseWrapper = null;
        private String pathTemplate = null;

        private ServiceHandlerChainBuilder() {
        }

        public ServiceHandlerChain build() {
            return new ServiceHandlerChain(this.serverRequestInterceptors, this.methodInfo, this.requestEntity, this.multipartFileMap, this.responseWrapper, this.pathTemplate);
        }

        public ServiceHandlerChainBuilder setServerRequestInterceptor(List<ServerRequestInterceptor> serverRequestInterceptors) {
            if (CollectionUtils.isEmpty(serverRequestInterceptors)) {
                return this;
            }
            this.serverRequestInterceptors = Collections.unmodifiableList(serverRequestInterceptors);
            return this;
        }

        public ServiceHandlerChainBuilder setMethodInfo(MethodInfo methodInfo) {
            Objects.requireNonNull(methodInfo);
            this.methodInfo = methodInfo;
            return this;
        }

        public ServiceHandlerChainBuilder setRequestEntity(RequestEntity<String> requestEntity) {
            Objects.requireNonNull(requestEntity);
            this.requestEntity = requestEntity;
            return this;
        }

        public ServiceHandlerChainBuilder setMultipartFileMap(Map<String, MultipartFile> multipartFileMap) {
            if (CollectionUtils.isEmpty(multipartFileMap)) {
                return this;
            }
            this.multipartFileMap = Collections.unmodifiableMap(multipartFileMap);
            return this;
        }

        public ServiceHandlerChainBuilder setResponseWrapper(ApiResponseWrapper<?> responseWrapper) {
            Objects.requireNonNull(responseWrapper);
            this.responseWrapper = responseWrapper;
            return this;
        }

        public ServiceHandlerChainBuilder setPathTemplate(String pathTemplate) {
            this.pathTemplate = pathTemplate;
            return this;
        }
    }
}

