/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.dispatcher.chain;

import com.tplink.smb.omada.dispatcher.cache.ServiceMethodInfo;
import com.tplink.smb.omada.dispatcher.chain.HandlerChain;
import com.tplink.smb.omada.dispatcher.chain.exception.HandlerChainBuildException;
import com.tplink.smb.omada.dispatcher.chain.strategy.HandlerChainBuildStrategy;
import com.tplink.smb.omada.dispatcher.common.access.HttpMethod;
import com.tplink.smb.omada.dispatcher.common.response.ApiResponseWrapper;
import com.tplink.smb.omada.dispatcher.configuration.DispatcherProperties;
import com.tplink.smb.omada.dispatcher.handler.RequestHandler;
import com.tplink.smb.omada.dispatcher.interceptor.RequestInterceptor;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.RequestEntity;
import org.springframework.web.multipart.MultipartFile;

public class HandlerChainManager {
    private static final Logger log = LoggerFactory.getLogger(HandlerChainManager.class);
    private static final AtomicLong REQUEST_ID_SEQ = new AtomicLong(0L);
    private DispatcherProperties dispatcherProperties;
    private List<RequestInterceptor> interceptors;
    private List<RequestHandler> requestHandlers;
    private List<HandlerChainBuildStrategy> buildStrategies;

    public HandlerChain createHandlerChain(HttpMethod httpMethod, ServiceMethodInfo method, RequestEntity<String> requestEntity, String sessionId, String omadacId, Map<String, MultipartFile> multipartFileMap, ApiResponseWrapper<?> responseWrapper, boolean openApiRequest, String accessToken) {
        for (HandlerChainBuildStrategy buildStrategy : this.buildStrategies) {
            if (!buildStrategy.isAbleToHandle(httpMethod, method, this.dispatcherProperties.getAsync().isEnable(), this.dispatcherProperties.getStream().isEnable())) continue;
            if (log.isTraceEnabled()) {
                log.trace("Using chain strategy: [{}] for request: [{} {}].", new Object[]{buildStrategy.getClass().getName(), httpMethod, method.getPath()});
            }
            return HandlerChain.builder().setMethodInfo(method).setRequestInterceptors(buildStrategy.getInterceptors(this.interceptors)).setRequestHandler(buildStrategy.getRequestHandler(this.requestHandlers)).setRequestEntity(requestEntity).setResponseWrapper(responseWrapper).setSessionId(sessionId).setMultipartFileMap(multipartFileMap).setOmadacId(omadacId).setRequestId(REQUEST_ID_SEQ.incrementAndGet()).setOpenApiRequest(openApiRequest).setAccessToken(accessToken).build();
        }
        log.error("Chain strategy not found for request: [{} {}]", (Object)method.getHttpMethod(), (Object)method.getPath());
        throw new HandlerChainBuildException("Failed to find chain build strategy to apply for request: [" + httpMethod + " " + method.getPath() + "]");
    }

    public void setInterceptors(List<RequestInterceptor> interceptors) {
        this.interceptors = interceptors;
    }

    public void setRequestHandlers(List<RequestHandler> requestHandlers) {
        this.requestHandlers = requestHandlers;
    }

    public void setBuildStrategies(List<HandlerChainBuildStrategy> buildStrategies) {
        this.buildStrategies = buildStrategies;
    }

    public void setDispatcherProperties(DispatcherProperties dispatcherProperties) {
        this.dispatcherProperties = dispatcherProperties;
    }
}

