/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.dispatcher.chain;

import com.google.common.collect.Lists;
import com.tplink.smb.omada.dispatcher.cache.ServiceMethodInfo;
import com.tplink.smb.omada.dispatcher.chain.exception.HandlerChainStateException;
import com.tplink.smb.omada.dispatcher.chain.exception.InvalidResultTypeException;
import com.tplink.smb.omada.dispatcher.common.access.HttpResponse;
import com.tplink.smb.omada.dispatcher.common.access.OperationResponse;
import com.tplink.smb.omada.dispatcher.common.response.ApiResponseWrapper;
import com.tplink.smb.omada.dispatcher.common.util.AccessTokenUtils;
import com.tplink.smb.omada.dispatcher.common.util.SessionUtils;
import com.tplink.smb.omada.dispatcher.handler.RequestHandler;
import com.tplink.smb.omada.dispatcher.interceptor.RequestInterceptor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.RequestEntity;
import org.springframework.util.CollectionUtils;
import org.springframework.web.context.request.async.DeferredResult;
import org.springframework.web.multipart.MultipartFile;

public class HandlerChain {
    private static final Logger log = LoggerFactory.getLogger(HandlerChain.class);
    private final List<RequestInterceptor> requestInterceptors;
    private final List<RequestInterceptor> succeededInterceptors = new ArrayList<RequestInterceptor>();
    private final RequestHandler requestHandler;
    private final ServiceMethodInfo methodInfo;
    private final RequestEntity<String> requestEntity;
    private final String sessionId;
    private final String omadacId;
    private final Map<String, MultipartFile> multipartFileMap;
    private final ApiResponseWrapper<?> responseWrapper;
    private final long requestId;
    private final boolean openApiRequest;
    private final String accessToken;
    private final AtomicBoolean executed = new AtomicBoolean(false);
    private List<Object> params = Collections.emptyList();

    private HandlerChain(List<RequestInterceptor> requestInterceptors, RequestHandler requestHandler, ServiceMethodInfo methodInfo, RequestEntity<String> requestEntity, String sessionId, String omadacId, Map<String, MultipartFile> multipartFileMap, ApiResponseWrapper<?> responseWrapper, long requestId, boolean openApiRequest, String accessToken) {
        this.methodInfo = methodInfo;
        this.requestInterceptors = requestInterceptors;
        this.requestHandler = requestHandler;
        this.requestEntity = requestEntity;
        this.multipartFileMap = multipartFileMap;
        this.responseWrapper = responseWrapper;
        this.sessionId = sessionId;
        this.omadacId = omadacId;
        this.requestId = requestId;
        this.openApiRequest = openApiRequest;
        this.accessToken = accessToken;
    }

    public static HandlerChainBuilder builder() {
        return new HandlerChainBuilder();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public Object execute() {
        if (!this.executed.compareAndSet(false, true)) {
            throw new HandlerChainStateException("A HandlerChain should not execute more than once.");
        }
        try {
            SessionUtils.setThreadSessionId((String)this.sessionId);
            AccessTokenUtils.setAccessToken((String)this.accessToken);
            OperationResponse<?> response = this.preHandle();
            if (response.success()) {
                try {
                    Object handlerResult = this.requestHandler.handle(this.requestEntity, this.sessionId, this.multipartFileMap, this.responseWrapper, this.methodInfo, this);
                    Object object = this.onHandleComplete(handlerResult);
                    return object;
                }
                catch (Exception e) {
                    log.warn("Execute {} handle failed with exception", (Object)this.requestHandler, (Object)e);
                    OperationResponse<?> operationResponse = this.onHandleComplete(OperationResponse.GENERAL_ERROR);
                    SessionUtils.clearThreadSession();
                    AccessTokenUtils.clearThreadSession();
                    return operationResponse;
                }
            }
            OperationResponse<?> operationResponse = this.postHandle(response);
            return operationResponse;
            {
                catch (Exception ex) {
                    log.error("Execute RestDispatcher HandlerChain failed with exception, request:<{} {}>", new Object[]{this.requestEntity.getMethod(), this.requestEntity.getUrl(), ex});
                    OperationResponse operationResponse2 = OperationResponse.GENERAL_ERROR;
                    return operationResponse2;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            SessionUtils.clearThreadSession();
            AccessTokenUtils.clearThreadSession();
        }
    }

    public Object onHandleComplete(Object handlerResult) {
        if (handlerResult instanceof HttpResponse) {
            HttpResponse httpResponse = (HttpResponse)handlerResult;
            return this.postHandle(new OperationResponse(httpResponse.getErrorCode(), httpResponse.getMsg(), httpResponse.getResult()));
        }
        if (handlerResult instanceof OperationResponse) {
            return this.postHandle((OperationResponse)handlerResult);
        }
        if (handlerResult instanceof DeferredResult) {
            return handlerResult;
        }
        throw new InvalidResultTypeException("RequestHandler " + this.requestHandler.getClass().getName() + " returned unsupported result " + handlerResult.toString());
    }

    public OperationResponse<?> onHandleComplete(OperationResponse<?> operationResponse) {
        return this.postHandle(operationResponse);
    }

    private OperationResponse<?> preHandle() {
        OperationResponse<?> response = OperationResponse.SUCCESS;
        for (RequestInterceptor preHandleInterceptor : this.requestInterceptors) {
            response = preHandleInterceptor.preHandle(this.requestEntity, this.multipartFileMap, this.responseWrapper, this.methodInfo, this);
            this.succeededInterceptors.add(preHandleInterceptor);
            if (response.success()) continue;
            break;
        }
        return response;
    }

    private OperationResponse<?> postHandle(OperationResponse<?> response) {
        if (!CollectionUtils.isEmpty(this.requestInterceptors)) {
            for (RequestInterceptor interceptor : Lists.reverse(this.succeededInterceptors)) {
                interceptor.postHandle(this.requestEntity, response, this.responseWrapper, this.methodInfo, this);
            }
        }
        return response;
    }

    public void setParams(List<Object> params) {
        this.params = params;
    }

    public List<RequestInterceptor> getRequestInterceptors() {
        return this.requestInterceptors;
    }

    public List<RequestInterceptor> getSucceededInterceptors() {
        return this.succeededInterceptors;
    }

    public RequestHandler getRequestHandler() {
        return this.requestHandler;
    }

    public ServiceMethodInfo getMethodInfo() {
        return this.methodInfo;
    }

    public RequestEntity<String> getRequestEntity() {
        return this.requestEntity;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public String getOmadacId() {
        return this.omadacId;
    }

    public Map<String, MultipartFile> getMultipartFileMap() {
        return this.multipartFileMap;
    }

    public ApiResponseWrapper<?> getResponseWrapper() {
        return this.responseWrapper;
    }

    public long getRequestId() {
        return this.requestId;
    }

    public boolean isOpenApiRequest() {
        return this.openApiRequest;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public AtomicBoolean getExecuted() {
        return this.executed;
    }

    public List<Object> getParams() {
        return this.params;
    }

    public static class HandlerChainBuilder {
        private List<RequestInterceptor> requestInterceptors = Collections.emptyList();
        private RequestHandler requestHandler = null;
        private ServiceMethodInfo methodInfo = null;
        private RequestEntity<String> requestEntity = null;
        private Map<String, MultipartFile> multipartFileMap = Collections.emptyMap();
        private ApiResponseWrapper<?> responseWrapper = null;
        private String sessionId = null;
        private String omadacId = null;
        private long requestId = -1L;
        private boolean openApiRequest = false;
        private String accessToken = null;

        private HandlerChainBuilder() {
        }

        public HandlerChain build() {
            return new HandlerChain(this.requestInterceptors, this.requestHandler, this.methodInfo, this.requestEntity, this.sessionId, this.omadacId, this.multipartFileMap, this.responseWrapper, this.requestId, this.openApiRequest, this.accessToken);
        }

        public HandlerChainBuilder setRequestInterceptors(List<RequestInterceptor> requestInterceptors) {
            if (CollectionUtils.isEmpty(requestInterceptors)) {
                return this;
            }
            this.requestInterceptors = Collections.unmodifiableList(requestInterceptors);
            return this;
        }

        public HandlerChainBuilder setRequestHandler(RequestHandler requestHandler) {
            Objects.requireNonNull(requestHandler);
            this.requestHandler = requestHandler;
            return this;
        }

        public HandlerChainBuilder setMethodInfo(ServiceMethodInfo methodInfo) {
            Objects.requireNonNull(methodInfo);
            this.methodInfo = methodInfo;
            return this;
        }

        public HandlerChainBuilder setRequestEntity(RequestEntity<String> requestEntity) {
            Objects.requireNonNull(requestEntity);
            this.requestEntity = requestEntity;
            return this;
        }

        public HandlerChainBuilder setMultipartFileMap(Map<String, MultipartFile> multipartFileMap) {
            if (CollectionUtils.isEmpty(multipartFileMap)) {
                return this;
            }
            this.multipartFileMap = Collections.unmodifiableMap(multipartFileMap);
            return this;
        }

        public HandlerChainBuilder setResponseWrapper(ApiResponseWrapper<?> responseWrapper) {
            Objects.requireNonNull(responseWrapper);
            this.responseWrapper = responseWrapper;
            return this;
        }

        public HandlerChainBuilder setSessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        public HandlerChainBuilder setOmadacId(String omadacId) {
            this.omadacId = omadacId;
            return this;
        }

        public HandlerChainBuilder setRequestId(long requestId) {
            this.requestId = requestId;
            return this;
        }

        public HandlerChainBuilder setOpenApiRequest(boolean openApiRequest) {
            this.openApiRequest = openApiRequest;
            return this;
        }

        public HandlerChainBuilder setAccessToken(String accessToken) {
            this.accessToken = accessToken;
            return this;
        }
    }
}

