/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.dispatcher.cache;

import com.tplink.smb.omada.dispatcher.annotation.Api;
import com.tplink.smb.omada.dispatcher.annotation.AppApi;
import com.tplink.smb.omada.dispatcher.common.access.HttpMethod;
import com.tplink.smb.omada.dispatcher.common.access.ServiceType;
import jakarta.annotation.Nonnull;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;

public class ServiceMethodInfo {
    private final String path;
    private final HttpMethod[] httpMethod;
    private final Object service;
    private final Method method;
    private final String methodName;
    private final Set<String> permissions;
    private final ServiceType serviceType;
    private final Set<String> apiType;
    private final String capability;
    private final String importance;
    private final String timeCostLevel;
    private final Set<String> encryptFields;

    public ServiceMethodInfo(String path, HttpMethod[] httpMethods, @Nonnull Method method, Object service, Set<String> permissions, ServiceType serviceType, String capability, Set<String> encryptFields) {
        this.path = path;
        this.httpMethod = httpMethods;
        this.method = method;
        this.service = service;
        this.permissions = permissions;
        this.serviceType = serviceType;
        this.methodName = method.getName();
        this.apiType = this.getApiTypes(method);
        this.capability = capability;
        this.importance = "normal";
        this.timeCostLevel = "normal";
        this.encryptFields = encryptFields;
    }

    public ServiceMethodInfo(String path, HttpMethod[] httpMethods, @Nonnull Method method, Object service, Set<String> permissions, ServiceType serviceType, String capability, String importance, String timeCostLevel, Set<String> encryptFields) {
        this.path = path;
        this.httpMethod = httpMethods;
        this.method = method;
        this.service = service;
        this.permissions = permissions;
        this.serviceType = serviceType;
        this.methodName = method.getName();
        this.apiType = this.getApiTypes(method);
        this.capability = capability;
        this.importance = importance;
        this.timeCostLevel = timeCostLevel;
        this.encryptFields = encryptFields;
    }

    public ServiceMethodInfo(String path, HttpMethod[] httpMethods, String methodName, Set<String> permissions, ServiceType serviceType, Set<String> apiType, String capability, Set<String> encryptFields) {
        this.path = path;
        this.httpMethod = httpMethods;
        this.service = null;
        this.method = null;
        this.permissions = permissions;
        this.serviceType = serviceType;
        this.methodName = methodName;
        this.apiType = apiType;
        this.capability = capability;
        this.importance = "normal";
        this.timeCostLevel = "normal";
        this.encryptFields = encryptFields;
    }

    public ServiceMethodInfo(String path, HttpMethod[] httpMethods, String methodName, Set<String> permissions, ServiceType serviceType, Set<String> apiType, String capability, String importance, String timeCostLevel, Set<String> encryptFields) {
        this.path = path;
        this.httpMethod = httpMethods;
        this.service = null;
        this.method = null;
        this.permissions = permissions;
        this.serviceType = serviceType;
        this.methodName = methodName;
        this.apiType = apiType;
        this.capability = capability;
        this.importance = importance;
        this.timeCostLevel = timeCostLevel;
        this.encryptFields = encryptFields;
    }

    private Set<String> getApiTypes(Method method) {
        HashSet<String> apiTypes = new HashSet<String>();
        Api api = method.getAnnotation(Api.class);
        AppApi appApi = method.getAnnotation(AppApi.class);
        if (api != null) {
            apiTypes.add("webApi");
        }
        if (appApi != null) {
            apiTypes.add("appApi");
        }
        return apiTypes;
    }

    public void addApiType(@Nonnull Set<String> apiTypes) {
        this.apiType.addAll(apiTypes);
    }

    public String getPath() {
        return this.path;
    }

    public HttpMethod[] getHttpMethod() {
        return this.httpMethod;
    }

    public Object getService() {
        return this.service;
    }

    public Method getMethod() {
        return this.method;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public Set<String> getPermissions() {
        return this.permissions;
    }

    public ServiceType getServiceType() {
        return this.serviceType;
    }

    public Set<String> getApiType() {
        return this.apiType;
    }

    public String getCapability() {
        return this.capability;
    }

    public String getImportance() {
        return this.importance;
    }

    public String getTimeCostLevel() {
        return this.timeCostLevel;
    }

    public Set<String> getEncryptFields() {
        return this.encryptFields;
    }

    public ServiceMethodInfo(String path, HttpMethod[] httpMethod, Object service, Method method, String methodName, Set<String> permissions, ServiceType serviceType, Set<String> apiType, String capability, String importance, String timeCostLevel, Set<String> encryptFields) {
        this.path = path;
        this.httpMethod = httpMethod;
        this.service = service;
        this.method = method;
        this.methodName = methodName;
        this.permissions = permissions;
        this.serviceType = serviceType;
        this.apiType = apiType;
        this.capability = capability;
        this.importance = importance;
        this.timeCostLevel = timeCostLevel;
        this.encryptFields = encryptFields;
    }
}

