/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.dispatcher.cache;

import com.tplink.smb.omada.dispatcher.cache.ApiEndpoint;
import com.tplink.smb.omada.dispatcher.cache.ApiServiceCache;
import com.tplink.smb.omada.dispatcher.cache.ServiceMethodInfo;
import com.tplink.smb.omada.dispatcher.common.access.HttpMethod;
import com.tplink.smb.omada.dispatcher.common.access.ServiceType;
import com.tplink.smb.omada.dispatcher.common.util.StringUtils;
import jakarta.annotation.Nonnull;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class ApiServiceInMemoryCache
implements ApiServiceCache {
    private static final Logger log = LoggerFactory.getLogger(ApiServiceInMemoryCache.class);
    private static final Pattern WILDCARD = Pattern.compile("^\\{\\w+}$");
    private PathMethodNode ROOT = PathMethodNode.build("");

    private static PathMethodNode getExistedWildcardNode(PathMethodNode node) {
        for (String nodeStr : node.nextMap.keySet()) {
            if (!WILDCARD.matcher(nodeStr).matches()) continue;
            return node.getNextNode(nodeStr);
        }
        return null;
    }

    private static String[] resolvePath(String path) {
        return path.replaceAll("/+", "/").split("/");
    }

    private static void register(String path, HttpMethod[] httpMethods, ServiceMethodInfo methodInfo, PathMethodNode root) {
        if (path == null || httpMethods == null || methodInfo == null) {
            return;
        }
        String[] nodeStrings = ApiServiceInMemoryCache.resolvePath(path);
        PathMethodNode current = root;
        for (String nodeStr : nodeStrings) {
            if (StringUtils.isNull((String)nodeStr)) continue;
            if (current.hasNode(nodeStr)) {
                current = current.getNextNode(nodeStr);
                continue;
            }
            if (WILDCARD.matcher(nodeStr).matches() && ApiServiceInMemoryCache.getExistedWildcardNode(current) != null) {
                throw new PathException("Illegal path [" + path + "], another path parameter exists in same level [" + current.getFullPath() + "]");
            }
            current = PathMethodNode.build(current, nodeStr);
        }
        current.putMethod(httpMethods, methodInfo);
    }

    private PathMethodNode resolveNode(String path) {
        if (path == null) {
            return null;
        }
        String[] nodeStrings = ApiServiceInMemoryCache.resolvePath(path);
        PathMethodNode current = this.ROOT;
        for (String nodeStr : nodeStrings) {
            if (StringUtils.isNull((String)nodeStr)) continue;
            if (current == null) {
                return null;
            }
            current = current.hasNode(nodeStr) ? current.getNextNode(nodeStr) : ApiServiceInMemoryCache.getExistedWildcardNode(current);
        }
        return current;
    }

    @Override
    public void register(ServiceMethodInfo methodInfo) {
        ApiServiceInMemoryCache.register(methodInfo.getPath(), methodInfo.getHttpMethod(), methodInfo, this.ROOT);
    }

    @Override
    public void register(String path, HttpMethod[] httpMethods, Method method, Object service, Set<String> permissions, ServiceType serviceType, String capability, Set<String> encryptFields) {
        ApiServiceInMemoryCache.register(path, httpMethods, new ServiceMethodInfo(path, httpMethods, method, service, permissions, serviceType, capability, encryptFields), this.ROOT);
    }

    @Override
    public ServiceMethodInfo resolveMethod(String path, HttpMethod httpMethod) {
        if (path == null || httpMethod == null) {
            return null;
        }
        PathMethodNode node = this.resolveNode(path);
        if (node == null) {
            log.debug("node is null");
            return null;
        }
        return node.getMethod(httpMethod);
    }

    @Override
    public void logAllApis() {
        if (!log.isDebugEnabled()) {
            return;
        }
        this.logNode(this.ROOT);
    }

    @Override
    public void clearAndRegisterAll(List<ServiceMethodInfo> serviceMethodInfos) {
        if (serviceMethodInfos.isEmpty()) {
            return;
        }
        PathMethodNode tmp = PathMethodNode.build("");
        for (ServiceMethodInfo serviceMethodInfo : serviceMethodInfos) {
            ApiServiceInMemoryCache.register(serviceMethodInfo.getPath(), serviceMethodInfo.getHttpMethod(), serviceMethodInfo, tmp);
        }
        this.ROOT = tmp;
    }

    @Override
    public List<ApiEndpoint> getAllEndpoints() {
        ArrayList<ApiEndpoint> apiEndpoints = new ArrayList<ApiEndpoint>();
        for (Map.Entry<String, PathMethodNode> nextNodeEntry : this.ROOT.nextMap.entrySet()) {
            this.addEndpoints(apiEndpoints, nextNodeEntry.getValue());
        }
        return Collections.unmodifiableList(apiEndpoints);
    }

    private void addEndpoints(@Nonnull List<ApiEndpoint> endpoints, @Nonnull PathMethodNode node) {
        if (!CollectionUtils.isEmpty(node.methodMap)) {
            String fullPath = node.getFullPath();
            endpoints.add(ApiEndpoint.builder().endpoint(fullPath).methods(node.methodMap.keySet()).build());
        }
        if (CollectionUtils.isEmpty(node.nextMap)) {
            return;
        }
        for (Map.Entry<String, PathMethodNode> nextNodeEntry : node.nextMap.entrySet()) {
            this.addEndpoints(endpoints, nextNodeEntry.getValue());
        }
    }

    private void logNode(PathMethodNode node) {
        for (HttpMethod httpMethod : node.methodMap.keySet()) {
            log.debug("Log APIs: --- {} {} -->> {}", new Object[]{httpMethod, node.getFullPath(), node.methodMap.get(httpMethod)});
        }
        for (String key : node.nextMap.keySet()) {
            this.logNode(node.nextMap.get(key));
        }
    }

    private static class PathMethodNode {
        private final PathMethodNode parent;
        private final String nodeStr;
        private final Map<HttpMethod, ServiceMethodInfo> methodMap;
        private final Map<String, PathMethodNode> nextMap;

        private PathMethodNode(String nodeStr) {
            this.parent = null;
            this.nodeStr = nodeStr;
            this.methodMap = new HashMap<HttpMethod, ServiceMethodInfo>(4);
            this.nextMap = new HashMap<String, PathMethodNode>(4);
        }

        private PathMethodNode(PathMethodNode parent, String nodeStr) {
            this.parent = parent;
            this.nodeStr = nodeStr;
            this.methodMap = new HashMap<HttpMethod, ServiceMethodInfo>(4);
            this.nextMap = new HashMap<String, PathMethodNode>(4);
        }

        public static PathMethodNode build(String nodeStr) {
            return new PathMethodNode(nodeStr);
        }

        public static PathMethodNode build(PathMethodNode parent, String nodeStr) {
            PathMethodNode node = new PathMethodNode(parent, nodeStr);
            parent.nextMap.put(nodeStr, node);
            return node;
        }

        public PathMethodNode getNextNode(String place) {
            return this.nextMap.get(place);
        }

        public ServiceMethodInfo getMethod(HttpMethod httpMethod) {
            return this.methodMap.get(httpMethod);
        }

        public void putMethod(HttpMethod httpMethod, ServiceMethodInfo method) {
            if (this.methodMap.containsKey(httpMethod) && this.methodMap.get(httpMethod) != null) {
                if (!this.methodMap.get(httpMethod).getMethodName().equals(method.getMethodName())) {
                    log.error("Try to register repeated path {}, httpMethod {}, apiType {} for method {} and {}", new Object[]{method.getPath(), httpMethod, method.getApiType(), this.methodMap.get(httpMethod).getMethodName(), method.getMethodName()});
                } else {
                    HashSet<String> apiTypeSet = new HashSet<String>();
                    apiTypeSet.addAll(this.methodMap.get(httpMethod).getApiType());
                    apiTypeSet.addAll(method.getApiType());
                    method.addApiType(apiTypeSet);
                    this.methodMap.put(httpMethod, method);
                }
            } else {
                this.methodMap.put(httpMethod, method);
            }
        }

        public void putMethod(HttpMethod[] httpMethods, ServiceMethodInfo method) {
            for (HttpMethod httpMethod : httpMethods) {
                this.putMethod(httpMethod, method);
            }
        }

        public boolean hasNode(String place) {
            return this.nextMap.containsKey(place);
        }

        public String toString() {
            return "FullPath [" + this.getFullPath() + "], " + ReflectionToStringBuilder.toString((Object)this);
        }

        public String getFullPath() {
            PathMethodNode parent = this.parent;
            StringBuilder path = new StringBuilder("/" + this.nodeStr);
            while (parent != null) {
                if (parent.parent != null) {
                    path.insert(0, "/" + parent.nodeStr);
                }
                parent = parent.parent;
            }
            return path.toString();
        }

        public PathMethodNode getParent() {
            return this.parent;
        }

        public String getNodeStr() {
            return this.nodeStr;
        }

        public Map<HttpMethod, ServiceMethodInfo> getMethodMap() {
            return this.methodMap;
        }

        public Map<String, PathMethodNode> getNextMap() {
            return this.nextMap;
        }
    }

    public static class PathException
    extends RuntimeException {
        PathException(String message) {
            super(message);
        }
    }
}

