/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.dispatcher;

import com.tplink.smb.omada.dispatcher.cache.ApiServiceCache;
import com.tplink.smb.omada.dispatcher.cache.ServiceMethodInfo;
import com.tplink.smb.omada.dispatcher.chain.HandlerChainManager;
import com.tplink.smb.omada.dispatcher.cluster.NodeDispatcher;
import com.tplink.smb.omada.dispatcher.common.access.HttpMethod;
import com.tplink.smb.omada.dispatcher.common.access.OperationResponse;
import com.tplink.smb.omada.dispatcher.common.response.ApiResponseWrapper;
import jakarta.annotation.Nullable;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.RequestEntity;
import org.springframework.web.multipart.MultipartFile;

public class RestDispatcher {
    private static final Logger log = LoggerFactory.getLogger(RestDispatcher.class);
    private HandlerChainManager handlerChainManager;
    private ApiServiceCache apiServiceCache;
    private NodeDispatcher nodeDispatcher;

    public Object dispatch(RequestEntity<String> requestEntity, @Nullable String sessionId, @Nullable String omadacId, Map<String, MultipartFile> multipartFileMap, ApiResponseWrapper<?> responseWrapper) {
        ServiceMethodInfo serviceMethodInfo;
        HttpMethod httpMethod;
        block7: {
            String nodeIdForSite;
            if (requestEntity == null) {
                log.warn("RequestEntity is null.");
                return OperationResponse.GENERAL_ERROR;
            }
            String path = requestEntity.getUrl().getPath();
            if (requestEntity.getMethod() == null || (httpMethod = HttpMethod.resolve((String)requestEntity.getMethod().name())) == null) {
                log.warn("Failed to resolve request method, method: {}", (Object)requestEntity.getMethod());
                return OperationResponse.UNSUPPORTED_HTTP_PATH;
            }
            serviceMethodInfo = this.apiServiceCache.resolveMethod(path, httpMethod);
            if (serviceMethodInfo == null) {
                log.warn("Unsupported path, path:{}, method:{}", (Object)path, (Object)httpMethod);
                return OperationResponse.UNSUPPORTED_HTTP_PATH;
            }
            if (this.nodeDispatcher.clusterModeOn() && !this.nodeDispatcher.handleByCurrentNode(serviceMethodInfo.getPath()) && (nodeIdForSite = this.nodeDispatcher.getNodeIdForSite(path, serviceMethodInfo)) != null && !Objects.equals(this.nodeDispatcher.getCurrentNodeId(), nodeIdForSite)) {
                try {
                    return this.nodeDispatcher.nodeDispatch(omadacId, nodeIdForSite, path, httpMethod, sessionId, serviceMethodInfo, requestEntity, multipartFileMap, responseWrapper, false, null);
                }
                catch (Exception e) {
                    log.warn("nodeDispatch failed: {}", (Object)e.getMessage());
                    if (this.nodeDispatcher.clusterHAMode()) {
                        log.debug("nodeDispatcher.clusterHAMode()\uff1a");
                        return new OperationResponse(-44272, "Request failed. The target node may have stopped working, Please wait for the switch between the primary and secondary nodes.");
                    }
                    if (!this.nodeDispatcher.clusterHsMode()) break block7;
                    log.debug("nodeDispatcher.clusterHsMode()\uff1a");
                    return new OperationResponse(-44254, "Request failed. The target node may have stopped working, Please wait for a while until the nodes rebalance.");
                }
            }
        }
        return this.handlerChainManager.createHandlerChain(httpMethod, serviceMethodInfo, requestEntity, sessionId, omadacId, multipartFileMap, responseWrapper, false, null).execute();
    }

    public Object dispatchOpenApi(RequestEntity<String> requestEntity, @Nullable String sessionId, @Nullable String omadacId, Map<String, MultipartFile> multipartFileMap, ApiResponseWrapper<?> responseWrapper, String accessToken) {
        String nodeIdForSite;
        HttpMethod httpMethod;
        if (requestEntity == null) {
            log.warn("RequestEntity is null.");
            return OperationResponse.GENERAL_ERROR;
        }
        String path = requestEntity.getUrl().getPath();
        if (requestEntity.getMethod() == null || (httpMethod = HttpMethod.resolve((String)requestEntity.getMethod().name())) == null) {
            log.warn("Failed to resolve request method, method: {}", (Object)requestEntity.getMethod());
            return OperationResponse.UNSUPPORTED_HTTP_PATH;
        }
        ServiceMethodInfo serviceMethodInfo = this.apiServiceCache.resolveMethod(path, httpMethod);
        if (serviceMethodInfo == null) {
            log.warn("Unsupported path, path:{}, method:{}", (Object)path, (Object)httpMethod);
            return OperationResponse.UNSUPPORTED_HTTP_PATH;
        }
        if (this.nodeDispatcher.clusterModeOn() && !this.nodeDispatcher.handleByCurrentNode(serviceMethodInfo.getPath()) && (nodeIdForSite = this.nodeDispatcher.getNodeIdForSite(path, serviceMethodInfo)) != null && !Objects.equals(this.nodeDispatcher.getCurrentNodeId(), nodeIdForSite)) {
            try {
                return this.nodeDispatcher.nodeDispatch(omadacId, nodeIdForSite, path, httpMethod, sessionId, serviceMethodInfo, requestEntity, multipartFileMap, responseWrapper, true, accessToken);
            }
            catch (Exception e) {
                log.warn("nodeDispatch failed: {}", (Object)e.getMessage());
                return new OperationResponse(-44254, "Request failed. The target node may have stopped working, Please wait for a while until the nodes rebalance.");
            }
        }
        return this.handlerChainManager.createHandlerChain(httpMethod, serviceMethodInfo, requestEntity, sessionId, omadacId, multipartFileMap, responseWrapper, true, accessToken).execute();
    }

    public void setApiServiceCache(ApiServiceCache apiServiceCache) {
        this.apiServiceCache = apiServiceCache;
    }

    public void setHandlerChainManager(HandlerChainManager handlerChainManager) {
        this.handlerChainManager = handlerChainManager;
    }

    public void setNodeDispatcher(NodeDispatcher nodeDispatcher) {
        this.nodeDispatcher = nodeDispatcher;
    }
}

