/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.component.cache.mem.util;

import java.util.concurrent.TimeUnit;
import lombok.NonNull;

public final class TimeUtil {
    private static final long NANO_ORIGIN = System.nanoTime();

    public static long now() {
        return System.nanoTime() - NANO_ORIGIN;
    }

    public static long getExpireTime(long timeToLive, @NonNull TimeUnit timeUnit) {
        if (timeUnit == null) {
            throw new NullPointerException("timeUnit is marked non-null but is null");
        }
        return TimeUtil.now() + timeUnit.toNanos(timeToLive);
    }

    public static boolean isExpire(Long expireTime) {
        if (expireTime == null) {
            return false;
        }
        return expireTime - TimeUtil.now() <= 0L;
    }

    private TimeUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

