/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.component.cache.mem.thread;

import com.tplink.smb.component.cache.api.CacheService;
import com.tplink.smb.component.cache.mem.CacheManager;
import com.tplink.smb.component.cache.mem.dto.Wrapper;
import com.tplink.smb.component.cache.mem.task.DelayedTask;
import com.tplink.smb.component.cache.mem.task.DelayedTaskManager;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CleanTimeoutCacheThread
extends Thread {
    private static final Logger log = LoggerFactory.getLogger(CleanTimeoutCacheThread.class);
    private static final int SLEEP_TIME = 1000;
    private final CacheManager cacheManager;
    private final CacheService cacheService;

    public CleanTimeoutCacheThread(CacheService cacheService, CacheManager cacheManager) {
        this.cacheService = cacheService;
        this.cacheManager = cacheManager;
    }

    @Override
    public void run() {
        while (!Thread.currentThread().isInterrupted()) {
            boolean hasTimeOutTask = false;
            try {
                for (Map.Entry<String, DelayQueue<DelayedTask>> entry : DelayedTaskManager.QUEUE_MAP.entrySet()) {
                    DelayQueue<DelayedTask> queue = entry.getValue();
                    DelayedTask delayedTask = (DelayedTask)queue.peek();
                    if (delayedTask == null || delayedTask.getDelay(TimeUnit.NANOSECONDS) > 0L) continue;
                    hasTimeOutTask = true;
                    queue.remove(delayedTask);
                    if (delayedTask.getHashKey() == null) {
                        Wrapper wrapper = (Wrapper)this.cacheManager.getCache(delayedTask.getCacheName()).getIfPresent((Object)delayedTask.getKey());
                        if (wrapper == null || !Objects.equals(wrapper.getExpireTime(), delayedTask.getExpireTime())) continue;
                        log.debug("[cacheService]cache timeout, task={}", (Object)delayedTask);
                        this.cacheService.deleteKey(delayedTask.getCacheName(), delayedTask.getKey());
                        continue;
                    }
                    log.debug("[cacheService]cache timeout, task={}", (Object)delayedTask);
                    this.cacheService.deleteHashValue(delayedTask.getCacheName(), delayedTask.getKey(), delayedTask.getHashKey());
                }
                if (hasTimeOutTask) continue;
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                log.warn("[cacheService]", (Throwable)e);
                Thread.currentThread().interrupt();
            }
            catch (Exception e) {
                log.warn("[cacheService]", (Throwable)e);
            }
        }
    }
}

