/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.component.cache.mem.thread;

import com.tplink.smb.component.cache.mem.CacheManager;
import com.tplink.smb.component.cache.mem.dto.Wrapper;
import com.tplink.smb.component.cache.mem.task.DelayedTask;
import com.tplink.smb.component.cache.mem.task.DelayedTaskManager;
import java.util.Iterator;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CleanQueueThread
extends Thread {
    private static final Logger log = LoggerFactory.getLogger(CleanQueueThread.class);
    private static final int SLEEP_TIME = 60000;
    private final CacheManager cacheManager;

    public CleanQueueThread(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    @Override
    public void run() {
        while (!Thread.currentThread().isInterrupted()) {
            try {
                DelayedTaskManager.QUEUE_MAP.forEach((cacheName, queue) -> {
                    Iterator iterator = queue.iterator();
                    while (iterator.hasNext()) {
                        DelayedTask delayedTask = (DelayedTask)iterator.next();
                        Wrapper wrapper = (Wrapper)this.cacheManager.getCache(delayedTask.getCacheName()).getIfPresent((Object)delayedTask.getKey());
                        if (wrapper != null && Objects.equals(wrapper.getExpireTime(), delayedTask.getExpireTime())) continue;
                        iterator.remove();
                    }
                });
                Thread.sleep(60000L);
            }
            catch (InterruptedException e) {
                log.warn("[cacheService]", (Throwable)e);
                Thread.currentThread().interrupt();
            }
            catch (Exception e) {
                log.warn("[cacheService]", (Throwable)e);
            }
        }
    }
}

