/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.component.cache.mem.task;

import com.tplink.smb.component.cache.mem.task.DelayedTask;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.DelayQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DelayedTaskManager {
    private static final Logger log = LoggerFactory.getLogger(DelayedTaskManager.class);
    public static final Map<String, DelayQueue<DelayedTask>> QUEUE_MAP = new ConcurrentHashMap<String, DelayQueue<DelayedTask>>();

    public static void addTask(long expireTime, String cacheName, String key) {
        boolean offer = DelayedTaskManager.getCacheTimeOutQueue(cacheName).offer(DelayedTask.of(cacheName, key, null, expireTime));
        log.trace("updateTask res = {}", (Object)offer);
    }

    public static void updateTask(long expireTime, String cacheName, String key, String hashKey) {
        DelayedTaskManager.removeTask(cacheName, key, hashKey);
        boolean offer = DelayedTaskManager.getCacheTimeOutQueue(cacheName).offer(DelayedTask.of(cacheName, key, hashKey, expireTime));
        log.trace("updateTask res = {}", (Object)offer);
    }

    public static void removeTask(String cacheName, String key) {
        DelayedTaskManager.getCacheTimeOutQueue(cacheName).removeIf(o -> Objects.equals(o.getCacheName(), cacheName) && Objects.equals(o.getKey(), key));
    }

    public static void removeTask(String cacheName, String key, String hashKey) {
        DelayedTaskManager.getCacheTimeOutQueue(cacheName).removeIf(o -> Objects.equals(o.getCacheName(), cacheName) && Objects.equals(o.getKey(), key) && Objects.equals(o.getHashKey(), hashKey));
    }

    private static DelayQueue<DelayedTask> getCacheTimeOutQueue(String cacheName) {
        return QUEUE_MAP.computeIfAbsent(cacheName, k -> new DelayQueue());
    }

    private DelayedTaskManager() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

