/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.component.cache.mem.task;

import com.tplink.smb.component.cache.mem.util.TimeUtil;
import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;
import org.springframework.lang.NonNull;

public class DelayedTask
implements Delayed {
    private final String cacheName;
    private final String key;
    private final String hashKey;
    private final long expireTime;

    public DelayedTask(String cacheName, String key, String hashKey, long expireTime) {
        this.cacheName = cacheName;
        this.key = key;
        this.hashKey = hashKey;
        this.expireTime = expireTime;
    }

    public static DelayedTask of(String cacheName, String key, String hashKey, long expireTime) {
        return new DelayedTask(cacheName, key, hashKey, expireTime);
    }

    @Override
    public long getDelay(TimeUnit unit) {
        return unit.convert(this.expireTime - TimeUtil.now(), TimeUnit.NANOSECONDS);
    }

    @Override
    public int compareTo(@NonNull Delayed other) {
        if (other == this) {
            return 0;
        }
        if (other instanceof DelayedTask) {
            DelayedTask x = (DelayedTask)other;
            long diff = this.expireTime - x.expireTime;
            if (diff == 0L) {
                return 0;
            }
            return diff < 0L ? -1 : 1;
        }
        long diff = this.getDelay(TimeUnit.NANOSECONDS) - other.getDelay(TimeUnit.NANOSECONDS);
        if (diff == 0L) {
            return 0;
        }
        return diff < 0L ? -1 : 1;
    }

    public String getCacheName() {
        return this.cacheName;
    }

    public String getKey() {
        return this.key;
    }

    public String getHashKey() {
        return this.hashKey;
    }

    public long getExpireTime() {
        return this.expireTime;
    }

    public String toString() {
        return "DelayedTask(cacheName=" + this.getCacheName() + ", key=" + this.getKey() + ", hashKey=" + this.getHashKey() + ", expireTime=" + this.getExpireTime() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DelayedTask)) {
            return false;
        }
        DelayedTask other = (DelayedTask)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$cacheName = this.getCacheName();
        String other$cacheName = other.getCacheName();
        if (this$cacheName == null ? other$cacheName != null : !this$cacheName.equals(other$cacheName)) {
            return false;
        }
        String this$key = this.getKey();
        String other$key = other.getKey();
        if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
            return false;
        }
        String this$hashKey = this.getHashKey();
        String other$hashKey = other.getHashKey();
        return !(this$hashKey == null ? other$hashKey != null : !this$hashKey.equals(other$hashKey));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DelayedTask;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $cacheName = this.getCacheName();
        result = result * 59 + ($cacheName == null ? 43 : $cacheName.hashCode());
        String $key = this.getKey();
        result = result * 59 + ($key == null ? 43 : $key.hashCode());
        String $hashKey = this.getHashKey();
        result = result * 59 + ($hashKey == null ? 43 : $hashKey.hashCode());
        return result;
    }
}

