/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.component.cache.mem;

import com.tplink.smb.component.cache.mem.CacheManager;
import com.tplink.smb.component.cache.mem.CacheServiceMemImpl;
import com.tplink.smb.component.cache.mem.config.CacheProperties;
import com.tplink.smb.component.cache.mem.thread.CleanQueueThread;
import com.tplink.smb.component.cache.mem.thread.CleanTimeoutCacheThread;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={CacheProperties.class})
public class MemCacheAutoConfiguration {
    @Bean(value={"memCacheService"})
    @ConditionalOnMissingBean(name={"memCacheService"})
    public CacheServiceMemImpl cacheService(CacheManager cacheManager) {
        CacheServiceMemImpl cacheServiceMem = new CacheServiceMemImpl();
        CleanTimeoutCacheThread cleanTimeoutCacheThread = new CleanTimeoutCacheThread(cacheServiceMem, cacheManager);
        cleanTimeoutCacheThread.setDaemon(true);
        cleanTimeoutCacheThread.start();
        CleanQueueThread cleanQueueThread = new CleanQueueThread(cacheManager);
        cleanQueueThread.setDaemon(true);
        cleanQueueThread.start();
        return cacheServiceMem;
    }

    @Bean
    public CacheManager cacheManager() {
        return new CacheManager();
    }
}

