/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.component.cache.mem;

import com.github.benmanes.caffeine.cache.Cache;
import com.tplink.smb.component.cache.api.CacheService;
import com.tplink.smb.component.cache.api.IAtomicLong;
import com.tplink.smb.component.cache.api.Version;
import com.tplink.smb.component.cache.mem.AtomicLongImpl;
import com.tplink.smb.component.cache.mem.CacheManager;
import com.tplink.smb.component.cache.mem.config.CacheProperties;
import com.tplink.smb.component.cache.mem.dto.Wrapper;
import com.tplink.smb.component.cache.mem.task.DelayedTaskManager;
import com.tplink.smb.component.cache.mem.util.TimeUtil;
import com.tplink.smb.component.lock.api.ReadWriteLockService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.Queue;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiFunction;
import java.util.stream.Stream;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class CacheServiceMemImpl
implements CacheService {
    private static final Logger log = LoggerFactory.getLogger(CacheServiceMemImpl.class);
    private static final long CAS_LOCK_TIME_OUT_S = 60L;
    private static final long SORTED_SET_LOCK_TIME_OUT_S = 60L;
    private static final String SORTED_SET_INDEX = "_index_4_sorted_set";
    @Autowired
    private CacheManager cacheManager;
    @Autowired
    private CacheProperties cacheProperties;
    @Autowired
    private ReadWriteLockService lockService;

    public <T> T get(String cacheName, @NonNull String key, Class<T> clazz) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        Wrapper wrapper = (Wrapper)this.cacheManager.getCache(cacheName).getIfPresent((Object)key);
        if (wrapper == null) {
            return null;
        }
        if (TimeUtil.isExpire(wrapper.getExpireTime())) {
            this.cacheManager.getCache(cacheName).invalidate((Object)key);
            return null;
        }
        return wrapper.getCacheObj();
    }

    public <T> T get(String cacheName, @NonNull String key, @NonNull BiFunction<String, String, T> loadHandle, Class<T> clazz) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (loadHandle == null) {
            throw new NullPointerException("loadHandle is marked non-null but is null");
        }
        Wrapper<T> wrapper = (Wrapper<T>)this.cacheManager.getCache(cacheName).get((Object)key, k -> {
            Object apply = loadHandle.apply(cacheName, key);
            return Wrapper.of(apply);
        });
        assert (wrapper != null);
        if (TimeUtil.isExpire(wrapper.getExpireTime())) {
            wrapper = Wrapper.of(loadHandle.apply(cacheName, key));
            this.cacheManager.getCache(cacheName).put((Object)key, wrapper);
        }
        return wrapper.getCacheObj();
    }

    public <T> List<T> batchGet(String cacheName, @NonNull List<String> keys, @NonNull Class<T> clazz, int batchSize) {
        if (keys == null) {
            throw new NullPointerException("keys is marked non-null but is null");
        }
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        ArrayList<T> pos = new ArrayList<T>();
        for (String key : keys) {
            pos.add(this.get(cacheName, key, clazz));
        }
        return pos;
    }

    public Stream<String> getKeysByPattern(String cacheName, @NonNull String pattern) {
        if (pattern == null) {
            throw new NullPointerException("pattern is marked non-null but is null");
        }
        return this.cacheManager.getCache(cacheName).asMap().keySet().stream().filter(k -> this.isMatch((String)k, pattern));
    }

    public <T> void set(String cacheName, @NonNull String key, @NonNull T value) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        this.cacheManager.getCache(cacheName).put((Object)key, Wrapper.of(value));
    }

    public <T> void set(String cacheName, @NonNull String key, @NonNull T value, long timeToLive, @NonNull TimeUnit timeUnit) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        if (timeUnit == null) {
            throw new NullPointerException("timeUnit is marked non-null but is null");
        }
        long expireTime = TimeUtil.getExpireTime(timeToLive, timeUnit);
        this.cacheManager.getCache(cacheName).put((Object)key, Wrapper.of(value, expireTime));
        DelayedTaskManager.addTask(expireTime, cacheName, key);
    }

    public boolean deleteKey(String cacheName, @NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        this.cacheManager.getCache(cacheName).invalidate(key);
        key = (String)key + SORTED_SET_INDEX;
        this.cacheManager.getCache(cacheName).invalidate(key);
        return true;
    }

    public long deleteKeyByPrefix(String cacheName, @NonNull String prefix) throws UnsupportedOperationException {
        if (prefix == null) {
            throw new NullPointerException("prefix is marked non-null but is null");
        }
        if (!this.cacheProperties.isEnableDeleteKeyByPrefix()) {
            throw new UnsupportedOperationException("please enableDeleteKeyByPattern.");
        }
        if (CollectionUtils.isEmpty(this.cacheProperties.getDeleteKeyByPrefixCacheNameSet()) || !this.cacheProperties.getDeleteKeyByPrefixCacheNameSet().contains(cacheName)) {
            throw new UnsupportedOperationException("please add [" + cacheName + "] in deleteKeyByPrefixCacheNameSet.");
        }
        long count = 0L;
        Cache<String, Wrapper> cache = this.cacheManager.getCache(cacheName);
        if (StringUtils.isEmpty((Object)prefix)) {
            count = cache.estimatedSize();
            cache.invalidateAll();
            return count;
        }
        Iterator iterator = cache.asMap().entrySet().iterator();
        while (iterator.hasNext()) {
            String key = (String)iterator.next().getKey();
            if (!key.startsWith(prefix)) continue;
            iterator.remove();
            ++count;
        }
        return count;
    }

    public boolean expireKey(String cacheName, @NonNull String key, long timeToLive, @NonNull TimeUnit timeUnit) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (timeUnit == null) {
            throw new NullPointerException("timeUnit is marked non-null but is null");
        }
        Wrapper wrapper = (Wrapper)this.cacheManager.getCache(cacheName).getIfPresent((Object)key);
        if (wrapper == null) {
            return false;
        }
        if (TimeUtil.isExpire(wrapper.getExpireTime())) {
            this.cacheManager.getCache(cacheName).invalidate((Object)key);
            return false;
        }
        long expireTime = TimeUtil.getExpireTime(timeToLive, timeUnit);
        wrapper.setExpireTime(expireTime);
        DelayedTaskManager.addTask(expireTime, cacheName, key);
        return true;
    }

    public <T> boolean replace(String cacheName, @NonNull String key, @NonNull T oldValue, @NonNull T newValue) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (oldValue == null) {
            throw new NullPointerException("oldValue is marked non-null but is null");
        }
        if (newValue == null) {
            throw new NullPointerException("newValue is marked non-null but is null");
        }
        Cache<String, Wrapper> cache = this.cacheManager.getCache(cacheName);
        Wrapper wrapper = (Wrapper)cache.getIfPresent((Object)key);
        if (wrapper == null) {
            return false;
        }
        if (TimeUtil.isExpire(wrapper.getExpireTime())) {
            this.cacheManager.getCache(cacheName).invalidate((Object)key);
            return false;
        }
        Wrapper<T> oldWrapper = Wrapper.of(oldValue, wrapper.getExpireTime());
        Wrapper<T> newWrapper = Wrapper.of(newValue, wrapper.getExpireTime());
        return cache.asMap().replace(key, oldWrapper, newWrapper);
    }

    public boolean cas(String cacheName, @NonNull String key, @NonNull Version value) {
        Version cacheValue;
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        Cache<String, Wrapper> cache = this.cacheManager.getCache(cacheName);
        Wrapper wrapper = (Wrapper)cache.get((Object)key, k -> new Wrapper());
        assert (wrapper != null);
        if (TimeUtil.isExpire(wrapper.getExpireTime())) {
            wrapper = new Wrapper();
            this.cacheManager.getCache(cacheName).put((Object)key, wrapper);
        }
        if ((cacheValue = (Version)wrapper.getCacheObj()) != null && !Objects.equals(cacheValue.getVersion(), value.getVersion())) {
            return false;
        }
        return (Boolean)this.lockService.doWithTryLockWrite(cacheName, (Object)key, 60L, TimeUnit.SECONDS, () -> {
            Version cloneCacheValue;
            Wrapper wrapper1 = (Wrapper)cache.get((Object)key, k -> new Wrapper());
            assert (wrapper1 != null);
            Version version = (Version)wrapper1.getCacheObj();
            if (cacheValue != null && !Objects.equals(cacheValue.getVersion(), value.getVersion())) {
                return false;
            }
            if (version == null) {
                version = value;
            }
            try {
                cloneCacheValue = (Version)version.clone();
                if (version.getVersion() >= 2000000000L) {
                    cloneCacheValue.setVersion(1L);
                } else {
                    cloneCacheValue.setVersion(version.getVersion() + 1L);
                }
            }
            catch (CloneNotSupportedException e) {
                log.error("[cacheService]", (Throwable)e);
                return false;
            }
            cache.put((Object)key, Wrapper.of(cloneCacheValue, wrapper1.getExpireTime()));
            return true;
        }, () -> {
            log.error("[cacheService] cas get lock fail, {}:{}", (Object)cacheName, (Object)key);
            return false;
        });
    }

    public long getRemainTimeToLive(String cacheName, @NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        Wrapper wrapper = (Wrapper)this.cacheManager.getCache(cacheName).getIfPresent((Object)key);
        if (wrapper == null) {
            return -2L;
        }
        Long expireTime = wrapper.getExpireTime();
        if (expireTime == null) {
            return -1L;
        }
        if (TimeUtil.isExpire(expireTime)) {
            return 0L;
        }
        return TimeUnit.NANOSECONDS.toMillis(expireTime - TimeUtil.now());
    }

    public IAtomicLong getAtomicLong(String cacheName, @NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        Wrapper<AtomicLong> wrapper = (Wrapper<AtomicLong>)this.cacheManager.getCache(cacheName).get((Object)key, k -> Wrapper.of(new AtomicLong()));
        assert (wrapper != null);
        if (TimeUtil.isExpire(wrapper.getExpireTime())) {
            wrapper = Wrapper.of(new AtomicLong());
            this.cacheManager.getCache(cacheName).put((Object)key, wrapper);
        }
        return AtomicLongImpl.of((AtomicLong)wrapper.getCacheObj());
    }

    public <T> Map<String, T> getHash(String cacheName, @NonNull String key, Class<T> clazz) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        Wrapper wrapper = (Wrapper)this.cacheManager.getCache(cacheName).get((Object)key, k -> Wrapper.of(new ConcurrentHashMap()));
        assert (wrapper != null);
        if (TimeUtil.isExpire(wrapper.getExpireTime())) {
            wrapper = Wrapper.of(new ConcurrentHashMap());
            this.cacheManager.getCache(cacheName).put((Object)key, wrapper);
        }
        return (Map)wrapper.getCacheObj();
    }

    public <T> T getHashValue(String cacheName, @NonNull String key, @NonNull String hashKey, Class<T> clazz) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (hashKey == null) {
            throw new NullPointerException("hashKey is marked non-null but is null");
        }
        Wrapper wrapper = (Wrapper)this.cacheManager.getCache(cacheName).getIfPresent((Object)key);
        if (wrapper == null) {
            return null;
        }
        if (TimeUtil.isExpire(wrapper.getExpireTime())) {
            this.cacheManager.getCache(cacheName).invalidate((Object)key);
            return null;
        }
        Map map = (Map)wrapper.getCacheObj();
        return map == null ? null : (T)map.get(hashKey);
    }

    public <T> T putHashValue(String cacheName, @NonNull String key, @NonNull String hashKey, @NonNull T value) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (hashKey == null) {
            throw new NullPointerException("hashKey is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        Wrapper wrapper = (Wrapper)this.cacheManager.getCache(cacheName).get((Object)key, k -> Wrapper.of(new ConcurrentHashMap()));
        assert (wrapper != null);
        if (TimeUtil.isExpire(wrapper.getExpireTime())) {
            wrapper = Wrapper.of(new ConcurrentHashMap());
            this.cacheManager.getCache(cacheName).put((Object)key, wrapper);
        }
        Map map = (Map)wrapper.getCacheObj();
        assert (map != null);
        T o = map.put(hashKey, value);
        return o;
    }

    public <T> T deleteHashValue(String cacheName, @NonNull String key, @NonNull String hashKey) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (hashKey == null) {
            throw new NullPointerException("hashKey is marked non-null but is null");
        }
        Wrapper wrapper = (Wrapper)this.cacheManager.getCache(cacheName).getIfPresent((Object)key);
        if (wrapper == null) {
            return null;
        }
        if (TimeUtil.isExpire(wrapper.getExpireTime())) {
            this.cacheManager.getCache(cacheName).invalidate((Object)key);
            return null;
        }
        Map map = (Map)wrapper.getCacheObj();
        T o = map == null ? null : (T)map.remove(hashKey);
        return o;
    }

    public <T> Map<String, T> getTimedHash(String cacheName, @NonNull String key, @NonNull Class<T> clazz) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        Wrapper wrapper = (Wrapper)this.cacheManager.getCache(cacheName).get((Object)key, k -> Wrapper.of(new ConcurrentHashMap()));
        assert (wrapper != null);
        if (TimeUtil.isExpire(wrapper.getExpireTime())) {
            wrapper = Wrapper.of(new ConcurrentHashMap());
            this.cacheManager.getCache(cacheName).put((Object)key, wrapper);
        }
        return (Map)wrapper.getCacheObj();
    }

    public <T> T getTimedHashValue(String cacheName, @NonNull String key, @NonNull String hashKey, @NonNull Class<T> clazz) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (hashKey == null) {
            throw new NullPointerException("hashKey is marked non-null but is null");
        }
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        Wrapper wrapper = (Wrapper)this.cacheManager.getCache(cacheName).getIfPresent((Object)key);
        if (wrapper == null) {
            return null;
        }
        if (TimeUtil.isExpire(wrapper.getExpireTime())) {
            this.cacheManager.getCache(cacheName).invalidate((Object)key);
            return null;
        }
        Map map = (Map)wrapper.getCacheObj();
        return map == null ? null : (T)map.get(hashKey);
    }

    public <T> T putTimedHashValue(String cacheName, @NonNull String key, @NonNull String hashKey, @NonNull T value) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (hashKey == null) {
            throw new NullPointerException("hashKey is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        Wrapper wrapper = (Wrapper)this.cacheManager.getCache(cacheName).get((Object)key, k -> Wrapper.of(new ConcurrentHashMap()));
        assert (wrapper != null);
        if (TimeUtil.isExpire(wrapper.getExpireTime())) {
            wrapper = Wrapper.of(new ConcurrentHashMap());
            this.cacheManager.getCache(cacheName).put((Object)key, wrapper);
        }
        Map map = (Map)wrapper.getCacheObj();
        T o = map.put(hashKey, value);
        DelayedTaskManager.removeTask(cacheName, key, hashKey);
        return o;
    }

    public <T> T putTimedHashValue(String cacheName, @NonNull String key, @NonNull String hashKey, @NonNull T value, long timeToLive, @NonNull TimeUnit timeUnit) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (hashKey == null) {
            throw new NullPointerException("hashKey is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        if (timeUnit == null) {
            throw new NullPointerException("timeUnit is marked non-null but is null");
        }
        Wrapper wrapper = (Wrapper)this.cacheManager.getCache(cacheName).get((Object)key, k -> Wrapper.of(new ConcurrentHashMap()));
        assert (wrapper != null);
        if (TimeUtil.isExpire(wrapper.getExpireTime())) {
            wrapper = Wrapper.of(new ConcurrentHashMap());
            this.cacheManager.getCache(cacheName).put((Object)key, wrapper);
        }
        Map map = (Map)wrapper.getCacheObj();
        long expireTime = TimeUtil.getExpireTime(timeToLive, timeUnit);
        DelayedTaskManager.updateTask(expireTime, cacheName, key, hashKey);
        return map.put(hashKey, value);
    }

    public <T> T deleteTimedHashValue(String cacheName, @NonNull String key, @NonNull String hashKey) {
        T o;
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (hashKey == null) {
            throw new NullPointerException("hashKey is marked non-null but is null");
        }
        Wrapper wrapper = (Wrapper)this.cacheManager.getCache(cacheName).getIfPresent((Object)key);
        if (wrapper == null) {
            return null;
        }
        if (TimeUtil.isExpire(wrapper.getExpireTime())) {
            this.cacheManager.getCache(cacheName).invalidate((Object)key);
            return null;
        }
        Map map = (Map)wrapper.getCacheObj();
        if (map == null) {
            o = null;
        } else {
            o = (T)map.remove(hashKey);
            DelayedTaskManager.removeTask(cacheName, key, hashKey);
        }
        return o;
    }

    public <T> boolean addSortedSetValue(String cacheName, @NonNull String key, @NonNull T value, double score) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        Wrapper indexWrapper = (Wrapper)this.cacheManager.getCache(cacheName).get((Object)(key + SORTED_SET_INDEX), k -> Wrapper.of(new HashMap()));
        assert (indexWrapper != null);
        Map indexMap = (Map)indexWrapper.getCacheObj();
        Wrapper wrapper = (Wrapper)this.cacheManager.getCache(cacheName).get((Object)key, k -> Wrapper.of(new TreeMap()));
        assert (wrapper != null);
        if (TimeUtil.isExpire(wrapper.getExpireTime())) {
            indexWrapper = Wrapper.of(new HashMap());
            this.cacheManager.getCache(cacheName).put((Object)(key + SORTED_SET_INDEX), indexWrapper);
            wrapper = Wrapper.of(new TreeMap());
            this.cacheManager.getCache(cacheName).put((Object)key, wrapper);
        }
        Map sortedMap = (Map)wrapper.getCacheObj();
        return (Boolean)this.lockService.doWithTryLockWrite(cacheName, (Object)key, 60L, TimeUnit.SECONDS, () -> {
            this.removeSortedSetValue(cacheName, key, value);
            Set values = sortedMap.computeIfAbsent(score, k -> new LinkedHashSet(2));
            indexMap.put(value, score);
            return values.add(value);
        }, () -> {
            log.error("[cacheService] addSortedSetValue get lock fail, {}:{}", (Object)cacheName, (Object)key);
            return false;
        });
    }

    public <T> int addSortedSetValueReturnSize(String cacheName, @NonNull String key, @NonNull T value, double score) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        Wrapper indexWrapper = (Wrapper)this.cacheManager.getCache(cacheName).get((Object)(key + SORTED_SET_INDEX), k -> Wrapper.of(new HashMap()));
        assert (indexWrapper != null);
        Map indexMap = (Map)indexWrapper.getCacheObj();
        Wrapper wrapper = (Wrapper)this.cacheManager.getCache(cacheName).get((Object)key, k -> Wrapper.of(new TreeMap()));
        assert (wrapper != null);
        if (TimeUtil.isExpire(wrapper.getExpireTime())) {
            indexWrapper = Wrapper.of(new HashMap());
            this.cacheManager.getCache(cacheName).put((Object)(key + SORTED_SET_INDEX), indexWrapper);
            wrapper = Wrapper.of(new TreeMap());
            this.cacheManager.getCache(cacheName).put((Object)key, wrapper);
        }
        Map sortedMap = (Map)wrapper.getCacheObj();
        return (Integer)this.lockService.doWithTryLockWrite(cacheName, (Object)key, 60L, TimeUnit.SECONDS, () -> {
            this.removeSortedSetValue(cacheName, key, value);
            Set values = sortedMap.computeIfAbsent(score, k -> new LinkedHashSet(2));
            indexMap.put(value, score);
            values.add(value);
            return indexMap.size();
        }, () -> {
            log.error("[cacheService] addSortedSetValueReturnSize get lock fail, {}:{}", (Object)cacheName, (Object)key);
            return -1;
        });
    }

    public <T> Collection<T> rangeSortedByScore(String cacheName, @NonNull String key, double min, double max, Class<T> clazz) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        ArrayList list = new ArrayList();
        Wrapper wrapper = (Wrapper)this.cacheManager.getCache(cacheName).getIfPresent((Object)key);
        if (wrapper == null) {
            return list;
        }
        if (TimeUtil.isExpire(wrapper.getExpireTime())) {
            this.cacheManager.getCache(cacheName).invalidate((Object)(key + SORTED_SET_INDEX));
            this.cacheManager.getCache(cacheName).invalidate((Object)key);
            return list;
        }
        TreeMap map = (TreeMap)wrapper.getCacheObj();
        if (CollectionUtils.isEmpty((Map)map)) {
            return list;
        }
        return (Collection)this.lockService.doWithTryLockRead(cacheName, (Object)key, 60L, TimeUnit.SECONDS, () -> {
            map.subMap(min, true, max, true).forEach((score, values) -> list.addAll(values));
            return list;
        }, () -> {
            log.error("[cacheService] rangeSortedByScore get lock fail, {}:{}", (Object)cacheName, (Object)key);
            return new ArrayList();
        });
    }

    public <T> boolean removeSortedSetValue(String cacheName, @NonNull String key, @NonNull T value) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        Wrapper indexWrapper = (Wrapper)this.cacheManager.getCache(cacheName).getIfPresent((Object)(key + SORTED_SET_INDEX));
        if (indexWrapper == null) {
            return true;
        }
        Map indexMap = (Map)indexWrapper.getCacheObj();
        if (CollectionUtils.isEmpty((Map)indexMap) || !indexMap.containsKey(value)) {
            return true;
        }
        Wrapper wrapper = (Wrapper)this.cacheManager.getCache(cacheName).getIfPresent((Object)key);
        if (wrapper == null) {
            return true;
        }
        if (TimeUtil.isExpire(wrapper.getExpireTime())) {
            this.cacheManager.getCache(cacheName).invalidate((Object)(key + SORTED_SET_INDEX));
            this.cacheManager.getCache(cacheName).invalidate((Object)key);
            return true;
        }
        Map map = (Map)wrapper.getCacheObj();
        if (CollectionUtils.isEmpty((Map)map)) {
            return true;
        }
        return (Boolean)this.lockService.doWithTryLockWrite(cacheName, (Object)key, 60L, TimeUnit.SECONDS, () -> {
            Double valueScore = (Double)indexMap.get(value);
            if (valueScore == null || !map.containsKey(valueScore)) {
                return true;
            }
            boolean res = false;
            Set set = (Set)map.get(valueScore);
            if (set != null && set.remove(value)) {
                res = true;
            }
            if (CollectionUtils.isEmpty((Collection)set)) {
                map.remove(valueScore);
            }
            indexMap.remove(value);
            return res;
        }, () -> {
            log.error("[cacheService] removeSortedSetValue get lock fail, {}:{}", (Object)cacheName, (Object)key);
            return false;
        });
    }

    public <T> Collection<T> pollSortedByScore(String cacheName, @NonNull String key, double min, double max, Class<T> clazz) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        ArrayList list = new ArrayList();
        Wrapper indexWrapper = (Wrapper)this.cacheManager.getCache(cacheName).getIfPresent((Object)(key + SORTED_SET_INDEX));
        if (indexWrapper == null) {
            return list;
        }
        Map indexMap = (Map)indexWrapper.getCacheObj();
        Wrapper wrapper = (Wrapper)this.cacheManager.getCache(cacheName).getIfPresent((Object)key);
        if (wrapper == null) {
            return list;
        }
        if (TimeUtil.isExpire(wrapper.getExpireTime())) {
            this.cacheManager.getCache(cacheName).invalidate((Object)(key + SORTED_SET_INDEX));
            this.cacheManager.getCache(cacheName).invalidate((Object)key);
            return list;
        }
        TreeMap map = (TreeMap)wrapper.getCacheObj();
        if (CollectionUtils.isEmpty((Map)indexMap) || CollectionUtils.isEmpty((Map)map)) {
            return list;
        }
        this.lockService.doWithTryLockWrite(cacheName, (Object)key, 60L, TimeUnit.SECONDS, () -> {
            NavigableMap subMap = map.subMap(min, true, max, true);
            Iterator iterator = subMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                list.addAll((Collection)entry.getValue());
                ((Set)entry.getValue()).forEach(indexMap::remove);
                iterator.remove();
            }
            return true;
        }, () -> {
            log.error("[cacheService] pollSortedByScore get lock fail, {}:{}", (Object)cacheName, (Object)key);
            return false;
        });
        return list;
    }

    public <T> Collection<T> pollSortedByScore(String cacheName, @NonNull String key, double min, double max, int count, @NonNull Class<T> clazz) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        ArrayList list = new ArrayList();
        Wrapper indexWrapper = (Wrapper)this.cacheManager.getCache(cacheName).getIfPresent((Object)(key + SORTED_SET_INDEX));
        if (indexWrapper == null) {
            return list;
        }
        Map indexMap = (Map)indexWrapper.getCacheObj();
        Wrapper wrapper = (Wrapper)this.cacheManager.getCache(cacheName).getIfPresent((Object)key);
        if (wrapper == null) {
            return list;
        }
        if (TimeUtil.isExpire(wrapper.getExpireTime())) {
            this.cacheManager.getCache(cacheName).invalidate((Object)(key + SORTED_SET_INDEX));
            this.cacheManager.getCache(cacheName).invalidate((Object)key);
            return list;
        }
        TreeMap map = (TreeMap)wrapper.getCacheObj();
        if (CollectionUtils.isEmpty((Map)indexMap) || CollectionUtils.isEmpty((Map)map)) {
            return list;
        }
        this.lockService.doWithTryLockWrite(cacheName, (Object)key, 60L, TimeUnit.SECONDS, () -> {
            int num = 0;
            NavigableMap subMap = map.subMap(min, true, max, true);
            Iterator entryIterator = subMap.entrySet().iterator();
            while (entryIterator.hasNext()) {
                Map.Entry entry = entryIterator.next();
                Set tSet = (Set)entry.getValue();
                if (num + tSet.size() <= count) {
                    num += tSet.size();
                    list.addAll(tSet);
                    tSet.forEach(indexMap::remove);
                    entryIterator.remove();
                    continue;
                }
                Iterator iterator = tSet.iterator();
                while (iterator.hasNext()) {
                    if (num == count) {
                        return true;
                    }
                    ++num;
                    Object t = iterator.next();
                    list.add(t);
                    iterator.remove();
                    indexMap.remove(t);
                }
            }
            return true;
        }, () -> {
            log.error("[cacheService] pollSortedByScoreByCount get lock fail, {}:{}", (Object)cacheName, (Object)key);
            return false;
        });
        return list;
    }

    public <T> Collection<T> pollFirst(String cacheName, @NonNull String key, int count, Class<T> clazz) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return this.pollFirstAndFilter(cacheName, key, count, null, null);
    }

    public <T> Collection<T> pollFirst(String cacheName, @NonNull String key, int count, double min, double max, Class<T> clazz) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return this.pollFirstAndFilter(cacheName, key, count, min, max);
    }

    private <T> Collection<T> pollFirstAndFilter(String cacheName, @NonNull String key, int count, Double min, Double max) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        ArrayList list = new ArrayList(count);
        if (count < 1) {
            return list;
        }
        Wrapper indexWrapper = (Wrapper)this.cacheManager.getCache(cacheName).getIfPresent((Object)(key + SORTED_SET_INDEX));
        if (indexWrapper == null) {
            return list;
        }
        Map indexMap = (Map)indexWrapper.getCacheObj();
        Wrapper wrapper = (Wrapper)this.cacheManager.getCache(cacheName).getIfPresent((Object)key);
        if (wrapper == null) {
            return list;
        }
        if (TimeUtil.isExpire(wrapper.getExpireTime())) {
            this.cacheManager.getCache(cacheName).invalidate((Object)(key + SORTED_SET_INDEX));
            this.cacheManager.getCache(cacheName).invalidate((Object)key);
            return list;
        }
        TreeMap map = (TreeMap)wrapper.getCacheObj();
        if (CollectionUtils.isEmpty((Map)indexMap) || CollectionUtils.isEmpty((Map)map)) {
            return list;
        }
        return (Collection)this.lockService.doWithTryLockWrite(cacheName, (Object)key, 60L, TimeUnit.SECONDS, () -> {
            Map.Entry firstEntry;
            int finalCount = count;
            HashMap<Double, Set> tempMap = new HashMap<Double, Set>();
            while (finalCount > 0 && (firstEntry = map.firstEntry()) != null) {
                Double score = (Double)firstEntry.getKey();
                Set values = (Set)firstEntry.getValue();
                if (min != null && score < min || max != null && score > max) {
                    tempMap.put(score, values);
                    map.remove(score);
                    finalCount -= values.size();
                    continue;
                }
                Iterator iterator = values.iterator();
                while (iterator.hasNext() && finalCount > 0) {
                    Object value = iterator.next();
                    list.add(value);
                    indexMap.remove(value);
                    iterator.remove();
                    --finalCount;
                }
                if (!CollectionUtils.isEmpty((Collection)values)) continue;
                map.remove(score);
            }
            map.putAll(tempMap);
            return list;
        }, () -> {
            log.error("[cacheService] pollFirstAndFilter get lock fail, {}:{}", (Object)cacheName, (Object)key);
            return new ArrayList();
        });
    }

    public <T> T peekFirst(String cacheName, @NonNull String key, @NonNull Class<T> clazz) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        Wrapper wrapper = (Wrapper)this.cacheManager.getCache(cacheName).getIfPresent((Object)key);
        if (wrapper == null) {
            return null;
        }
        if (TimeUtil.isExpire(wrapper.getExpireTime())) {
            this.cacheManager.getCache(cacheName).invalidate((Object)(key + SORTED_SET_INDEX));
            this.cacheManager.getCache(cacheName).invalidate((Object)key);
            return null;
        }
        TreeMap map = (TreeMap)wrapper.getCacheObj();
        if (CollectionUtils.isEmpty((Map)map)) {
            return null;
        }
        return (T)this.lockService.doWithTryLockRead(cacheName, (Object)key, 60L, TimeUnit.SECONDS, () -> {
            if (CollectionUtils.isEmpty((Map)map) || CollectionUtils.isEmpty((Collection)((Collection)map.firstEntry().getValue()))) {
                return null;
            }
            return ((Set)map.firstEntry().getValue()).iterator().next();
        }, () -> {
            log.error("[cacheService] peekFirst get lock fail, {}:{}", (Object)cacheName, (Object)key);
            return null;
        });
    }

    public int getSortedSetSize(String cacheName, @NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        Wrapper wrapper = (Wrapper)this.cacheManager.getCache(cacheName).getIfPresent((Object)(key + SORTED_SET_INDEX));
        if (wrapper == null) {
            return 0;
        }
        if (TimeUtil.isExpire(wrapper.getExpireTime())) {
            this.cacheManager.getCache(cacheName).invalidate((Object)(key + SORTED_SET_INDEX));
            this.cacheManager.getCache(cacheName).invalidate((Object)key);
            return 0;
        }
        Map indexMap = (Map)wrapper.getCacheObj();
        return indexMap == null ? 0 : indexMap.size();
    }

    public <T> Set<T> getSet(String cacheName, @NonNull String key, @NonNull Class<T> clazz) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        Wrapper wrapper = (Wrapper)this.cacheManager.getCache(cacheName).get((Object)key, k -> Wrapper.of(ConcurrentHashMap.newKeySet()));
        assert (wrapper != null);
        if (TimeUtil.isExpire(wrapper.getExpireTime())) {
            wrapper = Wrapper.of(ConcurrentHashMap.newKeySet());
            this.cacheManager.getCache(cacheName).put((Object)key, wrapper);
        }
        return (Set)wrapper.getCacheObj();
    }

    public <T> List<T> getList(String cacheName, @NonNull String key, @NonNull Class<T> clazz) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        Wrapper wrapper = (Wrapper)this.cacheManager.getCache(cacheName).get((Object)key, k -> Wrapper.of(Collections.synchronizedList(new ArrayList())));
        assert (wrapper != null);
        if (TimeUtil.isExpire(wrapper.getExpireTime())) {
            wrapper = Wrapper.of(Collections.synchronizedList(new ArrayList()));
            this.cacheManager.getCache(cacheName).put((Object)key, wrapper);
        }
        return (List)wrapper.getCacheObj();
    }

    public <T> Queue<T> getQueue(String cacheName, @NonNull String key, @NonNull Class<T> clazz) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        Wrapper wrapper = (Wrapper)this.cacheManager.getCache(cacheName).get((Object)key, k -> Wrapper.of(new ConcurrentLinkedQueue()));
        assert (wrapper != null);
        if (TimeUtil.isExpire(wrapper.getExpireTime())) {
            wrapper = Wrapper.of(new ConcurrentLinkedQueue());
            this.cacheManager.getCache(cacheName).put((Object)key, wrapper);
        }
        return (Queue)wrapper.getCacheObj();
    }

    public <T> Deque<T> getDeque(String cacheName, @NonNull String key, @NonNull Class<T> clazz) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        Wrapper wrapper = (Wrapper)this.cacheManager.getCache(cacheName).get((Object)key, k -> Wrapper.of(new ConcurrentLinkedDeque()));
        assert (wrapper != null);
        if (TimeUtil.isExpire(wrapper.getExpireTime())) {
            wrapper = Wrapper.of(new ConcurrentLinkedDeque());
            this.cacheManager.getCache(cacheName).put((Object)key, wrapper);
        }
        return (Deque)wrapper.getCacheObj();
    }

    public <T> BlockingQueue<T> getBlockingQueue(String cacheName, @NonNull String key, @NonNull Class<T> clazz) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        Wrapper wrapper = (Wrapper)this.cacheManager.getCache(cacheName).get((Object)key, k -> Wrapper.of(new LinkedBlockingQueue()));
        assert (wrapper != null);
        if (TimeUtil.isExpire(wrapper.getExpireTime())) {
            wrapper = Wrapper.of(new LinkedBlockingQueue());
            this.cacheManager.getCache(cacheName).put((Object)key, wrapper);
        }
        return (BlockingQueue)wrapper.getCacheObj();
    }

    public <T> BlockingDeque<T> getBlockingDeque(String cacheName, @NonNull String key, @NonNull Class<T> clazz) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        Wrapper wrapper = (Wrapper)this.cacheManager.getCache(cacheName).get((Object)key, k -> Wrapper.of(new LinkedBlockingDeque()));
        assert (wrapper != null);
        if (TimeUtil.isExpire(wrapper.getExpireTime())) {
            wrapper = Wrapper.of(new LinkedBlockingDeque());
            this.cacheManager.getCache(cacheName).put((Object)key, wrapper);
        }
        return (BlockingDeque)wrapper.getCacheObj();
    }

    public void clearCache() {
        this.cacheManager.clearCache();
    }

    private boolean isMatch(@NonNull String str, @NonNull String pattern) {
        int i;
        if (str == null) {
            throw new NullPointerException("str is marked non-null but is null");
        }
        if (pattern == null) {
            throw new NullPointerException("pattern is marked non-null but is null");
        }
        boolean[][] match = new boolean[str.length() + 1][pattern.length() + 1];
        match[str.length()][pattern.length()] = true;
        for (i = pattern.length() - 1; i >= 0 && pattern.charAt(i) == '*'; --i) {
            match[str.length()][i] = true;
        }
        for (i = str.length() - 1; i >= 0; --i) {
            for (int j = pattern.length() - 1; j >= 0; --j) {
                match[i][j] = str.charAt(i) == pattern.charAt(j) || pattern.charAt(j) == '?' ? match[i + 1][j + 1] : (pattern.charAt(j) == '*' ? match[i + 1][j] || match[i][j + 1] : false);
            }
        }
        return match[0][0];
    }
}

