/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.component.cache.mem;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.tplink.smb.component.cache.mem.config.CacheConfig;
import com.tplink.smb.component.cache.mem.config.CacheProperties;
import com.tplink.smb.component.cache.mem.dto.Wrapper;
import jakarta.annotation.PostConstruct;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;

public class CacheManager {
    @Autowired
    private CacheProperties cacheProperties;
    private Cache<String, Wrapper> globalCache;
    private Map<String, Cache<String, Wrapper>> cacheMap;

    @PostConstruct
    private void init() {
        this.globalCache = this.createCache(this.cacheProperties.getGlobalCache());
        this.cacheMap = new ConcurrentHashMap<String, Cache<String, Wrapper>>(this.cacheProperties.getCacheNames().size());
        this.cacheProperties.getCacheNames().forEach((name, config) -> this.cacheMap.computeIfAbsent((String)name, cacheName -> this.createCache((CacheConfig)config)));
    }

    private Cache<String, Wrapper> createCache(CacheConfig config) {
        Caffeine builder = Caffeine.newBuilder();
        if (config != null && config.getInitialCapacity() != null) {
            builder.initialCapacity(config.getInitialCapacity().intValue());
        } else if (this.cacheProperties.getDefaultConfig() != null && this.cacheProperties.getDefaultConfig().getInitialCapacity() != null) {
            builder.initialCapacity(this.cacheProperties.getDefaultConfig().getInitialCapacity().intValue());
        }
        if (config != null && config.getMaximumSize() != null) {
            builder.maximumSize(config.getMaximumSize().longValue());
        } else if (this.cacheProperties.getDefaultConfig() != null && this.cacheProperties.getDefaultConfig().getMaximumSize() != null) {
            builder.maximumSize(this.cacheProperties.getDefaultConfig().getMaximumSize().longValue());
        }
        if (config != null && config.getExpireAfterWrite() != null) {
            builder.expireAfterWrite(config.getExpireAfterWrite().longValue(), TimeUnit.SECONDS);
        } else if (this.cacheProperties.getDefaultConfig() != null && this.cacheProperties.getDefaultConfig().getExpireAfterWrite() != null) {
            builder.expireAfterWrite(this.cacheProperties.getDefaultConfig().getExpireAfterWrite().longValue(), TimeUnit.SECONDS);
        }
        return builder.build();
    }

    public Cache<String, Wrapper> getCache(String name) {
        if (StringUtils.isEmpty((Object)name)) {
            return this.globalCache;
        }
        return this.cacheMap.computeIfAbsent(name, cacheName -> this.createCache(this.cacheProperties.getDefaultConfig()));
    }

    public void clearCache() {
        this.globalCache.invalidateAll();
        Set<String> notClearCacheNameSet = this.cacheProperties.getNotClearCacheNameSet();
        this.cacheMap.forEach((k, v) -> {
            if (notClearCacheNameSet.contains(k)) {
                return;
            }
            v.invalidateAll();
        });
    }
}

