/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.async.business;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.tplink.smb.omada.async.business.AsyncBusinessThreadProperties;
import com.tplink.smb.omada.async.business.a.a;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={AsyncBusinessThreadProperties.class})
public class AsyncBusinessAutoConfiguration {
    @Bean(value={"asyncResponseExecutor"})
    @ConditionalOnMissingBean(name={"asyncResponseExecutor"})
    public ExecutorService asyncResponseExecutor(AsyncBusinessThreadProperties asyncBusinessThreadProperties) {
        return new ThreadPoolExecutor(asyncBusinessThreadProperties.getCoreSize(), asyncBusinessThreadProperties.getMaxSize(), asyncBusinessThreadProperties.getKeepAliveMills(), TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(asyncBusinessThreadProperties.getQueueLength()), new ThreadFactoryBuilder().setNameFormat("async-business-pool-%d").build());
    }

    @Bean
    public com.tplink.smb.omada.async.business.a asyncBusinessManager() {
        return new com.tplink.smb.omada.async.business.a();
    }

    @Bean
    public a asyncBusinessMeter() {
        return new a();
    }
}

