/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.sdwan.api.openapi.vo;

import com.tplink.smb.omada.a.a;
import com.tplink.smb.omada.manager.sdwan.api.openapi.vo.LanNetworkBriefOpenApiVO;
import com.tplink.smb.omada.manager.sdwan.api.openapi.vo.OsgPortStatBriefOpenApiVO;
import com.tplink.smb.omada.manager.sdwan.api.web.dto.SdWanMemberInfoVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import org.hibernate.validator.constraints.Range;
import org.springframework.util.CollectionUtils;

@Schema(name="SdWanMemberInfo")
public class SdWanMemberInfoOpenApiVO {
    @Schema(name="role", description="The role of sdWan member, hub or spoke.")
    @NotNull(message="SD-WAN member role parameter [type] should not be null.")
    @Range(min=0L, max=1L, message="Value of type is from 0 to 1.")
    private @NotNull(message="SD-WAN member role parameter [type] should not be null.") @Range(min=0L, max=1L, message="Value of type is from 0 to 1.") Integer role;
    @Schema(name="deviceMac", description="The device MAC of the sdWan member.")
    @a
    private String deviceMac;
    @Schema(name="deviceName", description="The device name of the sdWan member.")
    private String deviceName;
    @Schema(name="onlineStatus", description="The device online status of the sdWan member.")
    private Integer onlineStatus;
    @Schema(name="type", description="The device type of the sdWan member.")
    private String type;
    @Schema(name="model", description="The device model of the sdWan member.")
    private String model;
    @Schema(name="modelVersion", description="The device model version of the sdWan member.")
    private String modelVersion;
    @Schema(name="showModel", description="The device showmodel of the sdWan member.")
    private String showModel;
    @Schema(name="siteId", description="The ID of the site where the sdWan member is located.")
    private String siteId;
    @Schema(name="siteName", description="The name of the site where the sdWan member is located.")
    private String siteName;
    @Schema(name="wanPortsInfo", description="A list of device port status info for SdWan Member.")
    private List<OsgPortStatBriefOpenApiVO> wanPortsInfo;
    @Schema(name="lanNetworkInfo", description="A list of lan network info for SdWan Member.")
    private List<LanNetworkBriefOpenApiVO> lanNetworkInfo;
    @Schema(name="publicIp", description="Whether the sdWan member has a public IP.")
    private Boolean publicIp;
    @Schema(name="sdWanIp", description="The sdWan IP of the sdWan member.")
    private String sdWanIp;
    @Schema(name="linkedToHub", description="If a member is a spoke, the link connection to the hub is identified.")
    @Range(min=0L, max=1L, message="Value of type is from 0 to 1.")
    private @Range(min=0L, max=1L, message="Value of type is from 0 to 1.") Integer linkedToHub;

    public static SdWanMemberInfoVO toVO(SdWanMemberInfoOpenApiVO openApiVO) {
        SdWanMemberInfoVO vo = new SdWanMemberInfoVO();
        if (Objects.isNull(openApiVO)) {
            return vo;
        }
        vo.setRole(openApiVO.getRole());
        vo.setDeviceMac(openApiVO.getDeviceMac());
        vo.setDeviceName(openApiVO.getDeviceName());
        vo.setOnlineStatus(openApiVO.getOnlineStatus());
        vo.setType(openApiVO.getType());
        vo.setModel(openApiVO.getModel());
        vo.setModelVersion(openApiVO.getModelVersion());
        vo.setShowModel(openApiVO.getShowModel());
        vo.setSiteId(openApiVO.getSiteId());
        vo.setSiteName(openApiVO.getSiteName());
        vo.setWanPortsInfo(OsgPortStatBriefOpenApiVO.toVOList(openApiVO.getWanPortsInfo()));
        vo.setLanNetworkInfo(LanNetworkBriefOpenApiVO.toVOList(openApiVO.getLanNetworkInfo()));
        vo.setPublicIp(openApiVO.getPublicIp());
        vo.setSdWanIp(openApiVO.getSdWanIp());
        vo.setLinkedToHub(openApiVO.getLinkedToHub());
        return vo;
    }

    public static List<SdWanMemberInfoVO> toVOList(List<SdWanMemberInfoOpenApiVO> openApiVOList) {
        if (CollectionUtils.isEmpty(openApiVOList)) {
            return new ArrayList<SdWanMemberInfoVO>();
        }
        return openApiVOList.stream().map(SdWanMemberInfoOpenApiVO::toVO).collect(Collectors.toList());
    }

    public static SdWanMemberInfoOpenApiVO toOpenApiVO(SdWanMemberInfoVO vo) {
        if (Objects.isNull(vo)) {
            return new SdWanMemberInfoOpenApiVO();
        }
        SdWanMemberInfoOpenApiVO sdWanMemberInfoOpenApiVO = new SdWanMemberInfoOpenApiVO();
        sdWanMemberInfoOpenApiVO.setRole(vo.getRole());
        sdWanMemberInfoOpenApiVO.setDeviceMac(vo.getDeviceMac());
        sdWanMemberInfoOpenApiVO.setDeviceName(vo.getDeviceName());
        sdWanMemberInfoOpenApiVO.setOnlineStatus(vo.getOnlineStatus());
        sdWanMemberInfoOpenApiVO.setType(vo.getType());
        sdWanMemberInfoOpenApiVO.setModel(vo.getModel());
        sdWanMemberInfoOpenApiVO.setModelVersion(vo.getModelVersion());
        sdWanMemberInfoOpenApiVO.setShowModel(vo.getShowModel());
        sdWanMemberInfoOpenApiVO.setSiteId(vo.getSiteId());
        sdWanMemberInfoOpenApiVO.setSiteName(vo.getSiteName());
        sdWanMemberInfoOpenApiVO.setWanPortsInfo(OsgPortStatBriefOpenApiVO.toOpenApiVOList(vo.getWanPortsInfo()));
        sdWanMemberInfoOpenApiVO.setLanNetworkInfo(LanNetworkBriefOpenApiVO.toOpenApiVOList(vo.getLanNetworkInfo()));
        sdWanMemberInfoOpenApiVO.setPublicIp(vo.getPublicIp());
        sdWanMemberInfoOpenApiVO.setSdWanIp(vo.getSdWanIp());
        sdWanMemberInfoOpenApiVO.setLinkedToHub(vo.getLinkedToHub());
        return sdWanMemberInfoOpenApiVO;
    }

    public static List<SdWanMemberInfoOpenApiVO> toOpenApiVOList(List<SdWanMemberInfoVO> voList) {
        if (CollectionUtils.isEmpty(voList)) {
            return new ArrayList<SdWanMemberInfoOpenApiVO>();
        }
        return voList.stream().map(SdWanMemberInfoOpenApiVO::toOpenApiVO).collect(Collectors.toList());
    }

    @Generated
    public Integer getRole() {
        return this.role;
    }

    @Generated
    public String getDeviceMac() {
        return this.deviceMac;
    }

    @Generated
    public String getDeviceName() {
        return this.deviceName;
    }

    @Generated
    public Integer getOnlineStatus() {
        return this.onlineStatus;
    }

    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public String getModel() {
        return this.model;
    }

    @Generated
    public String getModelVersion() {
        return this.modelVersion;
    }

    @Generated
    public String getShowModel() {
        return this.showModel;
    }

    @Generated
    public String getSiteId() {
        return this.siteId;
    }

    @Generated
    public String getSiteName() {
        return this.siteName;
    }

    @Generated
    public List<OsgPortStatBriefOpenApiVO> getWanPortsInfo() {
        return this.wanPortsInfo;
    }

    @Generated
    public List<LanNetworkBriefOpenApiVO> getLanNetworkInfo() {
        return this.lanNetworkInfo;
    }

    @Generated
    public Boolean getPublicIp() {
        return this.publicIp;
    }

    @Generated
    public String getSdWanIp() {
        return this.sdWanIp;
    }

    @Generated
    public Integer getLinkedToHub() {
        return this.linkedToHub;
    }

    @Generated
    public void setRole(Integer role) {
        this.role = role;
    }

    @Generated
    public void setDeviceMac(String deviceMac) {
        this.deviceMac = deviceMac;
    }

    @Generated
    public void setDeviceName(String deviceName) {
        this.deviceName = deviceName;
    }

    @Generated
    public void setOnlineStatus(Integer onlineStatus) {
        this.onlineStatus = onlineStatus;
    }

    @Generated
    public void setType(String type) {
        this.type = type;
    }

    @Generated
    public void setModel(String model) {
        this.model = model;
    }

    @Generated
    public void setModelVersion(String modelVersion) {
        this.modelVersion = modelVersion;
    }

    @Generated
    public void setShowModel(String showModel) {
        this.showModel = showModel;
    }

    @Generated
    public void setSiteId(String siteId) {
        this.siteId = siteId;
    }

    @Generated
    public void setSiteName(String siteName) {
        this.siteName = siteName;
    }

    @Generated
    public void setWanPortsInfo(List<OsgPortStatBriefOpenApiVO> wanPortsInfo) {
        this.wanPortsInfo = wanPortsInfo;
    }

    @Generated
    public void setLanNetworkInfo(List<LanNetworkBriefOpenApiVO> lanNetworkInfo) {
        this.lanNetworkInfo = lanNetworkInfo;
    }

    @Generated
    public void setPublicIp(Boolean publicIp) {
        this.publicIp = publicIp;
    }

    @Generated
    public void setSdWanIp(String sdWanIp) {
        this.sdWanIp = sdWanIp;
    }

    @Generated
    public void setLinkedToHub(Integer linkedToHub) {
        this.linkedToHub = linkedToHub;
    }

    @Generated
    public String toString() {
        return "SdWanMemberInfoOpenApiVO(role=" + this.getRole() + ", deviceMac=" + this.getDeviceMac() + ", deviceName=" + this.getDeviceName() + ", onlineStatus=" + this.getOnlineStatus() + ", type=" + this.getType() + ", model=" + this.getModel() + ", modelVersion=" + this.getModelVersion() + ", showModel=" + this.getShowModel() + ", siteId=" + this.getSiteId() + ", siteName=" + this.getSiteName() + ", wanPortsInfo=" + this.getWanPortsInfo() + ", lanNetworkInfo=" + this.getLanNetworkInfo() + ", publicIp=" + this.getPublicIp() + ", sdWanIp=" + this.getSdWanIp() + ", linkedToHub=" + this.getLinkedToHub() + ")";
    }

    @Generated
    public SdWanMemberInfoOpenApiVO() {
    }

    @Generated
    public SdWanMemberInfoOpenApiVO(Integer role, String deviceMac, String deviceName, Integer onlineStatus, String type, String model, String modelVersion, String showModel, String siteId, String siteName, List<OsgPortStatBriefOpenApiVO> wanPortsInfo, List<LanNetworkBriefOpenApiVO> lanNetworkInfo, Boolean publicIp, String sdWanIp, Integer linkedToHub) {
        this.role = role;
        this.deviceMac = deviceMac;
        this.deviceName = deviceName;
        this.onlineStatus = onlineStatus;
        this.type = type;
        this.model = model;
        this.modelVersion = modelVersion;
        this.showModel = showModel;
        this.siteId = siteId;
        this.siteName = siteName;
        this.wanPortsInfo = wanPortsInfo;
        this.lanNetworkInfo = lanNetworkInfo;
        this.publicIp = publicIp;
        this.sdWanIp = sdWanIp;
        this.linkedToHub = linkedToHub;
    }
}

