/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.sdwan.api.openapi.vo;

import com.tplink.smb.omada.a.a;
import com.tplink.smb.omada.manager.sdwan.api.web.dto.SdWanLinksToHubVO;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import org.hibernate.validator.constraints.Range;
import org.springframework.util.CollectionUtils;

@Schema(name="SdWanLinksToHub")
public class SdWanLinksToHubOpenApiVO {
    @Schema(name="deviceMac", description="The device MAC of the sdWan member.")
    @a
    private String deviceMac;
    @Schema(name="type", description="The device type of a SD-WAN candidate device.")
    private String type;
    @Schema(name="model", description="The model of a SD-WAN candidate device.")
    private String model;
    @Schema(name="modelVersion", description="The model version of a SD-WAN candidate device.")
    private String modelVersion;
    @Schema(name="linkedToHub", description="If a member is a spoke, the link connection to the hub is identified.")
    @Range(min=0L, max=1L, message="Value of type is from 0 to 1.")
    private @Range(min=0L, max=1L, message="Value of type is from 0 to 1.") Integer linkedToHub;
    @Schema(name="onlineStatus", description="The device online status of the sdWan member.")
    private Integer onlineStatus;

    public static SdWanLinksToHubOpenApiVO toOpenApiVO(SdWanLinksToHubVO vo) {
        if (Objects.isNull(vo)) {
            return new SdWanLinksToHubOpenApiVO();
        }
        SdWanLinksToHubOpenApiVO sdWanLinksToHubOpenApiVO = new SdWanLinksToHubOpenApiVO();
        sdWanLinksToHubOpenApiVO.setDeviceMac(vo.getDeviceMac());
        sdWanLinksToHubOpenApiVO.setType(vo.getType());
        sdWanLinksToHubOpenApiVO.setModel(vo.getModel());
        sdWanLinksToHubOpenApiVO.setModelVersion(vo.getModelVersion());
        sdWanLinksToHubOpenApiVO.setLinkedToHub(vo.getLinkedToHub());
        sdWanLinksToHubOpenApiVO.setOnlineStatus(vo.getOnlineStatus());
        return sdWanLinksToHubOpenApiVO;
    }

    public static List<SdWanLinksToHubOpenApiVO> toOpenApiVOList(List<SdWanLinksToHubVO> voList) {
        if (CollectionUtils.isEmpty(voList)) {
            return new ArrayList<SdWanLinksToHubOpenApiVO>();
        }
        return voList.stream().map(SdWanLinksToHubOpenApiVO::toOpenApiVO).collect(Collectors.toList());
    }

    @Generated
    public String getDeviceMac() {
        return this.deviceMac;
    }

    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public String getModel() {
        return this.model;
    }

    @Generated
    public String getModelVersion() {
        return this.modelVersion;
    }

    @Generated
    public Integer getLinkedToHub() {
        return this.linkedToHub;
    }

    @Generated
    public Integer getOnlineStatus() {
        return this.onlineStatus;
    }

    @Generated
    public void setDeviceMac(String deviceMac) {
        this.deviceMac = deviceMac;
    }

    @Generated
    public void setType(String type) {
        this.type = type;
    }

    @Generated
    public void setModel(String model) {
        this.model = model;
    }

    @Generated
    public void setModelVersion(String modelVersion) {
        this.modelVersion = modelVersion;
    }

    @Generated
    public void setLinkedToHub(Integer linkedToHub) {
        this.linkedToHub = linkedToHub;
    }

    @Generated
    public void setOnlineStatus(Integer onlineStatus) {
        this.onlineStatus = onlineStatus;
    }

    @Generated
    public String toString() {
        return "SdWanLinksToHubOpenApiVO(deviceMac=" + this.getDeviceMac() + ", type=" + this.getType() + ", model=" + this.getModel() + ", modelVersion=" + this.getModelVersion() + ", linkedToHub=" + this.getLinkedToHub() + ", onlineStatus=" + this.getOnlineStatus() + ")";
    }

    @Generated
    public SdWanLinksToHubOpenApiVO() {
    }

    @Generated
    public SdWanLinksToHubOpenApiVO(String deviceMac, String type, String model, String modelVersion, Integer linkedToHub, Integer onlineStatus) {
        this.deviceMac = deviceMac;
        this.type = type;
        this.model = model;
        this.modelVersion = modelVersion;
        this.linkedToHub = linkedToHub;
        this.onlineStatus = onlineStatus;
    }
}

