/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.sdwan.api.openapi.vo;

import com.tplink.smb.omada.common.gridquery.GridVO;
import com.tplink.smb.omada.manager.sdwan.api.openapi.vo.SdWanLinkedSpokeOpenApiVO;
import com.tplink.smb.omada.manager.sdwan.api.openapi.vo.SdWanMemberInfoOpenApiVO;
import com.tplink.smb.omada.manager.sdwan.api.web.dto.SdWanGroupVO;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.util.CollectionUtils;

@Schema(name="SdWanGroupDetail")
public class SdWanGroupDetailOpenApiVO {
    @Schema(name="id", description="The ID of the SD-WAN group")
    private String id;
    @Schema(name="name", description="The name of the SD-WAN group")
    private String name;
    @Schema(name="description", description="The description of the SD-WAN group")
    private String description;
    @Schema(name="ipPoolStart", description="The start of the IP pool of the SD-WAN group")
    private String ipPoolStart;
    @Schema(name="ipPoolEnd", description="The end of the IP pool of the SD-WAN group")
    private String ipPoolEnd;
    @Schema(name="memberList", description="A list of members of the SD-WAN group")
    private List<SdWanMemberInfoOpenApiVO> memberList;
    @Schema(name="linkedSpokes", description="A list of linked-spokes of the SD-WAN group")
    private List<SdWanLinkedSpokeOpenApiVO> linkedSpokes;

    public static SdWanGroupDetailOpenApiVO toOpenApiVO(SdWanGroupVO sdWanGroupVO) {
        if (Objects.isNull(sdWanGroupVO)) {
            return new SdWanGroupDetailOpenApiVO();
        }
        SdWanGroupDetailOpenApiVO sdWanGroupDetailOpenApiVO = new SdWanGroupDetailOpenApiVO();
        sdWanGroupDetailOpenApiVO.setId(sdWanGroupVO.getId());
        sdWanGroupDetailOpenApiVO.setName(sdWanGroupVO.getName());
        sdWanGroupDetailOpenApiVO.setDescription(sdWanGroupVO.getDescription());
        sdWanGroupDetailOpenApiVO.setIpPoolStart(sdWanGroupVO.getIpPoolStart());
        sdWanGroupDetailOpenApiVO.setIpPoolEnd(sdWanGroupVO.getIpPoolEnd());
        sdWanGroupDetailOpenApiVO.setMemberList(SdWanMemberInfoOpenApiVO.toOpenApiVOList(sdWanGroupVO.getMemberList()));
        sdWanGroupDetailOpenApiVO.setLinkedSpokes(SdWanLinkedSpokeOpenApiVO.toOpenApiVOList(sdWanGroupVO.getLinkedSpokes()));
        return sdWanGroupDetailOpenApiVO;
    }

    public static GridVO<SdWanGroupDetailOpenApiVO> toOpenApiGridVO(GridVO<SdWanGroupVO> gridVO) {
        GridVO openApiGridVO = new GridVO();
        if (Objects.isNull(gridVO) || CollectionUtils.isEmpty((Collection)gridVO.getData())) {
            return openApiGridVO;
        }
        openApiGridVO.setTotalRows(gridVO.getTotalRows());
        openApiGridVO.setCurrentPage(gridVO.getCurrentPage());
        openApiGridVO.setCurrentSize(gridVO.getCurrentSize());
        openApiGridVO.setData(gridVO.getData().stream().map(SdWanGroupDetailOpenApiVO::toOpenApiVO).collect(Collectors.toList()));
        return openApiGridVO;
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public String getIpPoolStart() {
        return this.ipPoolStart;
    }

    @Generated
    public String getIpPoolEnd() {
        return this.ipPoolEnd;
    }

    @Generated
    public List<SdWanMemberInfoOpenApiVO> getMemberList() {
        return this.memberList;
    }

    @Generated
    public List<SdWanLinkedSpokeOpenApiVO> getLinkedSpokes() {
        return this.linkedSpokes;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Generated
    public void setIpPoolStart(String ipPoolStart) {
        this.ipPoolStart = ipPoolStart;
    }

    @Generated
    public void setIpPoolEnd(String ipPoolEnd) {
        this.ipPoolEnd = ipPoolEnd;
    }

    @Generated
    public void setMemberList(List<SdWanMemberInfoOpenApiVO> memberList) {
        this.memberList = memberList;
    }

    @Generated
    public void setLinkedSpokes(List<SdWanLinkedSpokeOpenApiVO> linkedSpokes) {
        this.linkedSpokes = linkedSpokes;
    }

    @Generated
    public String toString() {
        return "SdWanGroupDetailOpenApiVO(id=" + this.getId() + ", name=" + this.getName() + ", description=" + this.getDescription() + ", ipPoolStart=" + this.getIpPoolStart() + ", ipPoolEnd=" + this.getIpPoolEnd() + ", memberList=" + this.getMemberList() + ", linkedSpokes=" + this.getLinkedSpokes() + ")";
    }

    @Generated
    public SdWanGroupDetailOpenApiVO() {
    }

    @Generated
    public SdWanGroupDetailOpenApiVO(String id, String name, String description, String ipPoolStart, String ipPoolEnd, List<SdWanMemberInfoOpenApiVO> memberList, List<SdWanLinkedSpokeOpenApiVO> linkedSpokes) {
        this.id = id;
        this.name = name;
        this.description = description;
        this.ipPoolStart = ipPoolStart;
        this.ipPoolEnd = ipPoolEnd;
        this.memberList = memberList;
        this.linkedSpokes = linkedSpokes;
    }
}

