/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.sdwan.api.openapi.vo;

import com.tplink.smb.omada.a.a;
import com.tplink.smb.omada.common.gridquery.GridVO;
import com.tplink.smb.omada.manager.sdwan.api.openapi.vo.LanNetworkBriefOpenApiVO;
import com.tplink.smb.omada.manager.sdwan.api.openapi.vo.OsgPortStatBriefOpenApiVO;
import com.tplink.smb.omada.manager.sdwan.api.web.dto.SdWanCandidateDeviceVO;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.util.CollectionUtils;

@Schema(name="SdWanCandidateDevice")
public class SdWanCandidateDeviceOpenApiVO {
    @Schema(name="deviceName", description="The name of a SD-WAN candidate device.")
    private String deviceName;
    @Schema(name="deviceMac", description="The MAC of a SD-WAN candidate device.")
    @a
    private String deviceMac;
    @Schema(name="showModel", description="The showModel of a SD-WAN candidate device.")
    private String showModel;
    @Schema(name="type", description="The device type of a SD-WAN candidate device.")
    private String type;
    @Schema(name="model", description="The model of a SD-WAN candidate device.")
    private String model;
    @Schema(name="modelVersion", description="The model version of a SD-WAN candidate device.")
    private String modelVersion;
    @Schema(name="siteId", description="The ID of the site where the a SD-WAN candidate device located.")
    private String siteId;
    @Schema(name="siteName", description="The name of the site where the a SD-WAN candidate device located.")
    private String siteName;
    @Schema(name="wanIp", description="The wan IP of the a SD-WAN candidate device.")
    private String wanIp;
    @Schema(name="tunnelLimit", description="The maximum number of VPN tunnels that can be created.")
    private Integer tunnelLimit;
    @Schema(name="capacityLevel", description="The capacity level of a SD-WAN candidate device.")
    private Integer capacityLevel;
    @Schema(name="hasPublicIp", description="Whether the a SD-WAN candidate has public IP.")
    private Boolean hasPublicIp;
    @Schema(name="status", description="The online status of the candidate.")
    private Integer status;
    @Schema(name="lanNetworks", description="A list of the lan network info for the candidate.")
    private List<LanNetworkBriefOpenApiVO> lanNetworks;
    @Schema(name="portInfos", description="A list of the port info for the candidate.")
    private List<OsgPortStatBriefOpenApiVO> portInfos;

    public static SdWanCandidateDeviceOpenApiVO toOpenApiVO(SdWanCandidateDeviceVO sdWanCandidateDeviceVO) {
        if (Objects.isNull(sdWanCandidateDeviceVO)) {
            return new SdWanCandidateDeviceOpenApiVO();
        }
        SdWanCandidateDeviceOpenApiVO sdWanCandidateDeviceOpenApiVO = new SdWanCandidateDeviceOpenApiVO();
        sdWanCandidateDeviceOpenApiVO.setDeviceName(sdWanCandidateDeviceVO.getDeviceName());
        sdWanCandidateDeviceOpenApiVO.setDeviceMac(sdWanCandidateDeviceVO.getDeviceMac());
        sdWanCandidateDeviceOpenApiVO.setShowModel(sdWanCandidateDeviceVO.getShowModel());
        sdWanCandidateDeviceOpenApiVO.setType(sdWanCandidateDeviceVO.getType());
        sdWanCandidateDeviceOpenApiVO.setModel(sdWanCandidateDeviceVO.getModel());
        sdWanCandidateDeviceOpenApiVO.setModelVersion(sdWanCandidateDeviceVO.getModelVersion());
        sdWanCandidateDeviceOpenApiVO.setSiteId(sdWanCandidateDeviceVO.getSiteId());
        sdWanCandidateDeviceOpenApiVO.setSiteName(sdWanCandidateDeviceVO.getSiteName());
        sdWanCandidateDeviceOpenApiVO.setWanIp(sdWanCandidateDeviceVO.getWanIp());
        sdWanCandidateDeviceOpenApiVO.setTunnelLimit(sdWanCandidateDeviceVO.getTunnelLimit());
        sdWanCandidateDeviceOpenApiVO.setCapacityLevel(sdWanCandidateDeviceVO.getCapacityLevel());
        sdWanCandidateDeviceOpenApiVO.setHasPublicIp(sdWanCandidateDeviceVO.getHasPublicIp());
        sdWanCandidateDeviceOpenApiVO.setStatus(sdWanCandidateDeviceVO.getStatus());
        sdWanCandidateDeviceOpenApiVO.setLanNetworks(LanNetworkBriefOpenApiVO.toOpenApiVOList(sdWanCandidateDeviceVO.getLanNetworks()));
        sdWanCandidateDeviceOpenApiVO.setPortInfos(OsgPortStatBriefOpenApiVO.toOpenApiVOList(sdWanCandidateDeviceVO.getPortInfos()));
        return sdWanCandidateDeviceOpenApiVO;
    }

    public static List<SdWanCandidateDeviceOpenApiVO> toOpenApiVOList(List<SdWanCandidateDeviceVO> voList) {
        if (CollectionUtils.isEmpty(voList)) {
            return new ArrayList<SdWanCandidateDeviceOpenApiVO>();
        }
        return voList.stream().map(SdWanCandidateDeviceOpenApiVO::toOpenApiVO).collect(Collectors.toList());
    }

    public static GridVO<SdWanCandidateDeviceOpenApiVO> toOpenApiGridVO(GridVO<SdWanCandidateDeviceVO> gridVO) {
        GridVO openApiGridVO = new GridVO();
        if (Objects.isNull(gridVO) || CollectionUtils.isEmpty((Collection)gridVO.getData())) {
            return openApiGridVO;
        }
        openApiGridVO.setTotalRows(gridVO.getTotalRows());
        openApiGridVO.setCurrentPage(gridVO.getCurrentPage());
        openApiGridVO.setCurrentSize(gridVO.getCurrentSize());
        openApiGridVO.setData(gridVO.getData().stream().map(SdWanCandidateDeviceOpenApiVO::toOpenApiVO).collect(Collectors.toList()));
        return openApiGridVO;
    }

    @Generated
    public String getDeviceName() {
        return this.deviceName;
    }

    @Generated
    public String getDeviceMac() {
        return this.deviceMac;
    }

    @Generated
    public String getShowModel() {
        return this.showModel;
    }

    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public String getModel() {
        return this.model;
    }

    @Generated
    public String getModelVersion() {
        return this.modelVersion;
    }

    @Generated
    public String getSiteId() {
        return this.siteId;
    }

    @Generated
    public String getSiteName() {
        return this.siteName;
    }

    @Generated
    public String getWanIp() {
        return this.wanIp;
    }

    @Generated
    public Integer getTunnelLimit() {
        return this.tunnelLimit;
    }

    @Generated
    public Integer getCapacityLevel() {
        return this.capacityLevel;
    }

    @Generated
    public Boolean getHasPublicIp() {
        return this.hasPublicIp;
    }

    @Generated
    public Integer getStatus() {
        return this.status;
    }

    @Generated
    public List<LanNetworkBriefOpenApiVO> getLanNetworks() {
        return this.lanNetworks;
    }

    @Generated
    public List<OsgPortStatBriefOpenApiVO> getPortInfos() {
        return this.portInfos;
    }

    @Generated
    public void setDeviceName(String deviceName) {
        this.deviceName = deviceName;
    }

    @Generated
    public void setDeviceMac(String deviceMac) {
        this.deviceMac = deviceMac;
    }

    @Generated
    public void setShowModel(String showModel) {
        this.showModel = showModel;
    }

    @Generated
    public void setType(String type) {
        this.type = type;
    }

    @Generated
    public void setModel(String model) {
        this.model = model;
    }

    @Generated
    public void setModelVersion(String modelVersion) {
        this.modelVersion = modelVersion;
    }

    @Generated
    public void setSiteId(String siteId) {
        this.siteId = siteId;
    }

    @Generated
    public void setSiteName(String siteName) {
        this.siteName = siteName;
    }

    @Generated
    public void setWanIp(String wanIp) {
        this.wanIp = wanIp;
    }

    @Generated
    public void setTunnelLimit(Integer tunnelLimit) {
        this.tunnelLimit = tunnelLimit;
    }

    @Generated
    public void setCapacityLevel(Integer capacityLevel) {
        this.capacityLevel = capacityLevel;
    }

    @Generated
    public void setHasPublicIp(Boolean hasPublicIp) {
        this.hasPublicIp = hasPublicIp;
    }

    @Generated
    public void setStatus(Integer status) {
        this.status = status;
    }

    @Generated
    public void setLanNetworks(List<LanNetworkBriefOpenApiVO> lanNetworks) {
        this.lanNetworks = lanNetworks;
    }

    @Generated
    public void setPortInfos(List<OsgPortStatBriefOpenApiVO> portInfos) {
        this.portInfos = portInfos;
    }

    @Generated
    public String toString() {
        return "SdWanCandidateDeviceOpenApiVO(deviceName=" + this.getDeviceName() + ", deviceMac=" + this.getDeviceMac() + ", showModel=" + this.getShowModel() + ", type=" + this.getType() + ", model=" + this.getModel() + ", modelVersion=" + this.getModelVersion() + ", siteId=" + this.getSiteId() + ", siteName=" + this.getSiteName() + ", wanIp=" + this.getWanIp() + ", tunnelLimit=" + this.getTunnelLimit() + ", capacityLevel=" + this.getCapacityLevel() + ", hasPublicIp=" + this.getHasPublicIp() + ", status=" + this.getStatus() + ", lanNetworks=" + this.getLanNetworks() + ", portInfos=" + this.getPortInfos() + ")";
    }

    @Generated
    public SdWanCandidateDeviceOpenApiVO() {
    }

    @Generated
    public SdWanCandidateDeviceOpenApiVO(String deviceName, String deviceMac, String showModel, String type, String model, String modelVersion, String siteId, String siteName, String wanIp, Integer tunnelLimit, Integer capacityLevel, Boolean hasPublicIp, Integer status, List<LanNetworkBriefOpenApiVO> lanNetworks, List<OsgPortStatBriefOpenApiVO> portInfos) {
        this.deviceName = deviceName;
        this.deviceMac = deviceMac;
        this.showModel = showModel;
        this.type = type;
        this.model = model;
        this.modelVersion = modelVersion;
        this.siteId = siteId;
        this.siteName = siteName;
        this.wanIp = wanIp;
        this.tunnelLimit = tunnelLimit;
        this.capacityLevel = capacityLevel;
        this.hasPublicIp = hasPublicIp;
        this.status = status;
        this.lanNetworks = lanNetworks;
        this.portInfos = portInfos;
    }
}

