/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.sdwan.api.openapi.vo;

import com.tplink.smb.omada.manager.device.api.web.osg.dto.OsgPortStatBriefVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import org.hibernate.validator.constraints.Range;
import org.springframework.util.CollectionUtils;

@Schema(name="OsgPortStatBrief")
public class OsgPortStatBriefOpenApiVO {
    @Schema(name="port", description="The port sequence number of the device.")
    private Integer port;
    @Schema(name="mode", description="The mode whether the port works as a WAN or LAN.")
    @NotNull(message="SD-WAN device port mode [type] should not be null.")
    @Range(min=0L, max=1L, message="Value of type is from 0 to 1.")
    private @NotNull(message="SD-WAN device port mode [type] should not be null.") @Range(min=0L, max=1L, message="Value of type is from 0 to 1.") Integer mode;
    @Schema(name="name", description="The port name of the osg.")
    private String name;
    @Schema(name="linkStatus", description="The status of link connection.")
    private Integer linkStatus;
    @Schema(name="publicIp", description="Whether the device has a public IP.")
    private Boolean publicIp;
    @Schema(name="wanIp", description="The wan IP of the device.")
    private String wanIp;
    @Schema(name="portUuid", description="The UUID of port.")
    private String portUuid;

    public static OsgPortStatBriefOpenApiVO toOpenApiVO(OsgPortStatBriefVO vo) {
        if (Objects.isNull(vo)) {
            return new OsgPortStatBriefOpenApiVO();
        }
        OsgPortStatBriefOpenApiVO osgPortStatBriefOpenApiVO = new OsgPortStatBriefOpenApiVO();
        osgPortStatBriefOpenApiVO.setPort(vo.getPort());
        osgPortStatBriefOpenApiVO.setMode(vo.getMode());
        osgPortStatBriefOpenApiVO.setName(vo.getName());
        osgPortStatBriefOpenApiVO.setLinkStatus(vo.getLinkStatus());
        osgPortStatBriefOpenApiVO.setPublicIp(vo.getPublicIp());
        osgPortStatBriefOpenApiVO.setWanIp(vo.getWanIp());
        osgPortStatBriefOpenApiVO.setPortUuid(vo.getPortUuid());
        return osgPortStatBriefOpenApiVO;
    }

    public static List<OsgPortStatBriefOpenApiVO> toOpenApiVOList(List<OsgPortStatBriefVO> voList) {
        if (CollectionUtils.isEmpty(voList)) {
            return new ArrayList<OsgPortStatBriefOpenApiVO>();
        }
        return voList.stream().map(OsgPortStatBriefOpenApiVO::toOpenApiVO).collect(Collectors.toList());
    }

    public static OsgPortStatBriefVO toVO(OsgPortStatBriefOpenApiVO openApiVO) {
        OsgPortStatBriefVO vo = new OsgPortStatBriefVO();
        if (Objects.isNull(openApiVO)) {
            return vo;
        }
        vo.setPort(openApiVO.getPort());
        vo.setMode(openApiVO.getMode());
        vo.setName(openApiVO.getName());
        vo.setLinkStatus(openApiVO.getLinkStatus());
        vo.setPublicIp(openApiVO.getPublicIp());
        vo.setWanIp(openApiVO.getWanIp());
        vo.setPortUuid(openApiVO.getPortUuid());
        return vo;
    }

    public static List<OsgPortStatBriefVO> toVOList(List<OsgPortStatBriefOpenApiVO> openApiVoList) {
        if (CollectionUtils.isEmpty(openApiVoList)) {
            return new ArrayList<OsgPortStatBriefVO>();
        }
        return openApiVoList.stream().map(OsgPortStatBriefOpenApiVO::toVO).collect(Collectors.toList());
    }

    @Generated
    public Integer getPort() {
        return this.port;
    }

    @Generated
    public Integer getMode() {
        return this.mode;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public Integer getLinkStatus() {
        return this.linkStatus;
    }

    @Generated
    public Boolean getPublicIp() {
        return this.publicIp;
    }

    @Generated
    public String getWanIp() {
        return this.wanIp;
    }

    @Generated
    public String getPortUuid() {
        return this.portUuid;
    }

    @Generated
    public void setPort(Integer port) {
        this.port = port;
    }

    @Generated
    public void setMode(Integer mode) {
        this.mode = mode;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setLinkStatus(Integer linkStatus) {
        this.linkStatus = linkStatus;
    }

    @Generated
    public void setPublicIp(Boolean publicIp) {
        this.publicIp = publicIp;
    }

    @Generated
    public void setWanIp(String wanIp) {
        this.wanIp = wanIp;
    }

    @Generated
    public void setPortUuid(String portUuid) {
        this.portUuid = portUuid;
    }

    @Generated
    public String toString() {
        return "OsgPortStatBriefOpenApiVO(port=" + this.getPort() + ", mode=" + this.getMode() + ", name=" + this.getName() + ", linkStatus=" + this.getLinkStatus() + ", publicIp=" + this.getPublicIp() + ", wanIp=" + this.getWanIp() + ", portUuid=" + this.getPortUuid() + ")";
    }

    @Generated
    public OsgPortStatBriefOpenApiVO() {
    }

    @Generated
    public OsgPortStatBriefOpenApiVO(Integer port, Integer mode, String name, Integer linkStatus, Boolean publicIp, String wanIp, String portUuid) {
        this.port = port;
        this.mode = mode;
        this.name = name;
        this.linkStatus = linkStatus;
        this.publicIp = publicIp;
        this.wanIp = wanIp;
        this.portUuid = portUuid;
    }
}

