/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.sdwan.api.openapi.vo;

import com.tplink.smb.omada.a.a;
import com.tplink.smb.omada.manager.sdwan.api.web.dto.AutoSelectWanPortReqVO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import org.hibernate.validator.constraints.Range;
import org.springframework.util.CollectionUtils;

@Schema(name="AutoSelectWanPortReq")
public class AutoSelectWanPortReqOpenApiVO {
    @Schema(name="deviceMac", description="The MAC of a SD-WAN candidate device.")
    @a
    private String deviceMac;
    @Schema(name="siteId", description="Site ID.")
    private String siteId;
    @Schema(name="role", description="The role of SD-WAN member, hub: 0 or spoke: 1.")
    @NotNull(message="SD-WAN member role parameter [type] should not be null.")
    @Range(min=0L, max=1L, message="Value of type is from 0 to 1, hub: 0; spoke: 1.")
    private @NotNull(message="SD-WAN member role parameter [type] should not be null.") @Range(min=0L, max=1L, message="Value of type is from 0 to 1, hub: 0; spoke: 1.") Integer role;
    @Schema(name="linkedSpokes", description="A list MAC of linked-spokes of the sdWan group.")
    private List<String> linkedSpokes;

    public static AutoSelectWanPortReqVO toVO(AutoSelectWanPortReqOpenApiVO openApiVO) {
        AutoSelectWanPortReqVO vo = new AutoSelectWanPortReqVO();
        if (Objects.isNull(openApiVO)) {
            return vo;
        }
        vo.setDeviceMac(openApiVO.getDeviceMac());
        vo.setSiteId(openApiVO.getSiteId());
        vo.setRole(openApiVO.getRole());
        vo.setLinkedSpokes(openApiVO.getLinkedSpokes());
        return vo;
    }

    public static List<AutoSelectWanPortReqVO> toVOList(List<AutoSelectWanPortReqOpenApiVO> openApiVOList) {
        if (CollectionUtils.isEmpty(openApiVOList)) {
            return new ArrayList<AutoSelectWanPortReqVO>();
        }
        return openApiVOList.stream().map(AutoSelectWanPortReqOpenApiVO::toVO).collect(Collectors.toList());
    }

    @Generated
    public String getDeviceMac() {
        return this.deviceMac;
    }

    @Generated
    public String getSiteId() {
        return this.siteId;
    }

    @Generated
    public Integer getRole() {
        return this.role;
    }

    @Generated
    public List<String> getLinkedSpokes() {
        return this.linkedSpokes;
    }

    @Generated
    public void setDeviceMac(String deviceMac) {
        this.deviceMac = deviceMac;
    }

    @Generated
    public void setSiteId(String siteId) {
        this.siteId = siteId;
    }

    @Generated
    public void setRole(Integer role) {
        this.role = role;
    }

    @Generated
    public void setLinkedSpokes(List<String> linkedSpokes) {
        this.linkedSpokes = linkedSpokes;
    }

    @Generated
    public String toString() {
        return "AutoSelectWanPortReqOpenApiVO(deviceMac=" + this.getDeviceMac() + ", siteId=" + this.getSiteId() + ", role=" + this.getRole() + ", linkedSpokes=" + this.getLinkedSpokes() + ")";
    }

    @Generated
    public AutoSelectWanPortReqOpenApiVO() {
    }

    @Generated
    public AutoSelectWanPortReqOpenApiVO(String deviceMac, String siteId, Integer role, List<String> linkedSpokes) {
        this.deviceMac = deviceMac;
        this.siteId = siteId;
        this.role = role;
        this.linkedSpokes = linkedSpokes;
    }
}

