/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.terminal.b.a;

import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.ObjectUtil;
import com.tplink.nbu.common.utils.CollectionUtil;
import com.tplink.smb.ecsp.common.AddressDTO;
import com.tplink.smb.ecsp.common.TransResult;
import com.tplink.smb.ecsp.common.util.ArrayUtils;
import com.tplink.smb.log.component.client.api.LogApiService;
import com.tplink.smb.omada.common.access.OperationResponse;
import com.tplink.smb.omada.common.access.UserInfoBriefDTO;
import com.tplink.smb.omada.common.constant.DeviceTypeEnum;
import com.tplink.smb.omada.common.gridquery.GridVO;
import com.tplink.smb.omada.common.gridquery.QueryDataVO;
import com.tplink.smb.omada.common.smtpclient.MailInfo;
import com.tplink.smb.omada.common.smtpclient.MailServer;
import com.tplink.smb.omada.common.smtpclient.h;
import com.tplink.smb.omada.common.util.T;
import com.tplink.smb.omada.common.util.ae;
import com.tplink.smb.omada.common.util.e.a;
import com.tplink.smb.omada.common.util.s;
import com.tplink.smb.omada.device.manage.message.EcspFirstVersionEnum;
import com.tplink.smb.omada.device.manage.message.EcspVersion;
import com.tplink.smb.omada.device.manage.message.body.manage.BaseConfigRespBody;
import com.tplink.smb.omada.device.manage.message.config.ap.TerminalSetting;
import com.tplink.smb.omada.dispatcher.common.response.ApiResponseWrapper;
import com.tplink.smb.omada.dispatcher.common.util.SessionUtils;
import com.tplink.smb.omada.logmanager.api.internal.dto.OmadaLogKeyEnumDTO;
import com.tplink.smb.omada.logmanager.api.internal.dto.OmadaLogOmadacSettingDTO;
import com.tplink.smb.omada.logmanager.api.internal.dto.audit.AuditLogKeyEnumDTO;
import com.tplink.smb.omada.manager.analyze.api.a.o;
import com.tplink.smb.omada.manager.analyze.api.a.p;
import com.tplink.smb.omada.manager.device.api.internal.dto.ComponentInfoDTO;
import com.tplink.smb.omada.manager.device.api.internal.dto.osg.OsgImageDTO;
import com.tplink.smb.omada.manager.device.api.internal.dto.osg.OsgImageDescriptionDTO;
import com.tplink.smb.omada.manager.device.domain.model.ToolsDeviceGridDTO;
import com.tplink.smb.omada.manager.device.domain.model.device.G;
import com.tplink.smb.omada.manager.device.domain.model.deviceimage.ap.d;
import com.tplink.smb.omada.manager.device.domain.model.deviceimage.ap.f;
import com.tplink.smb.omada.manager.device.domain.model.deviceimage.b.c;
import com.tplink.smb.omada.manager.device.port.transport.k;
import com.tplink.smb.omada.manager.stomp.port.eventcenter.StompMessageEvent;
import com.tplink.smb.omada.manager.stomp.wo.SessionInfoWO;
import com.tplink.smb.omada.manager.stomp.wo.TerminalConnectAckWO;
import com.tplink.smb.omada.manager.terminal.api.web.vo.SessionDownloadVO;
import com.tplink.smb.omada.manager.terminal.api.web.vo.SessionSendEmailVO;
import com.tplink.smb.omada.manager.terminal.api.web.vo.TerminalCloseVO;
import com.tplink.smb.omada.manager.terminal.api.web.vo.TerminalDeviceListVO;
import com.tplink.smb.omada.manager.terminal.api.web.vo.TerminalDeviceQueryVO;
import com.tplink.smb.omada.manager.terminal.api.web.vo.TerminalDeviceVO;
import com.tplink.smb.omada.manager.terminal.api.web.vo.TerminalOpenVO;
import com.tplink.smb.omada.manager.terminal.api.web.vo.TerminalSessionVO;
import com.tplink.smb.omada.manager.terminal.b.a.a.g;
import com.tplink.smb.omada.manager.terminal.b.a.a.i;
import com.tplink.smb.omada.manager.terminal.b.a.b;
import com.tplink.smb.omada.manager.terminal.port.po.SessionIdPO;
import com.tplink.smb.omada.manager.terminal.port.po.TerminalDeviceMacInfoPO;
import com.tplink.smb.omada.manager.terminal.port.po.TerminalUserMacInfoPO;
import com.tplink.smb.rtty.protocol.packet.RttyTransMessage;
import com.tplink.smb.rtty.protocol.packet.message.manager.RttyManagerMessage;
import io.reactivex.Observable;
import io.reactivex.Single;
import io.reactivex.functions.Consumer;
import io.reactivex.functions.Function;
import jakarta.annotation.PostConstruct;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import lombok.Generated;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class e {
    @Generated
    private static final Logger a = LoggerFactory.getLogger(e.class);
    @Autowired
    private f b;
    @Autowired
    private com.tplink.smb.omada.manager.device.domain.model.deviceimage.b.g c;
    @Autowired
    private com.tplink.smb.omada.manager.device.application.device.i d;
    @Autowired
    private com.tplink.smb.omada.manager.device.domain.model.deviceimage.osg.i e;
    @Autowired
    private b f;
    @Autowired
    private com.tplink.smb.rtty.proxy.a g;
    @Autowired
    private com.tplink.smb.omada.manager.stomp.a.g h;
    @Autowired
    private com.tplink.smb.omada.manager.configuration.domain.model.site.component.a.f i;
    @Autowired
    private com.tplink.smb.omada.manager.terminal.port.cache.b j;
    @Autowired
    private com.tplink.smb.omada.identityaccess.api.internal.g k;
    @Autowired
    private com.tplink.smb.omada.logmanager.api.internal.h l;
    @Autowired
    private LogApiService m;
    @Autowired
    private com.tplink.smb.omada.manager.common.audit.a n;
    @Autowired
    private o o;
    @Autowired
    private p p;
    private i q;
    private g r;

    @PostConstruct
    private void b() {
        this.q = new i(this, this.h, this.j);
        this.r = new g(this, this.h, this.j);
        this.a().retryWhen((Function)new k(this.getClass().getSimpleName())).subscribe((Consumer)this.q);
        this.d().retryWhen((Function)new k(this.getClass().getSimpleName())).subscribe((Consumer)this.r);
    }

    public OperationResponse<TerminalDeviceListVO> a(String omadacId, String siteId, Integer deviceType) {
        a.debug("get terminal device, device type : {}", (Object)deviceType);
        ArrayList terminalDeviceList = new ArrayList();
        switch (DeviceTypeEnum.a((Integer)deviceType)) {
            case a: {
                List<com.tplink.smb.omada.manager.device.domain.model.deviceimage.ap.a> apList = this.b.a(new com.tplink.smb.omada.manager.j.a.a.c(omadacId), new com.tplink.smb.omada.manager.j.a.a.d(siteId), false);
                if (CollectionUtil.isEmpty(apList)) {
                    return OperationResponse.success((Object)new TerminalDeviceListVO());
                }
                apList.stream().filter(apImage -> apImage != null && apImage.bf()).forEach(apTerminal -> {
                    d apImageDescription = apTerminal.bd();
                    terminalDeviceList.add(TerminalDeviceListVO.DeviceInfo.builder().deviceMac(apTerminal.X()).deviceName(apTerminal.aw()).deviceType(deviceType).model(apImageDescription.s()).modelVersion(apImageDescription.t()).build());
                });
                break;
            }
            case c: {
                Map<String, c> oswMap = this.c.a(new com.tplink.smb.omada.manager.j.a.a.c(omadacId), new com.tplink.smb.omada.manager.j.a.a.d(siteId));
                if (MapUtil.isEmpty(oswMap)) {
                    return OperationResponse.success((Object)new TerminalDeviceListVO());
                }
                oswMap.values().stream().filter(oswImage -> oswImage != null && oswImage.bd()).forEach(oswTerminal -> {
                    com.tplink.smb.omada.manager.device.domain.model.deviceimage.b.e oswTerminalDescription = oswTerminal.bb();
                    terminalDeviceList.add(TerminalDeviceListVO.DeviceInfo.builder().deviceMac(oswTerminal.X()).deviceName(oswTerminal.aw()).deviceType(deviceType).model(oswTerminalDescription.s()).modelVersion(oswTerminalDescription.t()).build());
                });
                break;
            }
            case b: {
                List<OsgImageDTO> osgImageDTOs = this.d.b(new com.tplink.smb.omada.manager.j.a.a.c(omadacId), new com.tplink.smb.omada.manager.j.a.a.d(siteId));
                osgImageDTOs.stream().filter(osgImageDTO -> osgImageDTO != null && com.tplink.smb.omada.manager.terminal.b.a.e.a(osgImageDTO)).forEach(osgImageDTO -> {
                    OsgImageDescriptionDTO osgImageDTODescription = (OsgImageDescriptionDTO)osgImageDTO.getDescription();
                    terminalDeviceList.add(TerminalDeviceListVO.DeviceInfo.builder().deviceMac(osgImageDTO.getMac()).deviceName(osgImageDTO.getName()).deviceType(deviceType).model(osgImageDTODescription.getModel()).modelVersion(osgImageDTODescription.getModelVersion()).build());
                });
                break;
            }
        }
        return OperationResponse.success((Object)new TerminalDeviceListVO(terminalDeviceList));
    }

    @Deprecated
    private static boolean a(OsgImageDTO osgImageDTO) {
        try {
            if (osgImageDTO == null || osgImageDTO.getDescription() == null || ((OsgImageDescriptionDTO)osgImageDTO.getDescription()).getComponentInfo() == null) {
                return false;
            }
            ComponentInfoDTO componentInfo = ((OsgImageDescriptionDTO)osgImageDTO.getDescription()).getComponentInfo();
            EcspFirstVersionEnum version = EcspVersion.getFirstVersion((String)((OsgImageDescriptionDTO)osgImageDTO.getDescription()).getEcspVersion());
            switch (version) {
                case V2: 
                case V3: {
                    return componentInfo.getRealComponentsV2() != null && componentInfo.getRealComponentsV2().get(com.tplink.smb.omada.manager.common.b.a.a.h.bd.e()) != null;
                }
            }
            a.debug("ecsp first version {}, omadacId {}, mac {}.", new Object[]{version, osgImageDTO.getOmadacId(), com.tplink.smb.omada.common.util.e.a.d((String)osgImageDTO.getMac())});
            return false;
        }
        catch (Exception e2) {
            a.error("unsupported Terminal Setting, reason: {}", (Object)e2.getMessage());
            return false;
        }
    }

    public OperationResponse<GridVO<TerminalDeviceVO>> a(String omadacId, String siteId, TerminalDeviceQueryVO terminalDeviceQueryVO) {
        com.tplink.smb.omada.common.gridquery.a<TerminalDeviceVO> deviceGrid = this.b(omadacId, siteId, terminalDeviceQueryVO);
        GridVO deviceGridVO = new GridVO(deviceGrid.getTotalRows(), deviceGrid.getQueryData().b(), deviceGrid.getQueryData().c(), deviceGrid.getData());
        return OperationResponse.success((Object)deviceGridVO);
    }

    private com.tplink.smb.omada.common.gridquery.a<TerminalDeviceVO> b(String omadacId, String siteId, TerminalDeviceQueryVO terminalDeviceQueryVO) {
        Integer deviceType = terminalDeviceQueryVO.getDeviceType();
        com.tplink.smb.omada.common.gridquery.b queryData = QueryDataVO.transQueryData((QueryDataVO)terminalDeviceQueryVO);
        a.debug("get terminal device, device type : {}", (Object)deviceType);
        com.tplink.smb.omada.common.gridquery.a grid = new com.tplink.smb.omada.common.gridquery.a(queryData);
        switch (DeviceTypeEnum.a((Integer)deviceType)) {
            case a: {
                com.tplink.smb.omada.common.gridquery.a<TerminalDeviceVO> terminalApGrid = this.a(omadacId, siteId, (QueryDataVO)terminalDeviceQueryVO);
                if (!Objects.nonNull(terminalApGrid)) break;
                return terminalApGrid;
            }
            case c: {
                com.tplink.smb.omada.common.gridquery.a<TerminalDeviceVO> terminalOswGrid = this.b(omadacId, siteId, (QueryDataVO)terminalDeviceQueryVO);
                if (!Objects.nonNull(terminalOswGrid)) break;
                return terminalOswGrid;
            }
            case b: {
                com.tplink.smb.omada.common.gridquery.a<TerminalDeviceVO> terminalOsgDevice = this.c(omadacId, siteId, (QueryDataVO)terminalDeviceQueryVO);
                if (!Objects.nonNull(terminalOsgDevice)) break;
                return terminalOsgDevice;
            }
            default: {
                a.warn("query terminal by unknown device type: {}", (Object)deviceType);
            }
        }
        return grid;
    }

    private com.tplink.smb.omada.common.gridquery.a<TerminalDeviceVO> a(String omadacId, String siteId, QueryDataVO queryDataVO) {
        List<com.tplink.smb.omada.manager.device.domain.model.deviceimage.ap.a> apList = this.b.a(new com.tplink.smb.omada.manager.j.a.a.c(omadacId), new com.tplink.smb.omada.manager.j.a.a.d(siteId), false);
        if (CollectionUtils.isEmpty(apList)) {
            return null;
        }
        com.tplink.smb.omada.common.gridquery.a<ToolsDeviceGridDTO> deviceGrid = this.p.a(apList, queryDataVO);
        return com.tplink.smb.omada.manager.device.domain.model.a.a(deviceGrid);
    }

    private com.tplink.smb.omada.common.gridquery.a<TerminalDeviceVO> b(String omadacId, String siteId, QueryDataVO queryDataVO) {
        Map<String, c> oswImageMap = this.c.b(new com.tplink.smb.omada.manager.j.a.a.c(omadacId), new com.tplink.smb.omada.manager.j.a.a.d(siteId));
        ArrayList<c> oswList = new ArrayList<c>(oswImageMap.values());
        if (CollectionUtils.isEmpty(oswList)) {
            return null;
        }
        com.tplink.smb.omada.common.gridquery.a<ToolsDeviceGridDTO> deviceGrid = this.p.c(oswList, queryDataVO);
        return com.tplink.smb.omada.manager.device.domain.model.a.a(deviceGrid);
    }

    private com.tplink.smb.omada.common.gridquery.a<TerminalDeviceVO> c(String omadacId, String siteId, QueryDataVO queryDataVO) {
        OsgImageDTO osgImageDTO = this.d.a(new com.tplink.smb.omada.manager.j.a.a.c(omadacId), new com.tplink.smb.omada.manager.j.a.a.d(siteId));
        if (Objects.isNull(osgImageDTO)) {
            return null;
        }
        Optional<com.tplink.smb.omada.common.gridquery.a> deviceVOGridOptional = this.e.a(new com.tplink.smb.omada.manager.j.a.a.c(omadacId), new G(osgImageDTO.getMac())).map(osgImage -> {
            List<com.tplink.smb.omada.manager.device.domain.model.deviceimage.osg.e> osgList = Collections.singletonList(osgImage);
            com.tplink.smb.omada.common.gridquery.a<ToolsDeviceGridDTO> deviceGrid = this.p.d(osgList, queryDataVO);
            return com.tplink.smb.omada.manager.device.domain.model.a.a(deviceGrid);
        });
        return deviceVOGridOptional.orElse(null);
    }

    public OperationResponse a(String omadacId, String siteId, TerminalOpenVO terminalOpenVO, UserInfoBriefDTO userInfoBriefDTO) {
        String userId = SessionUtils.getSessionId();
        List deviceInfos = terminalOpenVO.getDeviceInfos();
        deviceInfos.forEach(deviceInfo -> {
            List sessionInfos = deviceInfo.getSessionInfos();
            Integer deviceType = deviceInfo.getDeviceType();
            sessionInfos.forEach(sessionInfo -> this.a(omadacId, siteId, userId, deviceType, sessionInfo.getSessionId(), sessionInfo.getDeviceMac()));
        });
        this.a(omadacId, siteId, terminalOpenVO, true, userInfoBriefDTO);
        return OperationResponse.SUCCESS;
    }

    public OperationResponse a(String omadacId, String siteId, TerminalOpenVO.DeviceInfo terminalReconnectVO) {
        String userId = SessionUtils.getSessionId();
        List sessionInfos = terminalReconnectVO.getSessionInfos();
        Integer deviceType = terminalReconnectVO.getDeviceType();
        sessionInfos.forEach(sessionInfo -> this.a(omadacId, siteId, userId, deviceType, sessionInfo.getSessionId(), sessionInfo.getDeviceMac()));
        return OperationResponse.SUCCESS;
    }

    private void a(String omadacId, String siteId, String userId, Integer deviceType, String sessionId, String deviceMac) {
        String httpSessionId = SessionUtils.getSessionId();
        TerminalUserMacInfoPO terminalUserMacInfoPO = this.j.c(omadacId, siteId, deviceMac);
        if (ObjectUtil.isNull((Object)terminalUserMacInfoPO)) {
            if (!this.a(omadacId, siteId, deviceType, deviceMac)) {
                this.a(omadacId, siteId, deviceMac, sessionId, com.tplink.smb.omada.common.g.b.h);
            }
            SessionIdPO sessionIdPO = new SessionIdPO();
            sessionIdPO.setHttpSessionId(httpSessionId);
            sessionIdPO.setDeviceMac(deviceMac);
            this.j.a(omadacId, siteId, sessionId, sessionIdPO);
            TerminalDeviceMacInfoPO terminalDeviceMacInfoPO = new TerminalDeviceMacInfoPO();
            terminalDeviceMacInfoPO.setDeviceType(deviceType);
            terminalDeviceMacInfoPO.setOmadacId(omadacId);
            terminalDeviceMacInfoPO.setSiteId(siteId);
            terminalDeviceMacInfoPO.getSessionIdUserMap().put(sessionId, httpSessionId);
            this.j.a(deviceMac, terminalDeviceMacInfoPO);
            this.a(omadacId, siteId, new G(deviceMac), deviceType, true, httpSessionId, sessionId);
        } else {
            AddressDTO addressDTO = terminalUserMacInfoPO.getAddressDTO();
            this.a(deviceMac, addressDTO).subscribe((integerTransResult, throwable) -> {
                TerminalDeviceMacInfoPO deviceMacInfo = this.j.a(deviceMac);
                if (ObjectUtil.isNull((Object)deviceMacInfo)) {
                    deviceMacInfo = new TerminalDeviceMacInfoPO();
                }
                deviceMacInfo.setDeviceType(deviceType);
                deviceMacInfo.setOmadacId(omadacId);
                deviceMacInfo.setSiteId(siteId);
                deviceMacInfo.getSessionIdUserMap().put(sessionId, httpSessionId);
                this.j.a(deviceMac, deviceMacInfo);
                SessionIdPO terminalUserSessionInfoPO = new SessionIdPO();
                terminalUserSessionInfoPO.setHttpSessionId(httpSessionId);
                terminalUserSessionInfoPO.setDeviceMac(deviceMac);
                this.j.a(omadacId, siteId, sessionId, terminalUserSessionInfoPO);
                if (Objects.nonNull(throwable)) {
                    a.warn("send device: {} heartbeat failed, exception: {}", (Object)com.tplink.smb.omada.common.util.e.a.d((String)deviceMac), throwable);
                    this.a(omadacId, siteId, new G(deviceMac), deviceType, true, userId, sessionId);
                    return;
                }
                a.info("transResult: {}", (Object)integerTransResult.getMsg());
                if (integerTransResult.isOK()) {
                    this.a(omadacId, siteId, httpSessionId, deviceMac, addressDTO, sessionId);
                } else {
                    a.warn("send device: {} heartbeat failed, err msg: {}", (Object)com.tplink.smb.omada.common.util.e.a.d((String)deviceMac), (Object)integerTransResult.getMsg());
                    this.a(omadacId, siteId, new G(deviceMac), deviceType, true, userId, sessionId);
                }
            });
        }
    }

    private boolean a(String omadacId, Integer deviceType, String deviceMac) {
        switch (DeviceTypeEnum.a((Integer)deviceType)) {
            case a: {
                Optional<com.tplink.smb.omada.manager.device.domain.model.deviceimage.ap.a> optionalApImage = this.b.a(new com.tplink.smb.omada.manager.j.a.a.c(omadacId), new G(deviceMac));
                if (!optionalApImage.isPresent()) break;
                com.tplink.smb.omada.manager.device.domain.model.deviceimage.ap.a apImage = optionalApImage.get();
                return apImage.at().e();
            }
            case c: {
                Optional<c> oswImageOptional = this.c.a(new com.tplink.smb.omada.manager.j.a.a.c(omadacId), new G(deviceMac));
                if (!oswImageOptional.isPresent()) break;
                c oswImage = oswImageOptional.get();
                return oswImage.at().e();
            }
            case b: {
                OsgImageDTO osgImageDTO = this.d.c(new com.tplink.smb.omada.manager.j.a.a.c(omadacId), new G(deviceMac));
                return osgImageDTO.getStatus().e();
            }
        }
        return false;
    }

    private Single<TransResult<Integer>> a(String deviceMac, AddressDTO addressDTO) {
        if (Objects.isNull(addressDTO)) {
            return Single.just((Object)new TransResult(2001));
        }
        return this.g.a(deviceMac, addressDTO, 30000L, 30000L).timeout(30000L, TimeUnit.MILLISECONDS);
    }

    public void a(Integer deviceType, String deviceMac, Set<G> apDisConnectedDeviceSet, Set<G> oswDisConnectedDeviceSet, Set<G> osgDisConnectedDeviceSet) {
        switch (DeviceTypeEnum.a((Integer)deviceType)) {
            case a: {
                apDisConnectedDeviceSet.add(new G(deviceMac));
                break;
            }
            case c: {
                oswDisConnectedDeviceSet.add(new G(deviceMac));
                break;
            }
            case b: {
                osgDisConnectedDeviceSet.add(new G(deviceMac));
                break;
            }
            default: {
                a.warn("unknown device type: {}, mac: {} add to disconnect device set", (Object)deviceType, (Object)com.tplink.smb.omada.common.util.e.a.d((String)deviceMac));
            }
        }
    }

    public OperationResponse a(String omadacId, String siteId, TerminalCloseVO terminalCloseVO) {
        String httpSessionId = SessionUtils.getSessionId();
        for (String deviceMac : terminalCloseVO.getDeviceMacs()) {
            this.a(omadacId, siteId, httpSessionId, deviceMac);
        }
        return OperationResponse.SUCCESS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public OperationResponse a(String omadacId, String siteId, SessionDownloadVO sessionDownloadVO, ApiResponseWrapper response, UserInfoBriefDTO userInfoBriefDTO) {
        OperationResponse operationResponse = OperationResponse.SUCCESS;
        List sessionInfos = sessionDownloadVO.getSessionInfos();
        String directory = this.c();
        StringBuilder stringBuilder = new StringBuilder("Terminal_Download");
        stringBuilder.append(".zip");
        String fileName = stringBuilder.toString();
        try {
            block12: {
                try (OutputStream outputStream = response.getOutputStream();){
                    response.setHeader("Content-Disposition", "attachment; filename=" + fileName);
                    response.setHeader("Content-Type", "application/octet-stream");
                    File[] tempFiles = this.a(sessionInfos, omadacId, siteId, directory);
                    boolean zipFileResult = this.a(tempFiles, outputStream, "Terminal_Download");
                    if (!zipFileResult) {
                        operationResponse = new OperationResponse(com.tplink.smb.omada.common.g.b.Mu);
                    }
                    if (outputStream == null) break block12;
                }
            }
        }
        catch (IOException e2) {
            a.warn("create temp file fail, exception: {}", (Throwable)e2);
            operationResponse = new OperationResponse(com.tplink.smb.omada.common.g.b.Mu);
            return operationResponse;
        }
        finally {
            File dir = new File(directory);
            File[] files = dir.listFiles();
            if (Objects.nonNull(files)) {
                for (File file : files) {
                    file.delete();
                }
            }
            dir.delete();
            this.a(omadacId, siteId, AuditLogKeyEnumDTO.TERMINAL_FILE_DOWNLOAD.name(), operationResponse.success(), userInfoBriefDTO);
            return operationResponse;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OperationResponse a(String omadacId, String siteId, SessionSendEmailVO sessionSendEmailVO, UserInfoBriefDTO userInfoBriefDTO) {
        OperationResponse operationResponse = OperationResponse.SUCCESS;
        if (!sessionSendEmailVO.emailAddressesValid()) {
            return new OperationResponse(com.tplink.smb.omada.common.g.b.bW);
        }
        List sessionInfos = sessionSendEmailVO.getSessionInfos();
        if (CollectionUtils.isEmpty((Collection)sessionInfos)) {
            return OperationResponse.PARAM_ERROR;
        }
        OperationResponse mailOperationResponse = this.l.a(omadacId);
        String directory = this.c();
        StringBuilder stringBuilder = new StringBuilder("Terminal_Download");
        stringBuilder.append(".zip");
        String fileName = stringBuilder.toString();
        File[] tempFiles = this.a(sessionInfos, omadacId, siteId, directory);
        File zipFile = new File(directory + fileName);
        try (FileOutputStream outputStream = new FileOutputStream(zipFile);){
            boolean zipFileResult = this.a(tempFiles, outputStream, fileName);
            if (zipFileResult && mailOperationResponse.success()) {
                OmadaLogOmadacSettingDTO omadaLogOmadacSettingDTO = (OmadaLogOmadacSettingDTO)mailOperationResponse.getResult();
                if (omadaLogOmadacSettingDTO.getMailServer().getSmtpEnable().booleanValue()) {
                    operationResponse = this.a(omadaLogOmadacSettingDTO, sessionSendEmailVO, zipFile, fileName, siteId);
                } else {
                    byte[] fileBytes = this.a(zipFile, omadacId);
                    JSONObject dataObject = new JSONObject();
                    dataObject.put("data", (Object)com.tplink.smb.omada.common.util.b.c.c((byte[])fileBytes));
                    dataObject.put("name", (Object)fileName);
                    operationResponse = this.a(omadacId, siteId, dataObject, fileName, sessionSendEmailVO);
                }
            } else {
                operationResponse = new OperationResponse(com.tplink.smb.omada.common.g.b.Mv);
            }
        }
        catch (IOException e2) {
            a.warn("send terminal email failed. ", (Throwable)e2);
            operationResponse = new OperationResponse(com.tplink.smb.omada.common.g.b.Mv);
        }
        finally {
            File[] files;
            File dir = new File(directory);
            for (File file : files = dir.listFiles()) {
                file.delete();
            }
            dir.delete();
        }
        if (com.tplink.smb.omada.common.g.b.W.b() == operationResponse.getErrorCode()) {
            operationResponse = new OperationResponse(com.tplink.smb.omada.common.g.b.LF);
        }
        this.a(omadacId, siteId, AuditLogKeyEnumDTO.TERMINAL_EMAIL_SEND.name(), operationResponse.success(), userInfoBriefDTO);
        return operationResponse;
    }

    private String c() {
        String randomDirectory = com.tplink.smb.omada.manager.terminal.c.a.a();
        StringBuilder stringBuilder = new StringBuilder(com.tplink.smb.omada.manager.terminal.a.a.e + randomDirectory + File.separator);
        return stringBuilder.toString();
    }

    public boolean a(File[] tempFiles, OutputStream outputStream, String fileName) throws IOException {
        if (ArrayUtils.isEmpty((Object[])tempFiles)) {
            return Boolean.FALSE;
        }
        ae.a((OutputStream)outputStream, (String)fileName, (File[])tempFiles);
        return Boolean.TRUE;
    }

    private File[] a(List<TerminalSessionVO> terminalSessions, String omadacId, String siteId, String directory) {
        ArrayList<File> sessionFileList = new ArrayList<File>(terminalSessions.size());
        for (TerminalSessionVO terminalSession : terminalSessions) {
            if (T.a((String)terminalSession.getContent())) continue;
            StringBuilder stringBuilder = new StringBuilder(omadacId);
            stringBuilder.append("_").append(siteId).append("_").append(terminalSession.getDeviceMac()).append(".txt");
            String tempTxtFileName = stringBuilder.toString();
            sessionFileList.add(s.a((byte[])com.tplink.smb.omada.common.util.b.c.b((String)terminalSession.getContent()), (String)directory, (String)tempTxtFileName));
            a.debug("download session into file:{}", (Object)(directory + com.tplink.smb.omada.common.util.e.a.d((String)terminalSession.getDeviceMac()) + ".txt"));
        }
        return sessionFileList.toArray(new File[0]);
    }

    private byte[] a(File zipFile, String omadacId) {
        byte[] byArray;
        FileInputStream inputStream = new FileInputStream(zipFile);
        try {
            byte[] data = new byte[inputStream.available()];
            inputStream.read(data);
            byArray = data;
        }
        catch (Throwable throwable) {
            try {
                try {
                    inputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e2) {
                a.warn("Send cloud email, generate attachment failed, omadac: {}, exception: {}", (Object)omadacId, (Object)e2);
                return new byte[0];
            }
        }
        inputStream.close();
        return byArray;
    }

    private OperationResponse a(OmadaLogOmadacSettingDTO omadaLogOmadacSettingDTO, SessionSendEmailVO sendEmailVO, File zipFile, String fileName, String siteId) {
        String omadacId = omadaLogOmadacSettingDTO.getOmadacId();
        ArrayList<File> files = new ArrayList<File>();
        files.add(zipFile);
        List<String> deviceMacList = sendEmailVO.getSessionInfos().stream().map(TerminalSessionVO::getDeviceMac).collect(Collectors.toList());
        String subject = this.a(deviceMacList);
        String contents = this.a(deviceMacList, fileName);
        MailInfo mailInfo = new MailInfo(sendEmailVO.getRecipients(), subject, contents, files);
        OperationResponse optRes = com.tplink.smb.omada.common.smtpclient.i.a((h)com.tplink.smb.omada.common.smtpclient.h.b().b(omadaLogOmadacSettingDTO.getOmadacId()).a((MailServer)Optional.ofNullable(omadaLogOmadacSettingDTO.getMailServer()).orElse(null)).a(mailInfo).a());
        if (optRes.success()) {
            return new OperationResponse(com.tplink.smb.omada.common.g.b.a);
        }
        List failEmails = (List)optRes.getResult();
        if (!CollectionUtils.isEmpty((Collection)failEmails)) {
            ArrayList logs = new ArrayList();
            failEmails.forEach(email -> logs.add(OmadaLogKeyEnumDTO.TERMINAL_MAIL_FL.build(omadacId, siteId, null, null, new String[]{email}).toJson()));
            this.m.addLogs(omadacId, logs);
        } else {
            this.m.addLog(omadacId, OmadaLogKeyEnumDTO.TERMINAL_MAIL_FL.build(omadacId, siteId, null, null, new String[]{"user"}).toJson());
        }
        return new OperationResponse(com.tplink.smb.omada.common.g.b.Mv);
    }

    private OperationResponse a(String omadacId, String siteId, JSONObject dataObject, String fileName, SessionSendEmailVO sendEmailVO) {
        OperationResponse sendEmailAvailableOpt = this.o.a(omadacId, "Terminal");
        if (!sendEmailAvailableOpt.success()) {
            a.debug("<Troubleshooting> send email is not available omadacId:{}, siteId:{}", (Object)omadacId, (Object)siteId);
            return sendEmailAvailableOpt;
        }
        if (Objects.isNull(dataObject.get("data"))) {
            return OperationResponse.GENERAL_ERROR;
        }
        JSONArray attachment = new JSONArray();
        attachment.put((Object)dataObject);
        List<String> deviceMacList = sendEmailVO.getSessionInfos().stream().map(TerminalSessionVO::getDeviceMac).collect(Collectors.toList());
        String subject = this.a(deviceMacList);
        String contents = this.a(deviceMacList, fileName);
        return this.o.a(omadacId, siteId, sendEmailVO.getRecipients(), subject, contents, attachment, "Terminal");
    }

    private String a(List<String> deviceMac) {
        AtomicReference<String> macs = new AtomicReference<String>("");
        deviceMac.forEach(v2 -> macs.set((String)macs.get() + " " + v2));
        return "Terminal Session Information for device" + macs;
    }

    public String a(List<String> deviceMac, String fileName) {
        AtomicReference<String> macs = new AtomicReference<String>("");
        deviceMac.forEach(v2 -> macs.set((String)macs.get() + " " + v2));
        return "Please find attached Terminal Download as " + fileName + " for device " + macs + ".zip";
    }

    public void a(String omadacId, String siteId, G deviceMac, Integer deviceType, boolean enable, String httpSessionId, String terminalSessionId) {
        if (this.a(omadacId, deviceType, deviceMac.a())) {
            this.a(omadacId, siteId, deviceType, deviceMac.a(), httpSessionId, terminalSessionId);
            TerminalSetting terminalSetting = this.f.a(omadacId, siteId, deviceMac.a(), enable);
            CompletableFuture<com.tplink.smb.omada.manager.device.application.message.c<BaseConfigRespBody>> completableFuture = this.a(new com.tplink.smb.omada.manager.j.a.a.c(omadacId), deviceMac, deviceType, terminalSetting);
            completableFuture.whenCompleteAsync((baseConfigRespBodySendDeviceMsgResult, throwable) -> {
                if (!baseConfigRespBodySendDeviceMsgResult.c()) {
                    this.a(omadacId, siteId, deviceMac.a(), terminalSessionId, com.tplink.smb.omada.common.g.b.Mr);
                }
            });
        } else {
            this.a(omadacId, siteId, deviceMac.a(), terminalSessionId, com.tplink.smb.omada.common.g.b.Mr);
        }
    }

    public void a(String omadacId, String siteId, String deviceMac, String sessionId, com.tplink.smb.omada.common.g.b resErrorCode) {
        a.info("send open terminal result to web: {}", (Object)sessionId);
        SessionInfoWO sessionInfo = new SessionInfoWO(resErrorCode.b(), resErrorCode.c(), deviceMac, sessionId);
        TerminalConnectAckWO terminalConnectAckWO = new TerminalConnectAckWO(sessionInfo);
        SessionIdPO terminalSessionIdInfo = this.j.a(omadacId, siteId, sessionId);
        String userId = terminalSessionIdInfo.getHttpSessionId();
        StompMessageEvent<TerminalConnectAckWO> stompMessageEvent = new StompMessageEvent<TerminalConnectAckWO>(com.tplink.smb.omada.common.q.c.o.a(), omadacId, siteId, userId, terminalConnectAckWO);
        this.h.b(stompMessageEvent);
    }

    private void a(com.tplink.smb.omada.manager.j.a.a.c omadacId, Set<G> deviceMacSet, Integer deviceType, TerminalSetting terminalSetting) {
        a.info("device rtty not connected, send terminal setting to: {}, {}", deviceMacSet, (Object)terminalSetting);
        switch (DeviceTypeEnum.a((Integer)deviceType)) {
            case a: {
                this.f.a(omadacId, deviceMacSet, terminalSetting);
                break;
            }
            case c: {
                this.f.b(omadacId, deviceMacSet, terminalSetting);
                break;
            }
            case b: {
                this.f.c(omadacId, deviceMacSet, terminalSetting);
                break;
            }
            default: {
                a.error("unknown device type : {}", (Object)deviceType);
            }
        }
    }

    private CompletableFuture<com.tplink.smb.omada.manager.device.application.message.c<BaseConfigRespBody>> a(com.tplink.smb.omada.manager.j.a.a.c omadacId, G deviceMac, Integer deviceType, TerminalSetting terminalSetting) {
        a.info("device rtty not connected, send terminal setting to: {}, {}", (Object)com.tplink.smb.omada.common.util.e.a.d((String)deviceMac.a()), (Object)terminalSetting);
        switch (DeviceTypeEnum.a((Integer)deviceType)) {
            case a: {
                return this.f.a(omadacId, deviceMac, terminalSetting);
            }
            case c: {
                return this.f.b(omadacId, deviceMac, terminalSetting);
            }
            case b: {
                return this.f.c(omadacId, deviceMac, terminalSetting);
            }
        }
        a.error("unknown device type : {}", (Object)deviceType);
        return null;
    }

    public void a(String deviceMac, int err, String msg, AddressDTO addressDTO) {
        a.debug("send rtty register response msg :{} to address: {}", (Object)msg, (Object)addressDTO);
        this.g.a(deviceMac, err, msg, addressDTO, 30000L, 30000L);
    }

    public void a(String omadacId, String siteId, String httpSessionId, String deviceMac, AddressDTO addressDTO, String terminalSessionId) {
        a.info("send rtty login request to device mac: {}, address: {}, terminal sessionId: {}", new Object[]{com.tplink.smb.omada.common.util.e.a.d((String)deviceMac), addressDTO, terminalSessionId});
        TerminalUserMacInfoPO userMacInfo = this.j.c(omadacId, siteId, deviceMac);
        TerminalDeviceMacInfoPO deviceMacInfo = this.j.a(deviceMac);
        if (ObjectUtil.isNull((Object)userMacInfo) || ObjectUtil.isNull((Object)deviceMacInfo)) {
            a.warn("send login request but terminal device: {} cache is null", (Object)com.tplink.smb.omada.common.util.e.a.d((String)deviceMac));
            return;
        }
        ConcurrentHashMap<String, String> userTerminalIdMap = userMacInfo.getUserTerminalIdMap();
        String oldTerminalSessionId = userTerminalIdMap.get(httpSessionId);
        if (ObjectUtil.isNotNull((Object)oldTerminalSessionId) && !oldTerminalSessionId.equals(terminalSessionId)) {
            this.a(omadacId, siteId, deviceMac, oldTerminalSessionId, com.tplink.smb.omada.common.g.b.Mz);
            this.a(omadacId, siteId, httpSessionId, deviceMac);
        }
        userMacInfo.getUserTerminalIdMap().put(httpSessionId, terminalSessionId);
        this.j.a(omadacId, siteId, deviceMac, userMacInfo);
        SessionIdPO sessionIdPO = new SessionIdPO();
        sessionIdPO.setHttpSessionId(httpSessionId);
        sessionIdPO.setDeviceMac(deviceMac);
        this.j.a(omadacId, siteId, terminalSessionId, sessionIdPO);
        deviceMacInfo.getSessionIdUserMap().put(terminalSessionId, httpSessionId);
        this.j.a(deviceMac, deviceMacInfo);
        this.g.a(httpSessionId, deviceMac, terminalSessionId, addressDTO, 30000L, 30000L);
    }

    public void a(String omadacId, String siteId, String httpSessionId, String deviceMac) {
        TerminalUserMacInfoPO userMacInfo = this.j.c(omadacId, siteId, deviceMac);
        TerminalDeviceMacInfoPO deviceMacInfo = this.j.a(deviceMac);
        if (ObjectUtil.isNull((Object)userMacInfo) || ObjectUtil.isNull((Object)deviceMacInfo)) {
            return;
        }
        AddressDTO addressDTO = userMacInfo.getAddressDTO();
        ConcurrentHashMap<String, String> userTerminalIdMap = userMacInfo.getUserTerminalIdMap();
        String terminalSessionId = userTerminalIdMap.get(httpSessionId);
        if (ObjectUtil.isNull((Object)terminalSessionId)) {
            return;
        }
        userTerminalIdMap.remove(httpSessionId);
        this.j.a(omadacId, siteId, deviceMac, userMacInfo);
        this.j.b(omadacId, siteId, terminalSessionId);
        deviceMacInfo.getSessionIdUserMap().remove(terminalSessionId);
        this.j.a(deviceMac, deviceMacInfo);
        this.g.a(terminalSessionId, deviceMac, addressDTO, 30000L, 30000L);
    }

    public void a(String omadacId, String siteId, String deviceMac, String sessionId, String data) {
        TerminalUserMacInfoPO userMacInfo = this.j.c(omadacId, siteId, deviceMac);
        if (ObjectUtil.isNull((Object)userMacInfo)) {
            a.warn("send TermData to empty userMac cache: {}, no operation permission", (Object)com.tplink.smb.omada.common.util.e.a.d((String)deviceMac));
            return;
        }
        TerminalDeviceMacInfoPO deviceMacInfo = this.j.a(deviceMac);
        if (ObjectUtil.isNull((Object)deviceMacInfo)) {
            a.warn("send TermData to empty device cache: {}, no operation permission", (Object)com.tplink.smb.omada.common.util.e.a.d((String)deviceMac));
            return;
        }
        AddressDTO addressDTO = userMacInfo.getAddressDTO();
        Single transResultSingle = this.g.b(deviceMac, sessionId, data, addressDTO, 30000L, 30000L);
        transResultSingle.subscribe(integerTransResult -> a.debug("send termData result: {}", (Object)integerTransResult.getErrCode()));
    }

    public Integer a(String deviceMac) {
        TerminalDeviceMacInfoPO deviceMacInfo = this.j.a(deviceMac);
        if (ObjectUtil.isNull((Object)deviceMacInfo)) {
            a.warn("terminal device: {} cache is null", (Object)com.tplink.smb.omada.common.util.e.a.d((String)deviceMac));
            return null;
        }
        return deviceMacInfo.getDeviceType();
    }

    private void a(String omadacId, String siteId, TerminalOpenVO terminalOpenVO, boolean isSuccess, UserInfoBriefDTO userInfoBriefDTO) {
        terminalOpenVO.getDeviceInfos().forEach(deviceInfo -> deviceInfo.getSessionInfos().forEach(sessionInfo -> this.n.a(omadacId, siteId, userInfoBriefDTO, AuditLogKeyEnumDTO.TERMINAL_OPEN.name(), (Boolean)isSuccess, sessionInfo.getDeviceMac())));
    }

    private void a(String omadacId, String siteId, String key, boolean isSuccess, UserInfoBriefDTO userInfoBriefDTO) {
        this.n.a(omadacId, siteId, userInfoBriefDTO, key, (Boolean)isSuccess, new String[0]);
    }

    public Observable<TransResult<RttyTransMessage>> a() {
        return this.g.a();
    }

    private Observable<TransResult<RttyManagerMessage>> d() {
        return this.g.b();
    }

    private boolean a(String omadacId, String siteId, Integer deviceType, String deviceMac) {
        OperationResponse<TerminalDeviceListVO> operationResponse = this.a(omadacId, siteId, deviceType);
        List deviceInfos = ((TerminalDeviceListVO)operationResponse.getResult()).getDeviceInfos();
        if (!operationResponse.success() || deviceInfos.isEmpty()) {
            a.warn("user has no permission to open device terminal");
            return false;
        }
        a.debug("checking user permission of opening terminal, device list: {}, mac: {}", (Object)deviceInfos, (Object)com.tplink.smb.omada.common.util.e.a.d((String)deviceMac));
        return deviceInfos.stream().anyMatch(deviceInfo -> deviceInfo.getDeviceMac().equals(deviceMac));
    }

    private void a(String omadacId, String siteId, Integer deviceType, String deviceMac, String httpSessionId, String terminalSessionId) {
        TerminalUserMacInfoPO terminalUserMacInfoPO = this.j.c(omadacId, siteId, deviceMac);
        if (Objects.isNull(terminalUserMacInfoPO)) {
            terminalUserMacInfoPO = new TerminalUserMacInfoPO();
        }
        terminalUserMacInfoPO.setDeviceType(deviceType);
        terminalUserMacInfoPO.getUserTerminalIdMap().put(httpSessionId, terminalSessionId);
        this.j.a(omadacId, siteId, deviceMac, terminalUserMacInfoPO);
    }
}

