/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.terminal.b.a.a;

import cn.hutool.core.util.ObjectUtil;
import com.tplink.smb.ecsp.common.TransResult;
import com.tplink.smb.omada.common.q.c;
import com.tplink.smb.omada.manager.stomp.a.g;
import com.tplink.smb.omada.manager.stomp.port.eventcenter.StompMessageEvent;
import com.tplink.smb.omada.manager.stomp.wo.DeviceCloseInfoWO;
import com.tplink.smb.omada.manager.stomp.wo.TerminalDeviceCloseWO;
import com.tplink.smb.omada.manager.terminal.b.a.e;
import com.tplink.smb.omada.manager.terminal.port.cache.b;
import com.tplink.smb.omada.manager.terminal.port.po.SessionIdPO;
import com.tplink.smb.omada.manager.terminal.port.po.TerminalDeviceMacInfoPO;
import com.tplink.smb.omada.manager.terminal.port.po.TerminalUserMacInfoPO;
import com.tplink.smb.rtty.protocol.RttyDeviceStateEnum;
import com.tplink.smb.rtty.protocol.packet.RttyManagerType;
import com.tplink.smb.rtty.protocol.packet.message.manager.RttyManagerMessage;
import io.reactivex.Observer;
import io.reactivex.annotations.NonNull;
import io.reactivex.disposables.Disposable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class a
implements Observer<TransResult<RttyManagerMessage>> {
    @Generated
    private static final Logger a = LoggerFactory.getLogger(a.class);
    private e b;
    private g c;
    private b d;

    public a(e terminalManagerApplication, g terminalStompCenter, b terminalCacheService) {
        this.b = terminalManagerApplication;
        this.c = terminalStompCenter;
        this.d = terminalCacheService;
    }

    public void onSubscribe(@NonNull Disposable d2) {
        a.debug("rtty device disconnect handler subscribe");
    }

    public void a(@NonNull TransResult<RttyManagerMessage> rttyManagerMessageTransResult) {
        a.debug("handle rtty disconnect message : {}", rttyManagerMessageTransResult);
        if (rttyManagerMessageTransResult.isOK()) {
            RttyManagerMessage managerMessage = (RttyManagerMessage)rttyManagerMessageTransResult.getResult();
            if (ObjectUtil.isNull((Object)managerMessage)) {
                return;
            }
            String deviceMac = managerMessage.getDeviceMac();
            TerminalDeviceMacInfoPO deviceMacInfo = this.d.a(deviceMac);
            if (ObjectUtil.isNull((Object)deviceMacInfo)) {
                return;
            }
            String omadacId = deviceMacInfo.getOmadacId();
            String siteId = deviceMacInfo.getSiteId();
            switch (RttyManagerType.fromInteger((int)managerMessage.getType())) {
                case DEVICE_DISCONNECT_EXCEPTION: 
                case DEVICE_DISCONNECT_NORMALLY: {
                    a.info("receive device: {} close normally, send message to front", (Object)deviceMac);
                    this.a(omadacId, siteId, deviceMac, Collections.list(deviceMacInfo.getSessionIdUserMap().keys()));
                    break;
                }
            }
            ConcurrentHashMap<String, String> sessionIdUserMap = deviceMacInfo.getSessionIdUserMap();
            sessionIdUserMap.forEach((terminalSessionId, httpSessionId) -> {
                a.info("disconnect terminal session id :{}", terminalSessionId);
                this.b.a(omadacId, siteId, (String)httpSessionId, deviceMac);
            });
            deviceMacInfo.setDeviceStatus(RttyDeviceStateEnum.DISCONNECT.getValue());
            deviceMacInfo.getSessionIdUserMap().clear();
            this.d.a(deviceMac, deviceMacInfo);
            TerminalUserMacInfoPO userMacInfo = this.d.c(omadacId, siteId, deviceMac);
            userMacInfo.getUserTerminalIdMap().clear();
            this.d.a(omadacId, siteId, deviceMac, userMacInfo);
        }
    }

    public void onError(@NonNull Throwable e2) {
        a.warn("rtty device disconnect handle error: {}", (Object)e2.getMessage());
    }

    public void onComplete() {
        a.debug("rtty device disconnect handler complete");
    }

    private void a(String omadacId, String siteId, String deviceMac, List<String> sessionIds) {
        ArrayList<StompMessageEvent> stompMessageEvents = new ArrayList<StompMessageEvent>();
        sessionIds.forEach(sessionId -> {
            ArrayList<String> disconnectSessionIds = new ArrayList<String>();
            disconnectSessionIds.add((String)sessionId);
            DeviceCloseInfoWO deviceCloseInfoWO = new DeviceCloseInfoWO(com.tplink.smb.omada.common.g.b.Mq.b(), com.tplink.smb.omada.common.g.b.Mq.c(), deviceMac, disconnectSessionIds);
            SessionIdPO terminalSessionIdInfo = this.d.a(omadacId, siteId, (String)sessionId);
            if (Objects.isNull(terminalSessionIdInfo)) {
                return;
            }
            String userId = terminalSessionIdInfo.getHttpSessionId();
            TerminalDeviceCloseWO terminalDeviceCloseWO = new TerminalDeviceCloseWO(deviceCloseInfoWO);
            StompMessageEvent<TerminalDeviceCloseWO> stompMessageEvent = new StompMessageEvent<TerminalDeviceCloseWO>(com.tplink.smb.omada.common.q.c.q.a(), omadacId, siteId, userId, terminalDeviceCloseWO);
            stompMessageEvents.add(stompMessageEvent);
        });
        this.c.a(stompMessageEvents);
    }

    public /* synthetic */ void onNext(@NonNull Object object) {
        this.a((TransResult<RttyManagerMessage>)((TransResult)object));
    }
}

