/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.device.report;

import com.tplink.smb.component.schedule.api.ScheduledEvent;
import com.tplink.smb.component.schedule.api.handler.ScheduledEventHandler;
import com.tplink.smb.omada.common.access.OperationResponse;
import com.tplink.smb.omada.common.g.b;
import com.tplink.smb.omada.manager.configuration.domain.model.site.R;
import com.tplink.smb.omada.manager.configuration.domain.model.site.z;
import com.tplink.smb.omada.manager.device.domain.model.g.Z;
import com.tplink.smb.omada.manager.device.report.DeviceListScheduleInfoDTO;
import com.tplink.smb.omada.manager.device.report.ExportDeviceListResultVO;
import com.tplink.smb.omada.manager.device.report.ExportDeviceListScheduleDTO;
import com.tplink.smb.omada.manager.device.report.a.a;
import com.tplink.smb.omada.manager.device.report.g;
import com.tplink.smb.omada.manager.device.report.k;
import com.tplink.smb.omada.manager.j.a.a.d;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class c
implements ScheduledEventHandler {
    @Generated
    private static final Logger a = LoggerFactory.getLogger(c.class);
    private static final String b = "omadacId";
    private static final String c = "siteId";
    private static final String d = "mspId";
    private static final int e = 1;
    private static final String f = "_";
    private static final String g = ".csv";
    private static final String h = ".xlsx";
    @Autowired
    private k i;
    @Autowired
    private g j;
    @Autowired
    private Z k;
    @Autowired
    private R l;

    public void handle(ScheduledEvent scheduledEvent) {
        if (Objects.isNull(scheduledEvent) || Objects.isNull(scheduledEvent.getTaskName()) || Objects.isNull(scheduledEvent.getTaskDataMap())) {
            a.warn("get schedule event failed for device list");
            return;
        }
        String taskName = scheduledEvent.getTaskName();
        Map dataMap = scheduledEvent.getTaskDataMap();
        if ("device_list_report_schedule".equals(taskName)) {
            this.a(dataMap);
        }
        if ("global_device_list_report_schedule".equals(taskName)) {
            this.b(dataMap);
        }
    }

    private void a(Map<String, Object> taskDataMap) {
        a.debug("start to send device list by email");
        String omadacId = (String)taskDataMap.get(b);
        String siteId = (String)taskDataMap.get(c);
        ExportDeviceListScheduleDTO scheduleInfo = this.j.a(omadacId, siteId);
        if (Objects.isNull(scheduleInfo) || !scheduleInfo.getEnable().booleanValue() || CollectionUtils.isEmpty((Collection)scheduleInfo.getEmailList()) || CollectionUtils.isEmpty((Collection)scheduleInfo.getSiteList())) {
            return;
        }
        Object scheduleInfoDTO = ((DeviceListScheduleInfoDTO.DeviceListScheduleInfoDTOBuilder)((DeviceListScheduleInfoDTO.DeviceListScheduleInfoDTOBuilder)((DeviceListScheduleInfoDTO.DeviceListScheduleInfoDTOBuilder)((DeviceListScheduleInfoDTO.DeviceListScheduleInfoDTOBuilder)((DeviceListScheduleInfoDTO.DeviceListScheduleInfoDTOBuilder)((DeviceListScheduleInfoDTO.DeviceListScheduleInfoDTOBuilder)((DeviceListScheduleInfoDTO.DeviceListScheduleInfoDTOBuilder)DeviceListScheduleInfoDTO.builder().omadacId(omadacId)).siteId(siteId)).reportName(scheduleInfo.getReportName())).format(scheduleInfo.getFormat())).emailList(scheduleInfo.getEmailList())).siteList(scheduleInfo.getSiteList())).timingType(scheduleInfo.getTimingType())).build();
        this.a((DeviceListScheduleInfoDTO)scheduleInfoDTO);
    }

    private void b(Map<String, Object> taskDataMap) {
        a.debug("start to send global device list by email");
        String omadacId = (String)taskDataMap.get(b);
        ExportDeviceListScheduleDTO scheduleInfo = this.j.a(omadacId);
        if (Objects.isNull(scheduleInfo) || !scheduleInfo.getEnable().booleanValue() || CollectionUtils.isEmpty((Collection)scheduleInfo.getEmailList())) {
            return;
        }
        List<z> siteList = this.l.e(new com.tplink.smb.omada.manager.j.a.a.c(omadacId), null);
        List<String> siteIdList = Optional.ofNullable(siteList).stream().flatMap(Collection::stream).map(site -> ((d)site.b()).a()).collect(Collectors.toList());
        Object scheduleInfoDTO = ((DeviceListScheduleInfoDTO.DeviceListScheduleInfoDTOBuilder)((DeviceListScheduleInfoDTO.DeviceListScheduleInfoDTOBuilder)((DeviceListScheduleInfoDTO.DeviceListScheduleInfoDTOBuilder)((DeviceListScheduleInfoDTO.DeviceListScheduleInfoDTOBuilder)((DeviceListScheduleInfoDTO.DeviceListScheduleInfoDTOBuilder)((DeviceListScheduleInfoDTO.DeviceListScheduleInfoDTOBuilder)DeviceListScheduleInfoDTO.builder().omadacId(omadacId)).reportName(scheduleInfo.getReportName())).format(scheduleInfo.getFormat())).emailList(scheduleInfo.getEmailList())).siteList(siteIdList)).timingType(scheduleInfo.getTimingType())).build();
        this.a((DeviceListScheduleInfoDTO)scheduleInfoDTO);
    }

    private void a(DeviceListScheduleInfoDTO scheduleInfo) {
        String omadacId = scheduleInfo.getOmadacId();
        String siteId = scheduleInfo.getSiteId();
        OperationResponse<List<ExportDeviceListResultVO>> operationResponse = this.k.a(new com.tplink.smb.omada.manager.j.a.a.c(omadacId), scheduleInfo.getSiteList(), scheduleInfo.getFormat());
        if (operationResponse.success() && Objects.nonNull(operationResponse.getResult())) {
            a.debug("Get export device list file success, omadacId : {}", (Object)omadacId);
            List resultVOList = (List)operationResponse.getResult();
            for (int index = 0; index < resultVOList.size(); ++index) {
                ExportDeviceListResultVO singleResultVO = (ExportDeviceListResultVO)resultVOList.get(index);
                if (resultVOList.size() == 1) {
                    this.a(omadacId, scheduleInfo, singleResultVO, siteId);
                    break;
                }
                boolean firstSharding = index == 0;
                String reportName = this.a(scheduleInfo.getReportName(), index + 1, resultVOList.size());
                OperationResponse sendResponse = this.a(omadacId, scheduleInfo, singleResultVO, siteId, firstSharding, reportName);
                if (index != 0 || sendResponse != null && sendResponse.success()) continue;
                a.info("send first report email failed, cancel to send last report email. omadacId:{}, siteId:{}.", (Object)omadacId, (Object)siteId);
                break;
            }
            a.info("finished to send report email for device list, omadacId:{}, siteId:{}.", (Object)omadacId, (Object)siteId);
        } else {
            a.info("failed to export device list file, omadacId : {}, siteId : {}, errorCode : {}.", new Object[]{omadacId, siteId, operationResponse.getErrorCode()});
        }
    }

    private String a(String reportName, int currentIndex, int allIndex) {
        if (reportName.endsWith(g)) {
            reportName = reportName.substring(0, reportName.length() - g.length());
        } else if (reportName.endsWith(h)) {
            reportName = reportName.substring(0, reportName.length() - h.length());
        }
        return reportName + f + currentIndex + f + allIndex;
    }

    private OperationResponse a(String omadacId, DeviceListScheduleInfoDTO scheduleInfo, ExportDeviceListResultVO resultVO, String siteId) {
        return this.a(omadacId, scheduleInfo, resultVO, siteId, true, null);
    }

    private OperationResponse a(String omadacId, DeviceListScheduleInfoDTO scheduleInfo, ExportDeviceListResultVO resultVO, String siteId, Boolean firstSharding, String reportName) {
        OperationResponse operationResponse;
        String subject = com.tplink.smb.omada.manager.device.report.a.a.a();
        String fileName = reportName == null ? scheduleInfo.getReportName() : reportName;
        switch (scheduleInfo.getFormat()) {
            case 0: {
                operationResponse = this.i.a(omadacId, resultVO, subject, fileName, siteId, scheduleInfo.getEmailList(), firstSharding);
                break;
            }
            case 1: {
                operationResponse = this.i.b(omadacId, resultVO, subject, fileName, siteId, scheduleInfo.getEmailList(), firstSharding);
                break;
            }
            default: {
                a.info("The format of scheduleInfo is wrong. omadacId:{}, siteId:{}.", (Object)omadacId, (Object)siteId);
                return new OperationResponse(com.tplink.smb.omada.common.g.b.b);
            }
        }
        if (operationResponse == null) {
            a.warn("send email failed for device list,omadaId:{},siteId:{}", (Object)omadacId, (Object)siteId);
            return operationResponse;
        }
        if (!operationResponse.success()) {
            a.info("send email failed for device list, omadaId:{}, siteId:{}, errorCode:{}", new Object[]{omadacId, siteId, operationResponse.getErrorCode()});
        }
        return operationResponse;
    }
}

