/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.device.port.transport;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.tplink.smb.omada.manager.device.domain.model.upgrade.common.b;
import com.tplink.smb.omada.manager.device.port.transport.ThreadConfigProperties;
import com.tplink.smb.omada.manager.device.port.transport.l;
import com.tplink.smb.omada.manager.device.port.transport.m;
import com.tplink.smb.omada.manager.device.port.transport.meter.a;
import com.tplink.smb.omada.manager.device.port.transport.n;
import com.tplink.smb.omada.manager.device.port.transport.o;
import com.tplink.smb.omada.manager.device.port.transport.p;
import com.tplink.smb.omada.manager.device.port.transport.q;
import com.tplink.smb.omada.manager.device.port.transport.r;
import com.tplink.smb.omada.manager.device.port.transport.s;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={ThreadConfigProperties.class})
public class TransportConfiguration {
    @Generated
    private static final Logger a = LoggerFactory.getLogger(TransportConfiguration.class);
    @Autowired
    private a b;

    @Lazy
    @Bean(name={"discoveryWorkGroup"})
    @ConditionalOnMissingBean(name={"discoveryWorkGroup"})
    public ExecutorService discoveryWorkGroup(ThreadConfigProperties threadConfigProperties) {
        a.info("discovery workGroup core thread num is {}, max thread num is {}", (Object)threadConfigProperties.getDiscoveryCoreThreadNum(), (Object)threadConfigProperties.getDiscoveryMaxThreadNum());
        String poolName = "discovery-work-group";
        ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(threadConfigProperties.getDiscoveryCoreThreadNum(), threadConfigProperties.getDiscoveryMaxThreadNum(), 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(threadConfigProperties.getDiscoveryExecutorQueueLength()), new ThreadFactoryBuilder().setNameFormat(poolName + "-%d").build(), new l(this, poolName));
        this.b.a(poolName, threadPoolExecutor.getQueue());
        this.b.a(poolName, threadPoolExecutor.getQueue(), threadConfigProperties.getDiscoveryExecutorQueueLength());
        return threadPoolExecutor;
    }

    @Lazy
    @Bean(name={"adoptWorkGroup"})
    @ConditionalOnMissingBean(name={"adoptWorkGroup"})
    public ExecutorService adoptWorkGroup(ThreadConfigProperties threadConfigProperties) {
        a.info("adopt workGroup core thread num is {}, max thread num is{}", (Object)threadConfigProperties.getAdoptCoreThreadNum(), (Object)threadConfigProperties.getAdoptMaxThreadNum());
        String poolName = "adopt-work-group";
        ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(threadConfigProperties.getAdoptCoreThreadNum(), threadConfigProperties.getAdoptMaxThreadNum(), 120L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(threadConfigProperties.getAdoptExecutorQueueLength()), new ThreadFactoryBuilder().setNameFormat(poolName + "-%d").build(), new m(this, poolName));
        this.b.a(poolName, threadPoolExecutor.getQueue());
        this.b.a(poolName, threadPoolExecutor.getQueue(), threadConfigProperties.getAdoptExecutorQueueLength());
        return threadPoolExecutor;
    }

    @Lazy
    @Bean(name={"manageWorkGroup"})
    @ConditionalOnMissingBean(name={"manageWorkGroup"})
    public ExecutorService manageWorkGroup(ThreadConfigProperties threadConfigProperties) {
        a.info("manager workGroup core thread  num is {}, max thread num is {}", (Object)threadConfigProperties.getManagerCoreThreadNum(), (Object)threadConfigProperties.getManagerMaxThreadNum());
        String poolName = "manage-work-group";
        ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(threadConfigProperties.getManagerCoreThreadNum(), threadConfigProperties.getManagerMaxThreadNum(), 120L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(threadConfigProperties.getManagerExecutorQueueLength()), new ThreadFactoryBuilder().setNameFormat(poolName + "-%d").build(), new n(this, poolName));
        this.b.a(poolName, threadPoolExecutor.getQueue());
        this.b.a(poolName, threadPoolExecutor.getQueue(), threadConfigProperties.getManagerExecutorQueueLength());
        return threadPoolExecutor;
    }

    @Lazy
    @Bean(name={"manageInformWorkGroup"})
    @ConditionalOnMissingBean(name={"manageInformWorkGroup"})
    public ExecutorService manageInformWorkGroup(ThreadConfigProperties threadConfigProperties) {
        a.info("manage Inform workGroup core thread  num is {}, max thread num is {}", (Object)(threadConfigProperties.getManagerInformCoreThreadNum() / 2), (Object)(threadConfigProperties.getManagerInformMaxThreadNum() / 2));
        String poolName = "manage-inform-work-group";
        ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(threadConfigProperties.getManagerInformCoreThreadNum() / 2, threadConfigProperties.getManagerInformMaxThreadNum() / 2, 120L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(2 * threadConfigProperties.getManagerInformExecutorQueueLength()), new ThreadFactoryBuilder().setNameFormat(poolName + "-%d").build(), new o(this, poolName));
        this.b.a(poolName, threadPoolExecutor.getQueue());
        this.b.a(poolName, threadPoolExecutor.getQueue(), threadConfigProperties.getManagerExecutorQueueLength());
        return threadPoolExecutor;
    }

    @Lazy
    @Bean(name={"manageAdoptInformWorkGroup"})
    @ConditionalOnMissingBean(name={"manageAdoptInformWorkGroup"})
    public ExecutorService manageAdoptInformWorkGroup(ThreadConfigProperties threadConfigProperties) {
        a.info("manage adopt Inform workGroup core thread  num is {}, max thread num is {}", (Object)(threadConfigProperties.getManagerInformCoreThreadNum() / 2), (Object)(threadConfigProperties.getManagerInformMaxThreadNum() / 2));
        String poolName = "manage-adopt-inform-work-group";
        ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(threadConfigProperties.getManagerInformCoreThreadNum() / 2, threadConfigProperties.getManagerInformMaxThreadNum() / 2, 120L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(2 * threadConfigProperties.getManagerInformExecutorQueueLength()), new ThreadFactoryBuilder().setNameFormat(poolName + "-%d").build(), new p(this, poolName));
        this.b.a(poolName, threadPoolExecutor.getQueue());
        this.b.a(poolName, threadPoolExecutor.getQueue(), threadConfigProperties.getManagerExecutorQueueLength());
        return threadPoolExecutor;
    }

    @Lazy
    @Bean(name={"upgradeWorkGroup"})
    @ConditionalOnMissingBean(name={"upgradeWorkGroup"})
    public ExecutorService upgradeWorkGroup(b upgradeConfig, ThreadConfigProperties threadConfigProperties) {
        a.info("upgrade workGroup core thread num is {}, max thread num is {}", (Object)threadConfigProperties.getUpgradeCoreTreadNum(), (Object)threadConfigProperties.getUpgradeMaxThreadNum());
        String poolName = "upgrade-work-group";
        ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(threadConfigProperties.getUpgradeCoreTreadNum(), threadConfigProperties.getUpgradeMaxThreadNum(), 120L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(upgradeConfig.n()), new ThreadFactoryBuilder().setNameFormat(poolName + "-%d").build(), new q(this, poolName));
        this.b.a(poolName, threadPoolExecutor.getQueue());
        this.b.a(poolName, threadPoolExecutor.getQueue(), upgradeConfig.n());
        return threadPoolExecutor;
    }

    @Lazy
    @Bean(name={"upgradeSendRequestGroup"})
    @ConditionalOnMissingBean(name={"upgradeSendRequestGroup"})
    public ExecutorService upgradeSendRequestGroup(b upgradeConfig, ThreadConfigProperties threadConfigProperties) {
        a.info("upgradeSendReq workGroup core thread num is {}, max thread num is {}", (Object)threadConfigProperties.getUpgradeSendReqCoreThreadNum(), (Object)threadConfigProperties.getUpgradeSendReqMaxThreadNum());
        String poolName = "upgrade-send-req-group";
        ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(threadConfigProperties.getUpgradeSendReqCoreThreadNum(), threadConfigProperties.getUpgradeSendReqMaxThreadNum(), 120L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(upgradeConfig.m()), new ThreadFactoryBuilder().setNameFormat(poolName + "-%d").build(), new r(this, poolName));
        this.b.a(poolName, threadPoolExecutor.getQueue());
        this.b.a(poolName, threadPoolExecutor.getQueue(), upgradeConfig.m());
        return threadPoolExecutor;
    }

    @Lazy
    @Bean(name={"forceProvisionDeviceGroup"})
    @ConditionalOnMissingBean(name={"forceProvisionDeviceGroup"})
    public ExecutorService forceProvisionDeviceGroup(ThreadConfigProperties threadConfigProperties) {
        a.info("force provision device workGroup core thread num is {}, max thread num is {}", (Object)threadConfigProperties.getForceProvisionCoreThreadNum(), (Object)threadConfigProperties.getForceProvisionMaxThreadNum());
        String poolName = "force-provision-device";
        ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(threadConfigProperties.getUpgradeSendReqCoreThreadNum(), threadConfigProperties.getUpgradeSendReqMaxThreadNum(), 120L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(threadConfigProperties.getForceProvisionQueueLength()), new ThreadFactoryBuilder().setNameFormat(poolName + "-%d").build(), new s(this, poolName));
        this.b.a(poolName, threadPoolExecutor.getQueue());
        this.b.a(poolName, threadPoolExecutor.getQueue(), threadConfigProperties.getForceProvisionQueueLength());
        return threadPoolExecutor;
    }
}

