/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.device.port.transport;

import com.tplink.smb.ecsp.common.DeviceType;
import com.tplink.smb.ecsp.message.grpc.DeviceAdoptInfoDTO;
import com.tplink.smb.ecsp.message.grpc.DeviceRequestDTO;
import com.tplink.smb.ecsp.message.grpc.EcspAdoptInfo;
import com.tplink.smb.ecsp.message.grpc.OperationResponse;
import com.tplink.smb.ecsp.protocol.packet.EcspMessage;
import com.tplink.smb.ecsp.protocol.packet.body.MessageBody;
import com.tplink.smb.ecsp.protocol.packet.header.MessageHeader;
import com.tplink.smb.ecsp.proxy.service.DeviceAdoptInfoService;
import com.tplink.smb.omada.common.constant.DeviceTypeEnum;
import com.tplink.smb.omada.common.obfuscate.KeepClassName;
import com.tplink.smb.omada.common.omadac.OmadacType;
import com.tplink.smb.omada.common.util.T;
import com.tplink.smb.omada.common.util.x;
import com.tplink.smb.omada.device.manage.message.EcspFirstVersionEnum;
import com.tplink.smb.omada.device.manage.message.EcspVersion;
import com.tplink.smb.omada.device.manage.message.body.adopt.v2.BasePreConnectedInfoV2Body;
import com.tplink.smb.omada.device.manage.message.body.eap.v2.ApPreConnectedInfoV2Body;
import com.tplink.smb.omada.device.manage.message.body.olt.v2.OltDiscoveryControllerSettingV2;
import com.tplink.smb.omada.device.manage.message.body.olt.v2.OltPreConnectedInfoV2Body;
import com.tplink.smb.omada.device.manage.message.body.osg.v2.OsgPreConnectedInfoV2Body;
import com.tplink.smb.omada.device.manage.message.body.osw.v2.OswPreConnectedInfoV2Body;
import com.tplink.smb.omada.device.manage.message.discovery.BaseDeviceMisc;
import com.tplink.smb.omada.device.manage.message.discovery.eap.ApDiscoveryControllerSettingV2;
import com.tplink.smb.omada.device.manage.message.discovery.eap.EapDiscoveryDeviceInfo;
import com.tplink.smb.omada.device.manage.message.discovery.olt.OltDiscoveryDeviceInfo;
import com.tplink.smb.omada.device.manage.message.discovery.osg.OsgDiscoveryControllerSettingV2;
import com.tplink.smb.omada.device.manage.message.discovery.osg.OsgDiscoveryDeviceInfo;
import com.tplink.smb.omada.device.manage.message.discovery.osw.OswDiscoveryControllerSettingV2;
import com.tplink.smb.omada.device.manage.message.discovery.osw.OswDiscoveryDeviceInfo;
import com.tplink.smb.omada.manager.common.d.e;
import com.tplink.smb.omada.manager.configuration.application.omadac.f;
import com.tplink.smb.omada.manager.device.application.adoption.v2.BasePreConnectedInfoDTO;
import com.tplink.smb.omada.manager.device.application.adoption.v2.BasePreConnectedInfoV1DTO;
import com.tplink.smb.omada.manager.device.application.adoption.v2.BasePreConnectedInfoV2DTO;
import com.tplink.smb.omada.manager.device.application.adoption.v2.a;
import com.tplink.smb.omada.manager.device.application.discovery.v2.ApPreConnectedInfoV2DTO;
import com.tplink.smb.omada.manager.device.application.discovery.v2.OltPreConnectedInfoV2DTO;
import com.tplink.smb.omada.manager.device.application.discovery.v2.OsgPreConnectedInfoV2DTO;
import com.tplink.smb.omada.manager.device.application.discovery.v2.OswPreConnectedInfoV2DTO;
import com.tplink.smb.omada.manager.device.domain.model.adopt.n;
import com.tplink.smb.omada.manager.device.domain.model.device.G;
import com.tplink.smb.omada.manager.device.domain.model.device.I;
import com.tplink.smb.omada.manager.device.domain.model.device.J;
import com.tplink.smb.omada.manager.device.domain.model.device.osw.aT;
import com.tplink.smb.omada.manager.device.domain.model.device.osw.aa;
import com.tplink.smb.omada.manager.device.domain.model.deviceimage.RunTimeAdoptInfo;
import com.tplink.smb.omada.manager.device.domain.model.deviceimage.l;
import com.tplink.smb.omada.manager.device.port.transport.DeviceAdoptInfoWithSiteRetryDTO;
import com.tplink.smb.omada.manager.device.port.transport.b.b;
import com.tplink.smb.omada.manager.device.port.transport.b.f;
import com.tplink.smb.omada.manager.device.port.transport.b.h;
import com.tplink.smb.omada.manager.device.port.transport.g;
import com.tplink.smb.omada.manager.device.port.transport.i;
import com.tplink.smb.omada.manager.j.a.a.c;
import com.tplink.smb.omada.manager.j.a.a.d;
import com.tplink.smb.omada.manager.license.domain.model.U;
import com.tplink.smb.omada.manager.stack.api.internal.dto.OswStackInfoDTO;
import com.tplink.smb.omada.manager.stack.api.internal.dto.OswStackMemberDTO;
import io.reactivex.Single;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component(value="localAdoptInfoService")
@KeepClassName
public class DeviceAdoptInfoServiceImpl
implements DeviceAdoptInfoService {
    @Generated
    private static final Logger a = LoggerFactory.getLogger(DeviceAdoptInfoServiceImpl.class);
    private static final int b = 1;
    private com.tplink.smb.omada.manager.device.domain.model.omadac.c c;
    private com.tplink.smb.omada.manager.common.d.b d;
    private g e;
    private com.tplink.smb.omada.manager.device.port.transport.h f;
    private h g;
    @Autowired
    private com.tplink.smb.omada.manager.restore.port.a.c h;
    @Autowired
    private n i;
    private com.tplink.smb.omada.lock.a.c j;
    private com.tplink.smb.omada.manager.configuration.domain.model.site.component.a.h k;
    private l l;
    @Autowired
    private com.tplink.smb.omada.manager.device.domain.model.a.a m;
    private e n;
    private i o;
    private U p;
    private com.tplink.smb.omada.manager.stack.api.internal.service.c q;
    private aT r;
    @Autowired
    private f s;

    public OperationResponse<DeviceAdoptInfoDTO> getDeviceAdoptInfo(DeviceRequestDTO deviceRequestDTO) {
        a.debug("get deviceAdoptinfo request for device {}.", (Object)deviceRequestDTO.getDeviceMac());
        return new OperationResponse((Object)this.a(deviceRequestDTO));
    }

    public Single<OperationResponse<DeviceAdoptInfoDTO>> getDeviceAdoptInfoAsync(DeviceRequestDTO deviceRequestDTO) {
        a.debug("get deviceAdoptinfo request for device {}.", (Object)deviceRequestDTO.getDeviceMac());
        DeviceAdoptInfoDTO deviceAdoptInfoDTO = this.a(deviceRequestDTO);
        return Single.just((Object)new OperationResponse((Object)deviceAdoptInfoDTO));
    }

    private DeviceAdoptInfoDTO a(DeviceRequestDTO deviceRequestDTO) {
        EcspMessage preConnectedInfo = deviceRequestDTO.getPreConnectInfo();
        if (preConnectedInfo == null) {
            a.debug("Receive empty preConnectedInfo when handle deviceAdoptInfo request. may rebuild link.");
            return null;
        }
        MessageHeader header = preConnectedInfo.getHeader();
        G deviceMac = new G(deviceRequestDTO.getDeviceMac());
        MessageBody body = preConnectedInfo.getBody();
        if (header == null) {
            a.debug("preConnectedInfo has empty header {} with body {}, device mac {}.", new Object[]{header, body, deviceRequestDTO.getDeviceMac()});
            return null;
        }
        String version = EcspVersion.fitFatEcspVer((String)header.getVersion());
        EcspFirstVersionEnum firstVersion = EcspVersion.getFirstVersion((String)version, (Integer)header.getVerCap());
        switch (firstVersion) {
            case V2: 
            case V3: {
                return this.a(header, body, deviceMac, deviceRequestDTO);
            }
            case V1: {
                return this.a(deviceMac, header);
            }
        }
        a.debug("Should not come here, ecsp version error. device {} version {} vercap {}.", new Object[]{header.getMac(), version, header.getVerCap()});
        return null;
    }

    private DeviceAdoptInfoDTO a(MessageHeader header, MessageBody body, G deviceMac, DeviceRequestDTO deviceRequestDTO) {
        BasePreConnectedInfoV2DTO preConnectedInfoV2DTO = this.a(header, body);
        if (preConnectedInfoV2DTO != null && preConnectedInfoV2DTO.isSuccess()) {
            boolean firstAdopt;
            if (this.m.a(preConnectedInfoV2DTO.getOmadacId(), deviceMac)) {
                a.info("{} {} in mac blacklist, return null adoptInfo", (Object)preConnectedInfoV2DTO.getOmadacId(), (Object)deviceMac);
                return null;
            }
            boolean bl2 = firstAdopt = !preConnectedInfoV2DTO.isRebuild();
            if (preConnectedInfoV2DTO.isPreLink() && !this.i.a(firstAdopt)) {
                a.info("Prelink connect failed because of acquiring limiter failed on device {} with omadac {}.", (Object)deviceMac, (Object)preConnectedInfoV2DTO.getOmadacId());
                return null;
            }
            if (this.h.b(preConnectedInfoV2DTO.getOmadacId().a())) {
                a.debug("This omadac {} is restoring when receive get adopt info request for v2 device {}.", (Object)preConnectedInfoV2DTO.getOmadacId(), (Object)deviceMac);
                return null;
            }
            DeviceAdoptInfoWithSiteRetryDTO deviceAdoptInfoWithSiteRetryDTO = this.a(preConnectedInfoV2DTO, deviceMac, deviceRequestDTO);
            if (deviceAdoptInfoWithSiteRetryDTO == null) {
                a.debug("Get null result from handlePreConnectedV2Service on device {} with omadac {}.", (Object)deviceMac, (Object)preConnectedInfoV2DTO.getOmadacId());
                return null;
            }
            return this.a(preConnectedInfoV2DTO.getOmadacId(), deviceAdoptInfoWithSiteRetryDTO, deviceMac);
        }
        return null;
    }

    private DeviceAdoptInfoWithSiteRetryDTO a(BasePreConnectedInfoV2DTO preConnectedInfoV2DTO, G deviceMac, DeviceRequestDTO deviceRequestDTO) {
        OswPreConnectedInfoV2DTO oswPreConnectedInfoV2DTO;
        String stackId;
        DeviceTypeEnum deviceType = preConnectedInfoV2DTO.getDeviceType();
        if (Objects.equals(deviceType, DeviceTypeEnum.c) && preConnectedInfoV2DTO instanceof OswPreConnectedInfoV2DTO && !T.c((String)(stackId = (oswPreConnectedInfoV2DTO = (OswPreConnectedInfoV2DTO)preConnectedInfoV2DTO).getStackId()))) {
            return this.a(oswPreConnectedInfoV2DTO, stackId, deviceMac, deviceRequestDTO);
        }
        return this.d.a(preConnectedInfoV2DTO.getOmadacId(), deviceMac, () -> this.f.a(preConnectedInfoV2DTO.getOmadacId(), deviceMac, deviceRequestDTO, preConnectedInfoV2DTO), () -> {
            a.warn("failed get v2 device {} lock with omadacId {} when handle pre connect.", (Object)deviceMac, (Object)preConnectedInfoV2DTO.getOmadacId());
            return null;
        });
    }

    private DeviceAdoptInfoWithSiteRetryDTO a(OswPreConnectedInfoV2DTO oswPreConnectedInfoV2DTO, String stackId, G deviceMac, DeviceRequestDTO deviceRequestDTO) {
        return this.n.a(oswPreConnectedInfoV2DTO.getOmadacId(), new com.tplink.smb.omada.manager.j.a.a.g(stackId), () -> {
            com.tplink.smb.omada.common.access.OperationResponse oswStackInfoRes;
            DeviceAdoptInfoWithSiteRetryDTO deviceAdoptInfoWithSiteRetryDTO = this.d.a(oswPreConnectedInfoV2DTO.getOmadacId(), deviceMac, () -> this.o.a(oswPreConnectedInfoV2DTO.getOmadacId(), deviceMac, new com.tplink.smb.omada.manager.j.a.a.g(stackId), deviceRequestDTO, oswPreConnectedInfoV2DTO), () -> {
                a.warn("failed get v2 device {} lock with omadacId {} when handle pre connect.", (Object)deviceMac, (Object)oswPreConnectedInfoV2DTO.getOmadacId());
                return null;
            });
            if (deviceAdoptInfoWithSiteRetryDTO != null && (oswStackInfoRes = this.q.f(oswPreConnectedInfoV2DTO.getOmadacId().a(), stackId)).success() && oswStackInfoRes.getResult() != null && !CollectionUtils.isEmpty((Collection)((OswStackInfoDTO)oswStackInfoRes.getResult()).getMembers())) {
                DeviceAdoptInfoDTO deviceAdoptInfoDTO;
                List members = ((OswStackInfoDTO)oswStackInfoRes.getResult()).getMembers();
                List<aa> memberOsws = this.r.a(oswPreConnectedInfoV2DTO.getOmadacId(), members.stream().map(OswStackMemberDTO::getMac).collect(Collectors.toList()));
                if (CollectionUtils.isEmpty(memberOsws)) {
                    return deviceAdoptInfoWithSiteRetryDTO;
                }
                ArrayList<EcspAdoptInfo> adoptInfoList = new ArrayList<EcspAdoptInfo>();
                adoptInfoList.add(new EcspAdoptInfo(com.tplink.smb.omada.manager.device.port.common.b.a.c, com.tplink.smb.omada.manager.device.port.common.b.a.d));
                d siteId = null;
                for (aa osw : memberOsws) {
                    siteId = osw.n();
                    Optional.ofNullable(osw.t()).ifPresent(adoptInfo -> adoptInfoList.add(new EcspAdoptInfo(adoptInfo.a(), adoptInfo.b())));
                    Optional.ofNullable(osw.s()).ifPresent(adoptInfo -> adoptInfoList.add(new EcspAdoptInfo(adoptInfo.a(), adoptInfo.b())));
                }
                if (deviceAdoptInfoWithSiteRetryDTO.getDeviceAdoptInfoDTO() == null) {
                    deviceAdoptInfoDTO = new DeviceAdoptInfoDTO(deviceRequestDTO.getDeviceMac(), DeviceType.SWITCH, adoptInfoList, oswPreConnectedInfoV2DTO.getEcspVersion());
                    return new DeviceAdoptInfoWithSiteRetryDTO(deviceAdoptInfoDTO, siteId);
                }
                if (!CollectionUtils.isEmpty((Collection)deviceAdoptInfoWithSiteRetryDTO.getDeviceAdoptInfoDTO().getAdoptInfoList())) {
                    adoptInfoList.addAll(deviceAdoptInfoWithSiteRetryDTO.getDeviceAdoptInfoDTO().getAdoptInfoList());
                }
                deviceAdoptInfoDTO = new DeviceAdoptInfoDTO(deviceRequestDTO.getDeviceMac(), DeviceType.SWITCH, adoptInfoList, oswPreConnectedInfoV2DTO.getEcspVersion());
                return new DeviceAdoptInfoWithSiteRetryDTO(deviceAdoptInfoDTO, siteId);
            }
            return deviceAdoptInfoWithSiteRetryDTO;
        }, () -> {
            a.warn("failed get v2 osw stack for device {} lock with omadacId {} when handle pre connect.", (Object)deviceMac, (Object)oswPreConnectedInfoV2DTO.getOmadacId());
            return null;
        });
    }

    private DeviceAdoptInfoDTO a(c omadacId, @Nonnull DeviceAdoptInfoWithSiteRetryDTO deviceAdoptInfoWithSiteRetryDTO, G deviceMac) {
        d siteId = deviceAdoptInfoWithSiteRetryDTO.getSiteId();
        if (deviceAdoptInfoWithSiteRetryDTO.supportSiteRetry()) {
            this.k.a(omadacId, siteId).ifPresent(commonSiteSetting -> {
                com.tplink.smb.omada.manager.configuration.domain.model.site.component.a.a.a deviceAccount = commonSiteSetting.r();
                DeviceAdoptInfoDTO deviceAdoptInfoDTO = deviceAdoptInfoWithSiteRetryDTO.getDeviceAdoptInfoDTO();
                if (deviceAccount == null || deviceAdoptInfoDTO == null) {
                    return;
                }
                ArrayList<EcspAdoptInfo> adoptInfoList = deviceAdoptInfoDTO.getAdoptInfoList();
                if (adoptInfoList == null) {
                    adoptInfoList = new ArrayList<EcspAdoptInfo>();
                    deviceAdoptInfoDTO.setAdoptInfoList(adoptInfoList);
                }
                adoptInfoList.add(new EcspAdoptInfo(deviceAccount.c(), deviceAccount.d()));
            });
            return deviceAdoptInfoWithSiteRetryDTO.getDeviceAdoptInfoDTO();
        }
        return deviceAdoptInfoWithSiteRetryDTO.getDeviceAdoptInfoDTO();
    }

    private DeviceAdoptInfoDTO a(G deviceMac, MessageHeader header) {
        c omadacId = this.c.a(deviceMac);
        if (omadacId == null) {
            a.warn("omadacId is null when handle preConnec for v1 device {}.", (Object)deviceMac);
            return null;
        }
        if (this.m.a(omadacId, deviceMac)) {
            a.info("{} {} in mac blacklist, return null adoptInfo", (Object)omadacId, (Object)deviceMac);
            return null;
        }
        if (this.h.b(omadacId.a())) {
            a.debug("This omadac {} is restoring when receive get adopt info request for v1 device {}.", (Object)omadacId, (Object)deviceMac);
            return null;
        }
        DeviceAdoptInfoWithSiteRetryDTO deviceAdoptInfoWithSiteRetryDTO = this.d.a(omadacId, deviceMac, () -> this.e.a(omadacId, deviceMac, this.a(header, omadacId)), () -> {
            a.warn("failed get v1 device {} lock with omadacId {} when handle pre connect.", (Object)deviceMac, (Object)omadacId);
            return null;
        });
        if (deviceAdoptInfoWithSiteRetryDTO == null) {
            a.debug("Get null result from handlePreConnectedV2Service on device {} with omadac {}.", (Object)deviceMac, (Object)omadacId);
            return null;
        }
        return this.a(omadacId, deviceMac, deviceAdoptInfoWithSiteRetryDTO);
    }

    private DeviceAdoptInfoDTO a(c omadacId, G deviceMac, DeviceAdoptInfoWithSiteRetryDTO deviceAdoptInfoWithSiteRetryDTO) {
        if (deviceAdoptInfoWithSiteRetryDTO.supportSiteRetry()) {
            this.k.a(omadacId, deviceAdoptInfoWithSiteRetryDTO.getSiteId()).ifPresent(commonSiteSetting -> {
                com.tplink.smb.omada.manager.configuration.domain.model.site.component.a.a.a deviceAccount = commonSiteSetting.r();
                DeviceAdoptInfoDTO deviceAdoptInfoDTO = deviceAdoptInfoWithSiteRetryDTO.getDeviceAdoptInfoDTO();
                if (deviceAccount == null || deviceAdoptInfoDTO == null) {
                    deviceAdoptInfoWithSiteRetryDTO.setNullDeviceAdoptInfoDTO();
                    return;
                }
                ArrayList<EcspAdoptInfo> adoptInfoList = deviceAdoptInfoDTO.getAdoptInfoList();
                if (adoptInfoList == null) {
                    adoptInfoList = new ArrayList<EcspAdoptInfo>(1);
                    deviceAdoptInfoDTO.setAdoptInfoList(adoptInfoList);
                }
                adoptInfoList.add(new EcspAdoptInfo(deviceAccount.c(), deviceAccount.d()));
                this.a(omadacId, deviceMac, deviceAccount, deviceAdoptInfoWithSiteRetryDTO);
            });
            return deviceAdoptInfoWithSiteRetryDTO.getDeviceAdoptInfoDTO();
        }
        DeviceAdoptInfoDTO deviceAdoptInfoDTO = deviceAdoptInfoWithSiteRetryDTO.getDeviceAdoptInfoDTO();
        if (deviceAdoptInfoDTO != null && CollectionUtils.isEmpty((Collection)deviceAdoptInfoDTO.getAdoptInfoList())) {
            return null;
        }
        return deviceAdoptInfoWithSiteRetryDTO.getDeviceAdoptInfoDTO();
    }

    private void a(@Nonnull c omadacId, @Nonnull G deviceMac, @Nonnull com.tplink.smb.omada.manager.configuration.domain.model.site.component.a.a.a deviceAccount, @Nonnull DeviceAdoptInfoWithSiteRetryDTO deviceAdoptInfoWithSiteRetryDTO) {
        this.d.a(omadacId, deviceMac, () -> {
            this.l.c(omadacId, deviceAdoptInfoWithSiteRetryDTO.getSiteId(), deviceMac).ifPresent(deviceImage -> {
                RunTimeAdoptInfo adoptInfo = deviceImage.aF();
                if (adoptInfo == null) {
                    adoptInfo = new RunTimeAdoptInfo();
                    deviceImage.a(adoptInfo);
                }
                adoptInfo.setPendingAdoptInfo(new RunTimeAdoptInfo.a(deviceAccount.c(), deviceAccount.d()));
                this.l.a((com.tplink.smb.omada.manager.device.domain.model.deviceimage.d)deviceImage);
            });
            return true;
        }, () -> {
            a.error("Failed get device lock when set v1 device adopt info to {} device image on omadac {} in autoAdopt.", (Object)deviceMac, (Object)omadacId);
            return false;
        });
    }

    private BasePreConnectedInfoV1DTO a(MessageHeader header, c omadacId) {
        DeviceTypeEnum deviceTypeEnum = DeviceTypeEnum.b((String)header.getDevice());
        switch (deviceTypeEnum) {
            case b: {
                return ((BasePreConnectedInfoV1DTO.BasePreConnectedInfoV1DTOBuilder)((BasePreConnectedInfoV1DTO.BasePreConnectedInfoV1DTOBuilder)((BasePreConnectedInfoV1DTO.BasePreConnectedInfoV1DTOBuilder)((BasePreConnectedInfoV1DTO.BasePreConnectedInfoV1DTOBuilder)((BasePreConnectedInfoV1DTO.BasePreConnectedInfoV1DTOBuilder)BasePreConnectedInfoV1DTO.builder().deviceMac(new G(header.getMac()))).deviceType(DeviceTypeEnum.b)).ecspVersion(header.getVersion())).omadacId(omadacId)).versionEnum(EcspFirstVersionEnum.V1)).build();
            }
            case a: {
                return ((BasePreConnectedInfoV1DTO.BasePreConnectedInfoV1DTOBuilder)((BasePreConnectedInfoV1DTO.BasePreConnectedInfoV1DTOBuilder)((BasePreConnectedInfoV1DTO.BasePreConnectedInfoV1DTOBuilder)((BasePreConnectedInfoV1DTO.BasePreConnectedInfoV1DTOBuilder)((BasePreConnectedInfoV1DTO.BasePreConnectedInfoV1DTOBuilder)BasePreConnectedInfoV1DTO.builder().deviceMac(new G(header.getMac()))).deviceType(DeviceTypeEnum.a)).ecspVersion(header.getVersion())).omadacId(omadacId)).versionEnum(EcspFirstVersionEnum.V1)).build();
            }
            case c: {
                return ((BasePreConnectedInfoV1DTO.BasePreConnectedInfoV1DTOBuilder)((BasePreConnectedInfoV1DTO.BasePreConnectedInfoV1DTOBuilder)((BasePreConnectedInfoV1DTO.BasePreConnectedInfoV1DTOBuilder)((BasePreConnectedInfoV1DTO.BasePreConnectedInfoV1DTOBuilder)((BasePreConnectedInfoV1DTO.BasePreConnectedInfoV1DTOBuilder)BasePreConnectedInfoV1DTO.builder().deviceMac(new G(header.getMac()))).deviceType(DeviceTypeEnum.c)).ecspVersion(header.getVersion())).omadacId(omadacId)).versionEnum(EcspFirstVersionEnum.V1)).build();
            }
        }
        a.debug("should not come here, error v1 device type {} device {} omadac {}.", new Object[]{header.getDevice(), header.getMac(), omadacId});
        return null;
    }

    @Nullable
    private BasePreConnectedInfoV2DTO a(@Nonnull MessageHeader header, MessageBody body) {
        DeviceTypeEnum deviceTypeEnum = DeviceTypeEnum.b((String)header.getDevice());
        switch (deviceTypeEnum) {
            case b: {
                return this.e(header, body);
            }
            case a: {
                return this.b(header, body);
            }
            case c: {
                return this.c(header, body);
            }
            case d: {
                return this.d(header, body);
            }
        }
        a.debug("should not come here, error v2 device type {} device {} omadac {}.", (Object)header.getDevice(), (Object)header.getMac());
        return null;
    }

    @Nullable
    private ApPreConnectedInfoV2DTO b(@Nonnull MessageHeader header, MessageBody body) {
        a.debug("pre connected info body {}", (Object)body);
        ApPreConnectedInfoV2Body preConnectedInfoV2Body = (ApPreConnectedInfoV2Body)x.a((String)x.a((Object)body), ApPreConnectedInfoV2Body.class);
        G deviceMac = new G(header.getMac());
        a preConnectedInfoEnum = this.a((BasePreConnectedInfoV2Body)preConnectedInfoV2Body, preConnectedInfoV2Body.getControllerSetting());
        c omadacId = this.c.a(deviceMac);
        d siteId = null;
        if (omadacId == null) {
            c destOmadacId;
            a.debug("May migration v2 ap device {} with preLink.", (Object)deviceMac);
            if (Objects.isNull(preConnectedInfoV2Body.getControllerSetting())) {
                a.debug("Invalid pre connected v2 ap device {} because of no omadacId.", (Object)deviceMac);
                return ((ApPreConnectedInfoV2DTO.ApPreConnectedInfoV2DTOBuilder)ApPreConnectedInfoV2DTO.builder().success(false)).build();
            }
            ApDiscoveryControllerSettingV2 controllerSetting = preConnectedInfoV2Body.getControllerSetting();
            if (controllerSetting.getControllerId() == null || header.getDest() == null) {
                a.debug("Invalid pre connected v2 ap device {} because of invalid controllerSetting {} or empty dest {}.", new Object[]{deviceMac, controllerSetting, header.getDest()});
                return ((ApPreConnectedInfoV2DTO.ApPreConnectedInfoV2DTOBuilder)ApPreConnectedInfoV2DTO.builder().success(false)).build();
            }
            c omadacIdFromControllerSetting = new c(controllerSetting.getControllerId());
            f.a omadacIdVerifyResult = this.g.a(omadacIdFromControllerSetting, destOmadacId = new c(header.getDest()), deviceMac, DeviceTypeEnum.a, header.getTimestamp());
            if (!omadacIdVerifyResult.a()) {
                a.debug("Alloc omadacId failed when handle pre connected info, ap v2 device {}. dest {} ", (Object)deviceMac, (Object)destOmadacId);
                return ((ApPreConnectedInfoV2DTO.ApPreConnectedInfoV2DTOBuilder)ApPreConnectedInfoV2DTO.builder().success(false)).build();
            }
            omadacId = omadacIdVerifyResult.d();
            if (omadacIdVerifyResult instanceof h.a) {
                h.a siteIdIdVerifyResult = (h.a)omadacIdVerifyResult;
                siteId = siteIdIdVerifyResult.h();
            }
        } else if (OmadacType.s() && preConnectedInfoEnum == com.tplink.smb.omada.manager.device.application.adoption.v2.a.c && !T.a((String)header.getDest(), (String)omadacId.a())) {
            a.info("refuse {} prelink {} not same with dest[{}]", new Object[]{deviceMac, omadacId, header.getDest()});
            return ((ApPreConnectedInfoV2DTO.ApPreConnectedInfoV2DTOBuilder)ApPreConnectedInfoV2DTO.builder().success(false)).build();
        }
        return this.a(preConnectedInfoEnum, header, preConnectedInfoV2Body, omadacId, siteId);
    }

    private ApPreConnectedInfoV2DTO a(a preConnectedInfoEnum, MessageHeader header, ApPreConnectedInfoV2Body preConnectedInfoV2Body, c omadacId, @Nullable d siteId) {
        Boolean fixProBySpecialModel = Boolean.FALSE;
        if (preConnectedInfoEnum == com.tplink.smb.omada.manager.device.application.adoption.v2.a.c) {
            boolean isProController = Objects.equals(this.p.a(omadacId), com.tplink.smb.omada.common.f.b.e.a());
            I deviceModelTypeDetectResult = J.a(preConnectedInfoV2Body.getDeviceMisc().getModelType(), ((EapDiscoveryDeviceInfo)preConnectedInfoV2Body.getDeviceInfo()).getModel(), ((EapDiscoveryDeviceInfo)preConnectedInfoV2Body.getDeviceInfo()).getModelVersion());
            boolean isProDevice = Boolean.TRUE.equals(deviceModelTypeDetectResult.a());
            fixProBySpecialModel = deviceModelTypeDetectResult.b();
            if (!isProController && isProDevice) {
                a.debug("Skip handle mismatch controller {} v2 ap device {} for {} controller {}.", new Object[]{isProDevice ? "pro" : "normal", header.getMac(), isProController ? "pro" : "normal", omadacId});
                return null;
            }
        }
        EcspFirstVersionEnum firstVersion = EcspVersion.getFirstVersion((String)header.getVersion(), (Integer)header.getVerCap());
        return ((ApPreConnectedInfoV2DTO.ApPreConnectedInfoV2DTOBuilder)((ApPreConnectedInfoV2DTO.ApPreConnectedInfoV2DTOBuilder)((ApPreConnectedInfoV2DTO.ApPreConnectedInfoV2DTOBuilder)((ApPreConnectedInfoV2DTO.ApPreConnectedInfoV2DTOBuilder)((BasePreConnectedInfoV2DTO.BasePreConnectedInfoV2DTOBuilder)((ApPreConnectedInfoV2DTO.ApPreConnectedInfoV2DTOBuilder)((BasePreConnectedInfoV2DTO.BasePreConnectedInfoV2DTOBuilder)((ApPreConnectedInfoV2DTO.ApPreConnectedInfoV2DTOBuilder)((ApPreConnectedInfoV2DTO.ApPreConnectedInfoV2DTOBuilder)((ApPreConnectedInfoV2DTO.ApPreConnectedInfoV2DTOBuilder)((ApPreConnectedInfoV2DTO.ApPreConnectedInfoV2DTOBuilder)((ApPreConnectedInfoV2DTO.ApPreConnectedInfoV2DTOBuilder)((ApPreConnectedInfoV2DTO.ApPreConnectedInfoV2DTOBuilder)ApPreConnectedInfoV2DTO.builder().ecspVersion(com.tplink.smb.omada.manager.device.port.transport.b.b.a(firstVersion, header.getVersion()))).timestamp(header.getTimestamp())).omadacId(omadacId)).siteId(siteId)).deviceMac(new G(header.getMac()))).deviceType(DeviceTypeEnum.a)).deviceMisc(preConnectedInfoV2Body.getDeviceMisc())).deviceInfo((EapDiscoveryDeviceInfo)((EapDiscoveryDeviceInfo)preConnectedInfoV2Body.getDeviceInfo()))).controllerSetting(preConnectedInfoV2Body.getControllerSetting())).preConnectedInfoType(preConnectedInfoEnum)).versionEnum(firstVersion)).success(true)).fixProBySpecialModel(fixProBySpecialModel)).build();
    }

    private boolean a(String device, BaseDeviceMisc deviceMisc, c omadacId) {
        boolean isProController = Objects.equals(this.p.a(omadacId), com.tplink.smb.omada.common.f.b.e.a());
        boolean isProDevice = deviceMisc != null && J.a(deviceMisc.getModelType());
        return !isProController && isProDevice;
    }

    @Nullable
    private OswPreConnectedInfoV2DTO c(@Nonnull MessageHeader header, MessageBody body) {
        OswPreConnectedInfoV2Body preConnectedInfoV2Body = (OswPreConnectedInfoV2Body)x.a((String)x.a((Object)body), OswPreConnectedInfoV2Body.class);
        G deviceMac = new G(header.getMac());
        a preConnectedInfoEnum = this.a((BasePreConnectedInfoV2Body)preConnectedInfoV2Body, preConnectedInfoV2Body.getControllerSetting());
        c omadacId = this.c.a(deviceMac);
        d siteId = null;
        if (omadacId == null) {
            c destOmadacId;
            a.debug("may migration v2 osw device {} with preLink.", (Object)deviceMac);
            if (Objects.isNull(preConnectedInfoV2Body.getControllerSetting())) {
                a.debug("Invalid pre connected v2 osw device {} because of no omadacId.", (Object)deviceMac);
                return ((OswPreConnectedInfoV2DTO.OswPreConnectedInfoV2DTOBuilder)OswPreConnectedInfoV2DTO.builder().success(false)).build();
            }
            OswDiscoveryControllerSettingV2 controllerSetting = preConnectedInfoV2Body.getControllerSetting();
            if (controllerSetting.getControllerId() == null || header.getDest() == null) {
                a.debug("Invalid pre connected v2 osw device {} because of invalid controllerSetting {} or empty dest {}.", new Object[]{deviceMac, controllerSetting, header.getDest()});
                return ((OswPreConnectedInfoV2DTO.OswPreConnectedInfoV2DTOBuilder)OswPreConnectedInfoV2DTO.builder().success(false)).build();
            }
            c omadacIdFromControllerSetting = new c(controllerSetting.getControllerId());
            f.a omadacIdVerifyResult = this.g.a(omadacIdFromControllerSetting, destOmadacId = new c(header.getDest()), deviceMac, DeviceTypeEnum.c, header.getTimestamp());
            if (!omadacIdVerifyResult.a()) {
                a.debug("alloc omadacId failed when handle pre connected info, osw v2 device {}. dest {} ", (Object)deviceMac, (Object)destOmadacId);
                return ((OswPreConnectedInfoV2DTO.OswPreConnectedInfoV2DTOBuilder)OswPreConnectedInfoV2DTO.builder().success(false)).build();
            }
            omadacId = omadacIdVerifyResult.d();
            if (omadacIdVerifyResult instanceof h.a) {
                h.a siteIdIdVerifyResult = (h.a)omadacIdVerifyResult;
                siteId = siteIdIdVerifyResult.h();
            }
        } else if (OmadacType.s() && preConnectedInfoEnum == com.tplink.smb.omada.manager.device.application.adoption.v2.a.c && !T.a((String)header.getDest(), (String)omadacId.a())) {
            a.info("refuse {} prelink {} not same with dest[{}]", new Object[]{deviceMac, omadacId, header.getDest()});
            return ((OswPreConnectedInfoV2DTO.OswPreConnectedInfoV2DTOBuilder)OswPreConnectedInfoV2DTO.builder().success(false)).build();
        }
        if (preConnectedInfoEnum == com.tplink.smb.omada.manager.device.application.adoption.v2.a.c && this.a(header.getDevice(), (BaseDeviceMisc)preConnectedInfoV2Body.getDeviceMisc(), omadacId)) {
            a.info("Skip handle preConnectedInfo mismatch osw device {} for controller {}.", (Object)header.getMac(), (Object)omadacId);
            return ((OswPreConnectedInfoV2DTO.OswPreConnectedInfoV2DTOBuilder)OswPreConnectedInfoV2DTO.builder().success(false)).build();
        }
        EcspFirstVersionEnum firstVersion = EcspVersion.getFirstVersion((String)header.getVersion(), (Integer)header.getVerCap());
        return ((OswPreConnectedInfoV2DTO.OswPreConnectedInfoV2DTOBuilder)((OswPreConnectedInfoV2DTO.OswPreConnectedInfoV2DTOBuilder)((OswPreConnectedInfoV2DTO.OswPreConnectedInfoV2DTOBuilder)((BasePreConnectedInfoV2DTO.BasePreConnectedInfoV2DTOBuilder)((OswPreConnectedInfoV2DTO.OswPreConnectedInfoV2DTOBuilder)((BasePreConnectedInfoV2DTO.BasePreConnectedInfoV2DTOBuilder)((OswPreConnectedInfoV2DTO.OswPreConnectedInfoV2DTOBuilder)((OswPreConnectedInfoV2DTO.OswPreConnectedInfoV2DTOBuilder)((BasePreConnectedInfoDTO.BasePreConnectedInfoDTOBuilder)((OswPreConnectedInfoV2DTO.OswPreConnectedInfoV2DTOBuilder)((OswPreConnectedInfoV2DTO.OswPreConnectedInfoV2DTOBuilder)((OswPreConnectedInfoV2DTO.OswPreConnectedInfoV2DTOBuilder)((OswPreConnectedInfoV2DTO.OswPreConnectedInfoV2DTOBuilder)OswPreConnectedInfoV2DTO.builder().ecspVersion(com.tplink.smb.omada.manager.device.port.transport.b.b.a(firstVersion, header.getVersion()))).timestamp(header.getTimestamp())).omadacId(omadacId)).siteId(siteId)).stackId(preConnectedInfoV2Body.getStackId())).deviceMac(new G(header.getMac()))).deviceType(DeviceTypeEnum.c)).deviceMisc(preConnectedInfoV2Body.getDeviceMisc())).deviceInfo((OswDiscoveryDeviceInfo)preConnectedInfoV2Body.getDeviceInfo())).controllerSetting(preConnectedInfoV2Body.getControllerSetting())).preConnectedInfoType(preConnectedInfoEnum)).versionEnum(firstVersion)).success(true)).build();
    }

    @Nullable
    private OltPreConnectedInfoV2DTO d(@Nonnull MessageHeader header, MessageBody body) {
        OltPreConnectedInfoV2Body preConnectedInfoV2Body = (OltPreConnectedInfoV2Body)x.a((String)x.a((Object)body), OltPreConnectedInfoV2Body.class);
        G deviceMac = new G(header.getMac());
        a preConnectedInfoEnum = this.a((BasePreConnectedInfoV2Body)preConnectedInfoV2Body, preConnectedInfoV2Body.getControllerSetting());
        c omadacId = this.c.a(deviceMac);
        d siteId = null;
        if (omadacId == null) {
            c destOmadacId;
            a.debug("May migration v2 olt device {} with preLink.", (Object)deviceMac);
            if (Objects.isNull(preConnectedInfoV2Body.getControllerSetting())) {
                a.debug("Invalid pre connected v2 olt device {} because of no omadacId.", (Object)com.tplink.smb.omada.common.util.e.a.d((String)deviceMac.a()));
                return ((OltPreConnectedInfoV2DTO.OltPreConnectedInfoV2DTOBuilder)OltPreConnectedInfoV2DTO.builder().success(false)).build();
            }
            OltDiscoveryControllerSettingV2 controllerSetting = preConnectedInfoV2Body.getControllerSetting();
            if (controllerSetting.getControllerId() == null || header.getDest() == null) {
                a.debug("Invalid pre connected v2 olt device {} because of invalid controllerSetting {} or empty dest {}.", new Object[]{com.tplink.smb.omada.common.util.e.a.d((String)deviceMac.a()), controllerSetting, header.getDest()});
                return ((OltPreConnectedInfoV2DTO.OltPreConnectedInfoV2DTOBuilder)OltPreConnectedInfoV2DTO.builder().success(false)).build();
            }
            c omadacIdFromControllerSetting = new c(controllerSetting.getControllerId());
            f.a omadacIdVerifyResult = this.g.a(omadacIdFromControllerSetting, destOmadacId = new c(header.getDest()), deviceMac, DeviceTypeEnum.d, header.getTimestamp());
            if (!omadacIdVerifyResult.a()) {
                a.debug("Alloc omadacId failed when handle pre connected info, olt v2 device {}. dest {} ", (Object)com.tplink.smb.omada.common.util.e.a.d((String)deviceMac.a()), (Object)destOmadacId);
                return ((OltPreConnectedInfoV2DTO.OltPreConnectedInfoV2DTOBuilder)OltPreConnectedInfoV2DTO.builder().success(false)).build();
            }
            omadacId = omadacIdVerifyResult.d();
            if (omadacIdVerifyResult instanceof h.a) {
                h.a siteIdIdVerifyResult = (h.a)omadacIdVerifyResult;
                siteId = siteIdIdVerifyResult.h();
            }
        } else if (OmadacType.s() && preConnectedInfoEnum == com.tplink.smb.omada.manager.device.application.adoption.v2.a.c && !T.a((String)header.getDest(), (String)omadacId.a())) {
            a.info("refuse {} prelink {} not same with dest[{}]", new Object[]{com.tplink.smb.omada.common.util.e.a.d((String)deviceMac.a()), omadacId, header.getDest()});
            return ((OltPreConnectedInfoV2DTO.OltPreConnectedInfoV2DTOBuilder)OltPreConnectedInfoV2DTO.builder().success(false)).build();
        }
        if (Objects.equals(this.s.f(omadacId.a()), com.tplink.smb.omada.common.f.b.e.a())) {
            a.info("Skip handle preConnectedInfo mismatch olt device {} for controller {}.", (Object)com.tplink.smb.omada.common.util.e.a.d((String)header.getMac()), (Object)omadacId);
            return ((OltPreConnectedInfoV2DTO.OltPreConnectedInfoV2DTOBuilder)OltPreConnectedInfoV2DTO.builder().success(false)).build();
        }
        EcspFirstVersionEnum firstVersion = EcspVersion.getFirstVersion((String)header.getVersion(), (Integer)header.getVerCap());
        return ((OltPreConnectedInfoV2DTO.OltPreConnectedInfoV2DTOBuilder)((OltPreConnectedInfoV2DTO.OltPreConnectedInfoV2DTOBuilder)((OltPreConnectedInfoV2DTO.OltPreConnectedInfoV2DTOBuilder)((BasePreConnectedInfoV2DTO.BasePreConnectedInfoV2DTOBuilder)((OltPreConnectedInfoV2DTO.OltPreConnectedInfoV2DTOBuilder)((OltPreConnectedInfoV2DTO.OltPreConnectedInfoV2DTOBuilder)((OltPreConnectedInfoV2DTO.OltPreConnectedInfoV2DTOBuilder)((OltPreConnectedInfoV2DTO.OltPreConnectedInfoV2DTOBuilder)((OltPreConnectedInfoV2DTO.OltPreConnectedInfoV2DTOBuilder)((OltPreConnectedInfoV2DTO.OltPreConnectedInfoV2DTOBuilder)((OltPreConnectedInfoV2DTO.OltPreConnectedInfoV2DTOBuilder)((OltPreConnectedInfoV2DTO.OltPreConnectedInfoV2DTOBuilder)OltPreConnectedInfoV2DTO.builder().ecspVersion(com.tplink.smb.omada.manager.device.port.transport.b.b.a(firstVersion, header.getVersion()))).timestamp(header.getTimestamp())).omadacId(omadacId)).siteId(siteId)).deviceMac(new G(header.getMac()))).deviceType(DeviceTypeEnum.d)).deviceInfo((OltDiscoveryDeviceInfo)preConnectedInfoV2Body.getDeviceInfo())).deviceMisc(preConnectedInfoV2Body.getDeviceMisc())).controllerSetting(preConnectedInfoV2Body.getControllerSetting())).preConnectedInfoType(preConnectedInfoEnum)).versionEnum(firstVersion)).success(true)).build();
    }

    @Nullable
    private OsgPreConnectedInfoV2DTO e(@Nonnull MessageHeader header, MessageBody body) {
        OsgPreConnectedInfoV2Body preConnectedInfoV2Body = (OsgPreConnectedInfoV2Body)x.a((String)x.a((Object)body), OsgPreConnectedInfoV2Body.class);
        G deviceMac = new G(header.getMac());
        a preConnectedInfoEnum = this.a((BasePreConnectedInfoV2Body)preConnectedInfoV2Body, preConnectedInfoV2Body.getControllerSetting());
        c omadacId = this.c.a(deviceMac);
        d siteId = null;
        if (omadacId == null) {
            c destOmadacId;
            a.debug("may migration V2 osg device {} with preLink.", (Object)deviceMac);
            if (Objects.isNull(preConnectedInfoV2Body.getControllerSetting())) {
                a.debug("Invalid pre connected v2 osg device {} because of no omadacId.", (Object)deviceMac);
                return ((OsgPreConnectedInfoV2DTO.OsgPreConnectedInfoV2DTOBuilder)OsgPreConnectedInfoV2DTO.builder().success(false)).build();
            }
            OsgDiscoveryControllerSettingV2 controllerSetting = preConnectedInfoV2Body.getControllerSetting();
            if (controllerSetting.getControllerId() == null || header.getDest() == null) {
                a.debug("Invalid pre connected v2 osg device {} because of invalid controllerSetting {} or empty dest {}.", new Object[]{deviceMac, controllerSetting, header.getDest()});
                return ((OsgPreConnectedInfoV2DTO.OsgPreConnectedInfoV2DTOBuilder)OsgPreConnectedInfoV2DTO.builder().success(false)).build();
            }
            c omadacIdFromControllerSetting = new c(controllerSetting.getControllerId());
            f.a omadacIdVerifyResult = this.g.a(omadacIdFromControllerSetting, destOmadacId = new c(header.getDest()), deviceMac, DeviceTypeEnum.b, header.getTimestamp());
            if (!omadacIdVerifyResult.a()) {
                a.debug("alloc omadacId failed when handle pre connected info, osg v2 device {}. dest {} ", (Object)deviceMac, (Object)destOmadacId);
                return ((OsgPreConnectedInfoV2DTO.OsgPreConnectedInfoV2DTOBuilder)OsgPreConnectedInfoV2DTO.builder().success(false)).build();
            }
            omadacId = omadacIdVerifyResult.d();
            if (omadacIdVerifyResult instanceof h.a) {
                h.a siteIdIdVerifyResult = (h.a)omadacIdVerifyResult;
                siteId = siteIdIdVerifyResult.h();
            }
        } else if (OmadacType.s() && preConnectedInfoEnum == com.tplink.smb.omada.manager.device.application.adoption.v2.a.c && !T.a((String)header.getDest(), (String)omadacId.a())) {
            a.info("refuse {} prelink {} not same with dest[{}]", new Object[]{deviceMac, omadacId, header.getDest()});
            return ((OsgPreConnectedInfoV2DTO.OsgPreConnectedInfoV2DTOBuilder)OsgPreConnectedInfoV2DTO.builder().success(false)).build();
        }
        if (preConnectedInfoEnum == com.tplink.smb.omada.manager.device.application.adoption.v2.a.c && this.a(header.getDevice(), (BaseDeviceMisc)preConnectedInfoV2Body.getDeviceMisc(), omadacId)) {
            a.info("Skip handle preConnectedInfo no pro osg device {} for pro controller {}.", (Object)header.getMac(), (Object)omadacId);
            return ((OsgPreConnectedInfoV2DTO.OsgPreConnectedInfoV2DTOBuilder)OsgPreConnectedInfoV2DTO.builder().success(false)).build();
        }
        EcspFirstVersionEnum firstVersion = EcspVersion.getFirstVersion((String)header.getVersion(), (Integer)header.getVerCap());
        return ((OsgPreConnectedInfoV2DTO.OsgPreConnectedInfoV2DTOBuilder)((OsgPreConnectedInfoV2DTO.OsgPreConnectedInfoV2DTOBuilder)((OsgPreConnectedInfoV2DTO.OsgPreConnectedInfoV2DTOBuilder)((BasePreConnectedInfoV2DTO.BasePreConnectedInfoV2DTOBuilder)((OsgPreConnectedInfoV2DTO.OsgPreConnectedInfoV2DTOBuilder)((BasePreConnectedInfoV2DTO.BasePreConnectedInfoV2DTOBuilder)((OsgPreConnectedInfoV2DTO.OsgPreConnectedInfoV2DTOBuilder)((OsgPreConnectedInfoV2DTO.OsgPreConnectedInfoV2DTOBuilder)((OsgPreConnectedInfoV2DTO.OsgPreConnectedInfoV2DTOBuilder)((OsgPreConnectedInfoV2DTO.OsgPreConnectedInfoV2DTOBuilder)((OsgPreConnectedInfoV2DTO.OsgPreConnectedInfoV2DTOBuilder)((OsgPreConnectedInfoV2DTO.OsgPreConnectedInfoV2DTOBuilder)OsgPreConnectedInfoV2DTO.builder().ecspVersion(com.tplink.smb.omada.manager.device.port.transport.b.b.a(firstVersion, header.getVersion()))).timestamp(header.getTimestamp())).omadacId(omadacId)).siteId(siteId)).deviceMac(deviceMac)).deviceType(DeviceTypeEnum.b)).deviceMisc(preConnectedInfoV2Body.getDeviceMisc())).deviceInfo((OsgDiscoveryDeviceInfo)((OsgDiscoveryDeviceInfo)preConnectedInfoV2Body.getDeviceInfo()))).controllerSetting(preConnectedInfoV2Body.getControllerSetting())).preConnectedInfoType(preConnectedInfoEnum)).versionEnum(firstVersion)).success(true)).build();
    }

    private a a(BasePreConnectedInfoV2Body preConnectedInfoV2Body, Object controllerSetting) {
        a preConnectedInfoEnum = preConnectedInfoV2Body.getRebuild() != null && preConnectedInfoV2Body.getRebuild() == 1 ? com.tplink.smb.omada.manager.device.application.adoption.v2.a.b : (Objects.isNull(controllerSetting) ? com.tplink.smb.omada.manager.device.application.adoption.v2.a.d : com.tplink.smb.omada.manager.device.application.adoption.v2.a.c);
        return preConnectedInfoEnum;
    }

    @Autowired
    public void a(com.tplink.smb.omada.manager.device.domain.model.omadac.c allocOmadacService) {
        this.c = allocOmadacService;
    }

    @Autowired
    public void a(com.tplink.smb.omada.manager.common.d.b managerDeviceLockFactory) {
        this.d = managerDeviceLockFactory;
    }

    @Autowired
    public void a(g handlePreConnectedV1Service) {
        this.e = handlePreConnectedV1Service;
    }

    @Autowired
    public void a(com.tplink.smb.omada.manager.device.port.transport.h handlePreConnectedV2Service) {
        this.f = handlePreConnectedV2Service;
    }

    @Autowired
    public void a(h verifyAndAllocSiteIdService) {
        this.g = verifyAndAllocSiteIdService;
    }

    @Autowired
    public void a(com.tplink.smb.omada.lock.a.c siteLockFactory) {
        this.j = siteLockFactory;
    }

    @Autowired
    public void a(com.tplink.smb.omada.manager.configuration.domain.model.site.component.a.h queryCommonSiteSettingService) {
        this.k = queryCommonSiteSettingService;
    }

    @Autowired
    public void a(l deviceImageRepository) {
        this.l = deviceImageRepository;
    }

    @Autowired
    public void a(e managerOswStackLockFactory) {
        this.n = managerOswStackLockFactory;
    }

    @Autowired
    public void a(i handleStackPreConnectedService) {
        this.o = handleStackPreConnectedService;
    }

    @Autowired
    public void a(U omadacCategoryService) {
        this.p = omadacCategoryService;
    }

    @Autowired
    public void a(com.tplink.smb.omada.manager.stack.api.internal.service.c oswStackInternalService) {
        this.q = oswStackInternalService;
    }

    @Autowired
    public void a(aT oswRepository) {
        this.r = oswRepository;
    }
}

