/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.device.port.common.util;

import com.tplink.smb.omada.common.access.OperationResponse;
import com.tplink.smb.omada.common.constant.x;
import com.tplink.smb.omada.common.omadac.config.b;
import com.tplink.smb.omada.common.util.T;
import com.tplink.smb.omada.device.manage.message.config.ap.ssid.SsidC;
import com.tplink.smb.omada.device.manage.message.inform.ap.ApBssidInfo;
import com.tplink.smb.omada.manager.common.api.configuration.wireless.dto.SsidDTO;
import com.tplink.smb.omada.manager.configuration.api.web.site.wireless.SsidVO;
import com.tplink.smb.omada.manager.device.domain.model.device.ap.c;
import com.tplink.smb.omada.manager.device.domain.model.deviceimage.ap.a;
import com.tplink.smb.omada.manager.device.domain.model.deviceimage.osg.e;
import com.tplink.smb.omada.manager.device.port.common.c.a.a.a.a.v;
import jakarta.annotation.Nonnull;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public abstract class o {
    @Generated
    private static final Logger a = LoggerFactory.getLogger(o.class);

    private o() {
    }

    public static boolean a(String ssidName) {
        return o.a(ssidName, 1, 32, "UTF-8");
    }

    public static boolean b(String mdnsVlan) {
        return o.a(mdnsVlan, 1, 64, "UTF-8");
    }

    public static boolean a(String val, int min, int max, String charsetName) {
        if (min > max) {
            return false;
        }
        if (val != null) {
            int len = val.getBytes(Charset.forName(charsetName)).length;
            return len >= min && len <= max;
        }
        return false;
    }

    public static boolean c(String psk) {
        if (T.a((String)psk)) {
            return false;
        }
        Matcher matcher = com.tplink.smb.omada.common.util.f.c.be.matcher(psk);
        return matcher.matches();
    }

    public static boolean a(int target, int min, int max) {
        return target >= min && target <= max;
    }

    public static Integer a(SsidDTO ssidDTO) {
        if (ssidDTO.getPmfMode() != null) {
            return ssidDTO.getPmfMode();
        }
        Integer security = ssidDTO.getSecurity();
        Boolean mloEnable = ssidDTO.getMloEnable();
        switch (security) {
            case 2: {
                if (ssidDTO.getWpaSetting() == null) {
                    return null;
                }
                return o.b(ssidDTO.getWpaSetting().getVersionEnt(), ssidDTO.getBand(), mloEnable);
            }
            case 3: 
            case 4: 
            case 5: {
                if (ssidDTO.getPskSetting() == null) {
                    return null;
                }
                return o.a(ssidDTO.getPskSetting().getVersionPsk(), ssidDTO.getBand(), mloEnable);
            }
            case 0: {
                return null;
            }
        }
        a.warn("failed to handleSsidPmfMode, Invalid security:{}", (Object)security);
        return null;
    }

    public static Integer a(Integer versionPsk, Integer band, Boolean mloEnable) {
        if (versionPsk < 4) {
            return 3;
        }
        if (versionPsk == 4) {
            return SsidVO.onlyEnable6G((Integer)band) || SsidVO.contain6G((Integer)band) && Boolean.TRUE.equals(mloEnable) ? 1 : 2;
        }
        return null;
    }

    public static Integer b(Integer versionEnt, Integer band, Boolean mloEnable) {
        if (versionEnt < 4) {
            return 3;
        }
        if (versionEnt == 4) {
            return SsidVO.onlyEnable6G((Integer)band) || SsidVO.contain6G((Integer)band) && Boolean.TRUE.equals(mloEnable) ? 1 : 2;
        }
        return null;
    }

    public static boolean a(Integer deviceType) {
        if (deviceType == null) {
            return true;
        }
        return (deviceType & 1) > 0;
    }

    public static boolean b(Integer deviceType) {
        if (deviceType == null) {
            return true;
        }
        return (deviceType & 2) > 0;
    }

    public static boolean a(Integer deviceType, Integer destType) {
        if (deviceType == null) {
            return true;
        }
        return (deviceType & destType) >= destType;
    }

    public static boolean b(SsidDTO ssidDTO) {
        if (ssidDTO.getBand() == null) {
            return false;
        }
        com.tplink.smb.omada.manager.common.constants.v ssidBand = com.tplink.smb.omada.manager.common.constants.v.a(ssidDTO.getBand());
        if (ssidBand == null) {
            return false;
        }
        return switch (ssidBand) {
            default -> throw new IncompatibleClassChangeError();
            case com.tplink.smb.omada.manager.common.constants.v.a, com.tplink.smb.omada.manager.common.constants.v.b, com.tplink.smb.omada.manager.common.constants.v.d -> true;
            case com.tplink.smb.omada.manager.common.constants.v.c, com.tplink.smb.omada.manager.common.constants.v.f, com.tplink.smb.omada.manager.common.constants.v.e, com.tplink.smb.omada.manager.common.constants.v.g -> false;
        };
    }

    public static boolean a() {
        b conf = com.tplink.smb.omada.common.omadac.config.c.a((String)"omada.properties");
        if (conf == null) {
            return false;
        }
        return conf.b("allow_select_default_vlan");
    }

    public static List<String> a(List<ApBssidInfo> bssids) {
        if (CollectionUtils.isEmpty(bssids)) {
            return new ArrayList<String>();
        }
        return bssids.stream().filter(Objects::nonNull).filter(apBssidInfo -> T.b((String)apBssidInfo.getBssid())).filter(apBssidInfo -> !T.a((String)apBssidInfo.getBssid(), (String)"00-00-00-00-00-00")).map(ApBssidInfo::getBssid).collect(Collectors.toList());
    }

    public static void a(a apImage, SsidC ssidC, Integer radioId) {
        if (Objects.isNull(ssidC.getOperation()) || Objects.isNull(x.a((int)ssidC.getOperation()))) {
            a.error("buildSsidCForWpa3 failed, this will never happen, ap:{}, ssid:{}", (Object)apImage.X(), (Object)ssidC.getId());
            return;
        }
        boolean supportNewWpa3Cipher = Boolean.TRUE.equals(apImage.br());
        if (!supportNewWpa3Cipher) {
            if (radioId == 3 && ssidC.getSingleBand().booleanValue()) {
                if (ssidC.getWpaCipher() == 6) {
                    ssidC.setWpaCipher(Integer.valueOf(4));
                }
                return;
            }
            ssidC.setWpaCipher(Integer.valueOf(3));
        }
    }

    public static void a(e osgImage, SsidC ssidC, Integer radioId) {
        if (Objects.isNull(ssidC.getOperation()) || Objects.isNull(x.a((int)ssidC.getOperation()))) {
            a.error("buildSsidCForWpa3 failed, this will never happen, osg:{}, ssid:{}", (Object)osgImage.X(), (Object)ssidC.getId());
            return;
        }
        boolean supportNewWpa3Cipher = Boolean.TRUE.equals(osgImage.db());
        if (!supportNewWpa3Cipher) {
            if (radioId == 3 && ssidC.getSingleBand().booleanValue()) {
                if (ssidC.getWpaCipher() == 6) {
                    ssidC.setWpaCipher(Integer.valueOf(4));
                }
                return;
            }
            ssidC.setWpaCipher(Integer.valueOf(3));
        }
    }

    public static OperationResponse<List<Integer>> d(@Nonnull String vlans) {
        if (!vlans.matches("^[\\d|\\d-\\d]+(,[\\d|\\d-\\d]+)*$")) {
            return new OperationResponse(com.tplink.smb.omada.common.g.b.d, null);
        }
        ArrayList<Integer> vlanIds = new ArrayList<Integer>();
        String[] splitStrings = vlans.split(",");
        if (splitStrings.length == 0) {
            return new OperationResponse(com.tplink.smb.omada.common.g.b.d, null);
        }
        if (splitStrings.length == 1 && splitStrings[0].matches("[\\d]+")) {
            if (!o.e(splitStrings[0])) {
                return new OperationResponse(com.tplink.smb.omada.common.g.b.nD, null);
            }
            Integer vlanNum = Integer.valueOf(splitStrings[0]);
            vlanIds.add(vlanNum);
            return new OperationResponse(com.tplink.smb.omada.common.g.b.a, vlanIds);
        }
        for (String splitString : splitStrings) {
            if (!o.e(splitString)) {
                return new OperationResponse(com.tplink.smb.omada.common.g.b.nD, null);
            }
            OperationResponse operationResponse = o.a(splitString, vlanIds);
            if (operationResponse.success()) continue;
            return operationResponse;
        }
        if (vlanIds.size() == 0) {
            return new OperationResponse(com.tplink.smb.omada.common.g.b.d, null);
        }
        return new OperationResponse(com.tplink.smb.omada.common.g.b.a, vlanIds);
    }

    private static boolean e(String vlanString) {
        if (vlanString.matches("[\\d]+")) {
            int vlanNum = Integer.parseInt(vlanString);
            if (vlanNum < 1 || vlanNum > 4094) {
                a.warn("ssid vlan should be between 1 and 4094");
                return false;
            }
        } else if (vlanString.matches("^\\d+-\\d+$")) {
            String[] strings = vlanString.split("-");
            if (strings.length != 2) {
                a.warn("vlan should be like begin-end instead of {}", (Object)vlanString);
                return false;
            }
            int begin = Integer.parseInt(strings[0]);
            if (begin < 1 || begin > 4094) {
                a.warn("ssid begin vlan should be between 1 and 4094");
                return false;
            }
            int end = Integer.parseInt(strings[1]);
            if (end < 1 || end > 4094) {
                a.warn("ssid end vlan should be between 1 and 4094");
                return false;
            }
        } else {
            a.warn("vlanSplitString should be like 1 or 1-100");
            return false;
        }
        return true;
    }

    private static OperationResponse a(String splitString, List<Integer> vlanIds) {
        if (splitString.matches("[\\d]+")) {
            Integer vlanNum = Integer.valueOf(splitString);
            if (vlanIds.contains(vlanNum)) {
                return new OperationResponse(com.tplink.smb.omada.common.g.b.gw);
            }
            vlanIds.add(vlanNum);
        } else {
            String[] strings = splitString.split("-");
            int begin = Integer.parseInt(strings[0]);
            int end = Integer.parseInt(strings[1]);
            if (end < begin) {
                int temp = end;
                end = begin;
                begin = temp;
            }
            for (int i2 = begin; i2 <= end; ++i2) {
                if (vlanIds.contains(i2)) {
                    return new OperationResponse(com.tplink.smb.omada.common.g.b.gw);
                }
                vlanIds.add(i2);
            }
        }
        return OperationResponse.SUCCESS;
    }

    public static void a(SsidC ssidC, c ap2) {
        boolean needAdjust;
        boolean supportMlo2And5;
        boolean bl2 = supportMlo2And5 = ap2.dj().checkSupportMlo(0) && ap2.dj().checkSupportMlo(1);
        if (!supportMlo2And5) {
            return;
        }
        boolean bl3 = needAdjust = (Objects.equals(ssidC.getMlo(), v.a(com.tplink.smb.omada.manager.common.constants.v.c)) || Objects.equals(ssidC.getMlo(), v.a(com.tplink.smb.omada.manager.common.constants.v.g))) && Objects.equals(ssidC.getSecurityMode(), 0);
        if (needAdjust) {
            ssidC.setSecurityMode(Integer.valueOf(9));
        }
    }
}

