/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.device.port.common.util;

import com.google.common.collect.Sets;
import com.tplink.smb.omada.common.access.OperationResponse;
import com.tplink.smb.omada.common.g.b;
import com.tplink.smb.omada.manager.configuration.domain.model.site.component.g;
import com.tplink.smb.omada.manager.configuration.domain.model.site.wired.lannetwork.BaseLanNetwork;
import com.tplink.smb.omada.manager.configuration.domain.model.site.wired.lannetwork.F;
import com.tplink.smb.omada.manager.configuration.domain.model.site.wireless.ssid.m;
import com.tplink.smb.omada.manager.device.domain.model.device.osw.aA;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public abstract class n {
    @Generated
    private static final Logger b = LoggerFactory.getLogger(n.class);
    private static final int c = 1;
    private static final int d = 4094;
    public static final String a = "_";

    private n() {
    }

    public static boolean a(String[] clientVlan) {
        if (clientVlan.length == 0) {
            return false;
        }
        for (String vlanString : clientVlan) {
            if (n.b(vlanString)) continue;
            return false;
        }
        return true;
    }

    public static boolean b(String[] serviceVlan) {
        if (serviceVlan.length == 0) {
            return false;
        }
        if (serviceVlan.length == 1 && serviceVlan[0].matches("[\\d]+")) {
            return n.b(serviceVlan[0]);
        }
        return false;
    }

    public static List<Map.Entry<String, List<Integer>>> a(m vlanSetting) {
        Map<String, List<Integer>> lanNetworkIdVlanIds = vlanSetting.f();
        ArrayList<Map.Entry<String, List<Integer>>> lanNetworkIdVlanIdsList = new ArrayList<Map.Entry<String, List<Integer>>>(lanNetworkIdVlanIds.entrySet());
        lanNetworkIdVlanIdsList.sort((o1, o2) -> {
            Integer i1 = (Integer)((List)o1.getValue()).get(0);
            Integer i2 = (Integer)((List)o2.getValue()).get(0);
            return i1 - i2;
        });
        return lanNetworkIdVlanIdsList;
    }

    public static List<Integer> a(String vlanPoolIds) {
        String[] splitStrings;
        ArrayList<Integer> vlanPoolIdList = new ArrayList<Integer>();
        for (String splitString : splitStrings = vlanPoolIds.split(",")) {
            if (splitString.matches("[\\d]+")) {
                Integer vlanNum = Integer.valueOf(splitString);
                vlanPoolIdList.add(vlanNum);
                continue;
            }
            String[] strings = splitString.split("-");
            int begin = Integer.parseInt(strings[0]);
            int end = Integer.parseInt(strings[1]);
            if (end < begin) {
                int temp = end;
                end = begin;
                begin = temp;
            }
            for (int i2 = begin; i2 <= end; ++i2) {
                vlanPoolIdList.add(i2);
            }
        }
        Collections.sort(vlanPoolIdList);
        return vlanPoolIdList;
    }

    public static boolean b(String vlanString) {
        if (vlanString.matches("[\\d]+")) {
            int vlanNum = Integer.parseInt(vlanString);
            if (vlanNum < 1 || vlanNum > 4094) {
                b.warn("vlan should be between 1 and 4094");
                return false;
            }
        } else if (vlanString.matches("^\\d+-\\d+$")) {
            String[] strings = vlanString.split("-");
            if (strings.length != 2) {
                b.warn("vlan should be like begin-end instead of {}", (Object)vlanString);
                return false;
            }
            int begin = Integer.parseInt(strings[0]);
            if (begin < 1 || begin > 4094) {
                b.warn("begin vlan should be between 1 and 4094");
                return false;
            }
            int end = Integer.parseInt(strings[1]);
            if (end < 1 || end > 4094) {
                b.warn("end vlan should be between 1 and 4094");
                return false;
            }
        } else {
            b.warn("vlanSplitString should be like 1 or 1-100");
            return false;
        }
        return true;
    }

    public static Map<String, Integer> c(String networkIdWithVlan) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        if (networkIdWithVlan != null && networkIdWithVlan.contains(a)) {
            String[] splits = networkIdWithVlan.split(a);
            map.put(splits[0], Integer.parseInt(splits[1]));
        }
        return map;
    }

    public static Map<String, Set<Integer>> a(List<String> networkIdsWithVlan) {
        if (networkIdsWithVlan == null || CollectionUtils.isEmpty(networkIdsWithVlan)) {
            return new HashMap<String, Set<Integer>>();
        }
        HashMap<String, Set<Integer>> bridgeVlanMap = new HashMap<String, Set<Integer>>(networkIdsWithVlan.size());
        networkIdsWithVlan.removeIf(netId -> {
            if (netId.contains(a)) {
                String[] splits = netId.split(a);
                n.a(splits, (Map<String, Set<Integer>>)bridgeVlanMap);
                return true;
            }
            return false;
        });
        networkIdsWithVlan.addAll(bridgeVlanMap.keySet());
        return bridgeVlanMap;
    }

    public static void a(String[] splits, Map<String, Set<Integer>> bridgeVlanMap) {
        Integer vlan = Integer.parseInt(splits[1]);
        if (null == bridgeVlanMap.computeIfPresent(splits[0], (netId, vlans) -> {
            vlans.add(vlan);
            return vlans;
        })) {
            bridgeVlanMap.put(splits[0], Sets.newHashSet((Object[])new Integer[]{vlan}));
        }
    }

    @Nullable
    public static String a(F lanNetworkId, Integer bridgeVlan) {
        if (lanNetworkId == null) {
            return null;
        }
        if (bridgeVlan == null) {
            return lanNetworkId.b();
        }
        return lanNetworkId.b() + a + bridgeVlan;
    }

    public static List<String> a(List<F> lanNetworkIdList, Map<String, Set<Integer>> bridgeVlanMap) {
        if (CollectionUtils.isEmpty(lanNetworkIdList)) {
            return new ArrayList<String>();
        }
        if (CollectionUtils.isEmpty(bridgeVlanMap)) {
            return lanNetworkIdList.stream().map(g::b).collect(Collectors.toList());
        }
        ArrayList<String> networkIdStrList = new ArrayList<String>();
        for (F lanNetworkId : lanNetworkIdList) {
            if (lanNetworkId == null) continue;
            Set bridgeVlanSet = Optional.ofNullable(bridgeVlanMap.get(lanNetworkId.b())).orElse(new HashSet());
            if (!CollectionUtils.isEmpty((Collection)bridgeVlanSet)) {
                for (Integer vlan : bridgeVlanMap.get(lanNetworkId.b())) {
                    networkIdStrList.add(lanNetworkId.b() + a + vlan);
                }
                continue;
            }
            networkIdStrList.add(lanNetworkId.b());
        }
        return networkIdStrList;
    }

    public static Set<String> b(List<F> lanNetworkIdList, Map<String, Set<Integer>> bridgeVlanMap) {
        if (CollectionUtils.isEmpty(lanNetworkIdList)) {
            return new HashSet<String>();
        }
        return new HashSet<String>(n.a(lanNetworkIdList, bridgeVlanMap));
    }

    public static OperationResponse<Integer> a(@Nonnull String lanNetworkId, Integer mvlanBridgeVlan, @Nonnull Map<String, BaseLanNetwork> idLanNetworkMap) {
        BaseLanNetwork lanNetwork = idLanNetworkMap.get(lanNetworkId);
        if (Objects.isNull(lanNetwork)) {
            return new OperationResponse(com.tplink.smb.omada.common.g.b.DD);
        }
        if (lanNetwork.isMultiVlans()) {
            if (mvlanBridgeVlan != null) {
                return OperationResponse.success((Object)mvlanBridgeVlan);
            }
            return new OperationResponse(com.tplink.smb.omada.common.g.b.DD);
        }
        return OperationResponse.success((Object)lanNetwork.getVlan());
    }

    @Nullable
    public static Integer a(@Nonnull aA mvlanSetting, @Nonnull Map<String, BaseLanNetwork> idLanNetworkMap) {
        Integer mvlanBridgeVlan;
        if (mvlanSetting == null || mvlanSetting.b() == null || CollectionUtils.isEmpty(idLanNetworkMap)) {
            return null;
        }
        String lanNetworkId = mvlanSetting.b().b();
        OperationResponse<Integer> getMvlanResp = n.a(lanNetworkId, mvlanBridgeVlan = mvlanSetting.c(), idLanNetworkMap);
        if (!getMvlanResp.success()) {
            return null;
        }
        return (Integer)getMvlanResp.getResult();
    }

    public static Map<Integer, BaseLanNetwork> a(Map<Integer, BaseLanNetwork> beforeUsedVlanMap, Map<Integer, BaseLanNetwork> afterUsedVlanMap) {
        HashMap<Integer, BaseLanNetwork> differentMap = new HashMap<Integer, BaseLanNetwork>();
        Sets.SetView differentVlanSet = Sets.difference(beforeUsedVlanMap.keySet(), afterUsedVlanMap.keySet());
        for (Integer vlan : differentVlanSet) {
            differentMap.put(vlan, beforeUsedVlanMap.get(vlan));
        }
        return differentMap;
    }

    public static Map<Integer, BaseLanNetwork> b(Map<Integer, BaseLanNetwork> beforeUsedVlanMap, Map<Integer, BaseLanNetwork> afterUsedVlanMap) {
        HashMap<Integer, BaseLanNetwork> differentMap = new HashMap<Integer, BaseLanNetwork>();
        Sets.SetView intersectionVlanSet = Sets.intersection(beforeUsedVlanMap.keySet(), afterUsedVlanMap.keySet());
        for (Integer vlan : intersectionVlanSet) {
            differentMap.put(vlan, afterUsedVlanMap.get(vlan));
        }
        return differentMap;
    }

    public static String b(List<Integer> vlanIds) {
        if (CollectionUtils.isEmpty(vlanIds)) {
            return null;
        }
        TreeSet<Integer> sorted = new TreeSet<Integer>(vlanIds);
        StringBuilder sb = new StringBuilder();
        Integer rangeStart = null;
        Integer prev = null;
        for (Integer vlan : sorted) {
            if (rangeStart == null) {
                rangeStart = vlan;
                prev = vlan;
                continue;
            }
            if (vlan == prev + 1) {
                prev = vlan;
                continue;
            }
            n.a(sb, (int)rangeStart, prev);
            rangeStart = vlan;
            prev = vlan;
        }
        n.a(sb, (int)rangeStart, prev);
        return sb.toString();
    }

    private static void a(StringBuilder sb, int start, int end) {
        if (sb.length() > 0) {
            sb.append(",");
        }
        if (start == end) {
            sb.append(start);
        } else {
            sb.append(start).append("-").append(end);
        }
    }
}

