/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.device.port.cache.reboot;

import com.tplink.smb.component.cache.api.CacheService;
import com.tplink.smb.device.firmware.upgrade.common.dto.device.DeviceHolder;
import com.tplink.smb.omada.manager.c.b.Q;
import com.tplink.smb.omada.manager.c.b.R;
import com.tplink.smb.omada.manager.c.b.bZ;
import com.tplink.smb.omada.manager.device.domain.model.deviceimage.l;
import com.tplink.smb.omada.manager.device.port.cache.reboot.po.DeviceRebootIdPO;
import com.tplink.smb.omada.manager.device.port.cache.reboot.po.DeviceRebootStatusPO;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class a
implements com.tplink.smb.omada.manager.device.domain.model.k.a.a {
    @Generated
    private static final Logger a = LoggerFactory.getLogger(a.class);
    private static final int b = 10;
    @Autowired
    private CacheService c;
    @Autowired
    private l d;

    @Override
    public void a(DeviceHolder deviceHolder, String username, String userRole) {
        DeviceRebootStatusPO rebootStatusPO = new DeviceRebootStatusPO();
        rebootStatusPO.setDeviceKey(deviceHolder.getDeviceMac());
        rebootStatusPO.setDpmsId(deviceHolder.getSysId());
        rebootStatusPO.setStatus(Q.a);
        rebootStatusPO.setLastActive(System.currentTimeMillis());
        rebootStatusPO.setUsername(username);
        rebootStatusPO.setUserRole(userRole);
        this.a(deviceHolder, rebootStatusPO);
    }

    @Override
    public void a(DeviceHolder deviceHolder, Q status) {
        DeviceRebootStatusPO rebootStatusPO = this.j(deviceHolder);
        if (Objects.isNull(rebootStatusPO)) {
            rebootStatusPO = ((DeviceRebootStatusPO.DeviceRebootStatusPOBuilder)((DeviceRebootStatusPO.DeviceRebootStatusPOBuilder)((DeviceRebootStatusPO.DeviceRebootStatusPOBuilder)((DeviceRebootStatusPO.DeviceRebootStatusPOBuilder)DeviceRebootStatusPO.builder().deviceKey(deviceHolder.getDeviceMac())).dpmsId(deviceHolder.getSysId())).status(status)).lastActive(System.currentTimeMillis())).build();
        } else {
            rebootStatusPO.setLastActive(System.currentTimeMillis());
            rebootStatusPO.setStatus(status);
        }
        if (Q.c.equals((Object)status) || Q.d.equals((Object)status)) {
            rebootStatusPO.setRebootFinishedTime(System.currentTimeMillis());
        }
        this.a(deviceHolder, rebootStatusPO);
    }

    @Override
    public void a(DeviceHolder deviceHolder, Q status, int estimateTime, R rebootType) {
        long currentTime = System.currentTimeMillis();
        DeviceRebootStatusPO rebootStatusPO = this.j(deviceHolder);
        if (Objects.isNull(rebootStatusPO)) {
            rebootStatusPO = ((DeviceRebootStatusPO.DeviceRebootStatusPOBuilder)((DeviceRebootStatusPO.DeviceRebootStatusPOBuilder)((DeviceRebootStatusPO.DeviceRebootStatusPOBuilder)((DeviceRebootStatusPO.DeviceRebootStatusPOBuilder)((DeviceRebootStatusPO.DeviceRebootStatusPOBuilder)((DeviceRebootStatusPO.DeviceRebootStatusPOBuilder)DeviceRebootStatusPO.builder().deviceKey(deviceHolder.getDeviceMac())).dpmsId(deviceHolder.getSysId())).status(status)).rebootType(rebootType)).estimateTime(estimateTime)).lastActive(currentTime)).build();
        } else {
            rebootStatusPO.setStatus(status);
            rebootStatusPO.setEstimateTime(estimateTime);
            rebootStatusPO.setRebootType(rebootType);
            rebootStatusPO.setLastActive(currentTime);
        }
        if (Q.b.equals((Object)status)) {
            rebootStatusPO.setRebootStartTime(currentTime);
        }
        this.a(deviceHolder, rebootStatusPO);
    }

    private void a(DeviceHolder deviceHolder, DeviceRebootStatusPO rebootStatusPO) {
        this.c.putHashValue("device.manager:device.reboot", "status", deviceHolder.toJson(), (Object)rebootStatusPO);
    }

    @Override
    public List<DeviceHolder> a(String rebootId) {
        DeviceRebootIdPO rebootIdPO = (DeviceRebootIdPO)this.c.getHashValue("device.manager:device.reboot", "idList", rebootId, DeviceRebootIdPO.class);
        if (Objects.isNull(rebootIdPO)) {
            return Collections.emptyList();
        }
        return rebootIdPO.getDeviceList();
    }

    @Override
    public void a(String rebootId, List<DeviceHolder> deviceList, String username, boolean batchReboot) {
        Object rebootIdPO = ((DeviceRebootIdPO.DeviceRebootIdPOBuilder)((DeviceRebootIdPO.DeviceRebootIdPOBuilder)((DeviceRebootIdPO.DeviceRebootIdPOBuilder)((DeviceRebootIdPO.DeviceRebootIdPOBuilder)DeviceRebootIdPO.builder().rebootId(rebootId)).username(username)).deviceList(deviceList)).batchReboot(batchReboot)).build();
        this.c.putHashValue("device.manager:device.reboot", "idList", rebootId, rebootIdPO);
    }

    private DeviceRebootStatusPO j(DeviceHolder deviceHolder) {
        return (DeviceRebootStatusPO)this.c.getHashValue("device.manager:device.reboot", "status", deviceHolder.toJson(), DeviceRebootStatusPO.class);
    }

    @Override
    public R a(DeviceHolder deviceHolder) {
        R rebootType;
        DeviceRebootStatusPO rebootStatusPO = this.j(deviceHolder);
        if (Objects.nonNull(rebootStatusPO) && Objects.nonNull(rebootType = rebootStatusPO.getRebootType())) {
            return rebootType;
        }
        return R.f;
    }

    @Override
    public Q b(DeviceHolder deviceHolder) {
        DeviceRebootStatusPO rebootStatusPO = this.j(deviceHolder);
        if (Objects.nonNull(rebootStatusPO)) {
            return rebootStatusPO.getStatus();
        }
        return null;
    }

    @Override
    public String c(DeviceHolder deviceHolder) {
        String username;
        DeviceRebootStatusPO rebootStatusPO = this.j(deviceHolder);
        if (Objects.nonNull(rebootStatusPO) && Objects.nonNull(username = rebootStatusPO.getUsername())) {
            return username;
        }
        return "";
    }

    @Override
    public String d(DeviceHolder deviceHolder) {
        String userRole;
        DeviceRebootStatusPO rebootStatusPO = this.j(deviceHolder);
        if (Objects.nonNull(rebootStatusPO) && Objects.nonNull(userRole = rebootStatusPO.getUserRole())) {
            return userRole;
        }
        return "";
    }

    @Override
    public int e(DeviceHolder deviceHolder) {
        Integer estimateTime;
        DeviceRebootStatusPO rebootStatusPO = this.j(deviceHolder);
        if (Objects.nonNull(rebootStatusPO) && Objects.nonNull(estimateTime = rebootStatusPO.getEstimateTime())) {
            return estimateTime;
        }
        return 0;
    }

    @Override
    public long f(DeviceHolder deviceHolder) {
        Long rebootStartTime;
        DeviceRebootStatusPO rebootStatusPO = this.j(deviceHolder);
        if (Objects.nonNull(rebootStatusPO) && Objects.nonNull(rebootStartTime = rebootStatusPO.getRebootStartTime())) {
            return rebootStartTime;
        }
        return System.currentTimeMillis();
    }

    @Override
    public long g(DeviceHolder deviceHolder) {
        Long rebootFinishedTime;
        DeviceRebootStatusPO rebootStatusPO = this.j(deviceHolder);
        if (Objects.nonNull(rebootStatusPO) && Objects.nonNull(rebootFinishedTime = rebootStatusPO.getRebootFinishedTime())) {
            return rebootFinishedTime;
        }
        return System.currentTimeMillis();
    }

    @Override
    public void a(DeviceHolder deviceHolder, int estimateTime) {
        a.debug("REBOOT THE DEVICE: {}", (Object)deviceHolder.toJson());
        long longestWaitingTime = (long)estimateTime * 2L + 25L;
        long expiredTime = System.currentTimeMillis() + TimeUnit.MILLISECONDS.convert(longestWaitingTime, TimeUnit.SECONDS);
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        a.debug("DEVICE {} WILL EXPIRE IN {}", (Object)deviceHolder.toJson(), (Object)dateFormat.format(expiredTime));
        this.c.addSortedSetValue("device.manager:device.reboot", "monitor", (Object)deviceHolder.toJson(), (double)expiredTime);
    }

    @Override
    public void h(DeviceHolder deviceHolder) {
        this.c.removeSortedSetValue("device.manager:device.reboot", "monitor", (Object)deviceHolder.toJson());
    }

    @Override
    public List<String> a() {
        double filterMin = 0.0;
        double filterMax = System.currentTimeMillis();
        Collection rebootTimeoutCollection = this.c.pollFirst("device.manager:device.reboot", "monitor", 10, filterMin, filterMax, String.class);
        return new ArrayList<String>(rebootTimeoutCollection);
    }

    @Override
    public void b(String deviceKey) {
        this.c.putHashValue("device.manager:device.reboot", "reset", deviceKey, (Object)System.currentTimeMillis());
    }

    @Override
    public boolean c(String deviceKey) {
        Object existed = this.c.getHashValue("device.manager:device.reboot", "reset", deviceKey, Object.class);
        return Objects.nonNull(existed);
    }

    private void e(String deviceKey) {
        this.c.deleteHashValue("device.manager:device.reboot", "reset", deviceKey);
        this.c.deleteHashValue("device.manager:device.reboot", "status", DeviceHolder.create((String)deviceKey, (String)"").toJson());
    }

    @Override
    public void i(DeviceHolder deviceHolder) {
        this.e(deviceHolder.getDeviceMac());
        this.c.deleteHashValue("device.manager:device.reboot", "status", deviceHolder.toJson());
    }

    @Override
    public void b() {
        Map rebootIdPOMap = this.c.getHash("device.manager:device.reboot", "idList", DeviceRebootIdPO.class);
        for (Map.Entry entry : rebootIdPOMap.entrySet()) {
            String rebootId = (String)entry.getKey();
            DeviceRebootIdPO rebootIdPO = (DeviceRebootIdPO)entry.getValue();
            if (Objects.isNull(rebootIdPO.getFinishedTimestamp())) {
                this.a(rebootId, rebootIdPO);
                continue;
            }
            this.b(rebootId, rebootIdPO);
        }
    }

    private void a(String rebootId, DeviceRebootIdPO rebootIdPO) {
        List<DeviceHolder> deviceHolderList = rebootIdPO.getDeviceList();
        int rebootingDeviceCount = deviceHolderList.size();
        for (DeviceHolder deviceHolder : deviceHolderList) {
            if (!this.k(deviceHolder)) continue;
            --rebootingDeviceCount;
        }
        if (rebootingDeviceCount == 0) {
            this.c(rebootId, rebootIdPO);
            if (rebootIdPO.getBatchReboot().booleanValue()) {
                long currentTime = System.currentTimeMillis();
                this.c.addSortedSetValue("device.manager:device.reboot", "userBatch:" + rebootIdPO.getUsername(), (Object)rebootId, (double)currentTime);
            }
        }
    }

    private void b(String rebootId, DeviceRebootIdPO rebootIdPO) {
        long rebootIdFinishedTime = rebootIdPO.getFinishedTimestamp();
        long timeLapse = System.currentTimeMillis() - rebootIdFinishedTime;
        if (timeLapse > bZ.i) {
            this.c.deleteHashValue("device.manager:device.reboot", "idList", rebootId);
            this.c.removeSortedSetValue("device.manager:device.reboot", "userBatch:" + rebootIdPO.getUsername(), (Object)rebootId);
        }
    }

    @Override
    public List<String> d(String username) {
        String key = "userBatch:" + username;
        double minVal = 0.0;
        double maxVal = System.currentTimeMillis();
        Collection finishedRebootIdsCollection = this.c.pollSortedByScore("device.manager:device.reboot", key, minVal, maxVal, String.class);
        return new ArrayList<String>(finishedRebootIdsCollection);
    }

    @Override
    public void c() {
        Map statuses = this.c.getHash("device.manager:device.reboot", "status", DeviceRebootStatusPO.class);
        for (Map.Entry entry : statuses.entrySet()) {
            String deviceHolderJson = (String)entry.getKey();
            DeviceRebootStatusPO deviceRebootStatusPO = (DeviceRebootStatusPO)entry.getValue();
            long currentTime = System.currentTimeMillis();
            if (Objects.isNull(deviceRebootStatusPO.getRebootFinishedTime()) || currentTime - deviceRebootStatusPO.getRebootFinishedTime() <= bZ.i) continue;
            this.c.deleteHashValue("device.manager:device.reboot", "status", deviceHolderJson);
        }
    }

    private synchronized void c(String rebootId, DeviceRebootIdPO rebootIdPO) {
        rebootIdPO.setFinishedTimestamp(System.currentTimeMillis());
        this.c.putHashValue("device.manager:device.reboot", "idList", rebootId, (Object)rebootIdPO);
    }

    private boolean k(DeviceHolder deviceHolder) {
        Q statusType = this.b(deviceHolder);
        if (Objects.isNull(statusType)) {
            return true;
        }
        return statusType.equals((Object)Q.c) || statusType.equals((Object)Q.d);
    }
}

