/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.device.port.cache.device;

import com.tplink.smb.omada.device.manage.message.EcspFirstVersionEnum;
import com.tplink.smb.omada.manager.c.B;
import com.tplink.smb.omada.manager.device.domain.model.deviceimage.ComponentInfo;
import jakarta.annotation.Nonnull;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.util.CollectionUtils;

public class ComponentInfoImagePO {
    private Map<String, Integer> realComponents;
    private Map<String, ComponentVersionInfoPO> realComponentsV2;
    private Map<String, List<Integer>> notSupportComponents;
    private Map<String, ComponentCapInfoPO> componentCapInfo;
    private Integer version;

    public ComponentInfoImagePO(Map<String, Integer> realComponents, Map<String, ComponentInfo.b> realComponentsV2, Map<String, List<Integer>> notSupportComponents, Map<String, ComponentInfo.a> componentCapInfo, @Nonnull Integer version) {
        this.realComponents = realComponents;
        if (!CollectionUtils.isEmpty(realComponentsV2)) {
            this.realComponentsV2 = realComponentsV2.entrySet().stream().filter(entry -> entry.getValue() != null).collect(Collectors.toMap(Map.Entry::getKey, ComponentInfoImagePO::apply));
        }
        this.notSupportComponents = notSupportComponents;
        if (!CollectionUtils.isEmpty(componentCapInfo)) {
            this.componentCapInfo = componentCapInfo.entrySet().stream().filter(entry -> entry.getValue() != null).collect(Collectors.toMap(Map.Entry::getKey, ComponentInfoImagePO::applyCapInfo));
        }
        this.version = version;
    }

    public static ComponentInfoImagePO toImagePO(ComponentInfo componentInfo) {
        if (componentInfo == null) {
            return null;
        }
        return new ComponentInfoImagePO(componentInfo.getRealComponents(), componentInfo.getRealComponentsV2(), componentInfo.getNotSupportComponents(), componentInfo.getComponentCapInfo(), componentInfo.getVersion().getVersion());
    }

    public static ComponentInfo fromImagePO(ComponentInfoImagePO po) {
        if (po == null) {
            return null;
        }
        Map<String, ComponentInfo.b> realV2 = Collections.emptyMap();
        if (!CollectionUtils.isEmpty(po.getRealComponentsV2())) {
            realV2 = po.getRealComponentsV2().entrySet().stream().filter(entry -> entry.getValue() != null).collect(Collectors.toMap(Map.Entry::getKey, entry -> new ComponentInfo.b(((ComponentVersionInfoPO)entry.getValue()).version, ((ComponentVersionInfoPO)entry.getValue()).functionVersion)));
        }
        Map<String, Integer> realV1 = Collections.emptyMap();
        if (!CollectionUtils.isEmpty(po.getRealComponents())) {
            realV1 = new HashMap<String, Integer>(po.getRealComponents());
        }
        Map<String, ComponentInfo.a> componentCapInfo = Collections.emptyMap();
        if (!CollectionUtils.isEmpty(po.getComponentCapInfo())) {
            componentCapInfo = po.getComponentCapInfo().entrySet().stream().filter(entry -> entry.getValue() != null).collect(Collectors.toMap(Map.Entry::getKey, entry -> {
                if (CollectionUtils.isEmpty(((ComponentCapInfoPO)entry.getValue()).getUnsupportCapKeys())) {
                    if (((ComponentCapInfoPO)entry.getValue()).getUnsupportCaps() == null) {
                        return new ComponentInfo.a(new ArrayList<B>(), ((ComponentCapInfoPO)entry.getValue()).getEntryLimit());
                    }
                    return new ComponentInfo.a(((ComponentCapInfoPO)entry.getValue()).getUnsupportCaps().stream().map(cap -> new B(null, cap)).collect(Collectors.toList()), ((ComponentCapInfoPO)entry.getValue()).getEntryLimit());
                }
                return new ComponentInfo.a(((ComponentCapInfoPO)entry.getValue()).getUnsupportCapKeys(), ((ComponentCapInfoPO)entry.getValue()).getEntryLimit());
            }));
        }
        return new ComponentInfo(realV1, realV2, po.getNotSupportComponents(), componentCapInfo, EcspFirstVersionEnum.resolve((int)po.version));
    }

    private static ComponentVersionInfoPO apply(Map.Entry<String, ComponentInfo.b> entry) {
        return new ComponentVersionInfoPO(entry.getValue().c(), entry.getValue().d());
    }

    private static ComponentCapInfoPO applyCapInfo(Map.Entry<String, ComponentInfo.a> entry) {
        return new ComponentCapInfoPO(null, entry.getValue().c(), entry.getValue().b());
    }

    @Generated
    public Map<String, Integer> getRealComponents() {
        return this.realComponents;
    }

    @Generated
    public Map<String, ComponentVersionInfoPO> getRealComponentsV2() {
        return this.realComponentsV2;
    }

    @Generated
    public Map<String, List<Integer>> getNotSupportComponents() {
        return this.notSupportComponents;
    }

    @Generated
    public Map<String, ComponentCapInfoPO> getComponentCapInfo() {
        return this.componentCapInfo;
    }

    @Generated
    public Integer getVersion() {
        return this.version;
    }

    @Generated
    public void setRealComponents(Map<String, Integer> realComponents) {
        this.realComponents = realComponents;
    }

    @Generated
    public void setRealComponentsV2(Map<String, ComponentVersionInfoPO> realComponentsV2) {
        this.realComponentsV2 = realComponentsV2;
    }

    @Generated
    public void setNotSupportComponents(Map<String, List<Integer>> notSupportComponents) {
        this.notSupportComponents = notSupportComponents;
    }

    @Generated
    public void setComponentCapInfo(Map<String, ComponentCapInfoPO> componentCapInfo) {
        this.componentCapInfo = componentCapInfo;
    }

    @Generated
    public void setVersion(Integer version) {
        this.version = version;
    }

    @Generated
    public ComponentInfoImagePO() {
    }

    public static class ComponentVersionInfoPO {
        private Integer version;
        private Integer functionVersion;

        public static ComponentVersionInfoPO buildErrorComponent() {
            return new ComponentVersionInfoPO(-1, -1);
        }

        public boolean isError() {
            return this.version == -1 || this.functionVersion == -1;
        }

        @Generated
        public Integer getVersion() {
            return this.version;
        }

        @Generated
        public Integer getFunctionVersion() {
            return this.functionVersion;
        }

        @Generated
        public boolean equals(Object o2) {
            if (o2 == this) {
                return true;
            }
            if (!(o2 instanceof ComponentVersionInfoPO)) {
                return false;
            }
            ComponentVersionInfoPO other = (ComponentVersionInfoPO)o2;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$version = this.getVersion();
            Integer other$version = other.getVersion();
            if (this$version == null ? other$version != null : !((Object)this$version).equals(other$version)) {
                return false;
            }
            Integer this$functionVersion = this.getFunctionVersion();
            Integer other$functionVersion = other.getFunctionVersion();
            return !(this$functionVersion == null ? other$functionVersion != null : !((Object)this$functionVersion).equals(other$functionVersion));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ComponentVersionInfoPO;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $version = this.getVersion();
            result = result * 59 + ($version == null ? 43 : ((Object)$version).hashCode());
            Integer $functionVersion = this.getFunctionVersion();
            result = result * 59 + ($functionVersion == null ? 43 : ((Object)$functionVersion).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "ComponentInfoImagePO.ComponentVersionInfoPO(version=" + this.getVersion() + ", functionVersion=" + this.getFunctionVersion() + ")";
        }

        @Generated
        public ComponentVersionInfoPO(Integer version, Integer functionVersion) {
            this.version = version;
            this.functionVersion = functionVersion;
        }

        @Generated
        public ComponentVersionInfoPO() {
        }
    }

    public static class ComponentCapInfoPO {
        private List<String> unsupportCaps;
        private Integer entryLimit;
        private List<B> unsupportCapKeys;

        public ComponentCapInfoPO(List<String> unsupportCaps, Integer entryLimit) {
            this.unsupportCaps = unsupportCaps;
            this.entryLimit = entryLimit;
        }

        @Generated
        public List<String> getUnsupportCaps() {
            return this.unsupportCaps;
        }

        @Generated
        public Integer getEntryLimit() {
            return this.entryLimit;
        }

        @Generated
        public List<B> getUnsupportCapKeys() {
            return this.unsupportCapKeys;
        }

        @Generated
        public boolean equals(Object o2) {
            if (o2 == this) {
                return true;
            }
            if (!(o2 instanceof ComponentCapInfoPO)) {
                return false;
            }
            ComponentCapInfoPO other = (ComponentCapInfoPO)o2;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$entryLimit = this.getEntryLimit();
            Integer other$entryLimit = other.getEntryLimit();
            if (this$entryLimit == null ? other$entryLimit != null : !((Object)this$entryLimit).equals(other$entryLimit)) {
                return false;
            }
            List<String> this$unsupportCaps = this.getUnsupportCaps();
            List<String> other$unsupportCaps = other.getUnsupportCaps();
            if (this$unsupportCaps == null ? other$unsupportCaps != null : !((Object)this$unsupportCaps).equals(other$unsupportCaps)) {
                return false;
            }
            List<B> this$unsupportCapKeys = this.getUnsupportCapKeys();
            List<B> other$unsupportCapKeys = other.getUnsupportCapKeys();
            return !(this$unsupportCapKeys == null ? other$unsupportCapKeys != null : !((Object)this$unsupportCapKeys).equals(other$unsupportCapKeys));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ComponentCapInfoPO;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $entryLimit = this.getEntryLimit();
            result = result * 59 + ($entryLimit == null ? 43 : ((Object)$entryLimit).hashCode());
            List<String> $unsupportCaps = this.getUnsupportCaps();
            result = result * 59 + ($unsupportCaps == null ? 43 : ((Object)$unsupportCaps).hashCode());
            List<B> $unsupportCapKeys = this.getUnsupportCapKeys();
            result = result * 59 + ($unsupportCapKeys == null ? 43 : ((Object)$unsupportCapKeys).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "ComponentInfoImagePO.ComponentCapInfoPO(unsupportCaps=" + this.getUnsupportCaps() + ", entryLimit=" + this.getEntryLimit() + ", unsupportCapKeys=" + this.getUnsupportCapKeys() + ")";
        }

        @Generated
        public ComponentCapInfoPO() {
        }

        @Generated
        public ComponentCapInfoPO(List<String> unsupportCaps, Integer entryLimit, List<B> unsupportCapKeys) {
            this.unsupportCaps = unsupportCaps;
            this.entryLimit = entryLimit;
            this.unsupportCapKeys = unsupportCapKeys;
        }
    }
}

