/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.device.domain.model.upgrade.cloud;

import com.google.common.collect.Lists;
import com.tplink.smb.component.upgradefilecache.api.DownloadCallback;
import com.tplink.smb.component.upgradefilecache.api.DownloadResponse;
import com.tplink.smb.component.upgradefilecache.api.UpgradeFileCacheCommonService;
import com.tplink.smb.omada.common.access.OperationResponse;
import com.tplink.smb.omada.common.constant.DeviceStatusEnum;
import com.tplink.smb.omada.common.constant.DeviceTypeEnum;
import com.tplink.smb.omada.common.constant.d;
import com.tplink.smb.omada.common.constant.x;
import com.tplink.smb.omada.common.omadac.OmadacType;
import com.tplink.smb.omada.common.util.T;
import com.tplink.smb.omada.identityaccess.api.internal.dto.NoticeUserDevicesUpgradeDTO;
import com.tplink.smb.omada.identityaccess.api.internal.dto.UserSiteBriefDTO;
import com.tplink.smb.omada.logmanager.api.internal.dto.OmadaLogDTO;
import com.tplink.smb.omada.logmanager.api.internal.dto.OmadaLogKeyEnumDTO;
import com.tplink.smb.omada.logmanager.api.internal.dto.audit.AuditLogKeyEnumDTO;
import com.tplink.smb.omada.manager.common.audit.AuditLogUserDTO;
import com.tplink.smb.omada.manager.configuration.domain.model.site.R;
import com.tplink.smb.omada.manager.configuration.domain.model.site.z;
import com.tplink.smb.omada.manager.device.api.openapi.upgrade.OnlineUpgradeResOpenApiVO;
import com.tplink.smb.omada.manager.device.api.web.upgrade.UpgradeInfoVO;
import com.tplink.smb.omada.manager.device.api.web.upgrade.UpgradeSettingTryBetaVO;
import com.tplink.smb.omada.manager.device.application.upgrade.UpgradeDeviceApplicationService;
import com.tplink.smb.omada.manager.device.domain.model.device.G;
import com.tplink.smb.omada.manager.device.domain.model.device.O;
import com.tplink.smb.omada.manager.device.domain.model.device.SiteModelInfoDTO;
import com.tplink.smb.omada.manager.device.domain.model.device.o;
import com.tplink.smb.omada.manager.device.domain.model.device.osg.K;
import com.tplink.smb.omada.manager.device.domain.model.deviceimage.l;
import com.tplink.smb.omada.manager.device.domain.model.upgrade.UpgradeRequestDTO;
import com.tplink.smb.omada.manager.device.domain.model.upgrade.b;
import com.tplink.smb.omada.manager.device.domain.model.upgrade.cache.UpgradeDeviceItem;
import com.tplink.smb.omada.manager.device.domain.model.upgrade.cache.d;
import com.tplink.smb.omada.manager.device.domain.model.upgrade.cloud.B;
import com.tplink.smb.omada.manager.device.domain.model.upgrade.cloud.BatchUpgradeRequestDTO;
import com.tplink.smb.omada.manager.device.domain.model.upgrade.cloud.CloudDeviceUpgradeAdaptor;
import com.tplink.smb.omada.manager.device.domain.model.upgrade.cloud.CloudDeviceUpgradeService;
import com.tplink.smb.omada.manager.device.domain.model.upgrade.cloud.OnlineUpgradeStatusCache;
import com.tplink.smb.omada.manager.device.domain.model.upgrade.cloud.QueryTargetVersionFwDTO;
import com.tplink.smb.omada.manager.device.domain.model.upgrade.cloud.RollingUpgradeProcessTask;
import com.tplink.smb.omada.manager.device.domain.model.upgrade.cloud.UpgradeFwInfoDTO;
import com.tplink.smb.omada.manager.device.domain.model.upgrade.cloud.cache.BatchRollingUpgradeDeviceDTO;
import com.tplink.smb.omada.manager.device.domain.model.upgrade.cloud.f;
import com.tplink.smb.omada.manager.device.domain.model.upgrade.cloud.g;
import com.tplink.smb.omada.manager.device.domain.model.upgrade.cloud.h;
import com.tplink.smb.omada.manager.device.domain.model.upgrade.cloud.k;
import com.tplink.smb.omada.manager.device.domain.model.upgrade.cloud.m;
import com.tplink.smb.omada.manager.device.domain.model.upgrade.cloud.q;
import com.tplink.smb.omada.manager.device.domain.model.upgrade.cloud.r;
import com.tplink.smb.omada.manager.device.domain.model.upgrade.cloud.t;
import com.tplink.smb.omada.manager.device.domain.model.upgrade.firmware.Firmware;
import com.tplink.smb.omada.manager.device.port.cache.device.DeviceImagePO;
import com.tplink.smb.omada.manager.j.a.a.c;
import com.tplink.smb.omada.manager.stomp.a.a;
import com.tplink.smb.omada.manager.stomp.port.eventcenter.StompMessageEvent;
import com.tplink.smb.omada.manager.stomp.wo.DeviceWO;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;

@Component
public class i
implements CloudDeviceUpgradeService {
    @Generated
    private static final Logger a = LoggerFactory.getLogger(i.class);
    private l b;
    private O c;
    private UpgradeDeviceApplicationService d;
    private r e;
    private OnlineUpgradeStatusCache f;
    private UpgradeFileCacheCommonService g;
    private CloudDeviceUpgradeAdaptor h;
    private com.tplink.smb.omada.logmanager.api.internal.i i;
    private com.tplink.smb.omada.manager.device.domain.model.upgrade.task.h j;
    private a k;
    private com.tplink.smb.omada.manager.device.domain.model.upgrade.a.b l;
    private com.tplink.smb.omada.identityaccess.api.internal.g m;
    private com.tplink.smb.omada.manager.device.domain.model.mesh.g n;
    private com.tplink.smb.omada.manager.common.audit.a o;
    private d p;
    private R q;
    private com.tplink.smb.omada.manager.device.domain.model.upgrade.firmware.a r;
    private com.tplink.smb.omada.manager.device.application.upgrade.manage.a s;
    private B t;
    private K u;
    private f v;
    private static final Pattern w = Pattern.compile("^([a-zA-Z0-9][-a-zA-Z0-9]{0,59})(-v2)(.*)$");

    @Override
    public OperationResponse a(c omadacId, h checkFwCallback) {
        try {
            return this.h.a(omadacId, checkFwCallback);
        }
        catch (Exception e2) {
            a.error("omadacId:{}, checkDeviceLastFw occur exception:{}", new Object[]{omadacId.a(), e2.getMessage(), e2});
            return OperationResponse.GENERAL_ERROR;
        }
    }

    @Override
    public OperationResponse a(c omadacId, G deviceMac) {
        return this.h.a(omadacId, deviceMac);
    }

    @Override
    public OperationResponse a(c omadacId, G deviceMac, String role, String operator, String ip, int resource) {
        com.tplink.smb.omada.manager.device.domain.model.deviceimage.d deviceImage = this.b.a(omadacId, deviceMac).orElse(null);
        if (deviceImage == null) {
            a.warn("omadacId:{}, Can't find a matched device by {}.", (Object)omadacId.a(), (Object)com.tplink.smb.omada.common.util.e.a.d((String)deviceMac.a()));
            return OperationResponse.PARAM_ERROR;
        }
        String compoundModel = deviceImage.aX().x();
        String firmwareVersion = deviceImage.aX().u();
        String curVersion = deviceImage.aX().B();
        String oemId = deviceImage.aX().y();
        ArrayList<String> deviceMacs = new ArrayList<String>();
        deviceMacs.add(deviceMac.a());
        BatchUpgradeRequestDTO batchInfo = new BatchUpgradeRequestDTO(omadacId, deviceImage.ap(), deviceImage.an(), deviceMacs, compoundModel, curVersion, oemId, role, operator, true, ip, resource, null);
        return this.a(batchInfo, firmwareVersion);
    }

    @Override
    public OperationResponse a(BatchUpgradeRequestDTO batchInfo, String firmwareVersion) {
        String omadacId = batchInfo.getOmadacId().a();
        String siteId = batchInfo.getSite().a();
        a.info("omadacId:{},siteId:{} Start download and batch upgrade devices {}.", new Object[]{omadacId, siteId, com.tplink.smb.omada.common.util.e.a.a(batchInfo.getMacs())});
        if (com.tplink.smb.omada.manager.device.domain.model.upgrade.cloud.k.b(batchInfo.getCompoundModel(), firmwareVersion)) {
            a.warn("omadacId:{},siteId:{} Firmware version({}) of model({}) is in incompatible firmware versions, so batch online upgrading is forbidden.", new Object[]{omadacId, siteId, firmwareVersion, batchInfo.getCompoundModel()});
            return new OperationResponse(com.tplink.smb.omada.common.g.b.zU);
        }
        this.h.a();
        block4: for (String deviceMac : batchInfo.getMacs()) {
            OnlineUpgradeStatusCache.a onlineUpgradeStatus = this.f.getDeviceUpgradeInfo(omadacId, deviceMac);
            if (onlineUpgradeStatus != null) {
                switch (onlineUpgradeStatus) {
                    case c: {
                        a.info("omadacId:{},siteId:{}, Device {} is upgrading, please try later.", new Object[]{omadacId, siteId, com.tplink.smb.omada.common.util.e.a.d((String)deviceMac)});
                        continue block4;
                    }
                    case b: {
                        if (this.b(batchInfo.getCompoundModel(), batchInfo.getVersion(), batchInfo.getOemId())) {
                            a.info("omadacId:{},siteId:{},Firmware for device {} is downloading , please retry later.", new Object[]{omadacId, siteId, com.tplink.smb.omada.common.util.e.a.d((String)deviceMac)});
                            continue block4;
                        }
                        a.info("omadacId:{},siteId:{},Firmware is not downloading. Retry upgrading device {}.", new Object[]{omadacId, siteId, com.tplink.smb.omada.common.util.e.a.d((String)deviceMac)});
                        break;
                    }
                    default: {
                        a.info("omadacId:{},siteId:{}, Retry upgrading device {}.", new Object[]{omadacId, siteId, com.tplink.smb.omada.common.util.e.a.d((String)deviceMac)});
                    }
                }
            }
            this.f.updateDeviceUpgradeInfo(omadacId, deviceMac, OnlineUpgradeStatusCache.a.a);
        }
        OperationResponse res = this.a(batchInfo);
        if (!res.success()) {
            a.warn("omadacId:{},siteId:{} checkFirmWareAndUpgrade failed.", (Object)omadacId, (Object)siteId);
            return res;
        }
        return OperationResponse.SUCCESS;
    }

    @Override
    public OperationResponse b(c omadacId, G deviceMac) {
        HashMap<String, Integer> map = new HashMap<String, Integer>(2);
        map.put("status", OnlineUpgradeStatusCache.a.a.a());
        OnlineUpgradeStatusCache.a onlineUpgradeStatus = this.f.getDeviceUpgradeInfo(omadacId.a(), deviceMac.a());
        if (onlineUpgradeStatus != null) {
            map.put("status", onlineUpgradeStatus.a());
        }
        return new OperationResponse(com.tplink.smb.omada.common.g.b.a, map);
    }

    @Override
    public Boolean a(String modelModelVersion, String currentFwVers, String oemId) {
        q modelFw = this.e.a(modelModelVersion, currentFwVers, oemId).orElse(null);
        if (modelFw == null) {
            return false;
        }
        String lastFwVer = modelFw.k();
        return !T.a((String)lastFwVer) && com.tplink.smb.omada.manager.device.domain.model.upgrade.cloud.k.a(com.tplink.smb.omada.manager.device.domain.model.upgrade.cloud.k.b(currentFwVers), com.tplink.smb.omada.manager.device.domain.model.upgrade.cloud.k.b(lastFwVer)) < 0;
    }

    @Override
    public Boolean a(String currentVersion, String lastVersion) {
        return !T.a((String)lastVersion) && com.tplink.smb.omada.manager.device.domain.model.upgrade.cloud.k.a(com.tplink.smb.omada.manager.device.domain.model.upgrade.cloud.k.b(currentVersion), com.tplink.smb.omada.manager.device.domain.model.upgrade.cloud.k.b(lastVersion)) < 0;
    }

    @Override
    public Boolean a(com.tplink.smb.omada.manager.device.domain.model.deviceimage.d deviceImage) {
        if (deviceImage == null) {
            return false;
        }
        return DeviceStatusEnum.g.equals((Object)deviceImage.at()) || DeviceStatusEnum.h.equals((Object)deviceImage.at());
    }

    @Override
    public Boolean a(DeviceImagePO deviceImagePO) {
        if (deviceImagePO == null) {
            return false;
        }
        return DeviceStatusEnum.g.m().equals(deviceImagePO.getStatus()) || DeviceStatusEnum.h.m().equals(deviceImagePO.getStatus());
    }

    @Override
    public Boolean c(c omadacId, G deviceMac) {
        com.tplink.smb.omada.manager.device.domain.model.deviceimage.d deviceImage = this.b.a(omadacId, deviceMac).orElse(null);
        return this.a(deviceImage);
    }

    @Override
    public OperationResponse a(c omadacId, com.tplink.smb.omada.manager.j.a.a.d siteId, Collection<String> macs, String role, String operator, String ip, int resource, Map<String, String> map, Map<String, String> modelAndLogId, List<String> logIds) {
        OperationResponse res = this.l.a(omadacId, siteId, () -> {
            if (this.j.a(omadacId.a(), siteId.a())) {
                a.warn("omadacId:{},siteId:{}, Last rolling upgrade task is still running.", (Object)omadacId.a(), (Object)siteId.a());
                return new OperationResponse(com.tplink.smb.omada.common.g.b.zU);
            }
            this.f.clearRollUpgradeResMap(omadacId.a(), siteId.a());
            a.info("omadacId:{},siteId:{}, Start rolling upgrade devices {}", new Object[]{omadacId.a(), siteId.a(), com.tplink.smb.omada.common.util.e.a.d((String)macs.toString())});
            this.f.offerDevice(omadacId.a(), siteId.a(), this.a(omadacId, siteId, macs, ip, resource, map));
            return OperationResponse.SUCCESS;
        }, () -> {
            a.warn("omadacId:{},siteId:{}, Can't get lock when start rolling upgrade task.", (Object)omadacId.a(), (Object)siteId.a());
            return new OperationResponse(com.tplink.smb.omada.common.g.b.fi);
        });
        if (!res.success()) {
            return res;
        }
        BatchRollingUpgradeDeviceDTO upgradeInfo = this.f.getHeadDevice(omadacId.a(), siteId.a());
        if (upgradeInfo == null || CollectionUtils.isEmpty(upgradeInfo.getDeviceMacs())) {
            a.debug("omadacId:{},siteId:{}, get upgradeInfo is null.", (Object)omadacId.a(), (Object)siteId.a());
            return OperationResponse.SUCCESS;
        }
        BatchUpgradeRequestDTO batchInfo = new BatchUpgradeRequestDTO(omadacId, siteId, upgradeInfo.getDeviceType(), upgradeInfo.getDeviceMacs(), upgradeInfo.getCompoundModel(), upgradeInfo.getVersion(), upgradeInfo.getOemId(), role, operator, false, ip, resource, upgradeInfo.getTargetVersion());
        OperationResponse updateFirst = this.a(batchInfo, upgradeInfo.getFirmwareVersion());
        if (!updateFirst.success() && updateFirst.getErrorCode() != com.tplink.smb.omada.common.g.b.Ax.b()) {
            a.info("omadacId:{},siteId:{}, Batch upgrade devices failed {}", new Object[]{omadacId.a(), siteId.a(), updateFirst.getMsg()});
            Map<String, com.tplink.smb.omada.manager.device.domain.model.upgrade.common.a> tempMap = this.f.getRollUpgradeResMap(omadacId.a(), siteId.a());
            if (CollectionUtils.isEmpty(tempMap)) {
                tempMap = new HashMap<String, com.tplink.smb.omada.manager.device.domain.model.upgrade.common.a>(4);
            }
            for (String deviceMac : upgradeInfo.getDeviceMacs()) {
                tempMap.put(deviceMac, com.tplink.smb.omada.manager.device.domain.model.upgrade.common.a.b);
            }
            this.f.putRollUpgradeResMap(omadacId.a(), siteId.a(), tempMap);
        }
        RollingUpgradeProcessTask rollingUpgradeProcessTask = new RollingUpgradeProcessTask(omadacId.a(), siteId.a(), role, operator, System.currentTimeMillis(), updateFirst.success(), modelAndLogId, logIds);
        this.j.a(rollingUpgradeProcessTask);
        a.info("omadacId:{},siteId:{}, RollUpgradeControlTask submit success.", (Object)omadacId.a(), (Object)siteId.a());
        if (T.a((String)role) || T.a((String)operator)) {
            this.i.a(omadacId.a(), OmadaLogKeyEnumDTO.AP_ROLL_UP, OmadaLogDTO.build((String)omadacId.a(), (String)siteId.a(), (OmadaLogKeyEnumDTO)OmadaLogKeyEnumDTO.AP_ROLL_UP, (String[])new String[]{"System", "automatically"}).toJson());
            this.o.a(omadacId.a(), siteId.a(), AuditLogKeyEnumDTO.DEVICE_ROLLING_UPGRADE.name(), new AuditLogUserDTO("System", ip, resource), Boolean.TRUE, new String[0]);
        } else {
            this.i.a(omadacId.a(), OmadaLogKeyEnumDTO.AP_ROLL_UP, OmadaLogKeyEnumDTO.AP_ROLL_UP.build(omadacId.a(), siteId.a(), null, null, new String[]{role, operator}).toJson());
            this.o.a(omadacId.a(), siteId.a(), AuditLogKeyEnumDTO.DEVICE_ROLLING_UPGRADE.name(), new AuditLogUserDTO(operator, ip, resource), Boolean.TRUE, new String[0]);
        }
        return OperationResponse.SUCCESS;
    }

    @Override
    public OperationResponse a(c omadacId, com.tplink.smb.omada.manager.j.a.a.d siteKey) {
        a.info("omadacId:{},siteId:{} cancelUpDevices.", (Object)omadacId, (Object)siteKey);
        this.f.clearDeviceQueue(omadacId.a(), siteKey.a());
        return OperationResponse.SUCCESS;
    }

    @Override
    public OperationResponse b(c omadacId, com.tplink.smb.omada.manager.j.a.a.d siteKey) {
        HashMap<String, Object> map = new HashMap<String, Object>(4);
        if (this.f.isEmptyQueue(omadacId.a(), siteKey.a())) {
            if (CollectionUtils.isEmpty(this.f.getRollUpgradeResMap(omadacId.a(), siteKey.a()))) {
                map.put("status", d.a.a.a());
            } else {
                map.put("status", d.a.c.a());
                ArrayList<UpgradeInfoVO> upgradeInfoVOList = new ArrayList<UpgradeInfoVO>();
                Map<String, com.tplink.smb.omada.manager.device.domain.model.upgrade.common.a> tempMap = this.f.getRollUpgradeResMap(omadacId.a(), siteKey.a());
                Set<Map.Entry<String, com.tplink.smb.omada.manager.device.domain.model.upgrade.common.a>> rollUpResult = tempMap.entrySet();
                for (Map.Entry<String, com.tplink.smb.omada.manager.device.domain.model.upgrade.common.a> entry : rollUpResult) {
                    UpgradeInfoVO upgradeInfoVO = new UpgradeInfoVO();
                    upgradeInfoVO.setMac(entry.getKey());
                    upgradeInfoVO.setStatus(Integer.valueOf(entry.getValue().a()));
                    upgradeInfoVOList.add(upgradeInfoVO);
                }
                map.put("deviceResult", upgradeInfoVOList);
                this.f.clearRollUpgradeResMap(omadacId.a(), siteKey.a());
            }
        } else {
            map.put("status", d.a.b.a());
            BatchRollingUpgradeDeviceDTO deviceDTO = this.f.getHeadDevice(omadacId.a(), siteKey.a());
            if (deviceDTO != null && !CollectionUtils.isEmpty(deviceDTO.getDeviceMacs())) {
                map.put("mac", deviceDTO.getDeviceMacs().get(0));
            }
        }
        return new OperationResponse(com.tplink.smb.omada.common.g.b.a, map);
    }

    @Override
    public Boolean d(c omadacId, G deviceMac) {
        return this.f.getDeviceUpgradeInfo(omadacId.a(), deviceMac.a()) == OnlineUpgradeStatusCache.a.b;
    }

    @Override
    public void a(String compoundModel, String curVersion, String oemId, String hwId, Boolean isPro) {
        if (this.e.b(compoundModel + curVersion + oemId)) {
            return;
        }
        q model = com.tplink.smb.omada.manager.device.domain.model.upgrade.cloud.q.a().a(compoundModel + curVersion + oemId).b(compoundModel).c(curVersion).a(isPro).e(oemId).d(hwId).a();
        this.h.a(model);
    }

    @Override
    public boolean a() {
        return this.h.b();
    }

    @Override
    public OperationResponse a(BatchUpgradeRequestDTO info, String fileMd5, Boolean online) {
        c omadacId = info.getOmadacId();
        a.debug("omadacId:{}, upgradeDevice will pushDownloadStatus.", (Object)omadacId.a());
        for (String deviceMac : info.getMacs()) {
            this.a(omadacId, info.getSite(), new G(deviceMac), false);
        }
        UpgradeRequestDTO upgradeRequestDTO = new UpgradeRequestDTO(omadacId, "", com.tplink.smb.omada.manager.device.application.upgrade.d.a(info.getMacs()), fileMd5, info.getSite(), info.getDeviceTypeEnum(), info.getSingle(), online, info.getRole(), info.getOperator(), info.getOperatorIp(), info.getResource(), null, null, null);
        return this.d.b(upgradeRequestDTO);
    }

    @Override
    public void a(c omadacId) {
        OperationResponse<UpgradeSettingTryBetaVO> omadacTryBetaResp = this.t.b(omadacId.a());
        if (!omadacTryBetaResp.success() || null == omadacTryBetaResp.getResult()) {
            a.error("omadacId:{},handleDeviceUpgradeNotification failed, getOmadacTryBetaStatus failed.", (Object)omadacId);
            return;
        }
        Boolean tryBeta = ((UpgradeSettingTryBetaVO)omadacTryBetaResp.getResult()).getEnable();
        OperationResponse userRes = this.m.e(omadacId.a());
        List userList = (List)userRes.getResult();
        if (!userRes.success() || CollectionUtils.isEmpty((Collection)((Collection)userRes.getResult()))) {
            a.debug("omadacId:{}, empty admins list.", (Object)omadacId.a());
            return;
        }
        a.debug("omadacId:{}, Get admins list, size {} ", (Object)omadacId.a(), (Object)((List)userRes.getResult()).size());
        HashSet<String> siteIdSet = new HashSet<String>();
        for (UserSiteBriefDTO userDTO : userList) {
            if (!CollectionUtils.isEmpty((Collection)userDTO.getSiteIds())) {
                userDTO.getSiteIds().removeIf(Objects::isNull);
                siteIdSet.addAll(userDTO.getSiteIds());
            }
            if (!Boolean.TRUE.equals(userDTO.getAllSite())) continue;
            List<String> allSites = this.q.b(omadacId);
            allSites.removeIf(Objects::isNull);
            siteIdSet.addAll(allSites);
            break;
        }
        a.debug("omadacId:{}, Get site list in, size {} ", (Object)omadacId.a(), (Object)siteIdSet.size());
        HashSet<String> upgradeSiteSet = new HashSet<String>();
        HashSet<String> upgradeUserSet = new HashSet<String>();
        HashSet<String> noUpgradeUserSet = new HashSet<String>();
        for (String site : siteIdSet) {
            boolean siteNeedUpgrade = this.a(omadacId, site, tryBeta);
            if (!siteNeedUpgrade) continue;
            upgradeSiteSet.add(site);
        }
        for (UserSiteBriefDTO user : userList) {
            if (user == null) continue;
            a.debug("omadacId:{}, user info {}", (Object)omadacId.a(), (Object)user);
            if (CollectionUtils.containsAny((Collection)user.getSiteIds(), upgradeSiteSet) || upgradeSiteSet.size() > 0 && Boolean.TRUE.equals(user.getAllSite())) {
                a.debug("omadacId:{}, user {} has device upgrade notification.", (Object)omadacId.a(), (Object)user.getUserId());
                upgradeUserSet.add(user.getUserId());
                continue;
            }
            noUpgradeUserSet.add(user.getUserId());
        }
        NoticeUserDevicesUpgradeDTO noticeUserDevicesUpgradeDTO = new NoticeUserDevicesUpgradeDTO();
        noticeUserDevicesUpgradeDTO.setUpgradeUserSet(upgradeUserSet);
        noticeUserDevicesUpgradeDTO.setNoUpgradeUserSet(noUpgradeUserSet);
        noticeUserDevicesUpgradeDTO.setOmadacId(omadacId.a());
        this.m.a(noticeUserDevicesUpgradeDTO);
    }

    @Override
    public boolean a(List<com.tplink.smb.omada.manager.device.domain.model.deviceimage.d> deviceImageList) {
        if (CollectionUtils.isEmpty(deviceImageList)) {
            return false;
        }
        Map<String, String> modelFwMap = this.e.a();
        for (com.tplink.smb.omada.manager.device.domain.model.deviceimage.d deviceImage : deviceImageList) {
            String modelFwKey = deviceImage.aX().x() + deviceImage.aX().B();
            if (!this.a(deviceImage).booleanValue() || !this.a(deviceImage.aX().B(), modelFwMap.get(modelFwKey)).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public OperationResponse a(@Nullable g callBack) {
        return this.h.a(callBack);
    }

    @Override
    public Map<DeviceTypeEnum, List<String>> c(c omadacId, com.tplink.smb.omada.manager.j.a.a.d siteId) {
        Map<String, String> modelFwMap = this.e.a();
        List<com.tplink.smb.omada.manager.device.domain.model.deviceimage.d> deviceImages = this.b.a(omadacId, siteId);
        HashMap<DeviceTypeEnum, List<String>> res = new HashMap<DeviceTypeEnum, List<String>>();
        ArrayList<String> apMacList = new ArrayList<String>();
        ArrayList<String> osgMacList = new ArrayList<String>();
        ArrayList<String> oswMacList = new ArrayList<String>();
        res.put(DeviceTypeEnum.a, apMacList);
        res.put(DeviceTypeEnum.b, osgMacList);
        res.put(DeviceTypeEnum.c, oswMacList);
        if (CollectionUtils.isEmpty(modelFwMap) || CollectionUtils.isEmpty(deviceImages)) {
            return res;
        }
        block5: for (com.tplink.smb.omada.manager.device.domain.model.deviceimage.d deviceImage : deviceImages) {
            if (!deviceImage.A()) continue;
            String modelFwKey = deviceImage.aX().x() + deviceImage.aX().B() + deviceImage.aX().y();
            boolean upgradable = this.a(deviceImage.aX().B(), modelFwMap.get(modelFwKey)) != false && this.a(deviceImage) != false;
            if (!upgradable) continue;
            switch (deviceImage.an()) {
                case a: {
                    apMacList.add(deviceImage.X());
                    continue block5;
                }
                case b: {
                    osgMacList.add(deviceImage.X());
                    continue block5;
                }
                case c: {
                    oswMacList.add(deviceImage.X());
                    continue block5;
                }
            }
            a.warn("undefined device type when queryUpgradableDevice for {} {} {}", new Object[]{omadacId, siteId, com.tplink.smb.omada.common.util.e.a.d((String)deviceImage.al().a())});
        }
        res.put(DeviceTypeEnum.a, apMacList);
        res.put(DeviceTypeEnum.b, osgMacList);
        res.put(DeviceTypeEnum.c, oswMacList);
        return res;
    }

    @Override
    public int d(c omadacId, com.tplink.smb.omada.manager.j.a.a.d siteId) {
        Collection<BatchRollingUpgradeDeviceDTO> upgradeDeviceInfos = this.f.getUpQueue(omadacId.a(), siteId.a());
        int res = 0;
        if (!CollectionUtils.isEmpty(upgradeDeviceInfos)) {
            for (BatchRollingUpgradeDeviceDTO deviceInfo : upgradeDeviceInfos) {
                res += deviceInfo.getDeviceMacs().size();
            }
        }
        return res;
    }

    @Override
    public OnlineUpgradeResOpenApiVO a(c omadacId, com.tplink.smb.omada.manager.j.a.a.d siteId, G deviceMac) {
        OnlineUpgradeResOpenApiVO res = new OnlineUpgradeResOpenApiVO();
        com.tplink.smb.omada.manager.device.domain.model.deviceimage.d deviceImage = this.b.c(omadacId, siteId, deviceMac).orElse(null);
        if (deviceImage == null || deviceImage.aI() == null) {
            return null;
        }
        UpgradeDeviceItem item = this.p.a(deviceImage.aI().getUpgradeId(), deviceMac.a());
        if (item == null) {
            return null;
        }
        res.setFinished(Boolean.valueOf(item.isFinished()));
        res.setSuccess(Boolean.valueOf(item.isSuccessful()));
        return res;
    }

    private boolean b(String compoundModel, String version, String oemId) {
        Boolean downloadRes = this.f.getModelDownloadInfo(compoundModel, version, oemId);
        return downloadRes != null && Boolean.FALSE.equals(downloadRes);
    }

    private OperationResponse a(BatchUpgradeRequestDTO info) {
        String omadacId = info.getOmadacId().a();
        String siteId = info.getSite().a();
        OperationResponse<m> firmwareRes = this.b(info);
        if (!firmwareRes.success()) {
            a.warn("omadacId:{},siteId:{}, checkFirmWareAndUpgrade getFirmwareInfo failed", (Object)omadacId, (Object)siteId);
            return firmwareRes;
        }
        m firmwareBasicInfo = (m)firmwareRes.getResult();
        a.info("omadacId:{},siteId:{},firmware info {} for {} when checkFirmWareAndUpgrade", new Object[]{omadacId, siteId, firmwareBasicInfo, info});
        boolean firmwareExisted = this.g.checkUpgradeFileExisted(firmwareBasicInfo.a());
        if (firmwareExisted) {
            for (String string : info.getMacs()) {
                this.f.updateDeviceUpgradeInfo(omadacId, string, OnlineUpgradeStatusCache.a.c);
            }
            a.info("omadacId:{},siteId:{},start upgrade with existed upgrade file for {}", new Object[]{omadacId, siteId, info});
            OperationResponse res = this.a(info, firmwareBasicInfo.a(), firmwareBasicInfo.d());
            if (!res.success()) {
                a.info("omadacId:{},siteId:{}, upgrade devices {} after firmware download failed in {}, reason {}", new Object[]{omadacId, siteId, com.tplink.smb.omada.common.util.e.a.d((String)info.getMacs().toString()), info.getSite(), res.getMsg()});
                for (String deviceMac : info.getMacs()) {
                    this.f.updateDeviceUpgradeInfo(omadacId, deviceMac, OnlineUpgradeStatusCache.a.a);
                }
            }
            return res;
        }
        if (firmwareBasicInfo.b() == null) {
            a.warn("omadacId:{},siteId:{}, checkFirmWareAndUpgrade getFirmwareInfo url failed ", (Object)omadacId, (Object)siteId);
            return new OperationResponse(com.tplink.smb.omada.common.g.b.zV);
        }
        this.f.updateModelDownloadInfo(info.getCompoundModel(), info.getVersion(), info.getOemId(), false);
        List<String> files = this.v.c();
        DownloadCallback downloadCallback = this.h.a(info);
        this.a(firmwareBasicInfo);
        DownloadResponse res = this.g.downloadFromUrl(firmwareBasicInfo.b(), firmwareBasicInfo.a(), files, downloadCallback);
        a.info("omadacId:{},siteId:{}, start download {} for {} {} ", new Object[]{omadacId, siteId, firmwareBasicInfo.b(), info.getCompoundModel(), info.getTargetVersion()});
        if (res == DownloadResponse.WAITING) {
            return new OperationResponse(com.tplink.smb.omada.common.g.b.eV);
        }
        for (String deviceMac : info.getMacs()) {
            this.f.updateDeviceUpgradeInfo(omadacId, deviceMac, OnlineUpgradeStatusCache.a.b);
        }
        a.debug("omadacId:{},siteId:{}, start pushDownloadStatus {}", new Object[]{omadacId, siteId, com.tplink.smb.omada.common.util.e.a.d((String)info.getMacs().toString())});
        for (String deviceMac : info.getMacs()) {
            this.a(info.getOmadacId(), info.getSite(), new G(deviceMac), true);
        }
        return new OperationResponse(com.tplink.smb.omada.common.g.b.a);
    }

    private void a(m firmwareBasicInfo) {
        if (!Boolean.TRUE.equals(firmwareBasicInfo.d()) || firmwareBasicInfo.b() == null) {
            return;
        }
        String url = firmwareBasicInfo.b();
        UriComponentsBuilder uriComponentsBuilder = UriComponentsBuilder.fromUriString((String)url);
        UriComponents uriComponents = uriComponentsBuilder.build();
        String domain = uriComponents.getHost();
        if (domain == null) {
            return;
        }
        Matcher matcher = w.matcher(domain);
        if (!matcher.matches()) {
            return;
        }
        String convertDomain = matcher.group(1) + matcher.group(3);
        String convertUrl = uriComponentsBuilder.host(convertDomain).build().toUriString();
        firmwareBasicInfo.b(convertUrl);
        a.debug("checkFirmWareAndUpgrade checkAndConvertUrl relust:{} ", (Object)firmwareBasicInfo);
    }

    private OperationResponse<m> b(BatchUpgradeRequestDTO info) {
        m firmwareBasicInfo = new m();
        Optional<Firmware> manualFirmware = this.r.a(info.getOmadacId().a(), info.getCompoundModel(), info.getTargetVersion());
        if (manualFirmware.isPresent()) {
            firmwareBasicInfo.a(manualFirmware.get().getFileId());
            firmwareBasicInfo.c(manualFirmware.get().getName());
            firmwareBasicInfo.a(false);
            return new OperationResponse(com.tplink.smb.omada.common.g.b.a, (Object)firmwareBasicInfo);
        }
        a.info("Not manual upgrade for {} {} {} in {} {}", new Object[]{com.tplink.smb.omada.common.util.e.a.d((String)info.getMacs().toString()), info.getCompoundModel(), info.getTargetVersion(), info.getOmadacId(), info.getSite()});
        q modelFw = this.e.a(info.getCompoundModel(), info.getVersion(), info.getOemId()).orElse(null);
        if (modelFw == null) {
            a.info("Can't find online firmware for {} {} {} in {} {}", new Object[]{com.tplink.smb.omada.common.util.e.a.d((String)info.getMacs().toString()), info.getCompoundModel(), info.getTargetVersion(), info.getOmadacId(), info.getSite()});
            return new OperationResponse(com.tplink.smb.omada.common.g.b.Ab);
        }
        if (info.getTargetVersion() == null) {
            firmwareBasicInfo.a(modelFw.q());
            firmwareBasicInfo.c(modelFw.k());
            firmwareBasicInfo.b(modelFw.l());
            firmwareBasicInfo.a(true);
            return new OperationResponse(com.tplink.smb.omada.common.g.b.a, (Object)firmwareBasicInfo);
        }
        QueryTargetVersionFwDTO queryTargetVersionFwDTO = QueryTargetVersionFwDTO.builder().oemId(com.tplink.smb.omada.common.util.b.b.e((String)modelFw.h())).hwId(com.tplink.smb.omada.common.util.b.b.e((String)modelFw.g())).compoundModel(info.getCompoundModel()).pro(modelFw.d()).targetVersion(com.tplink.smb.omada.manager.device.domain.model.upgrade.cloud.k.c(info.getTargetVersion())).build();
        ArrayList<QueryTargetVersionFwDTO> queryList = new ArrayList<QueryTargetVersionFwDTO>();
        queryList.add(queryTargetVersionFwDTO);
        OperationResponse<Map<String, UpgradeFwInfoDTO>> queryRes = this.h.b(info.getOmadacId(), queryList);
        if (!queryRes.success()) {
            return new OperationResponse(com.tplink.smb.omada.common.g.b.a((int)queryRes.getErrorCode()));
        }
        a.info("Get firmware info from tp cloud {}", queryRes.getResult());
        UpgradeFwInfoDTO upgradeFwInfoDTO = (UpgradeFwInfoDTO)((Map)queryRes.getResult()).get(info.getCompoundModel() + info.getTargetVersion());
        if (upgradeFwInfoDTO == null && !CollectionUtils.isEmpty((Map)((Map)queryRes.getResult()))) {
            upgradeFwInfoDTO = (UpgradeFwInfoDTO)new ArrayList(((Map)queryRes.getResult()).values()).get(0);
        }
        if (upgradeFwInfoDTO == null || T.a((String)upgradeFwInfoDTO.getFwUrl())) {
            a.info("Can't find online firmware for {} {} {} in {} {}", new Object[]{com.tplink.smb.omada.common.util.e.a.d((String)info.getMacs().toString()), info.getCompoundModel(), info.getTargetVersion(), info.getOmadacId(), info.getSite()});
            return new OperationResponse(com.tplink.smb.omada.common.g.b.Ab);
        }
        firmwareBasicInfo.a(upgradeFwInfoDTO.getFwMD5());
        firmwareBasicInfo.c(upgradeFwInfoDTO.getFwVer());
        firmwareBasicInfo.b(upgradeFwInfoDTO.getFwUrl());
        firmwareBasicInfo.a(true);
        return new OperationResponse(com.tplink.smb.omada.common.g.b.a, (Object)firmwareBasicInfo);
    }

    private void a(c omadacId, com.tplink.smb.omada.manager.j.a.a.d siteId, G deviceMac, boolean isDownload) {
        DeviceWO deviceWO = new DeviceWO(deviceMac.a());
        deviceWO.setFwDownload(isDownload);
        deviceWO.setOperation(x.c.a());
        this.k.a(omadacId, deviceMac, StompMessageEvent.siteEvent(com.tplink.smb.omada.common.q.c.a.a(), omadacId.a(), siteId.a(), Lists.newArrayList((Object[])new DeviceWO[]{deviceWO})));
    }

    private List<BatchRollingUpgradeDeviceDTO> a(c omadacId, com.tplink.smb.omada.manager.j.a.a.d siteId, Collection<String> macs, String ip, int resource, Map<String, String> versionMap) {
        ArrayList apList = new ArrayList();
        ArrayList<G> apMacList = new ArrayList<G>();
        ArrayList oswList = new ArrayList();
        ArrayList osgList = new ArrayList();
        List<o> deviceList = this.c.b(omadacId, siteId, new HashSet<String>(macs));
        deviceList.forEach(device -> {
            switch (device.l()) {
                case a: {
                    apList.add(device);
                    apMacList.add(device.c_());
                    break;
                }
                case c: {
                    oswList.add(device);
                    break;
                }
                case b: {
                    osgList.add(device);
                    break;
                }
                default: {
                    a.warn("{} {} Invalid device type.", (Object)omadacId, (Object)com.tplink.smb.omada.common.util.e.a.d((String)device.d_()));
                }
            }
        });
        ArrayList<Object> sortedDevices = new ArrayList<Object>(macs.size());
        Map<Integer, Set<G>> hopMap = this.n.a(omadacId, apMacList);
        ListIterator<Map.Entry<Integer, Set<G>>> i2 = new ArrayList<Map.Entry<Integer, Set<G>>>(hopMap.entrySet()).listIterator(hopMap.size());
        while (i2.hasPrevious()) {
            Map.Entry<Integer, Set<G>> entry = i2.previous();
            ArrayList apInHop = new ArrayList();
            entry.getValue().forEach(deviceMac -> apList.stream().filter(device -> deviceMac.a(device.c_())).findFirst().ifPresent(apInHop::add));
            List sortedModelApMacList = apInHop.stream().sorted(Comparator.comparing(device -> device.O().getCompoundModel() + device.O().getVersion() + device.O().getOemId())).collect(Collectors.toList());
            sortedDevices.addAll(sortedModelApMacList);
        }
        sortedDevices.addAll(oswList);
        sortedDevices.addAll(osgList);
        ArrayList<BatchRollingUpgradeDeviceDTO> batchUpgradeList = new ArrayList<BatchRollingUpgradeDeviceDTO>();
        BatchRollingUpgradeDeviceDTO deviceDTO = new BatchRollingUpgradeDeviceDTO();
        ArrayList<String> deviceMacs = new ArrayList<String>();
        deviceDTO.setCompoundModel(((o)sortedDevices.get(0)).O().getCompoundModel());
        deviceDTO.setVersion(((o)sortedDevices.get(0)).O().getVersion());
        deviceDTO.setFirmwareVersion(((o)sortedDevices.get(0)).O().getFirmwareVersion());
        deviceDTO.setOemId(((o)sortedDevices.get(0)).O().getOemId());
        deviceDTO.setDeviceType(((o)sortedDevices.get(0)).l());
        deviceDTO.setDeviceMacs(deviceMacs);
        deviceDTO.setTargetVersion(versionMap.get(((o)sortedDevices.get(0)).d_()));
        deviceDTO.setIp(ip);
        deviceDTO.setResource(resource);
        batchUpgradeList.add(deviceDTO);
        for (o o2 : sortedDevices) {
            String targetVersion = versionMap.get(o2.d_());
            if (!(o2.O().getCompoundModel().equals(deviceDTO.getCompoundModel()) && o2.O().getVersion().equals(deviceDTO.getVersion()) && Objects.equals(o2.O().getOemId(), deviceDTO.getOemId()) && Objects.equals(deviceDTO.getTargetVersion(), versionMap.get(o2.d_())))) {
                deviceDTO = new BatchRollingUpgradeDeviceDTO();
                deviceMacs = new ArrayList();
                deviceDTO.setCompoundModel(o2.O().getCompoundModel());
                deviceDTO.setVersion(o2.O().getVersion());
                deviceDTO.setFirmwareVersion(o2.O().getFirmwareVersion());
                deviceDTO.setOemId(o2.O().getOemId());
                deviceDTO.setDeviceType(o2.l());
                deviceDTO.setDeviceMacs(deviceMacs);
                deviceDTO.setTargetVersion(targetVersion);
                deviceDTO.setIp(ip);
                deviceDTO.setResource(resource);
                batchUpgradeList.add(deviceDTO);
            }
            deviceMacs.add(o2.d_());
        }
        a.debug("omadacId:{}, siteId:{}, getUpgradeDevicesSorted result {}", new Object[]{omadacId.a(), siteId.a(), com.tplink.smb.omada.common.util.e.a.a(batchUpgradeList)});
        return batchUpgradeList;
    }

    private Boolean a(c omadacId, String siteId, Boolean tryBeta) {
        Object primarySiteId;
        Object osgOptional;
        z primarySite;
        List<SiteModelInfoDTO> siteModelInfoDTOS = this.c.f(omadacId, new HashSet<String>(Collections.singletonList(siteId)));
        if (OmadacType.t() && (primarySite = (z)this.q.d(omadacId).orElse(null)) != null && ((Optional)(osgOptional = this.u.a(omadacId, (com.tplink.smb.omada.manager.j.a.a.d)(primarySiteId = primarySite.b()), com.tplink.smb.omada.manager.c.x.a))).isPresent()) {
            String compoundModel = ((com.tplink.smb.omada.manager.device.domain.model.device.osg.b)((Optional)osgOptional).get()).dE().getCompoundModel();
            siteModelInfoDTOS = siteModelInfoDTOS.stream().filter(siteModelInfoDTO -> !siteModelInfoDTO.getSiteId().equals(primarySiteId.a()) || !siteModelInfoDTO.getCompoundModel().equals(compoundModel)).collect(Collectors.toList());
        }
        HashSet<String> compoundModels = new HashSet<String>();
        HashSet<String> oemIds = new HashSet<String>();
        for (SiteModelInfoDTO siteModelInfoDTO2 : siteModelInfoDTOS) {
            compoundModels.add(siteModelInfoDTO2.getCompoundModel());
            oemIds.add(siteModelInfoDTO2.getOemId());
        }
        List<q> modelFws = this.e.a(compoundModels, oemIds);
        HashMap modelFwMap = new HashMap();
        modelFws.forEach(modelFw -> modelFwMap.put(modelFw.e() + modelFw.h(), modelFw));
        HashMap<String, t> upgradeModelMap = new HashMap<String, t>();
        for (SiteModelInfoDTO siteModelInfoDTO3 : siteModelInfoDTOS) {
            t modelFwInfo = new t();
            q modelFw2 = (q)modelFwMap.get(siteModelInfoDTO3.getCompoundModel() + siteModelInfoDTO3.getOemId());
            if (null == modelFw2) {
                a.warn("no such model, omadacId:{}, siteModelInfoDTO:{}, modelFwMap:{}", new Object[]{omadacId, siteModelInfoDTO3, modelFwMap});
                continue;
            }
            modelFwInfo.b(modelFw2.g());
            modelFwInfo.a(modelFw2.h());
            modelFwInfo.e(siteModelInfoDTO3.getVersion());
            modelFwInfo.f(siteModelInfoDTO3.getFirmwareVersion());
            modelFwInfo.a(modelFw2.d());
            modelFwInfo.c(siteModelInfoDTO3.getCompoundModel());
            modelFwInfo.d(siteModelInfoDTO3.getShowModel());
            upgradeModelMap.put(modelFwInfo.c() + modelFwInfo.b() + modelFwInfo.f(), modelFwInfo);
        }
        Map<String, List<UpgradeFwInfoDTO>> channelUpgradeInfo = this.s.a(omadacId, upgradeModelMap);
        if (channelUpgradeInfo.isEmpty()) {
            return false;
        }
        for (Map.Entry<String, List<UpgradeFwInfoDTO>> channelUpgradeEntry : channelUpgradeInfo.entrySet()) {
            List upgradeFwVerList;
            List<UpgradeFwInfoDTO> upgradeFwInfoDTOList = channelUpgradeEntry.getValue();
            if (!Boolean.TRUE.equals(tryBeta)) {
                upgradeFwInfoDTOList = upgradeFwInfoDTOList.stream().filter(upgradeFwInfoDTO -> Objects.equals(com.tplink.smb.omada.manager.device.domain.model.upgrade.b.a.a(), upgradeFwInfoDTO.getChannel())).collect(Collectors.toList());
            }
            if (CollectionUtils.isEmpty(upgradeFwVerList = upgradeFwInfoDTOList.stream().map(UpgradeFwInfoDTO::getFwVer).filter(fwVer -> !T.a((String)fwVer)).collect(Collectors.toList()))) continue;
            return true;
        }
        return false;
    }

    @Autowired
    @Lazy
    @Generated
    public i(l deviceImageRepository, O deviceRepository, UpgradeDeviceApplicationService upgradeDeviceApplicationService, r modelFwRepository, OnlineUpgradeStatusCache onlineCache, UpgradeFileCacheCommonService upgradeFileCacheCommonService, CloudDeviceUpgradeAdaptor cloudDeviceUpgradeAdaptor, com.tplink.smb.omada.logmanager.api.internal.i logApiService, com.tplink.smb.omada.manager.device.domain.model.upgrade.task.h upgradeScheduleCenter, a deviceListStompCenter, com.tplink.smb.omada.manager.device.domain.model.upgrade.a.b upgradeCacheLockFactory, com.tplink.smb.omada.identityaccess.api.internal.g identityAccessInternalApiService, com.tplink.smb.omada.manager.device.domain.model.mesh.g meshTopoService, com.tplink.smb.omada.manager.common.audit.a sendAuditLogService, d upgradeProcessCacheRepository, R siteRepository, com.tplink.smb.omada.manager.device.domain.model.upgrade.firmware.a firmwareRepository, com.tplink.smb.omada.manager.device.application.upgrade.manage.a autoCheckUpgradeSiteTaskHandler, B upgradeModelFwService, K queryOsgService, f caCertificateRepository) {
        this.b = deviceImageRepository;
        this.c = deviceRepository;
        this.d = upgradeDeviceApplicationService;
        this.e = modelFwRepository;
        this.f = onlineCache;
        this.g = upgradeFileCacheCommonService;
        this.h = cloudDeviceUpgradeAdaptor;
        this.i = logApiService;
        this.j = upgradeScheduleCenter;
        this.k = deviceListStompCenter;
        this.l = upgradeCacheLockFactory;
        this.m = identityAccessInternalApiService;
        this.n = meshTopoService;
        this.o = sendAuditLogService;
        this.p = upgradeProcessCacheRepository;
        this.q = siteRepository;
        this.r = firmwareRepository;
        this.s = autoCheckUpgradeSiteTaskHandler;
        this.t = upgradeModelFwService;
        this.u = queryOsgService;
        this.v = caCertificateRepository;
    }
}

