/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.device.domain.model.rebuild;

import com.tplink.smb.ecsp.protocol.packet.body.MessageBody;
import com.tplink.smb.ecsp.protocol.packet.body.datagram.BaseRebuildResponse;
import com.tplink.smb.omada.common.constant.DeviceStatusEnum;
import com.tplink.smb.omada.common.constant.DeviceTypeEnum;
import com.tplink.smb.omada.common.util.T;
import com.tplink.smb.omada.device.manage.message.EcspFirstVersionEnum;
import com.tplink.smb.omada.device.manage.message.EcspVersion;
import com.tplink.smb.omada.device.manage.message.body.eap.ApConfigRespBody;
import com.tplink.smb.omada.device.manage.message.body.eap.v2.ApRebuildConfigV2Body;
import com.tplink.smb.omada.device.manage.message.body.manage.BaseConfigBody;
import com.tplink.smb.omada.device.manage.message.body.manage.BaseConfigRespBody;
import com.tplink.smb.omada.device.manage.message.body.manage.BaseRebuildReqBody;
import com.tplink.smb.omada.device.manage.message.body.manage.config.TimeConfig;
import com.tplink.smb.omada.device.manage.message.body.manage.config.UserAccountConfig;
import com.tplink.smb.omada.device.manage.message.body.olt.v2.OltRebuildConfigV2Body;
import com.tplink.smb.omada.device.manage.message.body.osg.OsgConfigureRespBody;
import com.tplink.smb.omada.device.manage.message.body.osg.v2.OsgRebuildConfigV2Body;
import com.tplink.smb.omada.device.manage.message.body.osw.OswConfigBody;
import com.tplink.smb.omada.device.manage.message.body.osw.OswConfigRespBody;
import com.tplink.smb.omada.device.manage.message.body.osw.v2.OswRebuildConfigV2Body;
import com.tplink.smb.omada.device.manage.message.config.SetKey;
import com.tplink.smb.omada.device.manage.message.config.osw.OswSetKeyEnum;
import com.tplink.smb.omada.manager.common.b.a.b.f;
import com.tplink.smb.omada.manager.configuration.domain.model.site.component.a.h;
import com.tplink.smb.omada.manager.device.domain.model.adopt.n;
import com.tplink.smb.omada.manager.device.domain.model.adopt.x;
import com.tplink.smb.omada.manager.device.domain.model.configsync.dN;
import com.tplink.smb.omada.manager.device.domain.model.configsync.dO;
import com.tplink.smb.omada.manager.device.domain.model.configsync.dto.BeforeSendConfigListDTO;
import com.tplink.smb.omada.manager.device.domain.model.device.G;
import com.tplink.smb.omada.manager.device.domain.model.device.O;
import com.tplink.smb.omada.manager.device.domain.model.device.ap.ay;
import com.tplink.smb.omada.manager.device.domain.model.device.b;
import com.tplink.smb.omada.manager.device.domain.model.device.o;
import com.tplink.smb.omada.manager.device.domain.model.device.osg.P;
import com.tplink.smb.omada.manager.device.domain.model.device.osw.bB;
import com.tplink.smb.omada.manager.device.domain.model.deviceimage.l;
import com.tplink.smb.omada.manager.device.domain.model.message.set.c;
import com.tplink.smb.omada.manager.device.domain.model.message.set.e;
import com.tplink.smb.omada.manager.device.domain.model.rebuild.RebuildDTO;
import com.tplink.smb.omada.manager.device.domain.model.rebuild.a;
import com.tplink.smb.omada.manager.license.domain.model.A;
import com.tplink.smb.omada.manager.license.domain.model.J;
import com.tplink.smb.omada.manager.license.domain.model.z;
import jakarta.annotation.Nullable;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class d {
    @Generated
    private static final Logger h = LoggerFactory.getLogger(d.class);
    @Autowired
    com.tplink.smb.omada.manager.device.port.transport.f.a a;
    @Autowired
    l b;
    @Autowired
    c c;
    @Autowired
    ay d;
    @Autowired
    bB e;
    @Autowired
    P f;
    @Autowired
    private z i;
    @Autowired
    private com.tplink.smb.omada.manager.device.domain.model.o.e j;
    private com.tplink.smb.omada.manager.common.d.b k;
    private com.tplink.smb.omada.lock.a.c l;
    private n m;
    @Autowired
    private O n;
    @Autowired
    private h o;
    @Autowired
    private J p;
    @Autowired
    private f q;
    @Autowired
    private com.tplink.smb.omada.manager.common.b.a.c.d r;
    @Autowired
    private e s;
    @Autowired
    @Qualifier(value="setMsgThreadPool")
    private ThreadPoolExecutor t;
    @Autowired
    private dN u;
    @Autowired
    @Lazy
    public dO g;
    @Autowired
    private x v;

    public void a(RebuildDTO rebuildDto) {
        long startTime = System.currentTimeMillis();
        com.tplink.smb.omada.manager.j.a.a.c omadacId = new com.tplink.smb.omada.manager.j.a.a.c(rebuildDto.getOmadacId());
        G deviceMac = new G(rebuildDto.getDeviceMac());
        EcspFirstVersionEnum ecspFirstVersionEnum = EcspVersion.getFirstVersion((String)rebuildDto.getEcspVersion());
        BaseRebuildReqBody rebuildReqBody = rebuildDto.getRebuildReqBody();
        if (rebuildReqBody == null) {
            h.error("rebuild for omadacId {} & mac {} failed, rebuildReqBody is null, reply rebuild fail", (Object)omadacId, (Object)deviceMac);
            this.a(omadacId, deviceMac, ecspFirstVersionEnum, rebuildDto);
            return;
        }
        if (rebuildReqBody.getConfigVersion() == null && !DeviceTypeEnum.d.equals((Object)rebuildDto.getDeviceType())) {
            h.error("rebuild for omadacId {} & mac {} failed, configVersion is null, reply rebuild fail", (Object)omadacId, (Object)deviceMac);
            this.a(omadacId, deviceMac, ecspFirstVersionEnum, rebuildDto);
            return;
        }
        Optional deviceImageOptional = this.b.a(omadacId, deviceMac);
        if (!deviceImageOptional.isPresent()) {
            h.info("rebuild for omadacId {} & mac {} failed, can't find deviceImage, reply rebuild fail", (Object)omadacId, (Object)deviceMac);
            this.a(omadacId, deviceMac, ecspFirstVersionEnum, rebuildDto);
            return;
        }
        com.tplink.smb.omada.manager.device.domain.model.deviceimage.d deviceImage = (com.tplink.smb.omada.manager.device.domain.model.deviceimage.d)deviceImageOptional.get();
        if (!this.j.a(deviceImage)) {
            h.info("{} {} is not in whitelist, reply rebuild failed", (Object)deviceImage.am(), (Object)deviceMac);
            this.a(omadacId, deviceMac, ecspFirstVersionEnum, rebuildDto);
            return;
        }
        if (!Objects.equals((Object)com.tplink.smb.omada.manager.license.domain.model.b.a, (Object)this.a(deviceImage))) {
            h.info("{} {} is unActive, reply rebuild failed", (Object)deviceImage.am(), (Object)deviceMac);
            this.a(omadacId, deviceMac, ecspFirstVersionEnum, rebuildDto);
            return;
        }
        if (Boolean.TRUE.equals(deviceImage.aQ())) {
            h.info("Rebuild for omadacId {} & mac {} failed, device account version is misMatch, reply rebuild fail.", (Object)omadacId, (Object)deviceMac);
            this.a(omadacId, deviceMac, ecspFirstVersionEnum, rebuildDto);
            return;
        }
        if (!this.b(deviceImage)) {
            if (h.isWarnEnabled()) {
                h.warn("rebuild for omadacId {} & mac {} failed, status[{}] is not Connected or HeartbeatMissed, reply rebuild fail", new Object[]{omadacId, deviceMac, deviceImage.at()});
            }
            this.a(omadacId, deviceMac, ecspFirstVersionEnum, rebuildDto);
            return;
        }
        this.a(deviceImage, omadacId, deviceMac, ecspFirstVersionEnum, rebuildDto);
        long endTime = System.currentTimeMillis();
        h.debug("rebuild device {} cost time: {}", (Object)deviceMac, (Object)(endTime - startTime));
    }

    private com.tplink.smb.omada.manager.license.domain.model.b a(com.tplink.smb.omada.manager.device.domain.model.deviceimage.d deviceImage) {
        if (!this.p.a(deviceImage.am(), deviceImage.ap())) {
            return com.tplink.smb.omada.manager.license.domain.model.b.a;
        }
        return this.i.b(deviceImage.am().a(), deviceImage.X());
    }

    private boolean b(com.tplink.smb.omada.manager.device.domain.model.deviceimage.d deviceImage) {
        if (deviceImage.y()) {
            return false;
        }
        return deviceImage.t() || deviceImage.s();
    }

    private void a(com.tplink.smb.omada.manager.device.domain.model.deviceimage.d deviceImage, com.tplink.smb.omada.manager.j.a.a.c omadacId, G deviceMac, EcspFirstVersionEnum ecspFirstVersionEnum, RebuildDTO rebuildDto) {
        BaseRebuildReqBody rebuildReqBody = rebuildDto.getRebuildReqBody();
        com.tplink.smb.omada.manager.j.a.a.d siteId = deviceImage.ap();
        this.l.a(omadacId.a(), siteId.a(), () -> this.k.a(omadacId, deviceMac, () -> {
            h.debug("get lock success. omadac {}, device mac {}.", (Object)omadacId, (Object)deviceMac);
            com.tplink.smb.omada.manager.device.domain.model.message.set.dto.a configureVersion = this.c.c(omadacId, deviceMac);
            if (configureVersion == null) {
                h.error("handle rebuild from omadacId {} & mac {} failed, can't find configureVersion", (Object)omadacId, (Object)deviceMac);
                this.a(omadacId, deviceMac, ecspFirstVersionEnum, rebuildDto);
                return false;
            }
            boolean resetConfig = false;
            if (!DeviceTypeEnum.d.equals((Object)deviceImage.an())) {
                com.tplink.smb.omada.manager.device.domain.model.message.set.dto.a deviceReqVersion = com.tplink.smb.omada.manager.device.domain.model.message.set.dto.a.a().a(rebuildReqBody.getConfigVersion()).a();
                boolean bl2 = resetConfig = !configureVersion.a(deviceReqVersion) || deviceImage.ae();
                if (!resetConfig) {
                    resetConfig = this.q.a(omadacId, deviceMac.a());
                }
                if (!deviceImage.e()) {
                    h.info("not reset config for no compatible device rebuild, {} {}", (Object)deviceImage.am(), (Object)deviceImage.al());
                    resetConfig = false;
                }
            }
            int count = 0;
            if (resetConfig) {
                while (!this.m.a(false) && count < 100) {
                    try {
                        ++count;
                        TimeUnit.MILLISECONDS.sleep(100L);
                    }
                    catch (InterruptedException e2) {
                        Thread.currentThread().interrupt();
                        h.warn("Thread was interrupted when rebuild mac {}", (Object)deviceMac, (Object)e2);
                    }
                }
            }
            if (count >= 100) {
                h.info("Failed get adopt limiter, refused rebuild for device {} with omadac {}.", (Object)deviceMac, (Object)omadacId);
                this.a(omadacId, deviceMac, ecspFirstVersionEnum, rebuildDto);
                return false;
            }
            h.info("Success get adopt limiter device {} with count {}.", (Object)deviceMac, (Object)count);
            o device = this.n.a(omadacId, siteId, deviceMac).orElse(null);
            if (resetConfig && !this.a(deviceImage, device)) {
                h.debug("checkPwd fail, refused rebuild for device {} {}", (Object)omadacId, (Object)deviceMac);
                this.a(omadacId, deviceMac, ecspFirstVersionEnum, rebuildDto);
                return false;
            }
            switch (ecspFirstVersionEnum) {
                case V1: {
                    this.a(omadacId, deviceMac, rebuildDto, resetConfig, ecspFirstVersionEnum, device);
                    deviceImage.ah();
                    deviceImage.aY().e(com.tplink.smb.omada.manager.device.domain.model.rebuild.a.a);
                    this.v.b(deviceImage);
                    this.b.a(deviceImage);
                    break;
                }
                case V2: 
                case V3: {
                    this.a(omadacId, deviceMac, rebuildDto, resetConfig, ecspFirstVersionEnum, configureVersion, device, deviceImage);
                    deviceImage.aY().e(resetConfig ? com.tplink.smb.omada.manager.device.domain.model.rebuild.a.b : com.tplink.smb.omada.manager.device.domain.model.rebuild.a.a);
                    this.v.b(deviceImage);
                    this.b.a(deviceImage);
                    break;
                }
                default: {
                    h.info("error ecspFirstVersionEnum {}, device mac {} omadacId {} rebuildDTO {}.", new Object[]{ecspFirstVersionEnum, deviceMac, omadacId, rebuildDto});
                }
            }
            if (device != null) {
                this.r.a(omadacId, siteId, deviceMac.a(), device.l(), deviceImage.aX().q());
            }
            return true;
        }, () -> {
            h.info("rebuild failed because get deviceLock failed. omadac {}, device mac {}.", (Object)omadacId, (Object)deviceMac);
            return false;
        }), () -> {
            h.info("rebuild failed because get siteLock faield. omadac {}, site {}, device {}.", new Object[]{omadacId, siteId, deviceMac});
            return false;
        });
    }

    private boolean a(com.tplink.smb.omada.manager.device.domain.model.deviceimage.d deviceImage, o device) {
        com.tplink.smb.omada.manager.j.a.a.c omadacId = deviceImage.am();
        com.tplink.smb.omada.manager.j.a.a.d siteId = deviceImage.ap();
        G deviceMac = deviceImage.al();
        if (device == null) {
            h.warn("{} {} {} rebuild fail, can't find in db", new Object[]{omadacId, siteId, deviceMac});
            return false;
        }
        if (device.t() != null) {
            h.warn("{} {} {} refused rebuild, password not unique", new Object[]{omadacId, siteId, deviceMac});
            return false;
        }
        b adoptInfo = device.s();
        if (adoptInfo == null) {
            h.warn("{} {} {} rebuild fail, adoptInfo is null", new Object[]{omadacId, siteId, deviceMac});
            return false;
        }
        Optional<com.tplink.smb.omada.manager.configuration.domain.model.site.component.a.a.a> deviceAccountOptional = this.o.a(deviceImage.am(), deviceImage.ap()).map(com.tplink.smb.omada.manager.configuration.domain.model.site.component.a.b::r);
        if (!deviceAccountOptional.isPresent()) {
            h.warn("{} {} {} rebuild fail, can't find site device account", new Object[]{omadacId, siteId, deviceMac});
            return false;
        }
        String siteUser = deviceAccountOptional.get().c();
        String sitePwd = deviceAccountOptional.get().d();
        if (T.a((String)siteUser, (String)adoptInfo.a()) && T.a((String)sitePwd, (String)adoptInfo.b())) {
            return true;
        }
        h.warn("{} {} {} refused rebuild, user or password not same with site", new Object[]{omadacId, siteId, deviceMac});
        return false;
    }

    private void a(com.tplink.smb.omada.manager.j.a.a.c omadacId, G deviceMac, EcspFirstVersionEnum ecspFirstVersionEnum, RebuildDTO rebuildDTO) {
        String ecspVersion = com.tplink.smb.omada.manager.device.port.common.b.b.a(rebuildDTO.getDeviceType(), ecspFirstVersionEnum);
        BaseRebuildResponse replyBody = new BaseRebuildResponse();
        replyBody.setErrCode(Integer.valueOf(1));
        this.a.a(omadacId, deviceMac, (MessageBody)replyBody, ecspFirstVersionEnum, ecspVersion, rebuildDTO.getSequenceId());
    }

    private void a(com.tplink.smb.omada.manager.j.a.a.c omadacId, G deviceMac, RebuildDTO rebuildDTO, boolean resetConfig, EcspFirstVersionEnum ecspFirstVersionEnum, o device) {
        DeviceTypeEnum deviceTypeEnum = rebuildDTO.getDeviceType();
        String ecspVersion = com.tplink.smb.omada.manager.device.port.common.b.b.a(deviceTypeEnum, ecspFirstVersionEnum);
        BaseRebuildResponse replyBody = new BaseRebuildResponse();
        replyBody.setErrCode(Integer.valueOf(0));
        replyBody.setResetConfig(resetConfig ? com.tplink.smb.omada.manager.device.domain.model.rebuild.a.b : com.tplink.smb.omada.manager.device.domain.model.rebuild.a.a);
        h.info("send rebuild reply[reset={}] to omadacId {} & mac {}", new Object[]{resetConfig, omadacId, deviceMac});
        this.a.a(omadacId, deviceMac, (MessageBody)replyBody, ecspFirstVersionEnum, ecspVersion, rebuildDTO.getSequenceId());
        if (resetConfig) {
            h.info("rebuild syncFullConfig to omadacId {} & mac {}", (Object)omadacId, (Object)deviceMac);
            this.b(omadacId, deviceMac, deviceTypeEnum);
        } else {
            this.a(device);
        }
    }

    private <T extends BaseConfigRespBody> void a(com.tplink.smb.omada.manager.j.a.a.c omadacId, G mac, RebuildDTO rebuildDTO, boolean resetConfig, EcspFirstVersionEnum ecspFirstVersionEnum, com.tplink.smb.omada.manager.device.domain.model.message.set.dto.a configureVersion, o device, com.tplink.smb.omada.manager.device.domain.model.deviceimage.d deviceImage) {
        MessageBody body;
        com.tplink.smb.omada.manager.j.a.a.d siteId = device.n();
        G deviceMac = device.c_();
        DeviceTypeEnum deviceTypeEnum = rebuildDTO.getDeviceType();
        String ecspVersion = com.tplink.smb.omada.manager.device.port.common.b.b.a(deviceTypeEnum, ecspFirstVersionEnum);
        Long rebuildTime = System.currentTimeMillis();
        boolean needResult = Objects.nonNull(device.O()) && device.O().supportBaseCfgSync();
        CompletableFuture<BeforeSendConfigListDTO> configFuture = null;
        CompletableFuture<com.tplink.smb.omada.manager.device.application.message.c<ApConfigRespBody>> rebuildResult = null;
        Map<SetKey, Object> settingMap = null;
        long rebuildFullConfigTimeOut = 300000L;
        if (resetConfig) {
            settingMap = this.a(omadacId, device.c_(), deviceTypeEnum);
            Map<SetKey, Object> newSettingMap = this.g.a(settingMap);
            configFuture = this.g.a(newSettingMap, omadacId, deviceMac, deviceTypeEnum, rebuildTime, false, true, true, rebuildTime);
            switch (deviceTypeEnum) {
                case a: {
                    rebuildFullConfigTimeOut = 600000L;
                    break;
                }
                case c: {
                    break;
                }
                case b: {
                    rebuildFullConfigTimeOut = 600000L;
                    break;
                }
            }
            if (!A.l.d().equals(deviceImage.aW().b())) {
                this.a(deviceImage, rebuildDTO.getSequenceId(), rebuildFullConfigTimeOut);
            }
        }
        if ((body = this.a(settingMap, omadacId, mac, deviceTypeEnum, configureVersion, deviceImage)) != null) {
            h.info("send v2 rebuild reply[reset={}] to omadacId {} & mac {}", new Object[]{resetConfig, omadacId, mac});
            if (needResult) {
                Class<ApConfigRespBody> deviceRespBodyClazz = null;
                switch (deviceTypeEnum) {
                    case a: {
                        deviceRespBodyClazz = ApConfigRespBody.class;
                        break;
                    }
                    case c: {
                        deviceRespBodyClazz = OswConfigRespBody.class;
                        break;
                    }
                    case b: {
                        deviceRespBodyClazz = OsgConfigureRespBody.class;
                        break;
                    }
                }
                rebuildResult = this.a.a(omadacId, mac, body, ecspVersion, rebuildDTO.getSequenceId(), deviceRespBodyClazz, rebuildFullConfigTimeOut);
            } else if (A.l.d().equals(deviceImage.aW().b())) {
                this.a.a(deviceImage, rebuildDTO, this.a(settingMap, configureVersion, deviceImage), this.a(settingMap, deviceImage), ecspFirstVersionEnum, ecspVersion, configureVersion, resetConfig);
            } else {
                this.a.a(omadacId, mac, body, ecspFirstVersionEnum, ecspVersion, rebuildDTO.getSequenceId());
            }
        }
        if (!resetConfig) {
            this.a(device);
        } else if (Objects.nonNull(configFuture) && needResult) {
            configFuture.thenCombineAsync(rebuildResult, (preSendConfigDTO, respResult) -> this.k.a(omadacId, deviceMac, () -> {
                h.debug("before handle rebuild result for {} {}", (Object)omadacId, (Object)deviceMac);
                this.g.a(omadacId, deviceMac, deviceTypeEnum, true, System.currentTimeMillis(), preSendConfigDTO.getDeployingComponentMap(), new AtomicInteger(rebuildDTO.getSequenceId()), respResult);
                return true;
            }, () -> {
                h.warn("failed handle rebuild response to {} {}, can't get lock", (Object)omadacId, (Object)deviceMac);
                return false;
            }), (Executor)this.t);
        }
    }

    private void a(o device) {
        com.tplink.smb.omada.manager.device.domain.model.device.ap.c ap2;
        boolean needSaveAp;
        if (DeviceTypeEnum.a.equals((Object)device.l()) && (needSaveAp = this.d.c(ap2 = (com.tplink.smb.omada.manager.device.domain.model.device.ap.c)device))) {
            this.n.a(ap2);
        }
    }

    @Nullable
    private Map<SetKey, Object> a(com.tplink.smb.omada.manager.j.a.a.c omadacId, G mac, DeviceTypeEnum deviceTypeEnum) {
        switch (deviceTypeEnum) {
            case a: {
                return this.d.b(omadacId, mac);
            }
            case c: {
                return this.e.b(omadacId, mac);
            }
            case b: {
                return this.f.b(omadacId, mac);
            }
            case d: {
                return Collections.emptyMap();
            }
        }
        h.info("unKnow deviceType {}, omadac {}, device {}.", new Object[]{deviceTypeEnum, omadacId, mac});
        return null;
    }

    @Nullable
    private MessageBody a(Map<SetKey, Object> settingMap, com.tplink.smb.omada.manager.j.a.a.c omadacId, G mac, DeviceTypeEnum deviceTypeEnum, com.tplink.smb.omada.manager.device.domain.model.message.set.dto.a configureVersion, com.tplink.smb.omada.manager.device.domain.model.deviceimage.d deviceImage) {
        switch (deviceTypeEnum) {
            case a: {
                return this.e(settingMap, configureVersion, deviceImage);
            }
            case c: {
                return this.d(settingMap, configureVersion, deviceImage);
            }
            case b: {
                return this.c(settingMap, configureVersion, deviceImage);
            }
            case d: {
                return this.b(settingMap, configureVersion, deviceImage);
            }
        }
        h.info("unKnow deviceType {}, omadac {}, device {}.", new Object[]{deviceTypeEnum, omadacId, mac});
        return null;
    }

    private OswRebuildConfigV2Body a(Map<SetKey, Object> settingMap, com.tplink.smb.omada.manager.device.domain.model.deviceimage.d deviceImage) {
        OswRebuildConfigV2Body oswRebuildConfigV2Body = new OswRebuildConfigV2Body();
        if (CollectionUtils.isEmpty(settingMap)) {
            oswRebuildConfigV2Body.setErrorCode(Integer.valueOf(0));
            oswRebuildConfigV2Body.setReset(Integer.valueOf(1));
            return oswRebuildConfigV2Body;
        }
        oswRebuildConfigV2Body.setErrorCode(Integer.valueOf(0));
        oswRebuildConfigV2Body.setReset(Integer.valueOf(0));
        if (settingMap.get(OswSetKeyEnum.TIME_SETTING) instanceof TimeConfig && settingMap.get(OswSetKeyEnum.USER_ACCOUNT) instanceof UserAccountConfig) {
            OswSetKeyEnum.TIME_SETTING.setContent(settingMap.get(OswSetKeyEnum.TIME_SETTING), (BaseConfigBody)oswRebuildConfigV2Body);
            OswSetKeyEnum.USER_ACCOUNT.setContent(settingMap.get(OswSetKeyEnum.USER_ACCOUNT), (BaseConfigBody)oswRebuildConfigV2Body);
        } else {
            h.warn("error when fillEsRebuildRespBody {} {}", (Object)deviceImage.am(), (Object)deviceImage.al());
        }
        oswRebuildConfigV2Body.setConfigVersion(null);
        oswRebuildConfigV2Body.setConfigVersionInc(null);
        return oswRebuildConfigV2Body;
    }

    private OswConfigBody a(Map<SetKey, Object> settingMap, com.tplink.smb.omada.manager.device.domain.model.message.set.dto.a configureVersion, com.tplink.smb.omada.manager.device.domain.model.deviceimage.d deviceImage) {
        OswConfigBody oswConfigBody = new OswConfigBody();
        if (CollectionUtils.isEmpty(settingMap)) {
            return oswConfigBody;
        }
        this.s.a(settingMap, (BaseConfigBody)oswConfigBody, deviceImage);
        oswConfigBody.setConfigVersion(Integer.valueOf(configureVersion.c()));
        oswConfigBody.setConfigVersionInc(null);
        return oswConfigBody;
    }

    private OltRebuildConfigV2Body b(Map<SetKey, Object> settingMap, com.tplink.smb.omada.manager.device.domain.model.message.set.dto.a configureVersion, com.tplink.smb.omada.manager.device.domain.model.deviceimage.d deviceImage) {
        OltRebuildConfigV2Body oltRebuildConfigV2Body = new OltRebuildConfigV2Body();
        if (CollectionUtils.isEmpty(settingMap)) {
            oltRebuildConfigV2Body.setErrorCode(Integer.valueOf(0));
            oltRebuildConfigV2Body.setReset(Integer.valueOf(1));
            return oltRebuildConfigV2Body;
        }
        oltRebuildConfigV2Body.setErrorCode(Integer.valueOf(0));
        oltRebuildConfigV2Body.setReset(Integer.valueOf(0));
        this.s.a(settingMap, (BaseConfigBody)oltRebuildConfigV2Body, deviceImage);
        oltRebuildConfigV2Body.setConfigVersion(Integer.valueOf(configureVersion.c()));
        oltRebuildConfigV2Body.setConfigVersionInc(null);
        return oltRebuildConfigV2Body;
    }

    private OsgRebuildConfigV2Body c(Map<SetKey, Object> settingMap, com.tplink.smb.omada.manager.device.domain.model.message.set.dto.a configureVersion, com.tplink.smb.omada.manager.device.domain.model.deviceimage.d deviceImage) {
        OsgRebuildConfigV2Body osgRebuildConfigV2Body = new OsgRebuildConfigV2Body();
        if (CollectionUtils.isEmpty(settingMap)) {
            osgRebuildConfigV2Body.setErrorCode(Integer.valueOf(0));
            osgRebuildConfigV2Body.setReset(Integer.valueOf(1));
            return osgRebuildConfigV2Body;
        }
        osgRebuildConfigV2Body.setErrorCode(Integer.valueOf(0));
        osgRebuildConfigV2Body.setReset(Integer.valueOf(0));
        if (Objects.nonNull(deviceImage.aX()) && deviceImage.aX().j()) {
            osgRebuildConfigV2Body.setNeedResult(Integer.valueOf(1));
        }
        this.s.a(settingMap, (BaseConfigBody)osgRebuildConfigV2Body, deviceImage);
        osgRebuildConfigV2Body.setConfigVersion(Integer.valueOf(configureVersion.c()));
        osgRebuildConfigV2Body.setConfigVersionInc(null);
        return osgRebuildConfigV2Body;
    }

    private OswRebuildConfigV2Body d(Map<SetKey, Object> settingMap, com.tplink.smb.omada.manager.device.domain.model.message.set.dto.a configureVersion, com.tplink.smb.omada.manager.device.domain.model.deviceimage.d deviceImage) {
        OswRebuildConfigV2Body oswRebuildConfigV2Body = new OswRebuildConfigV2Body();
        if (CollectionUtils.isEmpty(settingMap)) {
            oswRebuildConfigV2Body.setErrorCode(Integer.valueOf(0));
            oswRebuildConfigV2Body.setReset(Integer.valueOf(1));
            return oswRebuildConfigV2Body;
        }
        oswRebuildConfigV2Body.setErrorCode(Integer.valueOf(0));
        oswRebuildConfigV2Body.setReset(Integer.valueOf(0));
        if (Objects.nonNull(deviceImage.aX()) && deviceImage.aX().j()) {
            oswRebuildConfigV2Body.setNeedResult(Integer.valueOf(1));
        }
        this.s.a(settingMap, (BaseConfigBody)oswRebuildConfigV2Body, deviceImage);
        oswRebuildConfigV2Body.setConfigVersion(Integer.valueOf(configureVersion.c()));
        oswRebuildConfigV2Body.setConfigVersionInc(null);
        return oswRebuildConfigV2Body;
    }

    private ApRebuildConfigV2Body e(Map<SetKey, Object> settingMap, com.tplink.smb.omada.manager.device.domain.model.message.set.dto.a configureVersion, com.tplink.smb.omada.manager.device.domain.model.deviceimage.d deviceImage) {
        ApRebuildConfigV2Body apRebuildConfigV2Body = new ApRebuildConfigV2Body();
        if (CollectionUtils.isEmpty(settingMap)) {
            apRebuildConfigV2Body.setErrorCode(Integer.valueOf(0));
            apRebuildConfigV2Body.setReset(Integer.valueOf(1));
            return apRebuildConfigV2Body;
        }
        apRebuildConfigV2Body.setErrorCode(Integer.valueOf(0));
        apRebuildConfigV2Body.setReset(Integer.valueOf(0));
        if (deviceImage.aX().j()) {
            apRebuildConfigV2Body.setNeedResult(Integer.valueOf(1));
        }
        this.s.a(settingMap, (BaseConfigBody)apRebuildConfigV2Body, deviceImage);
        apRebuildConfigV2Body.setConfigVersion(Integer.valueOf(configureVersion.c()));
        apRebuildConfigV2Body.setConfigVersionInc(null);
        return apRebuildConfigV2Body;
    }

    private void b(com.tplink.smb.omada.manager.j.a.a.c omadacId, G deviceMac, DeviceTypeEnum deviceTypeEnum) {
        switch (deviceTypeEnum) {
            case a: {
                this.d.a(omadacId, deviceMac);
                break;
            }
            case c: {
                this.e.a(omadacId, deviceMac);
                break;
            }
            case b: {
                this.f.a(omadacId, deviceMac);
                break;
            }
            case d: {
                h.error("no need sync full config to omadacId {} & mac {}, deviceType:{}", new Object[]{omadacId, deviceMac, deviceTypeEnum});
                break;
            }
            default: {
                h.error("rebuild sync full config to omadacId {} & mac {}, but error deviceType:{}", new Object[]{omadacId, deviceMac, deviceTypeEnum});
            }
        }
    }

    @Autowired
    public void a(com.tplink.smb.omada.manager.common.d.b managerDeviceLockFactory) {
        this.k = managerDeviceLockFactory;
    }

    @Autowired
    public void a(com.tplink.smb.omada.lock.a.c siteLockFactory) {
        this.l = siteLockFactory;
    }

    @Autowired
    public void a(n adoptInstanceSyncControl) {
        this.m = adoptInstanceSyncControl;
    }

    private void a(com.tplink.smb.omada.manager.device.domain.model.deviceimage.d deviceImage, Integer seqId, long timeOutMs) {
        deviceImage.a(DeviceStatusEnum.d);
        long curTime = 0L;
        try {
            Long existedConfiguringTime;
            deviceImage.g(seqId);
            if (Objects.nonNull(seqId)) {
                deviceImage.d(seqId);
            }
            long existedTime = (existedConfiguringTime = deviceImage.aC()) == null ? 0L : existedConfiguringTime;
            curTime = System.currentTimeMillis() + timeOutMs;
            if (curTime >= existedTime) {
                deviceImage.a((Long)curTime);
            }
        }
        catch (Exception e2) {
            h.warn("device {} rebuild with full config, change status to configuring error", (Object)deviceImage.al(), (Object)e2);
        }
        this.b.a(deviceImage);
        h.info("device {} rebuild with full config, change status to configuring with seqId {} timeout is {}", new Object[]{deviceImage.al(), seqId, curTime});
    }
}

