/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.device.domain.model.message.ecsptool;

import com.tplink.smb.omada.common.constant.DeviceTypeEnum;
import com.tplink.smb.omada.common.obfuscate.KeepClass;
import com.tplink.smb.omada.common.obfuscate.KeepMethod;
import com.tplink.smb.omada.common.util.x;
import com.tplink.smb.omada.device.manage.message.MessageType;
import com.tplink.smb.omada.device.manage.message.body.eap.EapGetRespBody;
import com.tplink.smb.omada.device.manage.message.body.manage.BaseConfigBody;
import com.tplink.smb.omada.device.manage.message.body.manage.BaseConfigRespBody;
import com.tplink.smb.omada.device.manage.message.body.manage.BaseGetBody;
import com.tplink.smb.omada.device.manage.message.body.osg.OsgGetRespBody;
import com.tplink.smb.omada.device.manage.message.body.osw.OswGetRespBody;
import com.tplink.smb.omada.manager.device.domain.model.device.G;
import com.tplink.smb.omada.manager.device.domain.model.deviceimage.d;
import com.tplink.smb.omada.manager.device.domain.model.deviceimage.l;
import com.tplink.smb.omada.manager.device.domain.model.message.a;
import com.tplink.smb.omada.manager.device.domain.model.message.ecsptool.EcspToolEapGetBody;
import com.tplink.smb.omada.manager.device.domain.model.message.ecsptool.EcspToolOsgGetBody;
import com.tplink.smb.omada.manager.device.domain.model.message.ecsptool.EcspToolOswGetBody;
import com.tplink.smb.omada.manager.device.domain.model.message.set.c;
import com.tplink.smb.omada.manager.device.domain.model.message.set.dto.DealConfigVersionDTO;
import com.tplink.smb.omada.manager.device.domain.model.message.set.dto.GenConfigBodyDTO;
import com.tplink.smb.omada.manager.device.domain.model.message.set.dto.SendSetMsgDTO;
import com.tplink.smb.omada.manager.device.domain.model.message.set.e;
import com.tplink.smb.omada.manager.device.domain.model.message.set.j;
import com.tplink.smb.omada.manager.ecspplugin.api.EcspPluginInternalApiService;
import com.tplink.smb.omada.manager.ecspplugin.api.dto.EcspToolSendMsgResult;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@KeepClass
public class EcspToolDeviceMsgService
implements EcspPluginInternalApiService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EcspToolDeviceMsgService.class);
    @Autowired
    private l deviceImageRepository;
    @Autowired
    private a nextSequenceIdService;
    @Autowired
    private j sendSetMsgService;
    @Autowired
    private e deviceSetMsgService;
    @Autowired
    private com.tplink.smb.omada.manager.device.domain.model.message.get.d sendGetMsgService;
    @Autowired
    private c configureVersionFactory;

    @KeepMethod
    public EcspToolSendMsgResult sendMsgToDeviceSyncByEcspTool(Map<String, Object> settingMap, String macStr, String omadacIdStr, String deviceTypeEnumStr, Integer messageTypeCode, boolean configVersionInc) {
        G mac = new G(macStr);
        com.tplink.smb.omada.manager.j.a.a.c omadacId = new com.tplink.smb.omada.manager.j.a.a.c(omadacIdStr);
        DeviceTypeEnum deviceTypeEnum = DeviceTypeEnum.a((String)deviceTypeEnumStr);
        MessageType messageType = MessageType.resolve((int)messageTypeCode);
        Optional deviceImageOptional = this.deviceImageRepository.a(omadacId, mac);
        if (!deviceImageOptional.isPresent()) {
            log.warn("Device {} OmadacId {} not exist, failed to send message to target device", (Object)mac, (Object)omadacId);
            CompletableFuture.completedFuture(com.tplink.smb.omada.manager.device.application.message.c.a);
        }
        d deviceImage = (d)deviceImageOptional.get();
        log.info("Receive send message request from ecsp plugin, trying to send messageType:{}, content: {}, to device {}", new Object[]{messageType, settingMap, macStr});
        switch (messageType) {
            case SET_REQUEST: {
                BaseConfigBody configBody = new BaseConfigBody();
                settingMap.forEach((arg_0, arg_1) -> ((BaseConfigBody)configBody).setAdditionalProperty(arg_0, arg_1));
                configBody.setSequenceId(Integer.valueOf(this.nextSequenceIdService.a(omadacId, mac)));
                if (configVersionInc) {
                    configBody.setConfigVersionInc(Integer.valueOf(1));
                }
                GenConfigBodyDTO genConfigBodyDTO = this.a(configBody, deviceTypeEnum, deviceImage);
                com.tplink.smb.omada.manager.device.application.message.c<BaseConfigRespBody> resp = this.sendSetMsgService.sendSyncByEcspTool(SendSetMsgDTO.builder().deviceMac(mac).ecspVersion(deviceImage.aX().q()).deviceRespClazz(BaseConfigRespBody.class).configBody(genConfigBodyDTO.getConfigBody()).omadacId(omadacId).ecspFirstVersion(deviceImage.H()).timeoutMs(60000L).configVersion(genConfigBodyDTO.getConfigureVersion() == null ? null : Integer.valueOf(genConfigBodyDTO.getConfigureVersion().c())).build());
                if (!resp.c()) {
                    return EcspToolSendMsgResult.builder().b(Boolean.valueOf(resp.e())).a(Boolean.valueOf(resp.c())).a();
                }
                BaseConfigRespBody deviceResponse = resp.d();
                HashMap<String, Object> responseMap = new HashMap<String, Object>(deviceResponse.getAdditionalProperties());
                responseMap.put("sequenceId", deviceResponse.getSequenceId());
                responseMap.put("errcode", deviceResponse.getErrcode());
                responseMap.put("errmsg", deviceResponse.getErrmsg());
                if (deviceResponse.getConfigVersion() != null) {
                    responseMap.put("configVersion", deviceResponse.getConfigVersion());
                }
                return EcspToolSendMsgResult.builder().a(x.a(responseMap)).a(Boolean.valueOf(resp.c())).b(Boolean.valueOf(resp.e())).b(resp.d().getErrcode()).a(resp.d().getSequenceId()).c(genConfigBodyDTO.getConfigureVersion() == null ? null : Integer.valueOf(genConfigBodyDTO.getConfigureVersion().c())).a();
            }
            case GET_REQUEST: {
                switch (deviceTypeEnum) {
                    case a: {
                        EcspToolEapGetBody eapGetBody = new EcspToolEapGetBody();
                        settingMap.forEach(eapGetBody::setCustomData);
                        eapGetBody.setSequenceId(this.nextSequenceIdService.a(omadacId, mac));
                        com.tplink.smb.omada.manager.device.application.message.c<EapGetRespBody> resp = this.sendGetMsgService.a(omadacId, mac, (BaseGetBody)eapGetBody, EapGetRespBody.class, deviceImage.H());
                        if (!resp.c()) {
                            return EcspToolSendMsgResult.builder().b(Boolean.valueOf(resp.e())).a(Boolean.valueOf(resp.c())).a();
                        }
                        return EcspToolSendMsgResult.builder().a(x.a((Object)resp.d().getAdditionalProperties())).a(Boolean.valueOf(resp.c())).b(Boolean.valueOf(resp.e())).b(resp.d().getErrcode()).a(resp.d().getSequenceId()).c(null).a();
                    }
                    case c: {
                        EcspToolOswGetBody oswGetBody = new EcspToolOswGetBody();
                        settingMap.forEach(oswGetBody::setCustomData);
                        oswGetBody.setSequenceId(this.nextSequenceIdService.a(omadacId, mac));
                        com.tplink.smb.omada.manager.device.application.message.c<OswGetRespBody> resp = this.sendGetMsgService.c(omadacId, mac, (BaseGetBody)oswGetBody, OswGetRespBody.class, deviceImage.H());
                        if (!resp.c()) {
                            return EcspToolSendMsgResult.builder().b(Boolean.valueOf(resp.e())).a(Boolean.valueOf(resp.c())).a();
                        }
                        return EcspToolSendMsgResult.builder().a(x.a((Object)resp.d().getAdditionalProperties())).a(Boolean.valueOf(resp.c())).b(Boolean.valueOf(resp.e())).b(resp.d().getErrcode()).a(resp.d().getSequenceId()).c(null).a();
                    }
                    case b: {
                        EcspToolOsgGetBody osgGetBody = new EcspToolOsgGetBody();
                        settingMap.forEach(osgGetBody::setCustomData);
                        osgGetBody.setSequenceId(this.nextSequenceIdService.a(omadacId, mac));
                        com.tplink.smb.omada.manager.device.application.message.c<OsgGetRespBody> resp = this.sendGetMsgService.b(omadacId, mac, (BaseGetBody)osgGetBody, OsgGetRespBody.class, deviceImage.H());
                        if (!resp.c()) {
                            return EcspToolSendMsgResult.builder().b(Boolean.valueOf(resp.e())).a(Boolean.valueOf(resp.c())).a();
                        }
                        return EcspToolSendMsgResult.builder().a(x.a((Object)resp.d().getAdditionalProperties())).a(Boolean.valueOf(resp.c())).b(Boolean.valueOf(resp.e())).b(resp.d().getErrcode()).a(resp.d().getSequenceId()).c(null).a();
                    }
                }
                return EcspToolSendMsgResult.builder().a(Boolean.valueOf(false)).b(Boolean.valueOf(false)).a();
            }
        }
        return EcspToolSendMsgResult.builder().a(Boolean.valueOf(false)).b(Boolean.valueOf(false)).a();
    }

    private GenConfigBodyDTO a(BaseConfigBody configBody, DeviceTypeEnum deviceTypeEnum, d deviceImage) {
        if (configBody == null) {
            return GenConfigBodyDTO.FAIL;
        }
        DealConfigVersionDTO dealConfigVersionDTO = this.a(deviceImage.am(), deviceImage.al(), configBody);
        if (!dealConfigVersionDTO.isSuccess()) {
            return GenConfigBodyDTO.FAIL;
        }
        return new GenConfigBodyDTO(dealConfigVersionDTO.getConfigureVersion(), configBody);
    }

    private DealConfigVersionDTO a(com.tplink.smb.omada.manager.j.a.a.c omadacId, G deviceMac, BaseConfigBody configBody) {
        configBody.setSequenceId(Integer.valueOf(this.nextSequenceIdService.a(omadacId, deviceMac)));
        long startTime = System.currentTimeMillis();
        if (configBody.shouldIncConfigVersion()) {
            com.tplink.smb.omada.manager.device.domain.model.message.set.dto.a version = this.configureVersionFactory.a(omadacId, deviceMac);
            if (version == null) {
                log.info("can't get next configVersion for omadacId {} & mac {}, skip send setMsg", (Object)omadacId, (Object)deviceMac);
                return DealConfigVersionDTO.FAIL;
            }
            log.debug("end deal configVersion for mac {}, time cost {}", (Object)deviceMac, (Object)(System.currentTimeMillis() - startTime));
            return new DealConfigVersionDTO(version);
        }
        return new DealConfigVersionDTO(null);
    }
}

