/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.device.domain.model.mesh.failover;

import com.tplink.nbu.common.pii.utils.PIIJacksonUtil;
import com.tplink.smb.omada.common.access.OperationResponse;
import com.tplink.smb.omada.common.constant.CloudBasedProperties;
import com.tplink.smb.omada.common.constant.DeviceTypeEnum;
import com.tplink.smb.omada.common.util.W;
import com.tplink.smb.omada.device.manage.message.config.SetKey;
import com.tplink.smb.omada.device.manage.message.config.ap.ApSetKeyEnum;
import com.tplink.smb.omada.device.manage.message.config.ap.mesh.CandidateParentScanChannel;
import com.tplink.smb.omada.device.manage.message.config.ap.mesh.GetCandidateParents;
import com.tplink.smb.omada.device.manage.message.config.ap.mesh.Mesh;
import com.tplink.smb.omada.manager.device.domain.model.device.G;
import com.tplink.smb.omada.manager.device.domain.model.device.ap.A;
import com.tplink.smb.omada.manager.device.domain.model.device.ap.M;
import com.tplink.smb.omada.manager.device.domain.model.device.aq;
import com.tplink.smb.omada.manager.device.domain.model.deviceimage.ap.wireless.CandidateParentApBO;
import com.tplink.smb.omada.manager.device.domain.model.deviceimage.ap.wireless.CandidateParentApRadioInfoBO;
import com.tplink.smb.omada.manager.device.domain.model.deviceimage.ap.wireless.WirelessLinkInfo;
import com.tplink.smb.omada.manager.device.domain.model.mesh.a;
import com.tplink.smb.omada.manager.device.domain.model.mesh.c;
import com.tplink.smb.omada.manager.device.domain.model.mesh.dto.CheckFixMeshLinkDTO;
import com.tplink.smb.omada.manager.device.domain.model.mesh.dto.MeshLinkDTO;
import com.tplink.smb.omada.manager.device.domain.model.mesh.f;
import com.tplink.smb.omada.manager.device.domain.model.mesh.failover.MeshFailOverProperties;
import com.tplink.smb.omada.manager.device.domain.model.mesh.h;
import com.tplink.smb.omada.manager.device.domain.model.message.set.e;
import com.tplink.smb.omada.manager.j.a.a.d;
import jakarta.annotation.Nonnull;
import jakarta.annotation.PostConstruct;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
@com.tplink.smb.omada.common.spring.b
public class b {
    @Generated
    private static final Logger a = LoggerFactory.getLogger(b.class);
    @Autowired
    private com.tplink.smb.omada.manager.device.domain.model.mesh.failover.a b;
    @Autowired
    private MeshFailOverProperties c;
    @Autowired
    @Qualifier(value="meshWorkGroup")
    private ThreadPoolExecutor d;
    @Autowired
    private com.tplink.smb.omada.manager.device.domain.model.deviceimage.ap.f e;
    @Autowired
    private MeshFailOverProperties f;
    @Autowired
    private f g;
    @Autowired
    private e h;
    @Autowired
    private c i;
    @Autowired
    private com.tplink.smb.omada.manager.common.d.b j;
    @Autowired
    private com.tplink.smb.omada.manager.restore.port.a.c k;
    @Autowired
    private M l;
    @Autowired
    private a m;
    @Autowired
    private CloudBasedProperties n;
    @Autowired
    private com.tplink.smb.omada.judgement.a.e o;
    private static final long p = 35000L;
    private static final long q = 60000L;
    private static final long r = TimeUnit.SECONDS.toMillis(15L);

    @PostConstruct
    private void a() {
        if (com.tplink.smb.omada.common.f.b.a == this.n.getCbcType()) {
            a.info("failover task will not run on Essential");
            return;
        }
        com.tplink.smb.omada.common.concurrent.thread.b.a(this::b, (long)this.c.getInitDelayMs(), (long)this.c.getIntervalMs(), (TimeUnit)TimeUnit.MILLISECONDS);
    }

    private void b() {
        try {
            while (!Thread.currentThread().isInterrupted()) {
                List<aq> deviceIds = this.b.a(this.c.getPollCount());
                a.debug("failover poll {} devices to handle", (Object)deviceIds.size());
                if (!CollectionUtils.isEmpty(deviceIds)) {
                    for (aq deviceId : deviceIds) {
                        this.d.execute(() -> {
                            try {
                                this.b(deviceId);
                            }
                            catch (Exception e2) {
                                a.error("handle failover for {} error,", (Object)deviceId, (Object)e2);
                            }
                        });
                    }
                    continue;
                }
                break;
            }
        }
        catch (Exception e2) {
            a.error("failover task error", (Throwable)e2);
        }
    }

    private void b(aq omadacDeviceId) {
        com.tplink.smb.omada.manager.j.a.a.c omadacId = omadacDeviceId.a();
        G deviceMac = omadacDeviceId.b();
        if (this.k.b(omadacId.a())) {
            a.info("{} is restoring, stop deal failover for {}", (Object)omadacId, (Object)deviceMac);
            return;
        }
        com.tplink.smb.omada.manager.device.domain.model.deviceimage.ap.wireless.f wirelessApImage = this.e.a(omadacId, deviceMac).map(apImage -> {
            if (apImage.be()) {
                return (com.tplink.smb.omada.manager.device.domain.model.deviceimage.ap.wireless.f)apImage;
            }
            return null;
        }).orElse(null);
        if (wirelessApImage == null) {
            a.debug("stop failover {}, apImage not exist or not wireless", (Object)omadacDeviceId);
            return;
        }
        if (!this.d(omadacDeviceId, wirelessApImage)) {
            return;
        }
        if (wirelessApImage.C()) {
            this.a(omadacDeviceId, wirelessApImage);
        } else if (wirelessApImage.q()) {
            this.b(omadacDeviceId, wirelessApImage);
        } else {
            a.info("discard failover {}, ap status[{}] is not fit failover", (Object)omadacDeviceId, (Object)PIIJacksonUtil.parseToStr((Object)((Object)wirelessApImage.cz())));
        }
    }

    private void a(aq omadacDeviceId, com.tplink.smb.omada.manager.device.domain.model.deviceimage.ap.wireless.f wirelessApImage) {
        com.tplink.smb.omada.manager.j.a.a.c omadacId = wirelessApImage.am();
        G childMac = wirelessApImage.al();
        G currentParent = com.tplink.smb.omada.manager.device.domain.model.mesh.h.a(wirelessApImage);
        if (currentParent == null) {
            a.debug("failover priority scan {}, can't get current parent, try next time", (Object)omadacDeviceId);
            this.a(omadacDeviceId, true);
            return;
        }
        if (!this.g.b(wirelessApImage.am(), wirelessApImage.ap(), wirelessApImage.bd().V())) {
            a.debug("failover priority scan {}, site mesh setting or failover is disable, deal next time", (Object)omadacDeviceId);
            this.a(omadacDeviceId, true);
            return;
        }
        Optional<com.tplink.smb.omada.manager.device.domain.model.device.ap.c> childApOpt = this.l.a(omadacId, childMac);
        G priorityMac = childApOpt.map(ap2 -> ap2.dl().M()).map(A::h).map(G::new).orElse(null);
        if (priorityMac == null) {
            a.info("discard failover priority scan {}, ap has no priority", (Object)omadacDeviceId);
            return;
        }
        if (priorityMac.a(currentParent)) {
            a.info("no need failover priority scan {}, currentParent[{}] same with priority", (Object)omadacDeviceId, (Object)currentParent);
        } else {
            int radioId = childApOpt.map(ap2 -> ap2.dl().M()).map(A::i).orElse(1);
            this.a(omadacDeviceId, wirelessApImage, priorityMac, radioId);
        }
    }

    private void a(aq childOmadacDeviceId, com.tplink.smb.omada.manager.device.domain.model.deviceimage.ap.wireless.f wirelessApImage, G priorityMac, int radioId) {
        com.tplink.smb.omada.manager.device.domain.model.deviceimage.ap.a priorityImage = this.e.a(childOmadacDeviceId.a(), priorityMac).orElse(null);
        if (priorityImage == null || !priorityImage.C()) {
            a.debug("discard failover priority scan {}, priorityAP {} not connected", (Object)childOmadacDeviceId, (Object)priorityMac);
            this.c(childOmadacDeviceId);
            return;
        }
        Integer chan = com.tplink.smb.omada.manager.device.domain.model.mesh.h.a(priorityImage, radioId);
        if (chan == null) {
            a.debug("failover priority scan {}, priorityAP {} can't get radio[{}] channel, try next time", new Object[]{childOmadacDeviceId, priorityMac, radioId});
            this.a(childOmadacDeviceId, true);
            return;
        }
        int radioIdToScan = com.tplink.smb.omada.manager.device.domain.model.mesh.h.a(wirelessApImage, (int)chan, radioId);
        if (radioIdToScan < 0) {
            a.warn("failed priority scan {}, priority:{}, can't get scan radioId from parent[channel:{} radio:{}]", new Object[]{childOmadacDeviceId, priorityMac, chan, radioId});
            return;
        }
        int cmdId = Optional.ofNullable(wirelessApImage.cz().L()).map(com.tplink.smb.omada.manager.device.domain.model.deviceimage.ap.wireless.c::b).orElse(0) + 1;
        a.debug("start priority scan {}, priority:{} channel:{} radio:{} cmdId:{}", new Object[]{childOmadacDeviceId, priorityMac, chan, radioIdToScan, cmdId});
        if (!wirelessApImage.bd().K()) {
            a.info("not support priority scan {}, priority:{} channel:{} radio:{} cmdId:{}", new Object[]{childOmadacDeviceId, priorityMac, chan, radioIdToScan, cmdId});
            return;
        }
        this.h.b(this.a(chan, (long)cmdId, radioIdToScan), childOmadacDeviceId.b(), childOmadacDeviceId.a(), DeviceTypeEnum.a);
        this.a(childOmadacDeviceId, true);
    }

    private void c(aq childOmadacDeviceId) {
        this.j.a(childOmadacDeviceId.a(), childOmadacDeviceId.b(), () -> {
            com.tplink.smb.omada.manager.device.domain.model.deviceimage.ap.wireless.f childApImage = this.e.b(childOmadacDeviceId.a(), childOmadacDeviceId.b()).orElse(null);
            if (childApImage == null) {
                a.warn("failed changeStatusToNotScanAnymore for {}, apImage not exist or not wireless", (Object)childOmadacDeviceId);
                return false;
            }
            com.tplink.smb.omada.manager.device.domain.model.deviceimage.ap.wireless.c priorityInfo = childApImage.cz().L();
            if (priorityInfo == null) {
                priorityInfo = new com.tplink.smb.omada.manager.device.domain.model.deviceimage.ap.wireless.c();
                childApImage.cz().a(priorityInfo);
            }
            priorityInfo.a(com.tplink.smb.omada.manager.device.domain.model.mesh.failover.c.c);
            this.e.a(childApImage);
            return true;
        }, () -> {
            a.warn("failed changeStatusToNotScanAnymore for {}, can't get lock", (Object)childOmadacDeviceId);
            return false;
        });
    }

    private Map<SetKey, Object> a(int channel, long cmdId, int radioId) {
        GetCandidateParents gcp = new GetCandidateParents();
        gcp.setAction(Integer.valueOf(3));
        CandidateParentScanChannel scanChannel = new CandidateParentScanChannel();
        scanChannel.setChannel(Integer.valueOf(channel));
        scanChannel.setCmdId(Long.valueOf(cmdId));
        scanChannel.setRadioId(Integer.valueOf(radioId));
        gcp.setScanChannel(scanChannel);
        Mesh mesh = new Mesh();
        mesh.setGetCandidateParents(gcp);
        HashMap<SetKey, Object> settingMap = new HashMap<SetKey, Object>(1);
        settingMap.put((SetKey)ApSetKeyEnum.MESH_CMD, mesh);
        return settingMap;
    }

    private void b(aq omadacDeviceId, com.tplink.smb.omada.manager.device.domain.model.deviceimage.ap.wireless.f wirelessApImage) {
        Integer parentRadioId;
        com.tplink.smb.omada.manager.j.a.a.c omadacId = omadacDeviceId.a();
        G childMac = omadacDeviceId.b();
        d siteId = wirelessApImage.ap();
        Optional<com.tplink.smb.omada.manager.device.domain.model.device.ap.c> apOpt = this.l.a(omadacId, childMac);
        if (!apOpt.isPresent()) {
            a.warn("no more failover for not exist ap {} {}", (Object)omadacId, (Object)childMac);
            return;
        }
        com.tplink.smb.omada.manager.device.domain.model.device.ap.c childAp = apOpt.get();
        G parentMac = Optional.ofNullable(childAp.dl().M()).map(A::d).map(G::new).orElse(null);
        boolean doFix = this.a(omadacDeviceId, wirelessApImage, parentMac, parentRadioId = (Integer)Optional.ofNullable(childAp.dl().M()).map(A::c).orElse(null));
        if (doFix) {
            return;
        }
        if (!this.c(omadacDeviceId, wirelessApImage)) {
            this.e(omadacDeviceId);
            return;
        }
        a.debug("start failover for {} ", (Object)omadacDeviceId);
        G priorityMac = Optional.ofNullable(childAp.dl().M()).map(A::h).map(G::new).orElse(null);
        Integer priorityRadioId = null;
        if (priorityMac != null) {
            priorityRadioId = Optional.ofNullable(childAp.dl().M()).map(A::i).orElse(1);
            boolean notUsePriority = Optional.ofNullable(wirelessApImage.cz().L()).map(com.tplink.smb.omada.manager.device.domain.model.deviceimage.ap.wireless.c::c).orElse(false);
            if (notUsePriority || !this.a(priorityMac.a(), priorityRadioId, wirelessApImage)) {
                priorityMac = null;
                priorityRadioId = null;
            }
        }
        G priorityMacToLink = priorityMac;
        Integer priorityRadioIdToLink = priorityRadioId;
        this.i.a(omadacDeviceId.a(), siteId, omadacDeviceId.b(), priorityMacToLink, priorityRadioIdToLink, or -> {
            if (!or.success()) {
                a.info("failover {} priority {} : {}, auto link failed result {}, deal next time", new Object[]{omadacDeviceId, priorityMacToLink, priorityRadioIdToLink, or});
                if (priorityMacToLink != null) {
                    this.a(omadacDeviceId);
                }
                this.e(omadacDeviceId);
            } else {
                a.info("finish failover {}, link success", (Object)omadacDeviceId);
            }
        });
    }

    public void a(aq omadacDeviceId) {
        this.j.a(omadacDeviceId.a(), omadacDeviceId.b(), () -> {
            com.tplink.smb.omada.manager.device.domain.model.deviceimage.ap.wireless.f wirelessApImage = this.e.b(omadacDeviceId.a(), omadacDeviceId.b()).orElse(null);
            if (wirelessApImage == null) {
                a.warn("fail setNotUsePriorityNextTime for {}, apImage is null or not wireless", (Object)omadacDeviceId);
                return false;
            }
            a.debug("set not use priority for failover nextTime, {}", (Object)omadacDeviceId);
            com.tplink.smb.omada.manager.device.domain.model.deviceimage.ap.wireless.c priorityInfo = wirelessApImage.cz().L();
            if (priorityInfo == null) {
                priorityInfo = new com.tplink.smb.omada.manager.device.domain.model.deviceimage.ap.wireless.c();
                wirelessApImage.cz().a(priorityInfo);
            }
            priorityInfo.a((Boolean)true);
            this.e.a(wirelessApImage);
            return true;
        }, () -> {
            a.warn("fail setNotUsePriorityNextTime for {}, can't get lock", (Object)omadacDeviceId);
            return false;
        });
    }

    private boolean a(String priority, int priorityRadioId, com.tplink.smb.omada.manager.device.domain.model.deviceimage.ap.wireless.f wirelessApImage) {
        Map<String, CandidateParentApBO> candidateParentMap = wirelessApImage.cz().Y();
        if (CollectionUtils.isEmpty(candidateParentMap)) {
            return false;
        }
        CandidateParentApBO candidateParentApBO = candidateParentMap.get(priority);
        return com.tplink.smb.omada.manager.device.domain.model.mesh.h.a(candidateParentApBO, (Integer)priorityRadioId, 60000L);
    }

    private boolean a(aq omadacDeviceId, com.tplink.smb.omada.manager.device.domain.model.deviceimage.ap.wireless.f childApImage, G parentMac, Integer parentRadioId) {
        CheckFixMeshLinkDTO checkFixMeshLinkDTO = this.a(childApImage, parentMac, parentRadioId);
        if (!checkFixMeshLinkDTO.needFix()) {
            return false;
        }
        Integer radioId = checkFixMeshLinkDTO.getRadioId();
        if (radioId == null) {
            radioId = this.m.a(childApImage.am(), childApImage.ap(), childApImage.al(), parentMac);
            a.info("fix mesh link {} {} {} to parent {}, auto select radioId:{}", new Object[]{childApImage.am(), childApImage.ap(), childApImage.al(), parentMac, radioId});
            if (radioId == null) {
                return false;
            }
        }
        this.i.a(MeshLinkDTO.builder().omadacId(childApImage.am()).siteId(childApImage.ap()).childMac(childApImage.al()).oldParentMac(parentMac).newParentMac(parentMac).oldRadioId(parentRadioId).newRadioId(radioId).build(), (OperationResponse or) -> {
            if (!or.success()) {
                a.info("fix mesh link {} failed, result {}", (Object)omadacDeviceId, or);
                this.d(omadacDeviceId);
                this.e(omadacDeviceId);
            } else {
                a.info("success fix mesh link {}, link success", (Object)omadacDeviceId);
            }
        }, false);
        return true;
    }

    private void d(aq omadacDeviceId) {
        this.j.a(omadacDeviceId.a(), omadacDeviceId.b(), () -> {
            this.e.a(omadacDeviceId.a(), omadacDeviceId.b()).ifPresent(apImage -> {
                if (!apImage.be()) {
                    return;
                }
                com.tplink.smb.omada.manager.device.domain.model.deviceimage.ap.wireless.f wirelessApImage = (com.tplink.smb.omada.manager.device.domain.model.deviceimage.ap.wireless.f)apImage;
                WirelessLinkInfo wirelessLinkInfo = wirelessApImage.cz().aa();
                if (wirelessLinkInfo != null) {
                    wirelessLinkInfo.setFixedMeshLink(true);
                }
                this.e.a(wirelessApImage);
            });
            return true;
        }, () -> {
            a.warn("failed updateLinkFixed {}, can't get lock", (Object)omadacDeviceId);
            return false;
        });
    }

    private CheckFixMeshLinkDTO a(com.tplink.smb.omada.manager.device.domain.model.deviceimage.ap.wireless.f childApImage, G parentMac, Integer parentRadioId) {
        if (parentMac == null) {
            return CheckFixMeshLinkDTO.NO_NEED_FIX;
        }
        if (childApImage.cz().aa() != null && childApImage.cz().aa().isFixedMeshLink()) {
            return CheckFixMeshLinkDTO.NO_NEED_FIX;
        }
        int linkStatus = this.a(childApImage);
        if (linkStatus == 2 || linkStatus == 1) {
            return CheckFixMeshLinkDTO.NO_NEED_FIX;
        }
        if (!W.a((long)this.b(childApImage), (long)this.c.getPwdFixTimeout())) {
            return CheckFixMeshLinkDTO.NO_NEED_FIX;
        }
        Map<String, CandidateParentApBO> candidateParentMap = childApImage.cz().Y();
        if (CollectionUtils.isEmpty(candidateParentMap)) {
            return CheckFixMeshLinkDTO.NO_NEED_FIX;
        }
        CandidateParentApBO parentApBO = candidateParentMap.get(parentMac.a());
        if (parentApBO == null || parentApBO.getUptime() == null || W.a((long)parentApBO.getUptime(), (long)this.c.getPwdFixFreshTimeout())) {
            return CheckFixMeshLinkDTO.NO_NEED_FIX;
        }
        CandidateParentApRadioInfoBO radioInfoBO = parentApBO.getRadioInfoMap().get(parentRadioId);
        if (radioInfoBO != null && !W.a((long)radioInfoBO.getUptime(), (long)this.c.getPwdFixFreshTimeout())) {
            return new CheckFixMeshLinkDTO(true, parentRadioId);
        }
        return new CheckFixMeshLinkDTO(true, null);
    }

    private int a(com.tplink.smb.omada.manager.device.domain.model.deviceimage.ap.wireless.f wirelessApImage) {
        WirelessLinkInfo wirelessLinkInfo = wirelessApImage.cz().aa();
        if (wirelessLinkInfo != null && wirelessLinkInfo.getParentLink() != null) {
            return wirelessLinkInfo.getParentLink();
        }
        return 0;
    }

    private boolean c(aq omadacDeviceId, com.tplink.smb.omada.manager.device.domain.model.deviceimage.ap.wireless.f wirelessApImage) {
        if (wirelessApImage.bd().V()) {
            return false;
        }
        com.tplink.smb.omada.manager.configuration.domain.model.site.component.ap.f.b siteMeshSetting = this.g.a(wirelessApImage.am(), wirelessApImage.ap());
        if (siteMeshSetting == null) {
            a.warn("failover {}, site mesh setting or failover is disable, deal next time", (Object)omadacDeviceId);
            return false;
        }
        if (!Boolean.TRUE.equals(siteMeshSetting.c())) {
            a.debug("failover {}, site mesh setting is disable, deal next time", (Object)omadacDeviceId);
            return false;
        }
        if (!Boolean.TRUE.equals(siteMeshSetting.d())) {
            a.debug("failover {}, site failover is disable, deal next time", (Object)omadacDeviceId);
            return false;
        }
        long firstIsolatedTime = this.b(wirelessApImage);
        if (firstIsolatedTime > 0L && !W.a((long)firstIsolatedTime, (long)60000L)) {
            a.debug("failover {} isolated time not enough, deal next time", (Object)omadacDeviceId);
            return false;
        }
        WirelessLinkInfo wirelessLinkInfo = wirelessApImage.cz().aa();
        if (wirelessLinkInfo != null && wirelessLinkInfo.getParentLink() != null && wirelessLinkInfo.getParentLink() == 1) {
            a.debug("failover {} ap is linking, deal next time", (Object)omadacDeviceId);
            return false;
        }
        return true;
    }

    private boolean d(aq omadacDeviceId, com.tplink.smb.omada.manager.device.domain.model.deviceimage.ap.wireless.f wirelessApImage) {
        if ("PENDING-SITE".equals(wirelessApImage.ap().a())) {
            a.warn("stop failover {}, ap is in PENDING_SITE", (Object)omadacDeviceId);
            return false;
        }
        if (wirelessApImage.bd().V()) {
            a.debug("stop failover {}, ap is p2p wireless ap", (Object)omadacDeviceId);
            return false;
        }
        return true;
    }

    private long b(@Nonnull com.tplink.smb.omada.manager.device.domain.model.deviceimage.ap.wireless.f wirelessApImage) {
        return wirelessApImage.cz().ad() == null ? -1L : wirelessApImage.cz().ad();
    }

    private void e(aq omadacDeviceId) {
        this.b.a(omadacDeviceId, System.currentTimeMillis() + this.f.getNextTimeIntervalMs());
    }

    private void a(aq omadacDeviceId, boolean needSetFail) {
        long delayMs = this.j.a(omadacDeviceId.a(), omadacDeviceId.b(), () -> {
            long delay;
            com.tplink.smb.omada.manager.device.domain.model.deviceimage.ap.a apImage = this.e.a(omadacDeviceId.a(), omadacDeviceId.b()).orElse(null);
            if (apImage == null) {
                a.warn("discard priorityScan for {}, deviceImage not exist", (Object)omadacDeviceId);
                return -1L;
            }
            if (!apImage.be()) {
                a.warn("discard priorityScan for {}, ap not wireless", (Object)omadacDeviceId);
                return -1L;
            }
            if (apImage.bd().V()) {
                a.warn("discard priorityScan for {}, ap is support p2p", (Object)omadacDeviceId);
                return -1L;
            }
            com.tplink.smb.omada.manager.device.domain.model.deviceimage.ap.wireless.f wirelessApImage = (com.tplink.smb.omada.manager.device.domain.model.deviceimage.ap.wireless.f)apImage;
            com.tplink.smb.omada.manager.device.domain.model.deviceimage.ap.wireless.c priorityInfo = wirelessApImage.cz().L();
            if (priorityInfo == null) {
                priorityInfo = new com.tplink.smb.omada.manager.device.domain.model.deviceimage.ap.wireless.c();
                wirelessApImage.cz().a(priorityInfo);
            }
            if ((delay = priorityInfo.a(needSetFail)) < 0L) {
                a.info("discard priorityScan for {}, tryCount[{}] reach limit", (Object)omadacDeviceId, (Object)priorityInfo.b());
            }
            this.e.a(wirelessApImage);
            return delay;
        }, () -> {
            a.warn("priorityScan can't get lock, deal next time, {}", (Object)omadacDeviceId);
            return r;
        });
        if (delayMs >= 0L) {
            this.b.a(omadacDeviceId, System.currentTimeMillis() + delayMs);
        }
    }

    public void a(com.tplink.smb.omada.manager.j.a.a.c omadacId, G deviceMac) {
        if (!this.o.a(omadacId.a(), "settings:site:mesh:failover")) {
            return;
        }
        this.b.a(new aq(omadacId, deviceMac), System.currentTimeMillis() + 60000L);
    }

    public void b(com.tplink.smb.omada.manager.j.a.a.c omadacId, G deviceMac) {
        if (!this.o.a(omadacId.a(), "settings:site:mesh:failover")) {
            return;
        }
        this.b.a(new aq(omadacId, deviceMac), System.currentTimeMillis() + 35000L);
    }
}

