/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.device.domain.model.mesh.dto;

import com.tplink.smb.omada.a.a;
import com.tplink.smb.omada.manager.device.api.app.ap.dto.CandidateParentAppVO;
import com.tplink.smb.omada.manager.device.api.app.ap.dto.CandidateParentForAdoptAppVO;
import com.tplink.smb.omada.manager.device.api.app.ap.dto.CandidateParentForMspAdoptAppVO;
import com.tplink.smb.omada.manager.device.api.web.ap.dto.AbstractCandidateParentVO;
import com.tplink.smb.omada.manager.device.api.web.ap.dto.CandidateParentForAdoptWebVO;
import com.tplink.smb.omada.manager.device.api.web.ap.dto.CandidateParentForMspAdoptWebVO;
import com.tplink.smb.omada.manager.device.api.web.ap.dto.CandidateParentWebVO;
import com.tplink.smb.omada.manager.device.api.web.ap.dto.MultiBandInfoVO;
import com.tplink.smb.omada.manager.device.domain.model.deviceimage.ap.wireless.CandidateParentApRadioInfoBO;
import com.tplink.smb.omada.manager.device.domain.model.mesh.dto.MultiBandInfoDTO;
import com.tplink.smb.omada.manager.j.a.a.c;
import com.tplink.smb.omada.manager.j.a.a.d;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;

public class CandidateParentDTO {
    @a
    private String mac;
    private String name;
    private String type;
    private String model;
    private String modelVersion;
    private Integer hop;
    private Integer linkStatus;
    private Integer priorityStatus;
    private Boolean recommend;
    private Integer recommendRadioId;
    @Nullable
    private List<MultiBandInfoDTO> multiBandInfoList;
    private Boolean support5gMultiBand;

    public CandidateParentWebVO toWebVO() {
        CandidateParentWebVO webVO = new CandidateParentWebVO();
        this.fillCommonVoField((AbstractCandidateParentVO)webVO);
        webVO.setPriorityStatus(this.priorityStatus);
        return webVO;
    }

    public CandidateParentAppVO toAppVO() {
        CandidateParentAppVO appVO = new CandidateParentAppVO();
        this.fillCommonVoField((AbstractCandidateParentVO)appVO);
        return appVO;
    }

    private void fillCommonVoField(AbstractCandidateParentVO vo) {
        MultiBandInfoDTO bandInfo;
        vo.setMac(this.mac);
        vo.setName(this.name);
        vo.setHop(this.hop);
        vo.setLinkStatus(Optional.ofNullable(this.linkStatus).orElse(0));
        vo.setSupport5gMultiBand(this.support5gMultiBand);
        vo.setModel(this.model);
        vo.setModelVersion(this.modelVersion);
        vo.setType(this.type);
        if (this.multiBandInfoList == null || this.multiBandInfoList.isEmpty()) {
            return;
        }
        int childNumAllBand = 0;
        MultiBandInfoDTO bandInfo5g = null;
        MultiBandInfoDTO bandInfoAny = null;
        ArrayList<MultiBandInfoVO> multiBandInfoVOList = new ArrayList<MultiBandInfoVO>(this.multiBandInfoList.size());
        for (MultiBandInfoDTO bandInfo2 : this.multiBandInfoList) {
            if (bandInfo2 == null) continue;
            if (bandInfo2.getChildsNum() != null) {
                childNumAllBand += bandInfo2.getChildsNum().intValue();
            }
            if (bandInfo2.getRadioId().equals(1)) {
                bandInfo5g = bandInfo2;
            }
            bandInfoAny = bandInfo2;
            multiBandInfoVOList.add(MultiBandInfoVO.builder().radioId(bandInfo2.getRadioId()).channel(bandInfo2.getChannel()).rssi(bandInfo2.getRssi()).build());
        }
        MultiBandInfoDTO multiBandInfoDTO = bandInfo = bandInfo5g != null ? bandInfo5g : bandInfoAny;
        if (bandInfo != null) {
            vo.setChannel(bandInfo.getChannel());
            vo.setRssi(bandInfo.getRssi());
            vo.setSnr(bandInfo.getSnr());
        }
        vo.setChildsNum(Integer.valueOf(childNumAllBand));
        vo.setMultiBandInfo(multiBandInfoVOList);
    }

    public CandidateParentForAdoptWebVO toAdoptWebVO() {
        MultiBandInfoDTO bandInfoForOldField;
        CandidateParentForAdoptWebVO vo = new CandidateParentForAdoptWebVO();
        vo.setMac(this.mac);
        vo.setName(this.name);
        vo.setHop(this.hop);
        vo.setLinkStatus(this.linkStatus);
        vo.setRecommend(this.recommend);
        vo.setRecommendRadioId(this.recommendRadioId);
        vo.setModel(this.model);
        vo.setModelVersion(this.modelVersion);
        vo.setType(this.type);
        if (this.multiBandInfoList == null || this.multiBandInfoList.size() < 1) {
            return vo;
        }
        int childNumAllBand = 0;
        MultiBandInfoDTO bandInfo5g = null;
        MultiBandInfoDTO bandInfoAny = null;
        ArrayList<MultiBandInfoVO> multiBandInfoVOList = new ArrayList<MultiBandInfoVO>(this.multiBandInfoList.size());
        for (MultiBandInfoDTO bandInfo : this.multiBandInfoList) {
            if (bandInfo == null) continue;
            if (bandInfo.getChildsNum() != null) {
                childNumAllBand += bandInfo.getChildsNum().intValue();
            }
            if (bandInfo.getRadioId().equals(1)) {
                bandInfo5g = bandInfo;
            }
            bandInfoAny = bandInfo;
            multiBandInfoVOList.add(MultiBandInfoVO.builder().radioId(bandInfo.getRadioId()).channel(bandInfo.getChannel()).rssi(bandInfo.getRssi()).build());
        }
        MultiBandInfoDTO multiBandInfoDTO = bandInfoForOldField = bandInfo5g != null ? bandInfo5g : bandInfoAny;
        if (bandInfoForOldField != null) {
            vo.setChannel(bandInfoForOldField.getChannel());
            vo.setRssi(bandInfoForOldField.getRssi());
            vo.setSnr(bandInfoForOldField.getSnr());
        }
        vo.setChildsNum(Integer.valueOf(childNumAllBand));
        vo.setMultiBandInfo(multiBandInfoVOList);
        return vo;
    }

    public CandidateParentForAdoptAppVO toAdoptAppVO() {
        CandidateParentForAdoptAppVO vo = new CandidateParentForAdoptAppVO();
        vo.setMac(this.getMac());
        vo.setName(this.getName());
        vo.setModel(this.getModel());
        vo.setModelVersion(this.getModelVersion());
        vo.setType(this.type);
        vo.setHop(this.getHop());
        vo.setLinkStatus(this.getLinkStatus());
        vo.setRecommend(this.getRecommend());
        vo.setRecommendRadioId(this.getRecommendRadioId());
        if (this.getMultiBandInfoList() == null || this.getMultiBandInfoList().size() < 1) {
            return vo;
        }
        int childNumAllBand = 0;
        ArrayList<MultiBandInfoVO> multiBandInfoVOList = new ArrayList<MultiBandInfoVO>(this.getMultiBandInfoList().size());
        for (MultiBandInfoDTO bandInfo : this.getMultiBandInfoList()) {
            if (bandInfo == null) continue;
            if (bandInfo.getChildsNum() != null) {
                childNumAllBand += bandInfo.getChildsNum().intValue();
            }
            multiBandInfoVOList.add(MultiBandInfoVO.builder().radioId(bandInfo.getRadioId()).channel(bandInfo.getChannel()).rssi(bandInfo.getRssi()).build());
        }
        vo.setChildsNum(Integer.valueOf(childNumAllBand));
        vo.setMultiBandInfo(multiBandInfoVOList);
        return vo;
    }

    public void fillMultiBandInfo(Map<Integer, CandidateParentApRadioInfoBO> radioInfoMap) {
        if (radioInfoMap == null) {
            return;
        }
        ArrayList<MultiBandInfoDTO> dtoList = new ArrayList<MultiBandInfoDTO>(radioInfoMap.size());
        radioInfoMap.values().stream().forEach(bo2 -> dtoList.add(MultiBandInfoDTO.fromCandidateParentApRadioInfoBO(bo2)));
        dtoList.sort(Comparator.comparingInt(MultiBandInfoDTO::getRadioId));
        this.setMultiBandInfoList(dtoList);
    }

    public void fillChildNum(Map<Integer, Integer> radioChildNumMap) {
        if (this.multiBandInfoList == null) {
            return;
        }
        this.multiBandInfoList.forEach(bandInfo -> bandInfo.setChildsNum((Integer)radioChildNumMap.get(bandInfo.getRadioId())));
    }

    public CandidateParentForMspAdoptWebVO toAdoptWebVO(c omadacId, d siteId) {
        MultiBandInfoDTO bandInfoForOldField;
        CandidateParentForMspAdoptWebVO vo = new CandidateParentForMspAdoptWebVO();
        vo.setMac(this.getMac());
        vo.setName(this.getName());
        vo.setCustomId(omadacId.a());
        vo.setSite(siteId.a());
        vo.setHop(this.getHop());
        vo.setLinkStatus(this.getLinkStatus());
        vo.setRecommend(this.getRecommend());
        vo.setRecommendRadioId(this.getRecommendRadioId());
        vo.setModel(this.model);
        vo.setModelVersion(this.modelVersion);
        vo.setType(this.type);
        if (this.getMultiBandInfoList() == null || this.getMultiBandInfoList().size() < 1) {
            return vo;
        }
        int childNumAllBand = 0;
        MultiBandInfoDTO bandInfo5g = null;
        MultiBandInfoDTO bandInfoAny = null;
        ArrayList<MultiBandInfoVO> multiBandInfoVOList = new ArrayList<MultiBandInfoVO>(this.getMultiBandInfoList().size());
        for (MultiBandInfoDTO bandInfo : this.getMultiBandInfoList()) {
            if (bandInfo == null) continue;
            if (bandInfo.getChildsNum() != null) {
                childNumAllBand += bandInfo.getChildsNum().intValue();
            }
            if (bandInfo.getRadioId().equals(1)) {
                bandInfo5g = bandInfo;
            }
            bandInfoAny = bandInfo;
            multiBandInfoVOList.add(MultiBandInfoVO.builder().radioId(bandInfo.getRadioId()).channel(bandInfo.getChannel()).rssi(bandInfo.getRssi()).build());
        }
        MultiBandInfoDTO multiBandInfoDTO = bandInfoForOldField = bandInfo5g != null ? bandInfo5g : bandInfoAny;
        if (bandInfoForOldField != null) {
            vo.setChannel(bandInfoForOldField.getChannel());
            vo.setRssi(bandInfoForOldField.getRssi());
            vo.setSnr(bandInfoForOldField.getSnr());
        }
        vo.setChildsNum(Integer.valueOf(childNumAllBand));
        vo.setMultiBandInfo(multiBandInfoVOList);
        return vo;
    }

    public CandidateParentForMspAdoptAppVO toAdoptAppVO(c omadacId, d siteId) {
        CandidateParentForMspAdoptAppVO vo = new CandidateParentForMspAdoptAppVO();
        vo.setMac(this.getMac());
        vo.setName(this.getName());
        vo.setModel(this.getModel());
        vo.setModelVersion(this.getModelVersion());
        vo.setType(this.type);
        vo.setCustomId(omadacId.a());
        vo.setSite(siteId.a());
        vo.setHop(this.getHop());
        vo.setLinkStatus(this.getLinkStatus());
        vo.setRecommend(this.getRecommend());
        vo.setRecommendRadioId(this.getRecommendRadioId());
        if (this.getMultiBandInfoList() == null || this.getMultiBandInfoList().size() < 1) {
            return vo;
        }
        int childNumAllBand = 0;
        ArrayList<MultiBandInfoVO> multiBandInfoVOList = new ArrayList<MultiBandInfoVO>(this.getMultiBandInfoList().size());
        for (MultiBandInfoDTO bandInfo : this.getMultiBandInfoList()) {
            if (bandInfo == null) continue;
            if (bandInfo.getChildsNum() != null) {
                childNumAllBand += bandInfo.getChildsNum().intValue();
            }
            multiBandInfoVOList.add(MultiBandInfoVO.builder().radioId(bandInfo.getRadioId()).channel(bandInfo.getChannel()).rssi(bandInfo.getRssi()).build());
        }
        vo.setChildsNum(Integer.valueOf(childNumAllBand));
        vo.setMultiBandInfo(multiBandInfoVOList);
        return vo;
    }

    @Generated
    public String toString() {
        return "CandidateParentDTO(mac=" + this.getMac() + ", name=" + this.getName() + ", type=" + this.getType() + ", model=" + this.getModel() + ", modelVersion=" + this.getModelVersion() + ", hop=" + this.getHop() + ", linkStatus=" + this.getLinkStatus() + ", priorityStatus=" + this.getPriorityStatus() + ", recommend=" + this.getRecommend() + ", recommendRadioId=" + this.getRecommendRadioId() + ", multiBandInfoList=" + this.getMultiBandInfoList() + ", support5gMultiBand=" + this.getSupport5gMultiBand() + ")";
    }

    @Generated
    public String getMac() {
        return this.mac;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public String getModel() {
        return this.model;
    }

    @Generated
    public String getModelVersion() {
        return this.modelVersion;
    }

    @Generated
    public Integer getHop() {
        return this.hop;
    }

    @Generated
    public Integer getLinkStatus() {
        return this.linkStatus;
    }

    @Generated
    public Integer getPriorityStatus() {
        return this.priorityStatus;
    }

    @Generated
    public Boolean getRecommend() {
        return this.recommend;
    }

    @Generated
    public Integer getRecommendRadioId() {
        return this.recommendRadioId;
    }

    @Nullable
    @Generated
    public List<MultiBandInfoDTO> getMultiBandInfoList() {
        return this.multiBandInfoList;
    }

    @Generated
    public Boolean getSupport5gMultiBand() {
        return this.support5gMultiBand;
    }

    @Generated
    public void setMac(String mac) {
        this.mac = mac;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setType(String type) {
        this.type = type;
    }

    @Generated
    public void setModel(String model) {
        this.model = model;
    }

    @Generated
    public void setModelVersion(String modelVersion) {
        this.modelVersion = modelVersion;
    }

    @Generated
    public void setHop(Integer hop) {
        this.hop = hop;
    }

    @Generated
    public void setLinkStatus(Integer linkStatus) {
        this.linkStatus = linkStatus;
    }

    @Generated
    public void setPriorityStatus(Integer priorityStatus) {
        this.priorityStatus = priorityStatus;
    }

    @Generated
    public void setRecommend(Boolean recommend) {
        this.recommend = recommend;
    }

    @Generated
    public void setRecommendRadioId(Integer recommendRadioId) {
        this.recommendRadioId = recommendRadioId;
    }

    @Generated
    public void setMultiBandInfoList(@Nullable List<MultiBandInfoDTO> multiBandInfoList) {
        this.multiBandInfoList = multiBandInfoList;
    }

    @Generated
    public void setSupport5gMultiBand(Boolean support5gMultiBand) {
        this.support5gMultiBand = support5gMultiBand;
    }
}

