/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.device.domain.model.mesh.config;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.tplink.smb.omada.manager.device.domain.model.mesh.config.MeshProperties;
import com.tplink.smb.omada.manager.device.domain.model.mesh.config.a;
import com.tplink.smb.omada.manager.device.domain.model.mesh.failover.MeshFailOverProperties;
import com.tplink.smb.omada.manager.device.domain.model.mesh.scan.MeshScanProperties;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={MeshProperties.class, MeshScanProperties.class, MeshFailOverProperties.class})
public class MeshConfiguration {
    @Lazy
    @Bean(name={"meshWorkGroup"})
    @ConditionalOnMissingBean(name={"meshWorkGroup"})
    public ThreadPoolExecutor meshWorkGroup(MeshProperties meshProperties) {
        int coreSize = meshProperties.getThreadPoolSize();
        int maxSize = meshProperties.getThreadMaxPoolSize();
        return new ThreadPoolExecutor(coreSize, maxSize, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(meshProperties.getThreadPoolQueueSize()), new ThreadFactoryBuilder().setNameFormat("mesh-work-group-%d").build(), new a(this));
    }
}

