/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.device.domain.model.deviceimage.ap.wireless;

import com.tplink.smb.omada.common.obfuscate.KeepClass;
import com.tplink.smb.omada.common.util.T;
import com.tplink.smb.omada.common.util.l;
import com.tplink.smb.omada.device.manage.message.inform.ap.mesh.ChildAp;
import com.tplink.smb.omada.manager.device.domain.model.device.G;
import com.tplink.smb.omada.manager.device.domain.model.deviceimage.ap.BaseUplinkInfo;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@KeepClass
public class WirelessUplinkInfo
extends BaseUplinkInfo {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WirelessUplinkInfo.class);
    private static final long MAX_ACTIVITY_DELAY = 90L;
    private Integer parentRadioId;
    private Integer childRadioId;
    private String mac;
    private Integer channel;
    private Integer rssi;
    private Integer snr;
    private String txRate;
    private String rxRate;
    private long uptime;
    private String model;
    private String modelVersion;
    private String type;
    private String ip;

    public static WirelessUplinkInfo createByParentMeshInform(@Nonnull G parentMac, @Nonnull ChildAp childAp, @Nullable String deviceUptimeStr) {
        long deviceUptime = -1L;
        if (!T.c((String)deviceUptimeStr)) {
            deviceUptime = l.c((String)deviceUptimeStr);
        }
        return ((a)((a)((a)((a)((a)((a)((a)((a)((a)((BaseUplinkInfo.a)((a)((a)((a)((a)WirelessUplinkInfo.builder().a(parentMac.a())).d(childAp.getRssi())).e(childAp.getSnr())).b(childAp.getTxRate())).c(childAp.getRxRate())).c(childAp.getUpPackets())).d(childAp.getDownPackets())).e((Long)null)).a(deviceUptime)).a((Long)childAp.getUpBytes())).b((Long)childAp.getDownBytes())).b(System.currentTimeMillis())).a(childAp.getRadioId())).c(childAp.getCh())).d();
    }

    public void updateByParentMeshInform(@Nonnull G parentMac, @Nonnull ChildAp childAp, @Nullable String deviceUptimeStr) {
        if (T.c((String)deviceUptimeStr)) {
            this.setUptime(System.currentTimeMillis());
            return;
        }
        long deviceUptime = l.c((String)deviceUptimeStr);
        this.a(childAp, deviceUptime);
        this.setMac(parentMac.a());
        this.setRssi(childAp.getRssi());
        this.setSnr(childAp.getSnr());
        this.setTxRate(childAp.getTxRate());
        this.setRxRate(childAp.getRxRate());
        this.setUpPackets(childAp.getUpPackets());
        this.setDownPackets(childAp.getDownPackets());
        this.setDeviceUptime(deviceUptime);
        this.setUpBytes(childAp.getUpBytes());
        this.setDownBytes(childAp.getDownBytes());
        this.setUptime(System.currentTimeMillis());
        this.setParentRadioId(childAp.getRadioId());
        this.setChannel(childAp.getCh());
    }

    private void a(ChildAp childAp, long newUptime) {
        long oldUptime = this.getDeviceUptime();
        if (oldUptime <= 0L) {
            this.setUpRate(null);
            this.setDownRate(null);
            this.setActivity(null);
            return;
        }
        long newUpBytes = childAp.getUpBytes();
        long newDownBytes = childAp.getDownBytes();
        long oldUpBytes = this.getUpBytes();
        long oldDownBytes = this.getDownBytes();
        long time = newUptime - oldUptime;
        if (time <= 0L || time > 90L) {
            log.info("{} calculate activity uptime invalid[old:{},new:{}], set activity to null", new Object[]{childAp.getMac(), oldUptime, newUptime});
            this.setUpRate(null);
            this.setDownRate(null);
            this.setActivity(null);
            return;
        }
        long up = newUpBytes - oldUpBytes;
        long down = newDownBytes - oldDownBytes;
        long total = newUpBytes - oldUpBytes + newDownBytes - oldDownBytes;
        if (up <= 0L) {
            this.setUpRate(0L);
        } else {
            this.setUpRate(up / time);
        }
        if (down <= 0L) {
            this.setDownRate(0L);
        } else {
            this.setDownRate(down / time);
        }
        if (total <= 0L) {
            this.setActivity(0L);
        } else {
            this.setActivity(total / time);
        }
    }

    public void updateByChildMeshInform(Integer childRadioId, com.tplink.smb.omada.manager.device.domain.model.deviceimage.ap.a apImage) {
        if (childRadioId == null && apImage != null && apImage.bc().q() && !apImage.bc().r() && !apImage.bc().s() && !apImage.bc().t()) {
            childRadioId = 0;
        }
        this.setChildRadioId(Optional.ofNullable(childRadioId).orElse(1));
    }

    @Generated
    protected WirelessUplinkInfo(a<?, ?> b2) {
        super(b2);
        this.parentRadioId = b2.a;
        this.childRadioId = b2.b;
        this.mac = b2.c;
        this.channel = b2.d;
        this.rssi = b2.e;
        this.snr = b2.f;
        this.txRate = b2.g;
        this.rxRate = b2.h;
        this.uptime = b2.i;
        this.model = b2.j;
        this.modelVersion = b2.k;
        this.type = b2.l;
        this.ip = b2.m;
    }

    @Generated
    public static a<?, ?> builder() {
        return new b();
    }

    @Override
    @Generated
    public String toString() {
        return "WirelessUplinkInfo(parentRadioId=" + this.getParentRadioId() + ", childRadioId=" + this.getChildRadioId() + ", mac=" + this.getMac() + ", channel=" + this.getChannel() + ", rssi=" + this.getRssi() + ", snr=" + this.getSnr() + ", txRate=" + this.getTxRate() + ", rxRate=" + this.getRxRate() + ", uptime=" + this.getUptime() + ", model=" + this.getModel() + ", modelVersion=" + this.getModelVersion() + ", type=" + this.getType() + ", ip=" + this.getIp() + ")";
    }

    @Generated
    public Integer getParentRadioId() {
        return this.parentRadioId;
    }

    @Generated
    public Integer getChildRadioId() {
        return this.childRadioId;
    }

    @Generated
    public String getMac() {
        return this.mac;
    }

    @Generated
    public Integer getChannel() {
        return this.channel;
    }

    @Generated
    public Integer getRssi() {
        return this.rssi;
    }

    @Generated
    public Integer getSnr() {
        return this.snr;
    }

    @Generated
    public String getTxRate() {
        return this.txRate;
    }

    @Generated
    public String getRxRate() {
        return this.rxRate;
    }

    @Generated
    public long getUptime() {
        return this.uptime;
    }

    @Generated
    public String getModel() {
        return this.model;
    }

    @Generated
    public String getModelVersion() {
        return this.modelVersion;
    }

    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public String getIp() {
        return this.ip;
    }

    @Generated
    public void setParentRadioId(Integer parentRadioId) {
        this.parentRadioId = parentRadioId;
    }

    @Generated
    public void setChildRadioId(Integer childRadioId) {
        this.childRadioId = childRadioId;
    }

    @Generated
    public void setMac(String mac) {
        this.mac = mac;
    }

    @Generated
    public void setChannel(Integer channel) {
        this.channel = channel;
    }

    @Generated
    public void setRssi(Integer rssi) {
        this.rssi = rssi;
    }

    @Generated
    public void setSnr(Integer snr) {
        this.snr = snr;
    }

    @Generated
    public void setTxRate(String txRate) {
        this.txRate = txRate;
    }

    @Generated
    public void setRxRate(String rxRate) {
        this.rxRate = rxRate;
    }

    @Generated
    public void setUptime(long uptime) {
        this.uptime = uptime;
    }

    @Generated
    public void setModel(String model) {
        this.model = model;
    }

    @Generated
    public void setModelVersion(String modelVersion) {
        this.modelVersion = modelVersion;
    }

    @Generated
    public void setType(String type) {
        this.type = type;
    }

    @Generated
    public void setIp(String ip) {
        this.ip = ip;
    }

    @Generated
    public boolean equals(Object o2) {
        if (o2 == this) {
            return true;
        }
        if (!(o2 instanceof WirelessUplinkInfo)) {
            return false;
        }
        WirelessUplinkInfo other = (WirelessUplinkInfo)o2;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getUptime() != other.getUptime()) {
            return false;
        }
        Integer this$parentRadioId = this.getParentRadioId();
        Integer other$parentRadioId = other.getParentRadioId();
        if (this$parentRadioId == null ? other$parentRadioId != null : !((Object)this$parentRadioId).equals(other$parentRadioId)) {
            return false;
        }
        Integer this$childRadioId = this.getChildRadioId();
        Integer other$childRadioId = other.getChildRadioId();
        if (this$childRadioId == null ? other$childRadioId != null : !((Object)this$childRadioId).equals(other$childRadioId)) {
            return false;
        }
        Integer this$channel = this.getChannel();
        Integer other$channel = other.getChannel();
        if (this$channel == null ? other$channel != null : !((Object)this$channel).equals(other$channel)) {
            return false;
        }
        Integer this$rssi = this.getRssi();
        Integer other$rssi = other.getRssi();
        if (this$rssi == null ? other$rssi != null : !((Object)this$rssi).equals(other$rssi)) {
            return false;
        }
        Integer this$snr = this.getSnr();
        Integer other$snr = other.getSnr();
        if (this$snr == null ? other$snr != null : !((Object)this$snr).equals(other$snr)) {
            return false;
        }
        String this$mac = this.getMac();
        String other$mac = other.getMac();
        if (this$mac == null ? other$mac != null : !this$mac.equals(other$mac)) {
            return false;
        }
        String this$txRate = this.getTxRate();
        String other$txRate = other.getTxRate();
        if (this$txRate == null ? other$txRate != null : !this$txRate.equals(other$txRate)) {
            return false;
        }
        String this$rxRate = this.getRxRate();
        String other$rxRate = other.getRxRate();
        if (this$rxRate == null ? other$rxRate != null : !this$rxRate.equals(other$rxRate)) {
            return false;
        }
        String this$model = this.getModel();
        String other$model = other.getModel();
        if (this$model == null ? other$model != null : !this$model.equals(other$model)) {
            return false;
        }
        String this$modelVersion = this.getModelVersion();
        String other$modelVersion = other.getModelVersion();
        if (this$modelVersion == null ? other$modelVersion != null : !this$modelVersion.equals(other$modelVersion)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$ip = this.getIp();
        String other$ip = other.getIp();
        return !(this$ip == null ? other$ip != null : !this$ip.equals(other$ip));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof WirelessUplinkInfo;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $uptime = this.getUptime();
        result = result * 59 + (int)($uptime >>> 32 ^ $uptime);
        Integer $parentRadioId = this.getParentRadioId();
        result = result * 59 + ($parentRadioId == null ? 43 : ((Object)$parentRadioId).hashCode());
        Integer $childRadioId = this.getChildRadioId();
        result = result * 59 + ($childRadioId == null ? 43 : ((Object)$childRadioId).hashCode());
        Integer $channel = this.getChannel();
        result = result * 59 + ($channel == null ? 43 : ((Object)$channel).hashCode());
        Integer $rssi = this.getRssi();
        result = result * 59 + ($rssi == null ? 43 : ((Object)$rssi).hashCode());
        Integer $snr = this.getSnr();
        result = result * 59 + ($snr == null ? 43 : ((Object)$snr).hashCode());
        String $mac = this.getMac();
        result = result * 59 + ($mac == null ? 43 : $mac.hashCode());
        String $txRate = this.getTxRate();
        result = result * 59 + ($txRate == null ? 43 : $txRate.hashCode());
        String $rxRate = this.getRxRate();
        result = result * 59 + ($rxRate == null ? 43 : $rxRate.hashCode());
        String $model = this.getModel();
        result = result * 59 + ($model == null ? 43 : $model.hashCode());
        String $modelVersion = this.getModelVersion();
        result = result * 59 + ($modelVersion == null ? 43 : $modelVersion.hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $ip = this.getIp();
        result = result * 59 + ($ip == null ? 43 : $ip.hashCode());
        return result;
    }

    @Generated
    public WirelessUplinkInfo() {
    }

    @Generated
    public static abstract class a<C extends WirelessUplinkInfo, B extends a<C, B>>
    extends BaseUplinkInfo.a<C, B> {
        @Generated
        private Integer a;
        @Generated
        private Integer b;
        @Generated
        private String c;
        @Generated
        private Integer d;
        @Generated
        private Integer e;
        @Generated
        private Integer f;
        @Generated
        private String g;
        @Generated
        private String h;
        @Generated
        private long i;
        @Generated
        private String j;
        @Generated
        private String k;
        @Generated
        private String l;
        @Generated
        private String m;

        @Generated
        public B a(Integer parentRadioId) {
            this.a = parentRadioId;
            return this.c();
        }

        @Generated
        public B b(Integer childRadioId) {
            this.b = childRadioId;
            return this.c();
        }

        @Generated
        public B a(String mac) {
            this.c = mac;
            return this.c();
        }

        @Generated
        public B c(Integer channel) {
            this.d = channel;
            return this.c();
        }

        @Generated
        public B d(Integer rssi) {
            this.e = rssi;
            return this.c();
        }

        @Generated
        public B e(Integer snr) {
            this.f = snr;
            return this.c();
        }

        @Generated
        public B b(String txRate) {
            this.g = txRate;
            return this.c();
        }

        @Generated
        public B c(String rxRate) {
            this.h = rxRate;
            return this.c();
        }

        @Generated
        public B b(long uptime) {
            this.i = uptime;
            return this.c();
        }

        @Generated
        public B d(String model) {
            this.j = model;
            return this.c();
        }

        @Generated
        public B e(String modelVersion) {
            this.k = modelVersion;
            return this.c();
        }

        @Generated
        public B f(String type) {
            this.l = type;
            return this.c();
        }

        @Generated
        public B g(String ip) {
            this.m = ip;
            return this.c();
        }

        @Generated
        protected abstract B c();

        @Generated
        public abstract C d();

        @Override
        @Generated
        public String toString() {
            return "WirelessUplinkInfo.WirelessUplinkInfoBuilder(super=" + super.toString() + ", parentRadioId=" + this.a + ", childRadioId=" + this.b + ", mac=" + this.c + ", channel=" + this.d + ", rssi=" + this.e + ", snr=" + this.f + ", txRate=" + this.g + ", rxRate=" + this.h + ", uptime=" + this.i + ", model=" + this.j + ", modelVersion=" + this.k + ", type=" + this.l + ", ip=" + this.m + ")";
        }

        @Override
        @Generated
        public /* synthetic */ BaseUplinkInfo b() {
            return this.d();
        }

        @Override
        @Generated
        protected /* synthetic */ BaseUplinkInfo.a a() {
            return this.c();
        }
    }

    @Generated
    private static final class b
    extends a<WirelessUplinkInfo, b> {
        @Generated
        private b() {
        }

        @Generated
        protected b e() {
            return this;
        }

        @Override
        @Generated
        public WirelessUplinkInfo d() {
            return new WirelessUplinkInfo(this);
        }

        @Override
        @Generated
        protected /* synthetic */ a c() {
            return this.e();
        }

        @Override
        @Generated
        public /* synthetic */ BaseUplinkInfo b() {
            return this.d();
        }

        @Override
        @Generated
        protected /* synthetic */ BaseUplinkInfo.a a() {
            return this.e();
        }
    }
}

