/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.device.domain.model.deviceimage;

import com.tplink.smb.omada.async.business.e;
import com.tplink.smb.omada.common.obfuscate.KeepClass;
import com.tplink.smb.omada.common.util.l;
import com.tplink.smb.omada.manager.device.domain.model.device.b;
import jakarta.annotation.Nullable;
import java.util.concurrent.atomic.AtomicInteger;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@KeepClass
public class RunTimeAdoptInfo {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RunTimeAdoptInfo.class);
    public static final int AUTO_ADOPT_MAX_LEVEL = 20;
    @Nullable
    private e businessId;
    @Nullable
    private e fullAdoptBusinessId;
    @Nullable
    private String batchAdoptId;
    private Boolean autoAdopt;
    private a pendingAdoptInfo;
    private Integer adoptErrCode;
    private Integer autoAdoptCnt;
    private AtomicInteger autoAdoptWithErrorUserNamePasswordCnt;
    private Long lastTryTime;
    private Long expectedNextTime;
    private Integer receiveDiscoveryTimes;

    public void incAutoAdoptCnt() {
        this.autoAdoptCnt = this.autoAdoptCnt == null ? 1 : this.autoAdoptCnt + 1;
        if (this.autoAdoptCnt > 20) {
            this.autoAdoptCnt = 20;
        }
        int intervalSecond = this.a();
        this.lastTryTime = System.currentTimeMillis();
        this.expectedNextTime = this.lastTryTime + (long)(intervalSecond * 1000);
        log.debug("incAutoAdoptCnt level {} intervalSecond {}", (Object)this.autoAdoptCnt, (Object)intervalSecond);
    }

    private int a() {
        if (this.autoAdoptCnt <= 5) {
            return 0;
        }
        if (this.autoAdoptCnt <= 10) {
            return l.a((int)60, (int)120);
        }
        if (this.autoAdoptCnt <= 20) {
            return l.a((int)120, (int)240);
        }
        return l.a((int)240, (int)480);
    }

    public void updateBeforeAdopt(String userName, String password, boolean autoAdopt, boolean isStack) {
        if (!(autoAdopt && (userName == null || password == null) && isStack || this.pendingAdoptInfo != null || userName != null && password != null)) {
            userName = com.tplink.smb.omada.manager.device.port.common.b.a.c;
            password = com.tplink.smb.omada.manager.device.port.common.b.a.d;
        }
        if (userName != null && password != null) {
            this.setPendingAdoptInfo(new a(userName, password));
        }
        this.setAdoptErrCode(null);
        this.setAutoAdopt(autoAdopt);
        if (autoAdopt) {
            this.incAutoAdoptCnt();
        } else {
            this.setAutoAdoptCnt(null);
            this.setAutoAdoptWithErrorUserNamePasswordCnt(null);
        }
        log.debug("autoAdopt: {}, autoAdoptCnt: {}", (Object)autoAdopt, (Object)this.autoAdoptCnt);
    }

    public void updateToAutoAdopt() {
        this.incAutoAdoptCnt();
    }

    public void updateAfterAdoptFailed(Integer failCode) {
        if (com.tplink.smb.omada.manager.device.domain.model.adopt.c.a.g.b(failCode)) {
            this.setPendingAdoptInfo(null);
        }
        this.setAdoptErrCode(failCode);
        if (com.tplink.smb.omada.manager.device.domain.model.adopt.c.a.g.b(failCode) && Boolean.TRUE.equals(this.autoAdopt)) {
            if (this.autoAdoptWithErrorUserNamePasswordCnt == null) {
                this.autoAdoptWithErrorUserNamePasswordCnt = new AtomicInteger(1);
            } else {
                this.autoAdoptWithErrorUserNamePasswordCnt.incrementAndGet();
            }
        }
    }

    public void updateAfterAdoptSuccess() {
        this.setAutoAdopt(null);
        this.setAutoAdoptCnt(null);
        this.setAdoptErrCode(null);
        this.setAutoAdoptWithErrorUserNamePasswordCnt(null);
    }

    public boolean needRetryAutoAdoptAfterAccountError() {
        if (!Boolean.TRUE.equals(this.getAutoAdopt())) {
            return false;
        }
        return this.autoAdoptWithErrorUserNamePasswordCnt == null || this.autoAdoptWithErrorUserNamePasswordCnt.get() <= 2;
    }

    public boolean needRetryAutoAdoptAfterCoolDown() {
        if (!Boolean.TRUE.equals(this.getAutoAdopt())) {
            return false;
        }
        if (this.getAdoptErrCode() == null) {
            return true;
        }
        if (com.tplink.smb.omada.manager.device.domain.model.adopt.c.a.g.b(this.getAdoptErrCode())) {
            return true;
        }
        if (!(com.tplink.smb.omada.manager.device.domain.model.adopt.c.a.i.b(this.getAdoptErrCode()) || com.tplink.smb.omada.manager.device.domain.model.adopt.c.a.h.b(this.getAdoptErrCode()) || com.tplink.smb.omada.manager.device.domain.model.adopt.c.a.a.b(this.getAdoptErrCode()))) {
            return false;
        }
        log.debug("autoAdoptCnt: {}", (Object)this.autoAdoptCnt);
        if (this.autoAdoptCnt == null) {
            this.autoAdoptCnt = 0;
            log.warn("autoAdoptCnt is null while needRetryAutoAdopt, some where wrong");
            return true;
        }
        if (this.expectedNextTime != null && System.currentTimeMillis() < this.expectedNextTime) {
            log.debug("dont reach autoAdopt expected time {}.", (Object)this.expectedNextTime);
            return false;
        }
        return true;
    }

    public void updatePendingAdoptInfoByVerifyResult(b adoptInfo) {
        if (adoptInfo != null && adoptInfo.a() != null && adoptInfo.b() != null) {
            this.pendingAdoptInfo = new a(adoptInfo.a(), adoptInfo.b());
        }
    }

    public boolean verifyAdoptInfoInManually(String username, String password) {
        if (com.tplink.smb.omada.manager.device.domain.model.adopt.c.a.g.b(this.adoptErrCode)) {
            return username != null && password != null;
        }
        if (this.pendingAdoptInfo == null) {
            return username != null && password != null;
        }
        return true;
    }

    @Nullable
    @Generated
    public e getBusinessId() {
        return this.businessId;
    }

    @Nullable
    @Generated
    public e getFullAdoptBusinessId() {
        return this.fullAdoptBusinessId;
    }

    @Nullable
    @Generated
    public String getBatchAdoptId() {
        return this.batchAdoptId;
    }

    @Generated
    public Boolean getAutoAdopt() {
        return this.autoAdopt;
    }

    @Generated
    public a getPendingAdoptInfo() {
        return this.pendingAdoptInfo;
    }

    @Generated
    public Integer getAdoptErrCode() {
        return this.adoptErrCode;
    }

    @Generated
    public Integer getAutoAdoptCnt() {
        return this.autoAdoptCnt;
    }

    @Generated
    public AtomicInteger getAutoAdoptWithErrorUserNamePasswordCnt() {
        return this.autoAdoptWithErrorUserNamePasswordCnt;
    }

    @Generated
    public Long getLastTryTime() {
        return this.lastTryTime;
    }

    @Generated
    public Long getExpectedNextTime() {
        return this.expectedNextTime;
    }

    @Generated
    public Integer getReceiveDiscoveryTimes() {
        return this.receiveDiscoveryTimes;
    }

    @Generated
    public void setBusinessId(@Nullable e businessId) {
        this.businessId = businessId;
    }

    @Generated
    public void setFullAdoptBusinessId(@Nullable e fullAdoptBusinessId) {
        this.fullAdoptBusinessId = fullAdoptBusinessId;
    }

    @Generated
    public void setBatchAdoptId(@Nullable String batchAdoptId) {
        this.batchAdoptId = batchAdoptId;
    }

    @Generated
    public void setAutoAdopt(Boolean autoAdopt) {
        this.autoAdopt = autoAdopt;
    }

    @Generated
    public void setPendingAdoptInfo(a pendingAdoptInfo) {
        this.pendingAdoptInfo = pendingAdoptInfo;
    }

    @Generated
    public void setAdoptErrCode(Integer adoptErrCode) {
        this.adoptErrCode = adoptErrCode;
    }

    @Generated
    public void setAutoAdoptCnt(Integer autoAdoptCnt) {
        this.autoAdoptCnt = autoAdoptCnt;
    }

    @Generated
    public void setAutoAdoptWithErrorUserNamePasswordCnt(AtomicInteger autoAdoptWithErrorUserNamePasswordCnt) {
        this.autoAdoptWithErrorUserNamePasswordCnt = autoAdoptWithErrorUserNamePasswordCnt;
    }

    @Generated
    public void setLastTryTime(Long lastTryTime) {
        this.lastTryTime = lastTryTime;
    }

    @Generated
    public void setExpectedNextTime(Long expectedNextTime) {
        this.expectedNextTime = expectedNextTime;
    }

    @Generated
    public void setReceiveDiscoveryTimes(Integer receiveDiscoveryTimes) {
        this.receiveDiscoveryTimes = receiveDiscoveryTimes;
    }

    @Generated
    public boolean equals(Object o2) {
        if (o2 == this) {
            return true;
        }
        if (!(o2 instanceof RunTimeAdoptInfo)) {
            return false;
        }
        RunTimeAdoptInfo other = (RunTimeAdoptInfo)o2;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$autoAdopt = this.getAutoAdopt();
        Boolean other$autoAdopt = other.getAutoAdopt();
        if (this$autoAdopt == null ? other$autoAdopt != null : !((Object)this$autoAdopt).equals(other$autoAdopt)) {
            return false;
        }
        Integer this$adoptErrCode = this.getAdoptErrCode();
        Integer other$adoptErrCode = other.getAdoptErrCode();
        if (this$adoptErrCode == null ? other$adoptErrCode != null : !((Object)this$adoptErrCode).equals(other$adoptErrCode)) {
            return false;
        }
        Integer this$autoAdoptCnt = this.getAutoAdoptCnt();
        Integer other$autoAdoptCnt = other.getAutoAdoptCnt();
        if (this$autoAdoptCnt == null ? other$autoAdoptCnt != null : !((Object)this$autoAdoptCnt).equals(other$autoAdoptCnt)) {
            return false;
        }
        Long this$lastTryTime = this.getLastTryTime();
        Long other$lastTryTime = other.getLastTryTime();
        if (this$lastTryTime == null ? other$lastTryTime != null : !((Object)this$lastTryTime).equals(other$lastTryTime)) {
            return false;
        }
        Long this$expectedNextTime = this.getExpectedNextTime();
        Long other$expectedNextTime = other.getExpectedNextTime();
        if (this$expectedNextTime == null ? other$expectedNextTime != null : !((Object)this$expectedNextTime).equals(other$expectedNextTime)) {
            return false;
        }
        Integer this$receiveDiscoveryTimes = this.getReceiveDiscoveryTimes();
        Integer other$receiveDiscoveryTimes = other.getReceiveDiscoveryTimes();
        if (this$receiveDiscoveryTimes == null ? other$receiveDiscoveryTimes != null : !((Object)this$receiveDiscoveryTimes).equals(other$receiveDiscoveryTimes)) {
            return false;
        }
        e this$businessId = this.getBusinessId();
        e other$businessId = other.getBusinessId();
        if (this$businessId == null ? other$businessId != null : !this$businessId.equals(other$businessId)) {
            return false;
        }
        e this$fullAdoptBusinessId = this.getFullAdoptBusinessId();
        e other$fullAdoptBusinessId = other.getFullAdoptBusinessId();
        if (this$fullAdoptBusinessId == null ? other$fullAdoptBusinessId != null : !this$fullAdoptBusinessId.equals(other$fullAdoptBusinessId)) {
            return false;
        }
        String this$batchAdoptId = this.getBatchAdoptId();
        String other$batchAdoptId = other.getBatchAdoptId();
        if (this$batchAdoptId == null ? other$batchAdoptId != null : !this$batchAdoptId.equals(other$batchAdoptId)) {
            return false;
        }
        a this$pendingAdoptInfo = this.getPendingAdoptInfo();
        a other$pendingAdoptInfo = other.getPendingAdoptInfo();
        if (this$pendingAdoptInfo == null ? other$pendingAdoptInfo != null : !this$pendingAdoptInfo.equals(other$pendingAdoptInfo)) {
            return false;
        }
        AtomicInteger this$autoAdoptWithErrorUserNamePasswordCnt = this.getAutoAdoptWithErrorUserNamePasswordCnt();
        AtomicInteger other$autoAdoptWithErrorUserNamePasswordCnt = other.getAutoAdoptWithErrorUserNamePasswordCnt();
        return !(this$autoAdoptWithErrorUserNamePasswordCnt == null ? other$autoAdoptWithErrorUserNamePasswordCnt != null : !this$autoAdoptWithErrorUserNamePasswordCnt.equals(other$autoAdoptWithErrorUserNamePasswordCnt));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RunTimeAdoptInfo;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $autoAdopt = this.getAutoAdopt();
        result = result * 59 + ($autoAdopt == null ? 43 : ((Object)$autoAdopt).hashCode());
        Integer $adoptErrCode = this.getAdoptErrCode();
        result = result * 59 + ($adoptErrCode == null ? 43 : ((Object)$adoptErrCode).hashCode());
        Integer $autoAdoptCnt = this.getAutoAdoptCnt();
        result = result * 59 + ($autoAdoptCnt == null ? 43 : ((Object)$autoAdoptCnt).hashCode());
        Long $lastTryTime = this.getLastTryTime();
        result = result * 59 + ($lastTryTime == null ? 43 : ((Object)$lastTryTime).hashCode());
        Long $expectedNextTime = this.getExpectedNextTime();
        result = result * 59 + ($expectedNextTime == null ? 43 : ((Object)$expectedNextTime).hashCode());
        Integer $receiveDiscoveryTimes = this.getReceiveDiscoveryTimes();
        result = result * 59 + ($receiveDiscoveryTimes == null ? 43 : ((Object)$receiveDiscoveryTimes).hashCode());
        e $businessId = this.getBusinessId();
        result = result * 59 + ($businessId == null ? 43 : $businessId.hashCode());
        e $fullAdoptBusinessId = this.getFullAdoptBusinessId();
        result = result * 59 + ($fullAdoptBusinessId == null ? 43 : $fullAdoptBusinessId.hashCode());
        String $batchAdoptId = this.getBatchAdoptId();
        result = result * 59 + ($batchAdoptId == null ? 43 : $batchAdoptId.hashCode());
        a $pendingAdoptInfo = this.getPendingAdoptInfo();
        result = result * 59 + ($pendingAdoptInfo == null ? 43 : $pendingAdoptInfo.hashCode());
        AtomicInteger $autoAdoptWithErrorUserNamePasswordCnt = this.getAutoAdoptWithErrorUserNamePasswordCnt();
        result = result * 59 + ($autoAdoptWithErrorUserNamePasswordCnt == null ? 43 : $autoAdoptWithErrorUserNamePasswordCnt.hashCode());
        return result;
    }

    public static class a {
        private String a;
        private String b;

        @Generated
        public String a() {
            return this.a;
        }

        @Generated
        public String b() {
            return this.b;
        }

        @Generated
        public void a(String username) {
            this.a = username;
        }

        @Generated
        public void b(String password) {
            this.b = password;
        }

        @Generated
        public a() {
        }

        @Generated
        public a(String username, String password) {
            this.a = username;
            this.b = password;
        }
    }
}

