/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.device.domain.model.deviceimage;

import com.tplink.smb.omada.common.obfuscate.KeepClass;
import com.tplink.smb.omada.device.manage.message.EcspFirstVersionEnum;
import com.tplink.smb.omada.manager.c.B;
import com.tplink.smb.omada.manager.common.b.a.a.c;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

@KeepClass
public final class ComponentInfo {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ComponentInfo.class);
    @Nonnull
    private final Map<String, Integer> realComponents;
    @Nonnull
    private final Map<String, b> realComponentsV2;
    @Nullable
    private final Map<String, List<Integer>> notSupportComponents;
    @Nonnull
    private final Map<String, a> componentCapInfo;
    @Nonnull
    private final EcspFirstVersionEnum version;

    public ComponentInfo(@Nonnull Map<String, Integer> realComponents, @Nonnull Map<String, b> realComponentsV2, Map<String, List<Integer>> notSupportComponents, Map<String, a> componentCapInfo, @Nonnull EcspFirstVersionEnum versionEnum) {
        this.realComponents = Collections.unmodifiableMap(realComponents);
        this.realComponentsV2 = Collections.unmodifiableMap(realComponentsV2);
        this.notSupportComponents = CollectionUtils.isEmpty(notSupportComponents) ? Collections.emptyMap() : Collections.unmodifiableMap(notSupportComponents);
        this.componentCapInfo = CollectionUtils.isEmpty(componentCapInfo) ? Collections.emptyMap() : Collections.unmodifiableMap(componentCapInfo);
        this.version = versionEnum;
    }

    public ComponentInfo(@Nonnull Map<String, Integer> realComponents, @Nonnull Map<String, b> realComponentsV2, @Nonnull EcspFirstVersionEnum versionEnum) {
        this.realComponents = Collections.unmodifiableMap(realComponents);
        this.realComponentsV2 = Collections.unmodifiableMap(realComponentsV2);
        this.notSupportComponents = Collections.emptyMap();
        this.componentCapInfo = Collections.emptyMap();
        this.version = versionEnum;
    }

    public ComponentInfo(@Nonnull EcspFirstVersionEnum versionEnum) {
        this.realComponents = Collections.emptyMap();
        this.realComponentsV2 = Collections.emptyMap();
        this.notSupportComponents = Collections.emptyMap();
        this.componentCapInfo = Collections.emptyMap();
        this.version = versionEnum;
    }

    public static ComponentInfo buildV1RealComponents(@Nullable Map<String, Integer> realComponents, Map<String, a> componentCaps) {
        if (CollectionUtils.isEmpty(realComponents)) {
            return new ComponentInfo(Collections.emptyMap(), Collections.emptyMap(), EcspFirstVersionEnum.V1);
        }
        return new ComponentInfo(Collections.unmodifiableMap(realComponents), Collections.emptyMap(), Collections.emptyMap(), componentCaps, EcspFirstVersionEnum.V1);
    }

    public static ComponentInfo buildV2RealComponents(@Nullable Map<String, b> realComponentsV2, Map<String, a> componentCaps, Map<String, List<Integer>> notSupportComponents) {
        if (CollectionUtils.isEmpty(realComponentsV2)) {
            return new ComponentInfo(Collections.emptyMap(), Collections.emptyMap(), EcspFirstVersionEnum.V2);
        }
        return new ComponentInfo(Collections.emptyMap(), Collections.unmodifiableMap(realComponentsV2), notSupportComponents, componentCaps, EcspFirstVersionEnum.V2);
    }

    public Optional<Integer> getComponent(String componentName) {
        switch (this.version) {
            case V1: {
                return Optional.ofNullable(this.realComponents.get(componentName));
            }
            case V2: 
            case V3: {
                return Optional.ofNullable(this.realComponentsV2.get(componentName)).map(b::c);
            }
        }
        return Optional.empty();
    }

    private Optional<b> a(c component) {
        switch (this.version) {
            case V1: {
                return Optional.ofNullable(this.realComponents.get(component.e())).map(ver -> new b((Integer)ver, 0));
            }
            case V2: 
            case V3: {
                return Optional.ofNullable(this.realComponentsV2.get(component.e()));
            }
        }
        return Optional.empty();
    }

    public boolean isSupportByComponentVer(c component, int targetVer, int targetFunctionVer) {
        return this.a(component).map(ver -> ver.c() >= targetVer && ver.d() >= targetFunctionVer).orElse(false) != false && this.a(component, targetFunctionVer);
    }

    public boolean isSupportByComponentVerEqual(c component, int targetVer, int targetFunctionVer) {
        return this.a(component).map(ver -> ver.c() == targetVer && ver.d() == targetFunctionVer).orElse(false) != false && this.a(component, targetFunctionVer);
    }

    private boolean a(c component, int targetFunctionVer) {
        if (Objects.isNull(this.notSupportComponents)) {
            return true;
        }
        List<Integer> unSupportFunctionVers = this.notSupportComponents.get(component.e());
        if (CollectionUtils.isEmpty(unSupportFunctionVers)) {
            return true;
        }
        return !unSupportFunctionVers.contains(targetFunctionVer);
    }

    public boolean isSupportByVer(String name, int targetVer) {
        return this.getComponent(name).map(ver -> ver >= targetVer).orElse(false);
    }

    public boolean isInvalid() {
        return CollectionUtils.isEmpty(this.realComponents) && CollectionUtils.isEmpty(this.realComponentsV2);
    }

    @Nonnull
    @Generated
    public Map<String, Integer> getRealComponents() {
        return this.realComponents;
    }

    @Nonnull
    @Generated
    public Map<String, b> getRealComponentsV2() {
        return this.realComponentsV2;
    }

    @Nullable
    @Generated
    public Map<String, List<Integer>> getNotSupportComponents() {
        return this.notSupportComponents;
    }

    @Nonnull
    @Generated
    public Map<String, a> getComponentCapInfo() {
        return this.componentCapInfo;
    }

    @Nonnull
    @Generated
    public EcspFirstVersionEnum getVersion() {
        return this.version;
    }

    @Generated
    public String toString() {
        return "ComponentInfo(realComponents=" + this.getRealComponents() + ", realComponentsV2=" + this.getRealComponentsV2() + ", notSupportComponents=" + this.getNotSupportComponents() + ", componentCapInfo=" + this.getComponentCapInfo() + ", version=" + this.getVersion() + ")";
    }

    @Generated
    public boolean equals(Object o2) {
        if (o2 == this) {
            return true;
        }
        if (!(o2 instanceof ComponentInfo)) {
            return false;
        }
        ComponentInfo other = (ComponentInfo)o2;
        Map<String, Integer> this$realComponents = this.getRealComponents();
        Map<String, Integer> other$realComponents = other.getRealComponents();
        if (this$realComponents == null ? other$realComponents != null : !((Object)this$realComponents).equals(other$realComponents)) {
            return false;
        }
        Map<String, b> this$realComponentsV2 = this.getRealComponentsV2();
        Map<String, b> other$realComponentsV2 = other.getRealComponentsV2();
        if (this$realComponentsV2 == null ? other$realComponentsV2 != null : !((Object)this$realComponentsV2).equals(other$realComponentsV2)) {
            return false;
        }
        Map<String, List<Integer>> this$notSupportComponents = this.getNotSupportComponents();
        Map<String, List<Integer>> other$notSupportComponents = other.getNotSupportComponents();
        if (this$notSupportComponents == null ? other$notSupportComponents != null : !((Object)this$notSupportComponents).equals(other$notSupportComponents)) {
            return false;
        }
        Map<String, a> this$componentCapInfo = this.getComponentCapInfo();
        Map<String, a> other$componentCapInfo = other.getComponentCapInfo();
        if (this$componentCapInfo == null ? other$componentCapInfo != null : !((Object)this$componentCapInfo).equals(other$componentCapInfo)) {
            return false;
        }
        EcspFirstVersionEnum this$version = this.getVersion();
        EcspFirstVersionEnum other$version = other.getVersion();
        return !(this$version == null ? other$version != null : !this$version.equals(other$version));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<String, Integer> $realComponents = this.getRealComponents();
        result = result * 59 + ($realComponents == null ? 43 : ((Object)$realComponents).hashCode());
        Map<String, b> $realComponentsV2 = this.getRealComponentsV2();
        result = result * 59 + ($realComponentsV2 == null ? 43 : ((Object)$realComponentsV2).hashCode());
        Map<String, List<Integer>> $notSupportComponents = this.getNotSupportComponents();
        result = result * 59 + ($notSupportComponents == null ? 43 : ((Object)$notSupportComponents).hashCode());
        Map<String, a> $componentCapInfo = this.getComponentCapInfo();
        result = result * 59 + ($componentCapInfo == null ? 43 : ((Object)$componentCapInfo).hashCode());
        EcspFirstVersionEnum $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        return result;
    }

    public static class b {
        private final Integer a;
        private final Integer b;

        public b(Integer version, Integer functionVersion) {
            this.a = version;
            this.b = functionVersion;
        }

        public static b a() {
            return new b(-1, -1);
        }

        public boolean b() {
            return this.a == -1 || this.b == -1;
        }

        @Generated
        public Integer c() {
            return this.a;
        }

        @Generated
        public Integer d() {
            return this.b;
        }

        @Generated
        public boolean equals(Object o2) {
            if (o2 == this) {
                return true;
            }
            if (!(o2 instanceof b)) {
                return false;
            }
            b other = (b)o2;
            if (!other.a(this)) {
                return false;
            }
            Integer this$version = this.c();
            Integer other$version = other.c();
            if (this$version == null ? other$version != null : !((Object)this$version).equals(other$version)) {
                return false;
            }
            Integer this$functionVersion = this.d();
            Integer other$functionVersion = other.d();
            return !(this$functionVersion == null ? other$functionVersion != null : !((Object)this$functionVersion).equals(other$functionVersion));
        }

        @Generated
        protected boolean a(Object other) {
            return other instanceof b;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $version = this.c();
            result = result * 59 + ($version == null ? 43 : ((Object)$version).hashCode());
            Integer $functionVersion = this.d();
            result = result * 59 + ($functionVersion == null ? 43 : ((Object)$functionVersion).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "ComponentInfo.ComponentVersionInfo(version=" + this.c() + ", functionVersion=" + this.d() + ")";
        }
    }

    public static class a {
        private final List<B> a;
        private final Integer b;

        public a(List<B> unsupportCaps, Integer entryLimit) {
            this.a = unsupportCaps;
            this.b = entryLimit;
        }

        public static a a() {
            return new a(null, null);
        }

        @Generated
        public List<B> b() {
            return this.a;
        }

        @Generated
        public Integer c() {
            return this.b;
        }

        @Generated
        public boolean equals(Object o2) {
            if (o2 == this) {
                return true;
            }
            if (!(o2 instanceof a)) {
                return false;
            }
            a other = (a)o2;
            if (!other.a(this)) {
                return false;
            }
            Integer this$entryLimit = this.c();
            Integer other$entryLimit = other.c();
            return !(this$entryLimit == null ? other$entryLimit != null : !((Object)this$entryLimit).equals(other$entryLimit));
        }

        @Generated
        protected boolean a(Object other) {
            return other instanceof a;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $entryLimit = this.c();
            result = result * 59 + ($entryLimit == null ? 43 : ((Object)$entryLimit).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "ComponentInfo.ComponentCapInfo(unsupportCaps=" + this.b() + ", entryLimit=" + this.c() + ")";
        }
    }
}

