/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.manager.device.domain.model.device.osw;

import com.tplink.smb.omada.common.access.OperationResponse;
import com.tplink.smb.omada.common.e.l;
import com.tplink.smb.omada.common.obfuscate.KeepClass;
import com.tplink.smb.omada.common.util.T;
import com.tplink.smb.omada.manager.c.x;
import com.tplink.smb.omada.manager.configuration.domain.model.site.component.g;
import com.tplink.smb.omada.manager.configuration.domain.model.site.wired.lannetwork.BaseLanNetwork;
import com.tplink.smb.omada.manager.configuration.domain.model.site.wired.lannetwork.F;
import com.tplink.smb.omada.manager.configuration.domain.model.site.wired.lannetwork.LanNetwork;
import com.tplink.smb.omada.manager.configuration.domain.model.site.wired.lannetwork.Z;
import com.tplink.smb.omada.manager.configuration.domain.model.site.wired.lanprofile.NetworkAssociated;
import com.tplink.smb.omada.manager.configuration.domain.model.site.wired.lanprofile.b;
import com.tplink.smb.omada.manager.configuration.domain.model.site.wired.lanprofile.k;
import com.tplink.smb.omada.manager.device.application.device.osw.o;
import com.tplink.smb.omada.manager.device.domain.model.device.osw.d.M;
import com.tplink.smb.omada.manager.j.a.a.c;
import com.tplink.smb.omada.manager.j.a.a.d;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

@KeepClass
public class OswPortNetworkAssociated
implements l<OswPortNetworkAssociated> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OswPortNetworkAssociated.class);
    public static final String BRIDGE_VLAN_SEPARATOR = "_";
    public static final int UNTAGGED = 0;
    public static final int TAGGED = 1;
    private F nativeNetworkId;
    private Integer nativeBridgeVlan;
    private M networkTagsSetting;
    private List<F> tagNetworkIds;
    private Map<String, Set<Integer>> tagBridgeVlanMap;
    private List<F> untagNetworkIds;
    private Map<String, Set<Integer>> untagBridgeVlanMap;
    private Boolean voiceNetworkEnable;
    private F voiceNetworkId;
    private Integer voiceBridgeVlan;
    private Boolean voiceDscpEnable;
    private Integer voiceDscp;

    public void modifyByNetworkCommand(o networkAssociatedCommand) {
        if (networkAssociatedCommand == null) {
            return;
        }
        OswPortNetworkAssociated networkAssociatedFromCommand = OswPortNetworkAssociated.buildFromNetworkCommand(networkAssociatedCommand);
        this.modifyByNetworkAssociated(networkAssociatedFromCommand);
    }

    public void modifyByNetworkAssociated(OswPortNetworkAssociated newNetworkAssociated) {
        M networkTagsSettingEnum;
        if (newNetworkAssociated == null) {
            return;
        }
        if (newNetworkAssociated.getNativeNetworkId() != null) {
            this.setNativeNetworkId(newNetworkAssociated.getNativeNetworkId());
            this.setNativeBridgeVlan(newNetworkAssociated.getNativeBridgeVlan());
        }
        if (newNetworkAssociated.getNetworkTagsSetting() != null) {
            this.setNetworkTagsSetting(newNetworkAssociated.getNetworkTagsSetting());
        }
        if ((networkTagsSettingEnum = newNetworkAssociated.getNetworkTagsSetting()) != null) {
            switch (networkTagsSettingEnum) {
                case a: 
                case b: {
                    this.setTagNetworkIds(new ArrayList<F>());
                    this.setTagBridgeVlanMap(new HashMap<String, Set<Integer>>());
                    this.setUntagNetworkIds(new ArrayList<F>());
                    this.setUntagBridgeVlanMap(new HashMap<String, Set<Integer>>());
                    break;
                }
                case c: {
                    if (newNetworkAssociated.getTagNetworkIds() != null) {
                        this.setTagNetworkIds(newNetworkAssociated.getTagNetworkIds());
                        this.setTagBridgeVlanMap(newNetworkAssociated.getTagBridgeVlanMap());
                    }
                    if (newNetworkAssociated.getUntagNetworkIds() == null) break;
                    this.setUntagNetworkIds(newNetworkAssociated.getUntagNetworkIds());
                    this.setUntagBridgeVlanMap(newNetworkAssociated.getUntagBridgeVlanMap());
                    break;
                }
            }
        }
        Optional.ofNullable(newNetworkAssociated.getVoiceNetworkEnable()).ifPresent(this::setVoiceNetworkEnable);
        if (Boolean.TRUE.equals(this.getVoiceNetworkEnable())) {
            if (newNetworkAssociated.getVoiceNetworkId() != null) {
                this.setVoiceNetworkId(newNetworkAssociated.getVoiceNetworkId());
                this.setVoiceBridgeVlan(newNetworkAssociated.getVoiceBridgeVlan());
            }
        } else {
            this.setVoiceNetworkId(null);
            this.setVoiceBridgeVlan(null);
        }
        Optional.ofNullable(newNetworkAssociated.getVoiceDscpEnable()).ifPresent(this::setVoiceDscpEnable);
        Optional.ofNullable(newNetworkAssociated.getVoiceDscp()).ifPresent(this::setVoiceDscp);
    }

    public static OswPortNetworkAssociated buildFromNetworkAssociated(OswPortNetworkAssociated networkAssociated) {
        return OswPortNetworkAssociated.builder().a(networkAssociated.getNativeNetworkId()).a(networkAssociated.getNativeBridgeVlan()).a(networkAssociated.getNetworkTagsSetting()).a(networkAssociated.getTagNetworkIds()).a(networkAssociated.getTagBridgeVlanMap()).b(networkAssociated.getUntagNetworkIds()).b(networkAssociated.getUntagBridgeVlanMap()).a(networkAssociated.getVoiceNetworkEnable()).b(networkAssociated.getVoiceNetworkId()).b(networkAssociated.getVoiceBridgeVlan()).b(networkAssociated.getVoiceDscpEnable()).c(networkAssociated.getVoiceDscp()).a();
    }

    public static OswPortNetworkAssociated buildFromNetworkCommand(o networkAssociatedCommand) {
        return OswPortNetworkAssociated.build(networkAssociatedCommand.e(), networkAssociatedCommand.f(), networkAssociatedCommand.g(), networkAssociatedCommand.h(), networkAssociatedCommand.i(), networkAssociatedCommand.j(), networkAssociatedCommand.k(), networkAssociatedCommand.m(), networkAssociatedCommand.n(), networkAssociatedCommand.l(), networkAssociatedCommand.o(), networkAssociatedCommand.p());
    }

    public static OswPortNetworkAssociated build(String nativeNetworkId, Integer nativeBridgeVlan, Integer networkTagsSetting, List<String> tagNetworkIds, Map<String, Set<Integer>> tagBridgeVlanMap, List<String> untagNetworkIds, Map<String, Set<Integer>> untagBridgeVlanMap, String voiceNetworkId, Integer voiceBridgeVlan, Boolean voiceNetworkEnable, Boolean voiceDscpEnable, Integer voiceDscp) {
        OswPortNetworkAssociated networkAssociated = new OswPortNetworkAssociated();
        F nativeNetwork = T.a((String)nativeNetworkId) ? null : new F(nativeNetworkId);
        F voiceNetwork = T.a((String)voiceNetworkId) ? null : new F(voiceNetworkId);
        networkAssociated.setNativeNetworkId(nativeNetwork);
        networkAssociated.setNativeBridgeVlan(nativeBridgeVlan);
        networkAssociated.setVoiceNetworkEnable(voiceNetworkEnable);
        networkAssociated.setVoiceNetworkId(voiceNetwork);
        networkAssociated.setVoiceBridgeVlan(voiceBridgeVlan);
        networkAssociated.setVoiceDscpEnable(voiceDscpEnable);
        networkAssociated.setVoiceDscp(voiceDscp);
        M networkTagsSettingEnum = M.a(networkTagsSetting);
        networkAssociated.setNetworkTagsSetting(networkTagsSettingEnum);
        if (networkTagsSettingEnum != null) {
            switch (networkTagsSettingEnum) {
                case a: 
                case b: {
                    return networkAssociated;
                }
                case c: {
                    List<F> tagNetworkIdList = new ArrayList<F>(4);
                    if (tagNetworkIds != null && !tagNetworkIds.isEmpty()) {
                        tagNetworkIdList = tagNetworkIds.stream().filter(tagNetworkId -> !T.a((String)tagNetworkId)).map(F::new).collect(Collectors.toList());
                    }
                    List<F> untagNetworkIdList = new ArrayList<F>(4);
                    if (untagNetworkIds != null && !untagNetworkIds.isEmpty()) {
                        untagNetworkIdList = untagNetworkIds.stream().filter(untagNetworkId -> !T.a((String)untagNetworkId)).map(F::new).collect(Collectors.toList());
                    }
                    networkAssociated.setTagNetworkIds(tagNetworkIdList);
                    networkAssociated.setTagBridgeVlanMap(tagBridgeVlanMap);
                    networkAssociated.setUntagNetworkIds(untagNetworkIdList);
                    networkAssociated.setUntagBridgeVlanMap(untagBridgeVlanMap);
                    break;
                }
            }
        }
        return networkAssociated;
    }

    public static OperationResponse validateModify(o networkAssociatedCommand, OswPortNetworkAssociated networkAssociated, Boolean isEsSwitch) {
        if (networkAssociatedCommand == null || networkAssociated == null) {
            return OperationResponse.SUCCESS;
        }
        if (networkAssociatedCommand.m() != null && !Boolean.TRUE.equals(networkAssociatedCommand.l())) {
            return new OperationResponse(com.tplink.smb.omada.common.g.b.kc);
        }
        if (networkAssociatedCommand.p() != null && !Boolean.TRUE.equals(networkAssociatedCommand.o())) {
            return new OperationResponse(com.tplink.smb.omada.common.g.b.kc);
        }
        String nativeNetworkId = Optional.ofNullable(networkAssociatedCommand.e()).orElse(OswPortNetworkAssociated.buildNetworkIdStr(networkAssociated.getNativeNetworkId(), networkAssociated.getNativeBridgeVlan()));
        Integer networkTagsSetting = Optional.ofNullable(networkAssociatedCommand.g()).orElse(Optional.ofNullable(networkAssociated.getNetworkTagsSetting()).map(M::a).orElse(null));
        List<String> tagNetworkIds = Optional.ofNullable(networkAssociatedCommand.h()).orElse(OswPortNetworkAssociated.buildNetworkIdStrList(networkAssociated.getTagNetworkIds(), networkAssociated.getTagBridgeVlanMap()));
        List<String> untagNetworkIds = Optional.ofNullable(networkAssociatedCommand.j()).orElse(OswPortNetworkAssociated.buildNetworkIdStrList(networkAssociated.getUntagNetworkIds(), networkAssociated.getUntagBridgeVlanMap()));
        Boolean voiceNetworkEnable = Optional.ofNullable(networkAssociatedCommand.l()).orElse(networkAssociated.getVoiceNetworkEnable());
        String voiceNetworkId = Optional.ofNullable(networkAssociatedCommand.m()).orElse(OswPortNetworkAssociated.buildNetworkIdStr(networkAssociated.getVoiceNetworkId(), networkAssociated.getVoiceBridgeVlan()));
        return OswPortNetworkAssociated.validate(nativeNetworkId, networkTagsSetting, tagNetworkIds, untagNetworkIds, voiceNetworkEnable, voiceNetworkId, isEsSwitch);
    }

    public static OperationResponse validate(String nativeNetworkId, Integer networkTagsSetting, List<String> tagNetworkIds, List<String> untagNetworkIds, Boolean voiceNetworkEnable, String voiceNetworkId, Boolean isEsSwitch) {
        M networkTagsSettingEnum = M.a(networkTagsSetting);
        if (networkTagsSettingEnum == null || M.d.equals((Object)networkTagsSettingEnum)) {
            return OperationResponse.PARAM_ERROR;
        }
        if (!Boolean.TRUE.equals(isEsSwitch) && Boolean.TRUE.equals(voiceNetworkEnable) && nativeNetworkId != null && voiceNetworkId != null && Objects.equals(nativeNetworkId, voiceNetworkId)) {
            log.warn("Voice Network must be included in Tagged Networks.");
            return new OperationResponse(com.tplink.smb.omada.common.g.b.iI);
        }
        switch (networkTagsSettingEnum) {
            case a: {
                break;
            }
            case b: {
                if (Boolean.TRUE.equals(isEsSwitch) || !Boolean.TRUE.equals(voiceNetworkEnable) || voiceNetworkId == null || "0".equals(voiceNetworkId)) break;
                log.warn("Voice Network must be included in Tagged Networks.");
                return new OperationResponse(com.tplink.smb.omada.common.g.b.iI);
            }
            case c: {
                if (nativeNetworkId != null) {
                    boolean isNativeInTagged;
                    boolean bl2 = isNativeInTagged = tagNetworkIds != null && tagNetworkIds.contains(nativeNetworkId);
                    if (isNativeInTagged) {
                        log.warn("Native Network cannot be included in Tagged Networks.");
                        return new OperationResponse(com.tplink.smb.omada.common.g.b.iG);
                    }
                }
                if (tagNetworkIds != null && untagNetworkIds != null && !Collections.disjoint(tagNetworkIds, untagNetworkIds)) {
                    log.warn("Untagged Network cannot overlap with Tagged Networks.");
                    return new OperationResponse(com.tplink.smb.omada.common.g.b.iH);
                }
                if (Boolean.TRUE.equals(isEsSwitch) || !Boolean.TRUE.equals(voiceNetworkEnable) || voiceNetworkId == null || "0".equals(voiceNetworkId) || tagNetworkIds != null && tagNetworkIds.contains(voiceNetworkId)) break;
                log.warn("Voice Network must be included in Tagged Networks.");
                return new OperationResponse(com.tplink.smb.omada.common.g.b.iI);
            }
        }
        return OperationResponse.SUCCESS;
    }

    public static OswPortNetworkAssociated createDefaultNetworkAssociated(com.tplink.smb.omada.manager.device.domain.model.device.osw.a abstractOswPort) {
        return OswPortNetworkAssociated.builder().a((F)Optional.ofNullable((Z)com.tplink.smb.omada.common.spring.a.b(Z.class)).flatMap(queryLanNetworkService -> queryLanNetworkService.c(new c(abstractOswPort.e()), new d(abstractOswPort.d()), x.a).map(lanNetwork -> new F(((g)lanNetwork.getId()).b()))).orElse(null)).a(M.a).a();
    }

    public static OswPortNetworkAssociated createDefaultNetworkAssociated(BaseLanNetwork lanNetwork) {
        return OswPortNetworkAssociated.builder().a((F)Optional.ofNullable(lanNetwork).map(network -> new F(((g)network.getId()).b())).orElse(null)).a(M.a).a();
    }

    @Nullable
    public static String buildNetworkIdStr(F lanNetworkId, Integer bridgeVlan) {
        if (lanNetworkId == null) {
            return null;
        }
        if (bridgeVlan == null) {
            return lanNetworkId.b();
        }
        return lanNetworkId.b() + BRIDGE_VLAN_SEPARATOR + bridgeVlan;
    }

    public static List<String> buildNetworkIdStrList(List<F> lanNetworkIdList, Map<String, Set<Integer>> bridgeVlanMap) {
        if (CollectionUtils.isEmpty(lanNetworkIdList)) {
            return new ArrayList<String>();
        }
        if (CollectionUtils.isEmpty(bridgeVlanMap)) {
            return lanNetworkIdList.stream().map(g::b).collect(Collectors.toList());
        }
        ArrayList<String> networkIdStrList = new ArrayList<String>();
        for (F lanNetworkId : lanNetworkIdList) {
            if (lanNetworkId == null) continue;
            Set bridgeVlanSet = Optional.ofNullable(bridgeVlanMap.get(lanNetworkId.b())).orElse(new HashSet());
            if (!CollectionUtils.isEmpty((Collection)bridgeVlanSet)) {
                for (Integer vlan : bridgeVlanMap.get(lanNetworkId.b())) {
                    networkIdStrList.add(lanNetworkId.b() + BRIDGE_VLAN_SEPARATOR + vlan);
                }
                continue;
            }
            networkIdStrList.add(lanNetworkId.b());
        }
        return networkIdStrList;
    }

    public static Set<String> buildNetworkIdStrSet(List<F> lanNetworkIdList, Map<String, Set<Integer>> bridgeVlanMap) {
        if (CollectionUtils.isEmpty(lanNetworkIdList)) {
            return new HashSet<String>();
        }
        return new HashSet<String>(OswPortNetworkAssociated.buildNetworkIdStrList(lanNetworkIdList, bridgeVlanMap));
    }

    public void updateByReportedConfig(Integer reportedPvid, Integer tagMode, Integer mvlan, LanNetwork lanNetwork) {
        if (Objects.equals(reportedPvid, mvlan) && Objects.equals(tagMode, 1)) {
            return;
        }
        if (Objects.equals(reportedPvid, mvlan) && Objects.equals(tagMode, 0)) {
            if (Objects.equals((Object)M.a, (Object)this.getNetworkTagsSetting())) {
                this.setNativeNetworkId((F)lanNetwork.getId());
                if (lanNetwork.isMultiVlans()) {
                    this.setNativeBridgeVlan(mvlan);
                } else {
                    this.setNativeBridgeVlan(null);
                }
            } else if (Objects.equals((Object)M.c, (Object)this.getNetworkTagsSetting())) {
                this.setNativeNetworkId((F)lanNetwork.getId());
                if (CollectionUtils.isEmpty(this.getUntagNetworkIds())) {
                    this.setUntagNetworkIds(new ArrayList<F>());
                    this.getUntagNetworkIds().add((F)lanNetwork.getId());
                } else {
                    this.getUntagNetworkIds().add((F)lanNetwork.getId());
                }
                if (lanNetwork.isMultiVlans()) {
                    this.getUntagBridgeVlanMap().computeIfAbsent(((F)lanNetwork.getId()).b(), k2 -> new HashSet()).add(mvlan);
                }
            }
            return;
        }
        if (Objects.equals((Object)M.c, (Object)this.getNetworkTagsSetting())) {
            if (Objects.equals(tagMode, 1)) {
                if (CollectionUtils.isEmpty(this.getTagNetworkIds())) {
                    this.setTagNetworkIds(new ArrayList<F>());
                    this.getTagNetworkIds().add((F)lanNetwork.getId());
                } else {
                    this.getTagNetworkIds().add((F)lanNetwork.getId());
                }
                if (lanNetwork.isMultiVlans()) {
                    this.getTagBridgeVlanMap().computeIfAbsent(((F)lanNetwork.getId()).b(), k2 -> new HashSet()).add(mvlan);
                }
            } else {
                if (CollectionUtils.isEmpty(this.getUntagNetworkIds())) {
                    this.setUntagNetworkIds(new ArrayList<F>());
                    this.getUntagNetworkIds().add((F)lanNetwork.getId());
                } else {
                    this.getUntagNetworkIds().add((F)lanNetwork.getId());
                }
                if (lanNetwork.isMultiVlans()) {
                    this.getUntagBridgeVlanMap().computeIfAbsent(((F)lanNetwork.getId()).b(), k2 -> new HashSet()).add(mvlan);
                }
            }
        }
    }

    public void updateToCustom(OswPortNetworkAssociated customNetwork) {
        this.setNetworkTagsSetting(M.c);
        this.setTagNetworkIds(customNetwork.getTagNetworkIds());
        this.setTagBridgeVlanMap(customNetwork.getTagBridgeVlanMap());
        this.setUntagNetworkIds(customNetwork.getUntagNetworkIds());
        this.setUntagBridgeVlanMap(customNetwork.getUntagBridgeVlanMap());
    }

    public boolean requiredFieldIsNull() {
        return this.getNativeNetworkId() == null || this.getNetworkTagsSetting() == null;
    }

    public static OswPortNetworkAssociated buildFromLanProfile(b lanProfile, Boolean isEsSwitch, BaseLanNetwork primaryLanNetwork) {
        List untagNetworkIdStrs;
        OswPortNetworkAssociated portNetworkAssociated = new OswPortNetworkAssociated();
        if (lanProfile == null || lanProfile.j() == null) {
            return portNetworkAssociated;
        }
        NetworkAssociated networkAssociated = lanProfile.j();
        if (Objects.equals((Object)k.a, (Object)lanProfile.f())) {
            if (Objects.equals("All", lanProfile.h())) {
                OswPortNetworkAssociated.a(portNetworkAssociated, networkAssociated, primaryLanNetwork);
                if (isEsSwitch.booleanValue() && networkAssociated.getEsEnableTagNetworkIds() != null && Boolean.TRUE.equals(lanProfile.G())) {
                    portNetworkAssociated.setNetworkTagsSetting(M.c);
                    portNetworkAssociated.setTagNetworkIds(Optional.ofNullable(networkAssociated.getEsEnableTagNetworkIds()).map(ArrayList::new).orElse(new ArrayList()));
                    portNetworkAssociated.setTagBridgeVlanMap(Optional.ofNullable(networkAssociated.getEsEnableTagBridgeVlanMap()).map(HashMap::new).orElse(new HashMap()));
                } else {
                    portNetworkAssociated.setNetworkTagsSetting(M.a);
                }
                OswPortNetworkAssociated.a(portNetworkAssociated, networkAssociated, isEsSwitch);
            } else {
                OswPortNetworkAssociated.a(portNetworkAssociated, networkAssociated, primaryLanNetwork);
                portNetworkAssociated.setNetworkTagsSetting(M.b);
                OswPortNetworkAssociated.a(portNetworkAssociated, networkAssociated, isEsSwitch);
            }
        } else if (Objects.equals((Object)k.b, (Object)lanProfile.f())) {
            OswPortNetworkAssociated.a(portNetworkAssociated, networkAssociated, primaryLanNetwork);
            portNetworkAssociated.setNetworkTagsSetting(M.b);
            OswPortNetworkAssociated.a(portNetworkAssociated, networkAssociated, isEsSwitch);
        } else {
            OswPortNetworkAssociated.a(portNetworkAssociated, networkAssociated, primaryLanNetwork);
            portNetworkAssociated.setNetworkTagsSetting(M.c);
            portNetworkAssociated.setTagNetworkIds(Optional.ofNullable(networkAssociated.getTagNetworkIds()).map(ArrayList::new).orElse(new ArrayList()));
            portNetworkAssociated.setTagBridgeVlanMap(Optional.ofNullable(networkAssociated.getTagBridgeVlanMap()).map(HashMap::new).orElse(new HashMap()));
            portNetworkAssociated.setUntagNetworkIds(Optional.ofNullable(networkAssociated.getUntagNetworkIds()).map(ArrayList::new).orElse(new ArrayList()));
            portNetworkAssociated.setUntagBridgeVlanMap(Optional.ofNullable(networkAssociated.getUntagBridgeVlanMap()).map(HashMap::new).orElse(new HashMap()));
            OswPortNetworkAssociated.a(portNetworkAssociated, networkAssociated, isEsSwitch);
        }
        if (Objects.equals((Object)portNetworkAssociated.getNetworkTagsSetting(), (Object)M.c) && portNetworkAssociated.getNativeNetworkId() != null && portNetworkAssociated.getNativeNetworkId().b() != null && !(untagNetworkIdStrs = (List)Optional.ofNullable(portNetworkAssociated.getUntagNetworkIds()).map(untags -> untags.stream().map(g::b).collect(Collectors.toList())).orElse(new ArrayList())).contains(portNetworkAssociated.getNativeNetworkId().b())) {
            untagNetworkIdStrs.add(portNetworkAssociated.getNativeNetworkId().b());
            portNetworkAssociated.setUntagNetworkIds(untagNetworkIdStrs.stream().map(F::new).collect(Collectors.toList()));
            if (portNetworkAssociated.getNativeBridgeVlan() != null) {
                Map untagBridgeVlanMap = Optional.ofNullable(portNetworkAssociated.getUntagBridgeVlanMap()).orElse(new HashMap());
                Set birdgeVlanSet = untagBridgeVlanMap.getOrDefault(portNetworkAssociated.getNativeNetworkId().b(), new HashSet());
                birdgeVlanSet.add(portNetworkAssociated.getNativeBridgeVlan());
                untagBridgeVlanMap.put(portNetworkAssociated.getNativeNetworkId().b(), birdgeVlanSet);
                portNetworkAssociated.setUntagBridgeVlanMap(untagBridgeVlanMap);
            }
        }
        return portNetworkAssociated;
    }

    private static void a(OswPortNetworkAssociated portNetwork, NetworkAssociated lanProfileNetwork, BaseLanNetwork primaryLanNetwork) {
        if (lanProfileNetwork == null || portNetwork == null) {
            return;
        }
        if (lanProfileNetwork.getNativeNetworkId() != null && lanProfileNetwork.getNativeNetworkId().b() != null) {
            portNetwork.setNativeNetworkId(lanProfileNetwork.getNativeNetworkId());
            portNetwork.setNativeBridgeVlan(lanProfileNetwork.getNativeBridgeVlan());
        } else if (primaryLanNetwork != null && primaryLanNetwork.getId() != null && ((g)primaryLanNetwork.getId()).b() != null) {
            portNetwork.setNativeNetworkId(new F(((g)primaryLanNetwork.getId()).b()));
            portNetwork.setNativeBridgeVlan(null);
        }
    }

    private static void a(OswPortNetworkAssociated portNetwork, NetworkAssociated lanProfileNetwork, Boolean isEsSwitch) {
        if (lanProfileNetwork == null || portNetwork == null) {
            return;
        }
        if (!Boolean.TRUE.equals(isEsSwitch) && lanProfileNetwork.getVoiceNetworkId() != null && lanProfileNetwork.getVoiceNetworkId().b() != null) {
            portNetwork.setVoiceNetworkEnable(true);
            portNetwork.setVoiceNetworkId(lanProfileNetwork.getVoiceNetworkId());
            portNetwork.setVoiceBridgeVlan(lanProfileNetwork.getVoiceBridgeVlan());
        } else {
            portNetwork.setVoiceNetworkEnable(false);
            portNetwork.setVoiceNetworkId(null);
            portNetwork.setVoiceBridgeVlan(null);
        }
    }

    public boolean sameValueAs(OswPortNetworkAssociated other) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)other, (String[])new String[0]);
    }

    @Generated
    public static a builder() {
        return new a();
    }

    @Generated
    public F getNativeNetworkId() {
        return this.nativeNetworkId;
    }

    @Generated
    public Integer getNativeBridgeVlan() {
        return this.nativeBridgeVlan;
    }

    @Generated
    public M getNetworkTagsSetting() {
        return this.networkTagsSetting;
    }

    @Generated
    public List<F> getTagNetworkIds() {
        return this.tagNetworkIds;
    }

    @Generated
    public Map<String, Set<Integer>> getTagBridgeVlanMap() {
        return this.tagBridgeVlanMap;
    }

    @Generated
    public List<F> getUntagNetworkIds() {
        return this.untagNetworkIds;
    }

    @Generated
    public Map<String, Set<Integer>> getUntagBridgeVlanMap() {
        return this.untagBridgeVlanMap;
    }

    @Generated
    public Boolean getVoiceNetworkEnable() {
        return this.voiceNetworkEnable;
    }

    @Generated
    public F getVoiceNetworkId() {
        return this.voiceNetworkId;
    }

    @Generated
    public Integer getVoiceBridgeVlan() {
        return this.voiceBridgeVlan;
    }

    @Generated
    public Boolean getVoiceDscpEnable() {
        return this.voiceDscpEnable;
    }

    @Generated
    public Integer getVoiceDscp() {
        return this.voiceDscp;
    }

    @Generated
    public OswPortNetworkAssociated setNativeNetworkId(F nativeNetworkId) {
        this.nativeNetworkId = nativeNetworkId;
        return this;
    }

    @Generated
    public OswPortNetworkAssociated setNativeBridgeVlan(Integer nativeBridgeVlan) {
        this.nativeBridgeVlan = nativeBridgeVlan;
        return this;
    }

    @Generated
    public OswPortNetworkAssociated setNetworkTagsSetting(M networkTagsSetting) {
        this.networkTagsSetting = networkTagsSetting;
        return this;
    }

    @Generated
    public OswPortNetworkAssociated setTagNetworkIds(List<F> tagNetworkIds) {
        this.tagNetworkIds = tagNetworkIds;
        return this;
    }

    @Generated
    public OswPortNetworkAssociated setTagBridgeVlanMap(Map<String, Set<Integer>> tagBridgeVlanMap) {
        this.tagBridgeVlanMap = tagBridgeVlanMap;
        return this;
    }

    @Generated
    public OswPortNetworkAssociated setUntagNetworkIds(List<F> untagNetworkIds) {
        this.untagNetworkIds = untagNetworkIds;
        return this;
    }

    @Generated
    public OswPortNetworkAssociated setUntagBridgeVlanMap(Map<String, Set<Integer>> untagBridgeVlanMap) {
        this.untagBridgeVlanMap = untagBridgeVlanMap;
        return this;
    }

    @Generated
    public OswPortNetworkAssociated setVoiceNetworkEnable(Boolean voiceNetworkEnable) {
        this.voiceNetworkEnable = voiceNetworkEnable;
        return this;
    }

    @Generated
    public OswPortNetworkAssociated setVoiceNetworkId(F voiceNetworkId) {
        this.voiceNetworkId = voiceNetworkId;
        return this;
    }

    @Generated
    public OswPortNetworkAssociated setVoiceBridgeVlan(Integer voiceBridgeVlan) {
        this.voiceBridgeVlan = voiceBridgeVlan;
        return this;
    }

    @Generated
    public OswPortNetworkAssociated setVoiceDscpEnable(Boolean voiceDscpEnable) {
        this.voiceDscpEnable = voiceDscpEnable;
        return this;
    }

    @Generated
    public OswPortNetworkAssociated setVoiceDscp(Integer voiceDscp) {
        this.voiceDscp = voiceDscp;
        return this;
    }

    @Generated
    public String toString() {
        return "OswPortNetworkAssociated(nativeNetworkId=" + this.getNativeNetworkId() + ", nativeBridgeVlan=" + this.getNativeBridgeVlan() + ", networkTagsSetting=" + this.getNetworkTagsSetting() + ", tagNetworkIds=" + this.getTagNetworkIds() + ", tagBridgeVlanMap=" + this.getTagBridgeVlanMap() + ", untagNetworkIds=" + this.getUntagNetworkIds() + ", untagBridgeVlanMap=" + this.getUntagBridgeVlanMap() + ", voiceNetworkEnable=" + this.getVoiceNetworkEnable() + ", voiceNetworkId=" + this.getVoiceNetworkId() + ", voiceBridgeVlan=" + this.getVoiceBridgeVlan() + ", voiceDscpEnable=" + this.getVoiceDscpEnable() + ", voiceDscp=" + this.getVoiceDscp() + ")";
    }

    @Generated
    public OswPortNetworkAssociated(F nativeNetworkId, Integer nativeBridgeVlan, M networkTagsSetting, List<F> tagNetworkIds, Map<String, Set<Integer>> tagBridgeVlanMap, List<F> untagNetworkIds, Map<String, Set<Integer>> untagBridgeVlanMap, Boolean voiceNetworkEnable, F voiceNetworkId, Integer voiceBridgeVlan, Boolean voiceDscpEnable, Integer voiceDscp) {
        this.nativeNetworkId = nativeNetworkId;
        this.nativeBridgeVlan = nativeBridgeVlan;
        this.networkTagsSetting = networkTagsSetting;
        this.tagNetworkIds = tagNetworkIds;
        this.tagBridgeVlanMap = tagBridgeVlanMap;
        this.untagNetworkIds = untagNetworkIds;
        this.untagBridgeVlanMap = untagBridgeVlanMap;
        this.voiceNetworkEnable = voiceNetworkEnable;
        this.voiceNetworkId = voiceNetworkId;
        this.voiceBridgeVlan = voiceBridgeVlan;
        this.voiceDscpEnable = voiceDscpEnable;
        this.voiceDscp = voiceDscp;
    }

    @Generated
    public OswPortNetworkAssociated() {
    }

    @Generated
    public static class a {
        @Generated
        private F a;
        @Generated
        private Integer b;
        @Generated
        private M c;
        @Generated
        private List<F> d;
        @Generated
        private Map<String, Set<Integer>> e;
        @Generated
        private List<F> f;
        @Generated
        private Map<String, Set<Integer>> g;
        @Generated
        private Boolean h;
        @Generated
        private F i;
        @Generated
        private Integer j;
        @Generated
        private Boolean k;
        @Generated
        private Integer l;

        @Generated
        a() {
        }

        @Generated
        public a a(F nativeNetworkId) {
            this.a = nativeNetworkId;
            return this;
        }

        @Generated
        public a a(Integer nativeBridgeVlan) {
            this.b = nativeBridgeVlan;
            return this;
        }

        @Generated
        public a a(M networkTagsSetting) {
            this.c = networkTagsSetting;
            return this;
        }

        @Generated
        public a a(List<F> tagNetworkIds) {
            this.d = tagNetworkIds;
            return this;
        }

        @Generated
        public a a(Map<String, Set<Integer>> tagBridgeVlanMap) {
            this.e = tagBridgeVlanMap;
            return this;
        }

        @Generated
        public a b(List<F> untagNetworkIds) {
            this.f = untagNetworkIds;
            return this;
        }

        @Generated
        public a b(Map<String, Set<Integer>> untagBridgeVlanMap) {
            this.g = untagBridgeVlanMap;
            return this;
        }

        @Generated
        public a a(Boolean voiceNetworkEnable) {
            this.h = voiceNetworkEnable;
            return this;
        }

        @Generated
        public a b(F voiceNetworkId) {
            this.i = voiceNetworkId;
            return this;
        }

        @Generated
        public a b(Integer voiceBridgeVlan) {
            this.j = voiceBridgeVlan;
            return this;
        }

        @Generated
        public a b(Boolean voiceDscpEnable) {
            this.k = voiceDscpEnable;
            return this;
        }

        @Generated
        public a c(Integer voiceDscp) {
            this.l = voiceDscp;
            return this;
        }

        @Generated
        public OswPortNetworkAssociated a() {
            return new OswPortNetworkAssociated(this.a, this.b, this.c, this.d, this.e, this.f, this.g, this.h, this.i, this.j, this.k, this.l);
        }

        @Generated
        public String toString() {
            return "OswPortNetworkAssociated.OswPortNetworkAssociatedBuilder(nativeNetworkId=" + this.a + ", nativeBridgeVlan=" + this.b + ", networkTagsSetting=" + this.c + ", tagNetworkIds=" + this.d + ", tagBridgeVlanMap=" + this.e + ", untagNetworkIds=" + this.f + ", untagBridgeVlanMap=" + this.g + ", voiceNetworkEnable=" + this.h + ", voiceNetworkId=" + this.i + ", voiceBridgeVlan=" + this.j + ", voiceDscpEnable=" + this.k + ", voiceDscp=" + this.l + ")";
        }
    }
}

